.*****************************************************************************/
.*                                                                           */
.*  File Name   : HIDEKBD.IPF                                                */
.*                                                                           */
.*  Description : Hide Popup Keyboard Sample Program Information File        */
.*                                                                           */
.*                                                                           */
.*  Copyright (C) 1993 IBM Corporation                                       */
.*                                                                           */
.*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
.*      sample code created by IBM Corporation. This sample code is not      */
.*      part of any standard or IBM product and is provided to you solely    */
.*      for  the purpose of assisting you in the development of your         */
.*      applications.  The code is provided "AS IS", without                 */
.*      warranty of any kind.  IBM shall not be liable for any damages       */
.*      arising out of your use of the sample code, even if they have been   */
.*      advised of the possibility of such damages.                          */
.*                                                                           */
.*****************************************************************************/
:userdoc
.****************************************************************/
.*  Help from Hide Keyboard Window                              */
.*  PANEL_HIDEKBD                                               */
.****************************************************************/
:h1 res=910.Hide Pop-Up Keyboard Window
Select "Demo", then "Start Demo" to start the Demonstration Program.

The dialog displays a row of pushbuttons which controls the display
of a Pop-Up Keyboard.
:lines.
Button Actions:
:link
reftype=hd res=911.LOAD:elink. - Loads the default Pop-Up Keyboard.
:link
reftype=hd res=912.HIDE:elink. - Hides the currently visible Pop-Up Keyboard.
:link
reftype=hd res=913.RESTORE:elink. - Displays a hidden Pop-Up Keyboard.
:link
reftype=hd res=914.CLOSE:elink. - Closes the Pop-Up Keyboard.
:elines.
.****************************************************************/
.*  Help for LOAD Pushbutton                                    */
.*  PANEL_BTNLOAD                                               */
.****************************************************************/
:h1 res=911.LOAD
:lines.
LOAD - Loads the default Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = (APIRET) VkpLoadKeyboard( NULL,
                               hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for HIDE Pushbutton                                    */
.*  PANEL_BTNHIDE                                               */
.****************************************************************/
:h1 res=912.HIDE
:lines.
HIDE - Hides the currently visible Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = (APIRET) VkpHideKeyboard( hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for RESTORE Pushbutton                                 */
.*  PANEL_BTNREST                                               */
.****************************************************************/
:h1 res=913.RESTORE
:lines.
RESTORE - Displays a hidden Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
APIRET    rc;
:p.
rc = VkpSetKbPos( 0L, 0L, 0L, 0L,
                  SWP_SHOW,
                  hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
.****************************************************************/
.*  Help for CLOSE Pushbutton                                   */
.*  PANEL_BTNCLOSE                                              */
.****************************************************************/
:h1 res=914.CLOSE
:lines.
CLOSE - Closes the Pop-Up Keyboard.
:elines.
:p.
:hp4.Example:
:xmp.
:font facename=Helv size=10x10.
BOOL      rc;
:p.
rc = (APIRET) VkpCloseKb( hwnd )

   hwnd - The window handle of the frame
          that owns the Pop-Up Keyboard.
:ehp4.
:font facename=default.
:exmp.
:euserdoc.
