/*****************************************************************************/
/*                                                                           */
/* File Name:    HIDEKBD.H                                                   */
/*                                                                           */
/* Description:  Defines, static variable definitons and function            */
/*               prototypes for Keyboard API Sample program.                 */
/*                                                                           */
/*                                                                           */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/

/*-------------------------------------------------------------------*/
/* Resource identifiers.                                             */
/*-------------------------------------------------------------------*/
#define ID_NULL                           9999
#define ID_WINDOW                          256
#define ID_ICON                           1000

/*-------------------------------------------------------------------*/
/* Menu item identifiers.                                            */
/*-------------------------------------------------------------------*/
#define IDM_START_DLG                     1300
#define IDM_OPTIONS                       1310
#define IDM_DEMO                          1311
#define IDM_EXIT_DEMO                     1312
#define IDM_HELP                          1320

/*-------------------------------------------------------------------*/
/* Dialog item identifiers.                                          */
/*-------------------------------------------------------------------*/
#define IDD_DLG_HIDE                      1330
#define IDD_LOAD                          1331
#define IDD_HIDE                          1332
#define IDD_RESTORE                       1333
#define IDD_CLOSE                         1334

/*-------------------------------------------------------------------*/
/* Help IDs                                                          */
/*-------------------------------------------------------------------*/
#define HIDEKBD_HELPTABLE                  800
#define HIDEKBD_HELPSUBTABLE               801
#define BTNLOAD_HELPSUBTABLE               802
#define BTNHIDE_HELPSUBTABLE               803
#define BTNREST_HELPSUBTABLE               804
#define BTNCLOSE_HELPSUBTABLE              805

#define PANEL_HIDEKBD                      910
#define PANEL_BTNLOAD                      911
#define PANEL_BTNHIDE                      912
#define PANEL_BTNREST                      913
#define PANEL_BTNCLOSE                     914

/*-------------------------------------------------------------------*/
/* String identifiers.                                               */
/*-------------------------------------------------------------------*/
#define MY_MSG                            2800

#define IDS_APPNAME                   MY_MSG+1
#define IDS_NOSTANDARDWIN             MY_MSG+2
#define IDS_NOREGISTER                MY_MSG+3
#define IDS_NOERASE                   MY_MSG+4
#define IDS_NO_KBD_LOAD               MY_MSG+5
#define IDS_NO_KBD_RUNNING            MY_MSG+6
#define IDS_NO_HIDE_KBD               MY_MSG+7
#define IDS_NO_RESTORE_KBD            MY_MSG+8
#define IDS_NO_CLOSE_KBD              MY_MSG+9
#define IDS_NO_HELP                   MY_MSG+10
#define IDS_PEN_NOT_INSTALLED         MY_MSG+11
#define IDS_PEN_NOT_RUNNING           MY_MSG+12

/*-------------------------------------------------------------------*/
/* Constants.                                                        */
/*-------------------------------------------------------------------*/

#define MAXSTRINGLEN         80
#define PARMLEN              16
#define THREADSTACKSIZE   8192L
#define SEM_WAIT            -1L
#define SEM_TIMEOUT      10000L

/*-------------------------------------------------------------------*/
/* Public Variables                                                  */
/*-------------------------------------------------------------------*/

CHAR    szMsgString[MAXSTRINGLEN];          /* string for messages   */

/*-------------------------------------------------------------------*/
/* Private Variables                                                 */
/*-------------------------------------------------------------------*/

static  BOOL    fRunning=FALSE;             /* keyboard running flag */
static  HAB     hab;                        /* anchor block handle   */
static  HWND    hwndFrame;                  /* frame window handle   */
static  HWND    hwndClient;                 /* client window handle  */
static  HWND    hwndDemoWin;                /* demo dialog handle    */
static  HWND    hwndHelp;                   /* help window handle    */
static  HMQ     hmq;                        /* message queue handle  */
static  QMSG    qmsg;                       /* message from msg Q    */
static  CHAR    szString[MAXSTRINGLEN];     /* string to display     */

/*-------------------------------------------------------------------*/
/* Internal function prototypes                                      */
/*-------------------------------------------------------------------*/

static MRESULT EXPENTRY MainWndProc( HWND, USHORT, MPARAM, MPARAM );
static MRESULT EXPENTRY DemoDlgProc( HWND, USHORT, MPARAM, MPARAM );
static MRESULT EXPENTRY InstDlgProc( HWND, USHORT, MPARAM, MPARAM );
static MRESULT EXPENTRY MessageDlgProc( HWND, USHORT, MPARAM, MPARAM );
static VOID DisplayMessage( HAB, ULONG );
static VOID    InitHelp(VOID);
