/*****************************************************************************/
/*                                                                           */
/* File Name:    HIDEKBD.C                                                   */
/*                                                                           */
/* Description:  Sample program demonstrating how to use the                 */
/*               Popup Keyboard APIs hide and restore a Pop-Up               */
/*               keyboard.                                                   */
/*                                                                           */
/* APIs Tested:  VkpCloseKb                                                  */
/*               VkpLoadKeyboard                                             */
/*               VkpIsKbRunning                                              */
/*               VkpIsKbHidden                                               */
/*               VkpHideKeyboard                                             */
/*                                                                           */
/*                                                                           */
/*  Copyright (C) 1993 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/
#define INCL_PM
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSERRORS
#define INCL_WINERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "penpm.h"
#include "hidekbd.h"

int main ( VOID )
{
   ULONG   flCreate;                     /* window creation control flags */

   hab = WinInitialize ( 0 );
   hmq = WinCreateMsgQueue ( hab, 0 );

   WinRegisterClass(
      hab,                               /* Anchor block handle           */
      "HIDEKBDDemo",                     /* Window class name             */
      (PFNWP)MainWndProc,                /* Address of window procedure   */
      0L,                                /* No special Class Style        */
      0                                  /* No extra window words         */
      );

   flCreate = FCF_ICON          |
              FCF_TITLEBAR      |
              FCF_MENU          |
              FCF_SYSMENU       |
              FCF_MINBUTTON     |
              FCF_MAXBUTTON     |
              FCF_SIZEBORDER    |
              FCF_SHELLPOSITION |
              FCF_TASKLIST      ;

   hwndFrame = WinCreateStdWindow(
        HWND_DESKTOP,                    /* Desktop window is parent       */
        0L,                              /* Frame Window Style             */
        &flCreate,                       /* Frame creation flag            */
        "HIDEKBDDemo",                   /* Client window class name       */
        "Hide Keyboard Sample Program",  /* Title bar text                 */
        0L,                              /* No special class style         */
        (HMODULE)NULL,                   /* Resource is in .EXE file       */
        ID_WINDOW,                       /* Frame window identifier        */
        &hwndClient                      /* Client window handle           */
        );

   /*  Ensure Pen for OS/2 is running.  */
   if( WrtWaitActive( WRT_IMMEDIATE_RETURN ) )
   {
     DisplayMessage(hwndFrame, IDS_PEN_NOT_RUNNING);
     return( 0 );
   }

   WinSetWindowPos( hwndFrame,
                    HWND_TOP,
                      5, 300,
                    292, 100,
                    SWP_ACTIVATE | SWP_MOVE | SWP_SIZE | SWP_SHOW);

   InitHelp();

   while ( WinGetMsg ( hab, &qmsg, (HWND)0, 0, 0 ) != FALSE )
       WinDispatchMsg ( hab, &qmsg );

   WinDestroyWindow ( hwndFrame );
   WinDestroyMsgQueue ( hmq );
   WinTerminate ( hab );

   return(0);
}
/********************************************************************/
/* MainWndProc - Main window procedure.                             */
/********************************************************************/
static MRESULT EXPENTRY MainWndProc( HWND hwnd,
                                     USHORT msg,
                                     MPARAM mp1,
                                     MPARAM mp2 )
{
   HPS     hps;                          /* cached PS handle               */
   RECTL   rect;                         /* rectangle coordinates          */

   switch( msg )
   {

       case WM_CLOSE:

         WinSetFocus(HWND_DESKTOP,
                     hwnd );

         WinPostMsg( hwnd, WM_QUIT, 0L, 0L );

         return( (MRESULT)NULL );

       case WM_COMMAND:
         switch((USHORT)mp1)
         {
             case IDM_DEMO:

                 hwndDemoWin = WinLoadDlg( hwndFrame,
                                           hwnd,
                                           (PFNWP) DemoDlgProc,
                                           (HMODULE) NULL,
                                           IDD_DLG_HIDE,
                                           NULL );
                 return (MRESULT)0;

             case IDM_EXIT_DEMO:

                 WinPostMsg( hwnd, WM_CLOSE, 0L, 0L );

                 break;

             case IDM_HELP:

                 WinSendMsg( hwndHelp,
                             HM_DISPLAY_HELP,
                             MPFROMSHORT(PANEL_HIDEKBD),
                             MPFROMSHORT(HM_RESOURCEID) );

                 break;

             default :
                 break;
         }
         break;

       case WM_PAINT:

           hps = WinBeginPaint ( hwnd, (HPS)0, (PRECTL) &rect );

           WinFillRect( hps, (PRECTL) &rect, CLR_RED );

           WinEndPaint ( hps );

           break;

       default:
           break;
   }
   return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
}

/********************************************************************/
/* DemoDlgProc - Keyboard API Demonstration window procedure.       */
/********************************************************************/
static MRESULT EXPENTRY DemoDlgProc( HWND hwnd,
                                     USHORT msg,
                                     MPARAM mp1,
                                     MPARAM mp2 )
{
   HPS      hps;                         /* cached PS handle               */
   APIRET   ApiRc;                       /* api return code                */
   ULONG    ulFl;                        /* Positioning flag(s).           */
   RECTL    rect;                        /* rectangle coordinates          */

   switch( msg )
   {

       case WM_INITDLG:
          WinSetFocus(HWND_DESKTOP,
                      hwnd );
          return( (MRESULT) TRUE );

       case WM_COMMAND:

         switch((USHORT)mp1)
         {

           case IDD_LOAD:

               if( (ApiRc = VkpLoadKeyboard( NULL, hwnd )) == WRTERR_PEN_NOT_INSTALLED )
               {
                  DisplayMessage( hab, IDS_PEN_NOT_INSTALLED );
               }
               else if( ApiRc != VKP_NO_ERROR )
               {
                  sprintf( szMsgString, "%x", ApiRc );
                  DisplayMessage( hab, IDS_NO_KBD_LOAD );
               }

               break;

           case IDD_HIDE:

               ApiRc=VkpIsKbRunning( &fRunning );

               if( (fRunning == TRUE) && (ApiRc == VKP_NO_ERROR) )
               {
                  if( (ApiRc=VkpHideKeyboard( hwnd )) != VKP_NO_ERROR )
                  {
                     sprintf( szMsgString, "%x", ApiRc );
                     DisplayMessage( hab, IDS_NO_HIDE_KBD );
                  }
               }
               else
               {
                  sprintf( szMsgString, "%x", ApiRc );
                  DisplayMessage( hab, IDS_NO_KBD_RUNNING );
               }

               break;

           case IDD_RESTORE:

               ApiRc=VkpIsKbRunning( &fRunning );

               if( (fRunning == TRUE) && (ApiRc == VKP_NO_ERROR) )
               {
                  ulFl = SWP_SHOW;

                  if( (ApiRc = VkpSetKbPos( 0L, 0L, 0L, 0L, ulFl, hwnd )) != VKP_NO_ERROR )
                  {
                     sprintf( szMsgString, "%x", ApiRc );
                     DisplayMessage( hab, IDS_NO_RESTORE_KBD );
                  }
               }
               else
               {
                  sprintf( szMsgString, "%x", ApiRc );
                  DisplayMessage( hab, IDS_NO_KBD_RUNNING );
               }
               break;

           case IDD_CLOSE:

               if( (ApiRc = VkpCloseKb( hwnd )) != VKP_NO_ERROR )
               {
                  sprintf( szMsgString, "%x", ApiRc );
                  DisplayMessage( hab, IDS_NO_CLOSE_KBD );
               }
               break;

           default :
               break;

         }

       break;

       case WM_PAINT:

           hps = WinBeginPaint ( hwnd, (HPS)0, (PRECTL) &rect );

           WinFillRect( hps, (PRECTL) &rect, CLR_BLUE );

           WinEndPaint ( hps );

           break;

       default:
           return ( WinDefDlgProc( hwnd, msg, mp1, mp2 ) );

   }
   return ( (MRESULT)TRUE );
}

/********************************************************************/
/* DisplayMessage - display a message in a message box.             */
/********************************************************************/
static VOID DisplayMessage( HAB hab, ULONG ulStringNum )
{
   char szTemp[MAXSTRINGLEN];

   WinLoadString( hab,
                  0UL,
                  ulStringNum,
                  MAXSTRINGLEN,
                  szTemp );

   if( *szMsgString )
   {
      sprintf( szString, szTemp, szMsgString );
      szMsgString[0]='\0';
   }
   else
   {
      sprintf( szString, "%s", szTemp );
   }

   WinAlarm( HWND_DESKTOP,                  /* desktop window handle   */
             WA_NOTE );                     /* type of alarm           */

   WinMessageBox( HWND_DESKTOP,             /* parent window handle    */
                  hwndClient,               /* owner window handle     */
                  szString,                 /* pointer to message text */
                  "Demo Error",             /* title                   */
                  0,                        /* message box identifier  */
                  MB_OK |                   /* message box style       */
                  MB_MOVEABLE |
                  MB_ICONEXCLAMATION );

   return;
}

/*****************************************************************************/
/* InitHelp()                                                                */
/*                                                                           */
/* DESCRIPTION: Help Procedure                                               */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
VOID    InitHelp(VOID)
{

  HELPINIT      HelpInit;

   HelpInit.pszHelpLibraryName       = "hidekbd.hlp";
   HelpInit.pszHelpWindowTitle       = "Hide Popup Keyboard Sample Program Help";
   HelpInit.hmodHelpTableModule      = 0;
   HelpInit.hmodAccelActionBarModule = 0;
   HelpInit.phtHelpTable             = (PHELPTABLE)MAKEULONG( HIDEKBD_HELPTABLE, 0xffff );

   HelpInit.cb                       = sizeof( HELPINIT );
   HelpInit.ulReturnCode             = 0L;
   HelpInit.pszTutorialName          = (PSZ)NULL;
   HelpInit.idAccelTable             = 0L;
   HelpInit.idActionBar              = ID_WINDOW;
   HelpInit.fShowPanelId             = CMIC_HIDE_PANEL_ID;

   if ( ! ( hwndHelp = WinCreateHelpInstance( hab, &HelpInit ) ) )
     {

       /***************************/
       /* Help Creation error.    */
       /***************************/
       DisplayMessage(hab, IDS_NO_HELP);

     }
   else
     {
       WinAssociateHelpInstance( hwndHelp, hwndFrame );
     }
}

