#===================================================================
#
# APPLIC Make File
#
#===================================================================
#
#===================================================================
#
.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c

#===================================================================
#
#  Symbol definitions
#
#===================================================================

#===================================================================
#
# Default compilation macros for sample programs
#
#===================================================================
#
# Compile switchs  that are enabled
#
# /c      compile don't link
# /Fa+    Write ASM  file to DASD ( + = YES, - = NO
# /Fd+    Write temp file to DASD ( /Fd- = Write temp files to virtual memory )
# /Fl+    Write basic listing file  ( + = YES, - = NO )
# /Gd     use runtime library that: ( + = Dynamic Link, - = Static Link )
# /Ge     use runtime library that: ( + = EXE Built,    - = DLL Built )
# /Gm     use the multi-threaded libraries ( + = YES, - = NO )
# /Kb     Control basic diagnostic message (/Kb+ = ON, /Kb- = OFF )
# /Kp     Unused Parameter Messages        (/Kp+ = ON, /Kp- = OFF )
# /Fp2    Pack on two byte boundaries
# /Lf+    Write full  listing file  ( + = YES, - = NO )
# /Ms     use the system calling convention and not optilink as the default
# /O      Optimization: ( + = ON, - = OFF )
# /Rx     Subsystem Development (where x = e | n, e=runtime environ, n=none)
# /Se     allow cset  extensions
# /Ss     allow  "//" for comment lines
# /SpX    Pack on "X" boundary, where "X" is 1, 2, 4
# /Ti     Debug Information
#

CCE = icc  /c /Kb+ /Kp+ /Sp2

LFLAGSD    = /ALIGN:4 /NOI
LIBS       = OS2386+PENPM
LINK       = LINK386 $(LFLAGSD)
RC         = rc

#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

all: applic.exe

applic.obj:  applic.c applic.h
  $(CCE) applic.c

applic.res: applic.rc applic.h applic.ico applic.dlg
    $(RC) -r applic.rc

applic.lnk: applic.mak applic.def
    echo applic.obj        > applic.lnk
    echo applic.exe       >> applic.lnk
    echo applic.map       >> applic.lnk
    echo $(LIBS)          >> applic.lnk
    echo applic.def       >> applic.lnk

applic.exe : applic.obj applic.def applic.lnk applic.mak applic.res
    $(LINK) @applic.lnk
    $(RC) applic.res applic.exe
