/*****************************************************************************/
/*                                                                           */
/*  File Name   : APPLIC.H                                                   */
/*                                                                           */
/*  Description : Example Sketch/Handwriting Controls in Pen for OS/2        */
/*                                                                           */
/*  Copyright (C) 1992 IBM Corporation                                       */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */
/*                                                                           */
/*****************************************************************************/

#define ID_MAIN       1000       /* main window */

#define ID_BLACK               1
#define ID_BLUE                2
#define ID_RED                 3

#define BLACK_PEN              5
#define BLUE_PEN               6
#define RED_PEN                7

/****************************/
/* Pull Down Menu ID's      */
/****************************/
#define IDM_FILL_APP       10
#define IDM_DISPLAY_APP    11
#define IDM_EXIT           12


/**********************************************************/
/* Fill Out a Application - Dialog Field Control's        */
/**********************************************************/
#define IDD_FILL                    500

#define IDC_FLD_FIRSTNAME           501
#define IDC_DATA_FIRSTNAME          502
#define IDC_FLD_LASTNAME            503
#define IDC_DATA_LASTNAME           504

#define IDC_FLD_ADDRESS             505
#define IDC_DATA_ADDRESS            506
#define IDC_FLD_CITY                507
#define IDC_DATA_CITY               508
#define IDC_FLD_STATE               509
#define IDC_DATA_STATE              510
#define IDC_FLD_ZIP                 511
#define IDC_DATA_ZIP                512
#define IDC_SIGNATURE               513
#define IDC_SIGNATURE_PROMPT        514

#define IDC_SAVE_OR_NEXT            515
#define IDC_CLEAR_OR_TOP            516
#define IDC_SEARCH                  517
#define IDC_PEN_COLORS              518

/***********************************************/
/* Search Application - Dialog Field Control's */
/***********************************************/
#define IDD_SEARCH                  525
#define IDC_SEARCHBOX               526

#define IDD_MSGBOX                  550
#define MAXTEXTLEN 240                 /* Maximum length for message strings */

/*********************************************/
/* Messagetable Ids                          */
/*********************************************/
#define IDMSG_INFO                    700           /* Information Message   */
#define IDMSG_FILE_END                701           /* End of File.          */

#define IDMSG_WARNING                 710           /* Warning Message       */


#define IDMSG_ERROR                   725           /* Error Message                      */
#define IDMSG_NO_PEN_RUNNING          726           /* Pen for OS/2 is not running.       */
#define IDMSG_FILE_OPEN_ERROR         727           /* File Open Error!                   */
#define IDMSG_FILE_WRITE_ERROR        728           /* File Write Error!                  */
#define IDMSG_FILE_READ_ERROR         729           /* File Read Error!                   */
#define IDMSG_NO_RECORDS              730           /* No Records in File!                */
#define IDMSG_SIGNATURE_READ_ERROR    731           /* Error Reading Signature!           */
#define IDMSG_MISSING_LASTNAME        732           /* Application must have a last name! */
#define IDMSG_MEMORY_ERROR            733           /* Memory Allocation Error.           */
#define IDMSG_MISSING_FILE            734           /* No Applications to Display!        */

/***********************************/
/*   WinLoadString Constants       */
/***********************************/
#define APPLIC_CLASSNAME        750

MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY FillDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DisplayDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY SearchDlgProc( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);


int     main( void );
USHORT  SaveApp(HWND hwndDlg);
USHORT  OpenFile(void);
USHORT  ReadHeader(void);
USHORT  ReadAndDisplaySignature(HWND hwndDlg);
VOID    SetRecord(HWND hwndDlg);
VOID    ClearFields(HWND hwndDlg);
USHORT  ShowMessageBox(HWND hwnd, USHORT idMsg);
VOID    FillToolBar(HWND hwndDlg);
BOOL    CombSizing ( HWND hWnd, USHORT usField, USHORT Columns );

/***************************************/
/* Application Structure saved to file */
/***************************************/
#define LASTNAME_MAX   25
#define FIRSTNAME_MAX  25
#define ADDRESS_MAX    30
#define CITY_MAX       25
#define STATE_MAX      2
#define ZIP_MAX        5


/*************************/
/* Global                */
/*************************/

  HWND      hwndFrame;             /* window handle                          */
  HWND      hwndSearchDlg;         /* Search Dialog handle */
  HAB       hab;                   /* anchor block handle                    */

  USHORT    usResult;              /* Return from dialog box routine         */
  HPOINTER  BlackPen;              /* Black Pen                              */
  HPOINTER  BluePen;               /* Blue Pen                               */
  HPOINTER  RedPen;                /* Red Pen                                */

  ULONG     ulCurrentPtr;          /* Current Record Read or Displayed       */
  ULONG     ulNewPtr;              /* file pointer                           */
  ULONG     ulBytesRead;
  ULONG     ulBytesWritten;
  ULONG     ulAction;
  HFILE     hf;                    /* Address of file handle                 */

  /*********************************************************************/
  /* (Total Stroke Count * sizeof(ULONG) ) + Sum of all Stroke Lengths */
  /*********************************************************************/
  ULONG ulLastSignatureSize;

ULONG     *ulEachStrokeLength;           /* array of stroke lengths          */
CHAR      szSelectedName[LASTNAME_MAX + 1];

typedef struct _APPLICATION {
  CHAR szLastName[LASTNAME_MAX + 1];
  CHAR szFirstName[FIRSTNAME_MAX + 1];
  CHAR szAddress[ADDRESS_MAX + 1];
  CHAR szCity[CITY_MAX + 1];
  CHAR szState[STATE_MAX + 1];
  CHAR szZip[ZIP_MAX + 1];
  ULONG  ulStrokeTotal;            /* total number of strokes in signature   */
  ULONG  ulSignatureSize;          /* includes length bytes and stroke bytes */
} APPLICATION;
APPLICATION   App;                 /* store applicion information            */

/**************************************************/
/* Stroke Data from Signature (QUERY_STROKE_DATA) */
/**************************************************/
PSKETCHSTROKEDEF pStrokeData = NULL;

