
/***********************************************************************/
/* from PCX.H */


 /*****************************************************************************/
 /*                                                                           */
 /* PCX File Data Structures                                                  */
 /*                                                                           */
 /*****************************************************************************/
 
 #define PCXHEADERIDENTIFIER    0x0A
 #define PCXTRAILERIDENTIFIER   0x0C
 
 typedef struct _PCXCOLORMAP { /* pcxc */
     BYTE    bRed;
     BYTE    bGreen;
     BYTE    bBlue;
 } PCXCOLORMAP;
 typedef PCXCOLORMAP FAR *PPCXCOLORMAP;
 
 typedef struct _PCXHEADER { /* pcxh */
     BYTE         bHeaderID;                      /* x'0A'                    */
     BYTE         bVersion;                       /* 0 = 2.5                  */
                                                  /* 2 = 2.8 w/palette data   */
                                                  /* 3 = 2.8 w/o palette data */
                                                  /* 5 = 3.0 w/palette data   */
     BYTE         bEncodingMode;                  /* 1 = RLE                  */
     BYTE         bNumBitsPerPelPerPlane;         /* Bits per pel per plane   */
     USHORT       usXTopLeft;                     /* Cutout window coords     */
     USHORT       usYTopLeft;
     USHORT       usXBottomRight;
     USHORT       usYBottomRight;
     USHORT       usHorzResolution;
     USHORT       usVertResolution;
     PCXCOLORMAP  apcxcPalette16[16];             /* 16-color RGB palette     */
     BYTE         bIgnored;
     BYTE         bNumPlanes;                     /* Normally 1, 3, 4         */
                                                  /* 0 if 2.5 compatible      */
     USHORT       usBytesPerLine;                 /* Bytes per scan line      */
     USHORT       usPaletteInfo;                  /* 1 = Color/BW             */
                                                  /* 2 = Grayscale            */
     BYTE         abIgnored[58];
 } PCXHEADER;
 typedef PCXHEADER FAR *PPCXHEADER;
 
 typedef struct _PCXTRAILER { /* pcxt */
     BYTE         bTrailerID;                     /* x'0C'                    */
     PCXCOLORMAP  apcxcPalette256[256];           /* 256-color RGB palette    */
 } PCXTRAILER;
 typedef PCXTRAILER FAR *PPCXTRAILER;
 



/***********************************************************************/
/* from PCX.H */





/* declared in .c file */

PCXHEADER pcxheader;






/* this is how process_file is called */

   process_file( "apcxfile.pcx" );





/* the message that processes a new PCX file */


case WM_USER+1:

       if(NEW_FILE == 1)
       {
           NEW_FILE = 0;

           rect.xLeft = s_xtl-1;
           rect.yTop = s_ytl+1;
           rect.yBottom = swp_hs.y + swp_hs.cy + border_width;
           rect.xRight = swp_vs.x - border_width;

           WinFillRect(hpsWin, &rect, CLR_WHITE);      /* clears client window */
       }
       pt.x = s_xtl;
       pt.y = s_ytl;

       bm_ptr = start_point;
       stp_pt = s_ybr;

       x = display_bits( hpsWin, bm_ptr, pt, stp_pt );

       break;







/* this function displays the image to the screen */




INT display_bits( HPS hps, CHAR *bitmap_ptr, POINTL pt, LONG stp_pt )
{

LONG x;
APIRET rc;

   for( x=0 ; pt.y >= stp_pt ; pt.y-- )
   {
       GpiMove( hps, &pt );
       rc = GpiImage(hps, 0L, &sizl, nbytes, bitmap_ptr+x+spo );     /* draws the image */
       if( rc != GPI_OK )
           return(-1);
       x = x + byte_line_length;
   } /* end for */

   return(x);
}






/* this function reads a PCX file into memory */
/* it should be updated to use newer memory stuff */





void process_file ( CHAR *cptr )
{

ULONG allocflgs = PAG_WRITE | PAG_READ;
APIRET apirc;

PVOID *temp_point;


   fh= fopen(cptr, "rb");
   fread( (void *)&pcxheader, sizeof(pcxheader), 1, fh);
   total_bytes = pcxheader.usBytesPerLine * ( pcxheader.usYBottomRight + 1 );

   page_length =  pcxheader.usYBottomRight + 1;
   line_length =  pcxheader.usXBottomRight + 1;
   byte_line_length = pcxheader.usBytesPerLine;


/*
   if( MEM_ALLOCATED )
   {
       free( start_point );
       MEM_ALLOCATED = 0;
   }
 else
   {
       first_line = start_point = malloc( sizeof(CHAR)* total_bytes );

       MEM_ALLOCATED = 1;
   }
*/

   if( MEM_ALLOCATED )
       DosFreeMem( first_line );

   apirc = DosAllocMem( (PPVOID)&start_point, sizeof(CHAR)*total_bytes, fALLOC );

   MEM_ALLOCATED = 1;

   first_line = start_point;

   x=0;

   spo=0;

   while( (frc = fread( (void *)&buffer, 1, 1, fh)) == 1 )
   {
       if(x >= total_bytes)
           break;

       if( (buffer & 0XC0) == 0XC0 )
       {
           runlength = buffer & 0X3F;
           fread( (void *)&buffer, 1, 1, fh);

           buffer = buffer ^ 0XFF;

           for( y=0 ; y < runlength ; y++, x++ )
           {
              *(start_point + x ) = buffer;
           }
       }
     else
       {
           buffer = buffer ^ 0XFF;
           *(start_point + x ) = buffer;
           x++;
       }

   }

   x=0;
   fclose( fh);

}
/* end of process file */
ree( start_point );
       MEM_ALLOCATED = 0;
   }
 else
   {
       first_line = start_point = malloc( sizeof(CHAR)* total_bytes );

       MEM_ALLOCATED = 1;
   }
*/

   if( MEM_ALLOCATED )
       DosFreeMem( first_line );

   apirc = DosAllocMem( (PPVOID)&start_point, sizeof(CHAR)*total_bytes, fALLOC );

   MEM_ALLOCATED = 1;

   first_line = start_point;

   x=0;

   spo=0;

   while( (frc = fread( (void *)&buffer, 1, 1, fh)) == 1 )
   {
       if(x >= total_bytes)
           break;

       if( (buffer & 0XC0) == 0XC0 )
       {
           runlength = buffer & 0X3F;
           fread( (void *)&buffer, 1, 1, fh);

           buffer = buffer ^ 0XFF;