/*---------------------------------------------------------------------
Copyright (c) 2000-2001, Vadim Yegorov
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
THE POSSIBILITY OF SUCH DAMAGE.
---------------------------------------------------------------------*/

call  RxFuncAdd  'PCRELoad', 'REXXPCRE', 'PCRELoad'
call  PCRELoad

/*-------------------------------------------------------------------------*/
/**
 *  RxPCRE ।⠢ ᭮ ⮤  ࠡ  ॣ묨
 * ࠦﬨ   㤮 "⪮"  ⥪ libpcre.
 */
::class RxPCRE public
    /* 樠 ꥪ. ࠬ: */
    ::method init
        expose curLocale curMask pcre lasterr pairs
        use arg loc
        if  VAR('LOC') then
    	    curLocale = PCREInit(loc);
        else
            curLocale = PCREInit("");
        curMask = "";    /* current mask */
        pcre    = "";    /* ꥪ, ࠭騩 ⪮஢ ࠦ */
        lasterr = 0 ;    /*  訡 ?! ;)*/
        pairs   = 0 ;
        return self;
    /* 頥 , ਬ  PCRE */
    ::method getLocale
        expose curLocale
        return curLocale;

    /* 頥 ᯮ㥬 */
    ::method getMask
        expose curMask
        return curMask;

    /**  .
     *  @syntax rc = setMask(mask)
     *  @param mask ॣ୮ ࠦ  樨 PERL'a: /regexp/[options]
     *  @return  訡, 0 -- 訡 
     */
    ::method setMask
        expose curMask pcre lasterr pairs subs
        use arg mask
        lasterr = PCRECompile('pcre_tmp', mask);
        if lasterr = 0 then do
            curMask = mask;
            pcre = pcre_tmp;
            /*-- mask analyzing --*/
            n = 0; pairs = 1; l = mask~length
            do i = 1 to l
              ch = mask~substr(i,1);
              if ch = '(' then
                  n = n + 1;
              if ch = ')' then do
                  n = n - 1;
                  if n = 0 then
                      pairs = pairs + 1;
              end
            end
            subs = .array~new(pairs);
        end
        return lasterr

    /**  ࠣ⮢
     * @syntax rc = find(ofs_stem., str, [start_pos [,opts]])
     * @param ofs_stem  ⥬ ᬥ饭, ofs_stem.0 -- ᫮ ⮢
     * @param str       ப
     * @param start_pos ⮢ , 易⥫
     * @param opt 樨, 易⥫, ࠧ襭 ⮫쪮:
     *      A -  Anchored
     *      b -  Not begin of line
     *      e -  Not end of line
     *      g -  Not empty
     *
     * @return  訡
     */
    ::method find
        expose pcre ofs lasterr
        use arg L., str, pos, opts
        if \VAR('POS') then
            pos = 1;
        if \VAR('OPTS') then
            opts = "";
        if \VAR('STR') then
            str = "";

        lasterr = PCREExec(L,pcre,str,pos,opts);
        if lasterr = -1 then
            L.0 = 0;

        return lasterr;


    /**  ࠣ⮢
     * @syntax rc = findSubs(str, [start_pos [,opts]])
     * @param str       ப
     * @param start_pos ⮢ , 易⥫
     * @param opt 樨, 易⥫, ࠧ襭 ⮫쪮:
     *      A -  Anchored
     *      b -  Not begin of line
     *      e -  Not end of line
     *      g -  Not empty
     *
     * @return ᨢ ப, ᮤঠ ࠣ  nil
     *
     */
    ::method findSubs
        expose pcre ofs lasterr subs
        use arg str, pos, opts
        if \VAR('POS') then
            pos = 1;
        if \VAR('OPTS') then
            opts = "";
        lasterr = PCREExec('LO',pcre,str,pos,opts);

        if lasterr = 0 then do
            n = 1;
            do j = 1 to lo.0 by 2
                k = j; kk = k + 1;
                subs[n] = str~substr(lo.k, lo.kk - lo.k);
                n = n + 1;
            end
        end; else
            return .nil;
        return subs;

    /**
     * 頥  襭 ᫥ 樨
     *
     * @return RC, 0 -- 訡 , -1 --  ᯥ襭
     *
     */
    ::method lastError
        expose lasterr
        return lasterr

    /**
     * 頥  libpcre
     *
     * @return ப ᨨ
     */
    ::method getVersion
        return PCREVersion();
    /**
     * 頥  rxlibpcre
     *
     * @return ப ᨨ
     */
    ::method getRxVersion
        return PCRERxVersion();

    /**
     * 頥 ப    ⥪ libpcre
     *
     */
    ::method getAuthor
        return PCREAuthor();

    /**
     * 頥 ப    .
     */
    ::method getPortAuthor
        return PCREPortAuthor();

/*-------------------------------------------------------------------------*/
/**  ।⠢ ᮡ   樨 Perl'a:
 *  ($a, $b, $c) = /mask/ or do smt
 *  ਬ   ࠡ ⠪:
 *  if re~parse(string_for_parsing) then
 *     call re[1], re[2], re[3];
 *  㯯 '()'  ᪥   
 */
::class RxStrParser subclass RxPCRE public
    ::method init
        expose  ofs. slots instr
        use arg l
        super~new(l); /* set locale*/
        ofs.0 = 0;
        slots = 0;
        instr = "";
        return self;
    /** ࠧࠥ ப
      * @syntax rc = re~parse(string_for_parsing,[pos,[opts]])
      * @return 1 -- ᫨ ப 뫠 ࠧ࠭,  0 
      *              祭 ४ ᬮ  訡.
     */
    ::method parse
        expose ofs. slots instr
        use arg str , pos, opts
        if \VAR('POS') then
            pos = 1;
        if \VAR('OPTS') then
            opts = "";

        if  self~find(ofs.,str,pos,opts) = 0 then do
            /* found */
            slots = ofs.0/2;
            instr = str
            return 1;
        end
        /* not found or error occured, see lastError message */
        ofs.0 = 0;
        return 0;

    /**
     * 頥 ப  ᮮ.  ᪨.
     *  ப ⠪    訡 (᪠
     * 'index out of range')
     *
     * @syntax str = re[5];
     * @return ப
     */
    ::method '[]'
        expose ofs. slots  instr
        use arg idx
        if ofs.0 = 0 | idx >= slots then
            return ""; /* out of range */
        /*calc real offsets*/
        L  = idx * 2 + 1;
        H  = L + 1;
        return instr~substr(ofs.L, ofs.H - ofs.L);
/*-------------------------------------------------------------------------*/

