/*
THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

*/

call  RxFuncAdd  'PCRELoad', 'RXLIBPCRE', 'PCRELoad' 
call  PCRELoad

say '-------------------------------------------------'
say  'Version     : ' PCREVersion()
say  'PCRE Author : ' PCREAuthor()
say  'Port Author : ' PCREPortAuthor()

/*set current locale*/
say 'Use locale: 'PCREInit("");
say '-------------------------------------------------'
mask = "/\s*([_a-zA-Z][a-zA-Z0-9._]*)\s*=\s*([^#]*)(#|$)(.*)/"
say 'Mask: 'mask
say 'Compile. RC='PCRECompile('pcre', mask)

str.1 = '  parameter.number.1 = value '
str.2 = '  parameter.number.2 = value  # remark '
str.3 = '  2 = "zzz" '

do i = 1 to 3
  say '------------------------------------------------'
  rc = PCREExec('ofs',pcre,str.i);
  say "exec rc="rc;
  say 'String: "'str.i'"'

  select
    when rc = 0 then do
      do j = 1 to ofs.0 by 2
        k = j; kk = k + 1;
        say j'-'j+1': "'substr(str.i,ofs.k, ofs.kk - ofs.k)'"'
      end    
    end;
    when rc = -1 then do
      say 'Not found :('
    end
    otherwise
      say 'RC='rc
  end

end
say 'Deregistring...'
call PCREDrop
exit 0


