/*----------------------------------------------------------*/
/* V45UPGRD.CMD - Apply PCM Testkit V4.5 Upgrades after     */
/*                PCM V4.1 CDROM used for setup and install */
/*                                                          */
/*    Parameters: NONE                                      */
/*                                                          */
/* OS/2 environment variables for boot and testcase drives. */
/*----------------------------------------------------------*/
'@echo off'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
arg parm.1 comments
'cls'
say ' '
say ' '
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT') /* get OS2 boot drive letter */
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT') /* get testcase drive letter */
rellvl = value('PCM_RELLVL',,'OS2ENVIRONMENT')  /* get OS2 release level     */

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '[1;09;41m ***************************************************************[0;40;37m'
say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
say '[1;09;41m ***************************************************************[0;40;37m'
exit
end

say '[1;13;45m **************************************************************[0;40;37m'
say '[1;13;45m *      Preparing to apply PCM Testkit V4.5 Upgrade           *[0;40;37m'
say '[1;13;45m *                                                            *[0;40;37m'
say '[1;13;45m *        Continue, ONLY if PCM Testkit V4.1 CDROM was        *[0;40;37m'
say '[1;13;45m *       used for PCM setup and testcase installation.        *[0;40;37m'
say '[1;13;45m *                                                            *[0;40;37m'
say '[1;13;45m * Press ENTER to continue, otherwise press CTRL-BREAK to end *[0;40;37m'
say '[1;13;45m **************************************************************[0;40;37m'
pause
say ''
say '[1;09;41m ***********************************************[0;40;37m'
say '[1;09;41m * OS2 environment variable PCM_BOOTDRV is set *[0;40;37m'
say '[1;09;41m * UPDATING PCM Base/LAN testkit directories.  *[0;40;37m'
say '[1;09;41m ***********************************************[0;40;37m'
'xcopy a:\bootdrv\*  'os2drv':\ /s/e/v'

if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ******************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.      *[0;40;37m'
   say '[1;09;41m * PCM Base Testcase drive updates NOT BEING APPLIED. *[0;40;37m'
   say '[1;09;41m ******************************************************[0;40;37m'
   end
else do
   say '[1;09;41m ***************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV is set.    *[0;40;37m'
   say '[1;09;41m * UPDATING PCM Base testcase drive directories.   *[0;40;37m'
   say '[1;09;41m ***************************************************[0;40;37m'
   'xcopy a:\testdrv\*  'tstdrv':\ /s/e/v'
   end

say '[1;13;45m **********************************************************[0;40;37m'
say '[1;13;45m *       PCM Testkit V4.5 Upgrade has been applied.       *[0;40;37m'
say '[1;13;45m *                                                        *[0;40;37m'
say '[1;13;45m * A reboot IS NOT NEEDED to continue with either testing *[0;40;37m'
say '[1;13;45m *                 or results processing.                 *[0;40;37m'
say '[1;13;45m **********************************************************[0;40;37m'

exit

INFO_PLEASE:
  say '[1;26;45mͻ'
  say ' V45UPGRD.CMD - Apply PCM Testkit V4.5 BASE upgrades to system    '
  say '                after V4.1 CDROM used to install BASE testcases.  '
  say '                                                                  '
  say ' Parameters: NONE                                                 '
  say '                                                                  '
  say ' Uses OS/2 environment variables setup by PCMSETUP installation   '
  say ' to determine the testcase drive and OS/2 boot drive for updates. '
  say 'ͼ[0;40;37m'
  exit
