/* ------------------------------------------------------------*/
/* MAKERAW1.CMD  Analyze MMedia testcase logfiles and output a */
/*               summary with 1 line per script PASS or FAIL.  */
/*               Counts total PASS/FAIL and output .RA_ files. */
/* Parameters: NONE                                            */
/* Called by COPYRES.CMD analyze logs copied to \results dirs. */
/* 10-15-1998 Svetlana Kalnina - new code to fix Y2K problem.  */
/* ------------------------------------------------------------*/
'@echo off'
'cls'

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m **************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set. Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.  *[0;40;37m'
   say '[1;09;41m **************************************************************[0;40;37m'
   exit
 end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m **************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set. Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.  *[0;40;37m'
   say '[1;09;41m **************************************************************[0;40;37m'
   exit
 end

if stream(tstdrv':\results\mmepcm\svtraw','c','query size') \= ''
then 'erase 'tstdrv':\results\mmepcm\svtraw\*' '/n > nul'
else 'md 'tstdrv':\results\mmepcm\svtraw'

mach=tstdrv':\results\mmepcm\svtlog'
if stream(mach,'c','query size') = '' then signal END

call SysFileTree mach'\*.log','file','O'
do i=1 to file.0
   say file.i
   filename=FILESPEC("name",file.i)
   say filename
   call examine filename
end

exit

END:
'@echo No results for processing'


/*The procedure to examine multimedia test results*/
examine:
parse arg filename

sourcefile=tstdrv':\results\mmepcm\svtlog\'filename

/* rawfile=overlay('.RA_',filename,pos('.LOG',filename)) */

file_lan=LENGTH(filename)
rawfile=LEFT(filename,file_lan-3)'RA_'
say "rawfile: "rawfile
machfile=tstdrv':\results\mmepcm\svtraw\'rawfile

say 'machfile: 'machfile
say 'sourcefile: 'sourcefile

total_script=0
script_failed=0
script_passed=0
line1="Opening script file"
line2="Script completed successfuly"

do while LINES(sourcefile)\=0
   curent_line = LINEIN(sourcefile)
   if POS(line1,curent_line)>0 then do
      script_name = SUBSTR(curent_line,60,12)
      total_script= total_script+1

      do forever
         curent_line = LINEIN(sourcefile)

         if POS(line2,curent_line)>0 then do
            script_passed=script_passed+1
            say "script_passed= " script_passed
            'echo 'script_name'       :PASSED: >> 'machfile
            leave
         end

         if POS(line1,curent_line)>0 then do
              script_failed=script_failed+1
              say "script_failed= " script_failed
              'echo 'script_name'       :FAILED: **nya** >> 'machfile
              total_script= total_script+1
         end

         if LINES(sourcefile)=0 then do
              script_failed=script_failed+1
              say "script_failed= " script_failed
              'echo 'script_name'       :FAILED: **nya** >> 'machfile
              leave
         end
      end
   end
end

'echo # ---------------------------- >> 'machfile
'echo # TOTAL TESTCASES EXECUTED: 'total_script' >> 'machfile
'echo # ---------------------------- >> 'machfile
'echo #                   PASSED: 'script_passed' >> 'machfile
'echo #                   FAILED: 'script_failed' >> 'machfile
'echo #           Testing ERRORS:  >> 'machfile
'echo # ---------------------------- >> 'machfile
return
