/* *********************************************************************** */
/* COPYRES.CMD - REXX program to copy a SVT bucket's .IND and LOGFILE to   */
/*               \results.                                                 */
/*                                                                         */
/* 1992.May.03    Safa / Trey    Initial code                              */
/* 1993.Nov 28 Steven Hudson     modified for PCM for standalone w/o LAN   */
/* 1996 Oct 15 Svetlana Kalnina  call MAKERAW1.CMD (Y2K), not allraw.exe   */
/* *********************************************************************** */
Parse Upper Arg BUCKET

if BUCKET = '' then
do
   say ''
   say 'Yo! I need a bucket name!'
   say ''
   say 'Usage: copyres bucket'
   say ''
end
else
do
   myDUTID = VALUE('MME-DUTID',,'OS2ENVIRONMENT');
   MMEVER = VALUE('MME-BUILDVER',,'OS2ENVIRONMENT');
   if myDUTID = '' then
    do
      say ''
      say 'ABORTING: You have no MME-DUTID'
      say ''
      exit 1
    end
   if MMEVER = '' then
    do
      say ''
      say 'ABORTING: Problem with MME-BUILDVER'
      say ''
      exit 2
    end
   /*------------------------------*
    * say '      BUCKET: ' BUCKET  *
    * say '   MME-DUTID: ' myDUTID *
    * say 'MME-BUILDVER: ' MMEVER  *
    *------------------------------*/
   parse var myDUTID 4 myDUTnumber
   parse var BUCKET 1 bucketDUTnumber 4
   if myDUTnumber = bucketDUTnumber then
   do
      IndexFile = '\results\mme' || MMEVER || '\svtlog\' || BUCKET || '.ind';
      MasterIndex = '\results\mme' || MMEVER || '\svtlog\' || BUCKET || '.his';
      LogFile   = '\results\mme' || MMEVER || '\svtlog\' || BUCKET || '.log';
      ResultsFile ='\results\mme' || MMEVER || '\svtres\' || bucketDUTnumber || '.res'
      OldPtrFile = '\results\mme' || MMEVER || '\svtres\svtptrs.old'
      SAY ResultsFile
      /* if there is not a results file for this DUT, create one */
      'if not exist ' || ResultsFile || ' echo # > ' || ResultsFile
      /* if there is not an svtptrs.old file, stop and tell the user to get it fixed. */
      rc=stream(OldPtrFile,"c","open read")
      if rc<>'READY:' then
         Do
            SAY OldPtrFile
            SAY 'SVTPTRS.OLD cannot be found.  Please contact your Execution Lead to '
            SAY 'correct this problem, and then type copyres ' || BUCKET || '.'
            exit
         end /* do */
      else
         Do
           rc=stream(OldPtrFile,"c","close")
           call copystuff
         End
   end
   else  /* DUT number and bucket do not match */
   do
      say ''
      say 'Sorry, the bucket does not match your MME-DUTID: ' myDUTID
      say ''
   end
end


say ''
say 'The bucket that just completed was ' bucket

return

copystuff: procedure expose BUCKET IndexFile LogFile MasterIndex bucketDUTnumber ResultsFile
   '@copy \%MME-DUTID%\MME%MME-BUILDVER%\MME%MME-BUILDVER%.IND ' IndexFile
   '@type \%MME-DUTID%\MME%MME-BUILDVER%\LOGFILE               >>' LogFile
   /* change to the appropriate path */
   /* *********@D:********************/
   '@cd \RESULTS\MME%MME-BUILDVER%\SVTLOG'
   /* append .IND to .HIS */
   '@type 'IndexFile '>>' MasterIndex
   /* convert .IND to .RAW */
/********************************************************/
/* Y2K change to use makeraw1.cmd instead of allraw.exe */
/********************************************************/
/* ****'@CALL ALLRAW 'BUCKET****/
'@call MAKERAW1.CMD'
/*******************************/
'  @cd ..\svtraw'
Say BUCKET
'  @if exist 'BUCKET'.RA_ CALL RAW2RA 'BUCKET
'  @if not exist 'BUCKET'.RA_ copy 'BUCKET'.RAW 'BUCKET'.RA!'
   /* now get rid of .RAW file */
'  @del 'BUCKET'.RAW'
   /* finally, call oneres to build a .res file for this DUT */
'CALL  oneres 'bucketDUTnumber
/*'Call remout 'BUCKET*/
'  @cd ..\svtres'
'CALL buc'
return
