/************************************************************************/
/* FLSPGM1.CMD  -  Aurora File System Test case - for JFS,FAT,HPFS      */
/*                                                                      */
/* This testcase WILL FORMAT THE DRIVE LETTER PROVIDED, IT MUST BE JFS. */
/*                                                                      */
/* Parameters: THEY ARE POSITION DEPENDENT                              */
/*  /H:     File size to be created:   KB or MB or GB or Integer#bytes  */
/*  /per:   % drive freespace to fill: 0-->100%                         */
/*  /num:   number of drives:          Default is 1                     */
/*  /dl:    Drive letter(s) to test:   Default is C  (can have mult)    */
/*  /FSDir: Dir  name to be created:   Default is DIR                   */
/*  /FName: File name to be created:   Default is FILE                  */
/*  /iter:  number of iterations:      Default is 1                     */
/*  /AUTO   WHEN CALLED BY PCMJFS.CMD  ANYTHING ELSE=MANUAL PARM INPUT  */
/*----------------------------------------------------------------------*/
/* ONLY NON-BOOTABLE DRIVES CAN BE JFS VOLUMES.  (- indicates bootable) */
/* examples: /dl:-c  is considered a bootable drive.   (abort test run) */
/*           /dl:c   is considered a non-bootable drive.(continue test) */
/*----------------------------------------------------------------------*/
/* A file of size specified (/H:) is created and OS/2 commands used to  */
/* test the file-system using the large file.                           */
/* Commands: COPY, TREE, MKDIR, CHDIR,   RMDIR,  ATTRIB,                */
/*           MOVE, DIR,  TYPE,  REPLACE, COMPARE etc..                  */
/**/
/*    When started by entering "PCMJFS E" where E is the JFS Drive,     */
/*    the remaining parameters will be the default values.              */
/*                                                                      */
/*    When started by entering "FLSPGM1 E" where E is the JFS Drive,    */
/*    the user will be prompted to accept defaults for the remaining    */
/*    parameters, or input new values to overide the defaults.          */
/**/
/* Change history:                                                      */
/* 04-19-99 Initial modifications for OS/2 v4.5 compatibility test kit  */
/*          removed references to Staf, added logging and input parm    */
/*          for passing the drive letter (Rich Bassemir)                */
/* 04-22-99 completed changes to log file and error checking and        */
/*          removed unused code (RTB)                                   */
/* 04-23-99 Added /AUTO as parm.8 from PCMJFS.CMD. If blank or anything */
/*          else as parm.8, user is prompted for each parmameter.  (SWH)*/
/*          Added ? help, and use PCM env vars for boot/test drives(SWH)*/
/* 04-25-99 Corrected a problem with the compare test and removed the   */
/*          compare test when l=2 (not needed). Added the use of the    */
/*          no.in file so test would not wait for user input. Updated   */
/*          the evalution of the commandline variable. Removed an extra */
/*          validate check on a rename. Removed a parse arg commandline */
/*          statement that was causing a problem with the new code for  */
/*          handling user supplied parameters (RTB)                     */
/* 04-30-99 Updated history file to a 8x3 name (rtb)                    */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

/**************************************************************************/
/* USE PCM OS2 ENVIRONMENT VARIABLES TO GET OS/2 BOOT AND TESTCASE DRIVES.*/
/**************************************************************************/
os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

/***************** define the log file and history file *************/
logfile = tstdrv':\jfstest\jfstest.log'
histfile = tstdrv':\jfstest\jfstest.hst'

/***************** initialize a history file **************************/
res = lineout(histfile, '***** 'time() date()' FLSPGM1 History *****')
res = lineout(histfile)

/***************** copy existing file to history ********************/
'copy 'histfile'+'logfile' 'histfile
'erase 'logfile

/**************** start a new log file *****************************/
res = lineout(logfile, '     ')
res = lineout(logfile, '***** 'time() date()' FLSPGM1 STARTING *****')
res = lineout(logfile)

start_time = date('u') time('c')

/**/
/**/
arg parm.1 parm.2 parm.3 parm.4 parm.5 parm.6 parm.7 parm.8 comments    /*SWH*/
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

/**/
/* If called by PCMJFS.CMD, jfsdrv is from user, rest of parms are defaults. */
/**/
if parm.8 = '/AUTO' then do          /* build commandline from first 7 parms */
   commandLine = ' 'parm.1' 'parm.2' 'parm.3' 'parm.4' 'parm.5' 'parm.6' 'parm.7
   say commandline
   signal AUTORUN
   end
else do     /**/
     'cls'  /* not called by PCMJFS.CMD, present dflts, allow user to change */
     say ' '/**/
     say ' '
     say ''
     say 'Parameters are position dependent - following are defaults:     '
     say ''
     say ' P1 = /H:    (File size to create:  Default is 10MB  #MB or #GB)'
     say ' P2 = /per:  (% freespace to fill:  Default is 90       0-->100)'
     say ' P3 = /num:  (number of drives:     Default is 1)'
     say ' P4 = /dl:   (Drive letter(s)       Default is E)'
     say ' P5 = /FSDir:(Dir  name to create:  Default is DIR)'
     say ' P6 = /FName:(File name to create:  Default is FILE)'
     say ' P7 = /iter: (number of iterations: Default is 1)'
     say ''
     say ' Type  Y  and press enter to accept all defaults'
     say ' or'
     say ' Type  N  to change any or all of the parameters from defaults'
     say ''
     pull rundflt
     if rundflt = 'Y' then do
        commandLine = '/H:10MB /PER:90 /NUM:1 /DL:E /FSDIR:JDIR /FNAME:JFILE /ITER:1'
        res = lineout(logfile, '       ')
        res = lineout(logfile, 'Starting FLSPGM1.CMD with DEFAULT Values passed from PCMJFS.CMD')
        res = lineout(logfile)
        signal AUTORUN
        end
     else do
     /**/
     /* Show parameter description and default, accept new input from user.  */
     /**/
     res = lineout(logfile, '       ')
     res = lineout(logfile, 'USER STARTING FLSPGM1 - WITH OWN PARM VALUES')
     res = lineout(logfile)
     say ''
     say ' P1 = /H:10MB  (File size to create during test)'
     say ' '
     say 'Press Enter to accept default, or enter new value (##MB or ##GB)'
     say ''
     pull A1
     if A1 = '' then do
        P1 = '/H:10MB '
        end
     else do
          P1 = '/H:'||A1
          end
     say ''
     say ' P2 = /per:90  (% freespace to fill on JFS Drive: Range 0-->100)'
     say ' '
     say 'Press Enter to accept default, or enter new value (##)'
     say ''
     pull A2
     if A2 = '' then do
        P2 = '/per:90 '
        end
     else do
          P2 = '/per:'||A2
          end
     say ''
     say ' P3 = /num:1   (number of JFS Drives to test)'
     say ' '
     say 'Press Enter to accept default, or enter new value (#)'
     say ''
     pull A3
     if A3 = '' then do
        P3 = '/num:1 '
        end
     else do
          P3 = '/num:'||A3
          end
     say ''
     say ' P4 = /dl:E   (JFS Drive letter(s) to be tested'
     say ' '
     say 'Press Enter to accept default, or enter new value (X)'
     say ''
     pull A4
     if A4 = '' then do
        P4 = '/dl:E '
        end
     else do
          P4 = '/dl:'||A3
          end
     say ''
     say ' P5 = /FSDir:Dir  (Directory name to create on JFS Drive)'
     say ' '
     say 'Press Enter to accept default, or enter new value (______)'
     say ''
     pull A5
     if A5 = '' then do
        P5 = '/FSDir:DIR '
        end
     else do
          P5 = '/FSDir:'||A5
          end
     say ''
     say ' P6 = /FName:File  (fILE name to create on JFS Drive)'
     say ' '
     say 'Press Enter to accept default, or enter new value (______)'
     say ''
     pull A6
     if A6 = '' then do
        P6 = '/FName:DIR '
        end
     else do
          P6 = '/FName:'||A6
          end
     say ''
     say ' P7 = /iter:1   (number of iterations of testcase to run)'
     say ' '
     say 'Press Enter to accept default, or enter new value (______)'
     say ''
     pull A7
     if A7 = '' then do
        P7 = '/iter:1 '
        end
     else do
          P7 = '/iter:'||A7
          end
     say ''
     commandLine = ' 'P1' 'P2' 'P3' 'P4' 'P5' 'P6' 'P7
     res = lineout(logfile, 'PARMS ARE 'commandline)
     res = lineout(logfile)
     /**/
     end /* End of ELSE DO when /AUTO parm #8 was not passed from pcmjfs.cmd */

/**/
/**/
AUTORUN:

call InitCommandLineParser
call AddCommandLineOption "hds"
call AddCommandLineOption "Percen"
call AddCommandLineOption "numDr"
call AddCommandLineOption "dLetter"
call AddCommandLineOption "fsdir"
call AddCommandLineOption "fName"
call AddCommandLineOption "iter"

call ParseCommandLine commandline
if RESULT \= 0 then call bad_exit 1

/*----------------------------------------*/
call CommandLineOptionValue("hds")
hds = RESULT
res = lineout(logfile, '-----> File size to create = 'hds)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("percen")
percen = RESULT
res = lineout(logfile, '-----> Percentage of free space to fill = 'percen)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("numDr")
numDr = RESULT
res = lineout(logfile, '-----> Number of drives = 'numdr)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("dLetter")
dLetter = RESULT
res = lineout(logfile, '-----> Drive letter = 'dletter)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("fsDir")
fsDir = RESULT
res = lineout(logfile, '-----> Directory = 'fsdir)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("fName")
fName = RESULT
res = lineout(logfile, '-----> File name = 'fname)
res = lineout(logfile)
/*----------------------------------------*/
call CommandLineOptionValue("iter")
iter = RESULT
res = lineout(logfile, '-----> Number of iterations = 'iter)
res = lineout(logfile)
/*---------------------------------------------------------------------------*/

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/****************************************************************************/
'format 'dletter': /fs:jfs /bs:4096 /ls:10  < yes.in'
/****************************************************************************/
hdsize = 1024
fsize = 0
fpsize=0
val = 0
curdir = directory()
nbytes=0
niter=0
k = 0
check = 0
do i = 1 to numdr
     say 'enter the drive letter'
     say 'enter - before any boot drive. ex: -c '
     disk = sysdriveinfo(dletter)
     say "Disk Drive under test = "disk
     parse var disk var1 var2 var3 var4
     say "Disk space free  =" var2
     /*----------------------------------*/
     say "Total Disk Space = " var3
     var5 = var3 - var2
     say "Available Space = " var5
     /*----------------------------------*/
     per = (percen/100)
     say "percentage of disk to be filled = " per
     hpercen = trunc(per*var2)
     say "truncated percentage = " hpercen
     /*----------------------------------------------------------*/
     /* hpercen = hpercen - reserving free space for other files */
     /*----------------------------------------------------------*/
     say "percentage of hard disk you want to fill" hpercen
     res = lineout(logfile, 'Percentage of hard disk you want to fill 'hpercen)
     res = lineout(logfile)
end

/****************************************************************************/
if (Right(hds,1) = 'B') then
   nbytes = Length(hds)
else
do
   Say hds "is not a valid drive size"
   Say "enter a valid Drive size"
   Call SysSleep(5)
   call bad_exit 2
end

/****************************************************************************/
select
     when (Right(hds, 2) = 'KB') then
        do
        len = nbytes -2
        hdsize = left(hds , len) * 1024
        say 'file size to be used = 'hdsize
        res = lineout(logfile, 'File size to be used = 'hdsize)
        res = lineout(logfile)
        end
     when (Right(hds, 2) = 'MB') then
        do
        len = nbytes -2
        hdsize = left(hds , len) * 1024 * 1024
        say 'file size to be used = 'hdsize
        res = lineout(logfile, 'File size to be used = 'hdsize)
        res = lineout(logfile)
        end
     when (Right(hds, 2) = 'GB') then
       do
       len = nbytes -2
       hdsize = Left(hds , len) * 1024 * 1024 * 1024
       say 'file size to be used = 'hdsize
        res = lineout(logfile, 'File size to be used = 'hdsize)
        res = lineout(logfile)
       end
     otherwise NOP
end

/****************************************************************************/
hdsize = hdsize - 500
if (hdsize > hpercen) then
do
  say " can't create file of" hdsize "on hard disk size of" hpercen
  call bad_exit 3
end
/*--------------------------------------------------------------------------*/
/* calculating the number of file of file size hds to be created on hpercen */
/*--------------------------------------------------------------------------*/
fno = trunc(hpercen/hdsize)
res = lineout(logfile, 'Calculating the number of files to be created ')
res = lineout(logfile, 'fno='fno' hpercen='hpercen' hdsize=' hdsize )
res = lineout(logfile)
say "fno" fno "hpercen" hpercen "hdsize" hdsize
/****************************************************************************/
do i = 1 to numDr
   if (left(dletter, 1) = '-') then
      bdrive.i = right(dletter,1) || ':'
   else
      do
      bdrive.i = ''
      end
   dletter.i = right(dletter,1) || ':'
end
/****************************************************************************/
say "File Size - hdsize = " hdsize
say "Drive Letter - dletter.1 =" dletter.1
say fsdir '\' fname
/* enter this loop with these variables defined                         */
/* dletter.i - drive letter                                             */
/* fsdir - the name of the file directory supplied from the command line*/
/* fname - the name of the file supplied from the command line          */

do i = 1 to numDr
  do l = 1 to fno
    do j = 1 to iter
       tardir = dletter.i'\'fsdir||j||l       /* define d:\fsdir11 directory */
       targetd = '\'fsdir ||j||l              /* \fsdir11 directory */
       tempdir = tardir'\temp'                /* d:\fsdir11\temp    */
       tempd = targetd'\temp'                 /* \fsdir11\temp      */
       filename = tardir'\'fname||j||l        /* d:\fsdir11\fname11 */
       filnm = fname||j||l                    /* fname11            */
       outfile = tardir'\outfile'             /* d:\fsdir11\outfile */
       smlfile = tardir'\smlfile'             /* d:\fsdir11\smlfile */
       smfilnm = 'smlfile'
       tempfile = tardir'\tempfile'
       repfile1 =  tardir'\repfile1'
       repfile2 =  tempdir'\repfile1'
       resfile = tardir'\pdirres'
       trc = tardir '\temprc'
       compfil =tardir'\temp\compfile'        /*files for the compare test */
       compfil1 =tardir'\temp\compfil1'
       clndir = fsdir ||j||l

       say filename
       say 'creating a directory on ' dletter.i
       res = lineout(logfile, 'Creating a directory on 'dletter.i)
       res = lineout(logfile)

       dletter.i
       "CD" '\'

       Mkdir tardir        /* create d:\fsdir1 directory */
       /************** start a large file *****************/
       call lineout filename,'Testing file system test case' , 1
       call lineout filename
       call SYSFileTree filename ,'file'      /* third token is file size */
       parse var file.1 one two fsize three   /* parse out the file size  */

       /************** start a small file *****************/
       call lineout smlfile,'Adding smaller file increments' , 1
       call lineout smlfile
       call SYSFileTree filename ,'file'     /* third token is file size */
       parse var file.1 one1 two1 smlfsize three1
       file.1 = 0

       /****************** Create the Large file ************/
       res = lineout(logfile, 'Creating large files to fill up disk ')
       res = lineout(logfile)
       do until hdsize <= fsize         /* loop until file size > hard drive */
         copy filename '+' filename  tempfile  /* double size of file  */
         call SysFileDelete (filename)         /* delete original file */
         rename tempfile filnm            /* rename file to fsname11   */
         fsize = 2*fsize                  /* double the file size parm */
         check = hdsize - fsize           /* check is the difference   */
         res = lineout(logfile, 'hdsize is currently 'hdsize' needs to be less then fsize currently at 'fsize)
         res = lineout(logfile)
         /*---------------------------------------------------------------------*/
         /* if we are going exceed the limit of the drive in the next iteration */
         /*---------------------------------------------------------------------*/
         cd targetd
         if ((2*fsize) > hdsize ) then
         do
           res = lineout(logfile, 'file size is approaching hdsize')
           res = lineout(logfile, 'working on small file build')
           res = lineout(logfile)
           do while (fsize < hdsize)
              /*-------------------------------------------------------*/
              /* Keep adding small file to filename until reach hdsize */
              /*-------------------------------------------------------*/
              if ((2*smlfsize) < check) then    /*                        */
              do
                /*-------------------------------------------*/
                /* another small file when added to filename */
                /* still keeps it less than hdsize           */
                /*-------------------------------------------*/
                copy smlfile '+' smlfile tempfile     /*double file size   */
                call SysFileDelete (smlFile)        /*delete original file */
                rename tempfile smfilnm       /*rename new file to smlfile */
                smlfsize = 2* smlfsize        /*smlfsize is now doubled */
              end
              /*--------------------------------*/
              /* Add the small file to filename */
              /*--------------------------------*/
              copy filename  '+'  smlFile           /*append to test file  */
              /*call SysFileDelete (smlFile) unclear why this is here      */
              /*--------------------------------*/
              fsize = fsize  + smlfsize             /*file size increase   */
              check = hdsize - fsize              /* difference left to go */
              res = lineout(logfile, 'file size is 'fsize' with 'check' left to go')
              res = lineout(logfile)
           end  /* end of do while fsize < hdsize */
           /***************************************/
           call SysFileDelete (smlFile)     /* delete file to start fresh  */
         end /* end do if 3*fsize > hdsize   */
       end   /* end do until hdsize <= fsize */
       /*--------------------------------------------------------------*/
       /******** Testing OS2 commands on Large file that we created****/
       /*--------------------------------------------------------------*/
       /*************************Testing DIR command******/
       "CD" targetD
       "DIR"
       call validate RC "Dir"
       res = lineout(logfile, 'Checked the DIR command ')
       res = lineout(logfile)
       /*************************Testing TREE command*****/
       "CD" targetD
       Tree
       call validate RC "TREE"
       res = lineout(logfile, 'Checked the TREE command ')
       res = lineout(logfile)
       /*************************Testing RENAME command***/
       "RENAME" rtncode tempf
       testResult=RC
       call validate RC "Rename"
       res = lineout(logfile, 'Checked the RENAME command ')
       res = lineout(logfile)
       /*************************Testing CHKDSK command***/
       "CHKDSK" dletter.i
       testResult=RC
       call validate RC "CHKDSK"
       res = lineout(logfile, 'Checked the CHKDSK command ')
       res = lineout(logfile)
       /*************************Testing ATTRIB command***/
       "CD" targetD
       "ATTRIB" '-R' fileName
       testResult=RC
       call validate RC "ATTRIB"
       res = lineout(logfile, 'Checked the ATTRIB command ')
       res = lineout(logfile)
       /*************************Testing mkDir command****/
       "CD" '\'
       "MD" tempDir
       testResult=RC
       call validate RC "MkDir"
       res = lineout(logfile, 'Checked the MKDIR command ')
       res = lineout(logfile)
       /*************************Testing Compare command**/
       /****compare the files on the same disk****/
       "CD" targetd
       "CD" tempdir
       call lineout compfil,"compare test"
       call lineout compfil
       call lineout compfil1,"compare test"
       call lineout compfil1
       comp compfil compfil1 ' < 'tstdrv':\util\no.in'
       testResult=RC
       call validate RC "COMPARE"
       res = lineout(logfile, 'Checked the COMPARE command ')
       res = lineout(logfile)
       /***************Testing Replace command*****************/
       "CD" targetd
       call lineout repfile1,'Replace Command test: File 1',1
       call lineout repfile1
       call lineout repfile2,'Replace Command test: File 2',1
       call lineout repfile2
       REPLACE repfile1 tempd
       call validate RC "Replace"
       res = lineout(logfile, 'Checked the REPLACE command ')
       res = lineout(logfile)
       /***************Testing RmDir command*****************************/
       "CD"'\'
       "CD" tempDir
       "DEL" '*.* /n'
       "CD"..
       RmDir temp
       testResult=RC
       call validate RC "RmDir"
       res = lineout(logfile, 'Checked the RMDIR command ')
       res = lineout(logfile)
       /***************Testing Move command*****************/
       "CD" targetd
       "MD" tempdir
       call lineout movfile,"Move command test"
       call lineout movfile
       move movfile tempd
       testResult=RC
       call validate RC "MOVE"
       res = lineout(logfile, 'Checked the MOVE command ')
       res = lineout(logfile)
       /***************Testing Find command*****************/
       call lineout filename,'Find Test'
       call lineout filename
       Find '"Find Test"' filename
       call validate RC "FIND"
       res = lineout(logfile, 'Checked the FIND command ')
       res = lineout(logfile)
       /***************Testing Type command*****************/
       /*                         */
       /* "CD" targetd            */
       /*  Type filename          */
       /*call validate RC "TYPE"  */
       /*****************Cleanup after each iteration*******/
       cleanup:
       k = k+1
       if bdrive.i = ''then
         do
           if ((i > 1) & (k = j)) then
             do
               Say" Non BootCleanup"
               /*****LVM /delete:dletter.i ,partname.i*****/
             end
         end
         else do
              "CD" targetd
              "CD" temp
              del '*.* /n'
              "CD"..
              rmdir temp
              del '*.* /n'
              "CD"..
              call SysRmDir tardir
              end
       /*------------*/
    end  /* end do J */
  end    /* end do L */
end      /* end do I */
res = lineout(logfile, '******* FLSPGM1 has completed successfully 'time() date())
res = lineout(logfile, '       ')
res = lineout(logfile)
say "TEST CASE FINISHED"
call directory curdir    /*return to the original directory */

Return 0
/*****************************************************************************/
/*****************************************************************************/


/*********************************************************************/
/* InitCommandLineParser - Initializes the command line parser       */
/* Accepts:                                                          */
/*  Optionally, max number of command line arguments (default = 0)   */                                                */
/*  Optionally, indication whether parser should be case sensitive   */
/*      (0 = case insensitive, 1 = case sensitive) (default = 0)     */
/*                                                                   */
/* Returns: 0                                                        */
/*********************************************************************/
InitCommandLineParser: PROCEDURE EXPOSE CommandLineParser.

parse arg maxArgs, caseSensitive

if maxArgs = '' then maxArgs = 0

if DATATYPE(maxArgs, "W") \= 1 then maxArgs = 0

if caseSensitive = '' then caseSensitive = 0

if (caseSensitive \= 0) & (caseSensitive \= 1) then caseSensitive = 0

CommandLineParser.!MaxArgs = maxArgs
CommandLineParser.!CaseSensitive = caseSensitive
CommandLineParser.!Option.0 = 0
CommandLineParser.!Group.0 = 0
CommandLineParser.!Need.0 = 0
CommandLineParser.!Arg.0 = 0
CommandLineParser.!Instance.0 = 0
CommandLineParser.!Debug = 0

RETURN 0

/* End of InitCommandLineParser */


/*********************************************************************/
/* AddCommandLineOption - Adds an option to the parser               */
/*                                                                   */
/* Accepts:                                                          */
/*    The name of the option.                                        */
/*    Optionally, the number of times this option may be specified   */
/*                (0 = unlimitied) (default = 1)                     */
/*    Optionally, indiation of whether this option may have a value  */
/*            ("YES" = the option must have a value)                 */
/*            ("NO"  = the option must not have a value)             */
/*            ("ALLOWED" = the option may have value, not required   */
/*            (default = "YES")                                      */
/*                                                                   */
/* Returns: 0 , if the option was successfully added                 */
/*          >0, if there was an error adding the option              */
/*********************************************************************/
AddCommandLineOption: PROCEDURE EXPOSE CommandLineParser.

parse arg optionName, optionCount, optionValueReq

if optionName  = "" then RETURN 1
if optionCount = "" then optionCount = 1

if DATATYPE(optionCount, "W") \= 1 then optionCount = 1

if optionCount < 0 then optionCount = 1

if optionValueReq = "" then optionValueReq = "YES"

optionValueReq = TRANSLATE(optionValueReq)

if WORDPOS(optionValueReq, "YES NO ALLOWED") = 0 then optionValueReq = "YES"

index = CommandLineParser.!Option.0 + 1

CommandLineParser.!Option.0               = index
CommandLineParser.!Option.index.!Name     = optionName
CommandLineParser.!Option.index.!Count    = optionCount
CommandLineParser.!Option.index.!ValueReq = optionValueReq

RETURN 0
/* End of AddCommandLineOption */

/*********************************************************************/
/* CommandLineOptionTimes - Returns the number of times an option    */
/*                          was specified                            */
/*                                                                   */
/* Accepts: The name of the option                                   */
/*                                                                   */
/* Returns: The number of times the option was specified             */
/*          0 is returned if an invalid option is specified          */
/*********************************************************************/
CommandLineOptionTimes: PROCEDURE EXPOSE CommandLineParser.

  parse arg name

  if name = "" then RETURN 0

  if \CommandLineParser.!CaseSensitive then name = TRANSLATE(name)

  numTimes = 0

  do i = 1 to CommandLineParser.!Instance.0

      if \CommandLineParser.!CaseSensitive then
          testName = TRANSLATE(CommandLineParser.!Instance.i.!Name)
      else
          testName = CommandLineParser.!Instance.i.!Name

      if name = testName then numTimes = numTimes + 1

  end

  RETURN numTimes
/* End of CommandLineOptionTimes */


/*********************************************************************/
/* CommandLineOptionValue - Returns the value of the specified       */
/*                          instance of an option                    */
/*                                                                   */
/* Accepts: The name of the option                                   */
/*          Optionally, the desired instance of the option           */
/*            (default = 1)                                          */
/*                                                                   */
/* Returns: The value of the specified instance of the option        */
/*          The empty string is returned if an invalid option or     */
/*            non-existant instance is specified                     */
/*********************************************************************/
CommandLineOptionValue: PROCEDURE EXPOSE CommandLineParser.

  parse arg name, index

  if name = "" then RETURN 0

  if \CommandLineParser.!CaseSensitive then name = TRANSLATE(name)

  if index = "" then index = 1
  if DATATYPE(index, "W") \= 1 then index = 1
  if index < 1 then index = 1

  value = ""
  numTimes = 0

  do i = 1 to CommandLineParser.!Instance.0 while numTimes \= index

      if \CommandLineParser.!CaseSensitive then
          testName = TRANSLATE(CommandLineParser.!Instance.i.!Name)
      else
          testName = CommandLineParser.!Instance.i.!Name

      if name = testName then numTimes = numTimes + 1
      if numTimes = index then value = CommandLineParser.!Instance.i.!Value

  end

  RETURN value
/* End of CommandLineOptionValue */


/*********************************************************************/
/* ParseCommandLine - Parses the indicated command line              */
/*                                                                   */
/* Accepts: The command line to parse                                */
/*                                                                   */
/* Returns: 0 , if command line successfully parsed                  */
/*          >0, if an error was encountered during the parse (in     */
/*            this case the variable CommandLineParseErrorBuffer     */
/*            will be set to a descriptive error message)            */
/*********************************************************************/
ParseCommandLine: PROCEDURE EXPOSE CommandLineParser.,
                                   CommandLineParseErrorBuffer

parse arg line

if line = "" then do
    CommandLineParseErrorBuffer = "You must specify a command line"
    RETURN 1
end

CommandLineParser.!Arg.0 = 0
CommandLineParser.!Instance.0 = 0
CommandLineParseErrorBuffer = ""
whiteSpace = " "
optionIndicator = "-/"
valueSeparator = ":"
inQuote = 0
inEscape = 0
mode = "NONE"
currData = ""
word.0 = 0
/*---------------------------------------------------------------------------*/
/* First break up the command line into OPTIONs, OPTIONDATA, and DATA        */
/*---------------------------------------------------------------------------*/
do i = 1 to LENGTH(line)
    currChar = SUBSTR(line, i, 1)
    if inEscape then do
        inEscape = 0
        currData = currData || currChar
        end
    else if inQuote then do
        if currChar = '"' then inQuote = 0
        else if currChar = '\' then inEscape = 1
        else currData = currData || currChar
        end
    else if POS(currChar, whiteSpace) \= 0 then do
        if mode = "NONE" then ITERATE
        else call CommandLineParserInternalAddWord "NONE"
        end
    else if currChar = '"' then do
        inQuote = 1
        if mode = "OPTION" then
            call CommandLineParserInternalAddWord "OPTIONDATA"
        else if mode = "NONE" then
            mode = "DATA"
        end
    else if POS(currChar, optionIndicator) \= 0 then do
        if mode = "NONE" then mode = "OPTION"
        else currData = currData || currChar
        end
    else if POS(currChar, valueSeparator) \= 0 then do
        if mode = "OPTION" then
            call CommandLineParserInternalAddWord "OPTIONDATA"
        else do
            if mode = "NONE" then mode = "DATA"
            currData = currData || currChar
            end
        end
    else do
        if mode = "NONE" then mode = "DATA"
        currData = currData || currChar
        end
end     /* for I = 1 to length - process each character in line */

/*---------------------------------------------------------------------------*/
if mode \= "NONE" then
    call CommandLineParserInternalAddWord "NONE"

if CommandLineParser.!Debug then do
     do i = 1 to word.0
        say "Word" i":" word.i.!Data"("word.i.!Type")"
     end
   end

/*---------------------------------------------------------------------------*/
/*        Now go through the words, validate the options themselves,         */
/*                 and create the list of option instances.                  */
/*---------------------------------------------------------------------------*/
currOption = ""
valueReq = "NO"
do i = 1 to word.0
    if word.i.!Type = "OPTION" then
    do  /*--------------------------------------------------------*/
        /* See if we can match this option up with a valid option */
        /*--------------------------------------------------------*/
        if \CommandLineParser.!CaseSensitive then
            thisOption = TRANSLATE(word.i.!Data)
        else
            thisOption = word.i.!Data
        /*--------------------------------------------------------*/
        theOption = 0
        possibleOption.0 = 0
        optionData = ""
        hasValue = 0
        /*--------------------------------------------------------*/
        do j = 1 to CommandLineParser.!Option.0 while theOption = 0
            /*--------------------------------------------------------*/
            if \CommandLineParser.!CaseSensitive then
                testOption = TRANSLATE(CommandLineParser.!Option.j.!Name)
            else
                testOption = CommandLineParser.!Option.j.!Name
            /*--------------------------------------------------------*/
            if thisOption = testOption then
            do  /*----------------------------------------------------*/
                /* This is a straight match like /Testcase for option */
                /* 'Testcase'                                         */
                /*----------------------------------------------------*/
                theOption = j
            end
            /*--------------------------------------------------------*/
            else if LEFT(testOption, LENGTH(thisOption)) = thisOption then
            do  /*--------------------------------------------------------*/
                /* This is a possible match like /Test for option */
                /* 'Testcase'                                     */
                /*--------------------------------------------------------*/
                possibleOptionIndex = possibleOption.0 + 1
                possibleOption.0 = possibleOptionIndex
                possibleOption.possibleOptionIndex.!Index = j
                possibleOption.possibleOptionIndex.!Value = ""
            end
            /*------------------------------------------------------------*/
            else if LEFT(thisOption, LENGTH(testOption)) = testOption then
            do  /*--------------------------------------------------------*/
                /* This is a possible match with data like /FeProg.exe    */
                /* for 'Fe'.  It is not a straight match because of       */
                /* cases like /Fst matching Fs with 't' data when both    */
                /* Fs and Fst are options.                                */
                /*--------------------------------------------------------*/
                possibleOptionIndex = possibleOption.0 + 1
                possibleOption.0 = possibleOptionIndex
                possibleOption.possibleOptionIndex.!Index = j
                possibleOption.possibleOptionIndex.!Value =,
                    SUBSTR(word.i.!Data, LENGTH(testOption) + 1)
            end
            /*-------------------------------------------------------*/
        end /* for j= 1 to cmdline parser - each possible option     */
        /*-----------------------------------------------------------*/
        /* If we didn't get a straight match, see if we got only one */
        /* possible match.  If so, then use the possible match.      */
        /*-----------------------------------------------------------*/
        if theOption = 0 & possibleOption.0 = 1 then
          do
            theOption = possibleOption.1.!Index
            optionData = possibleOption.1.!Value
          end
        /*------------------------------------------------------------*/
        if theOption \= 0 then
         do /*------------------------------------------------------------*/
            /* We found an appropriate match */
            /*------------------------------------------------------------*/
            if valueReq = "YES" then
            do  /*--------------------------------------------------*/
                /* Error, previously found option requires a value */
                /*--------------------------------------------------*/
                CommandLineParseErrorBuffer = "You must specify a value",
                                              "for option" currOption
                RETURN 1
            end
            /*------------------------------------------------------------*/
            else if valueReq = "ALLOWED" then
            do  /*--------------------------------------------------*/
                /* Previously found option does not get a value */
                /*--------------------------------------------------*/
                instanceIndex = CommandLineParser.!Instance.0 + 1
                CommandLineParser.!Instance.0 = instanceIndex
                /*--------------------------------------------------*/
                CommandLineParser.!Instance.instanceIndex.!Name = currOption
                CommandLineParser.!Instance.instanceIndex.!Value = ""
            end
            /*------------------------------------------------------------*/
            if (CommandLineOptionTimes(CommandLineParser.!Option.theOption.!Name) =,
                CommandLineParser.!Option.theOption.!Count) &,
               (CommandLineParser.!Option.theOption.!Count \= 0) then
            do  /*----------------------------------------------------*/
                /* This instance exceeds this option's instance limit */
                /*----------------------------------------------------*/
                CommandLineParseErrorBuffer = "You may specify no more than",
                    CommandLineParser.!Option.theOption.!Count "instance(s)",
                    "of option" CommandLineParser.!Option.theOption.!Name
                /*--------------------------------------------------*/
                RETURN 1
            end
            /*------------------------------------------------------------*/
            if (optionData \= "") &,
               (CommandLineParser.!Option.theOption.!ValueReq = "NO") then
            do  /*--------------------------------------------------*/
                /* They specified option data and it is not allowed */
                /*--------------------------------------------------*/
                CommandLineParseErrorBuffer = "Option",
                    CommandLineParser.!Option.theOption.!Name "is not",
                    "allowed to have a value"
                /*--------------------------------------------------*/
                RETURN 1
            end
            /*------------------------------------------------------------*/
            else if optionData \= "" then
            do  /*----------------------------------------------------------*/
                /* They specified option data and the option either allows  */
                /* or requires it.  First, add this option to instance list */
                /*----------------------------------------------------------*/
                instanceIndex = CommandLineParser.!Instance.0 + 1
                CommandLineParser.!Instance.0 = instanceIndex
                /*----------------------------------------------------------*/
                CommandLineParser.!Instance.instanceIndex.!Name =,
                    CommandLineParser.!Option.theOption.!Name
                CommandLineParser.!Instance.instanceIndex.!Value = optionData
                /*----------------------------------------------------------*/
                /* Now, initialize currOption in case we get an OPTIONDATA. */
                /* Be sure to set hasValue, to identify that this option    */
                /* has already received a value.                            */
                /*----------------------------------------------------------*/
                currOption = CommandLineParser.!Option.theOption.!Name
                valueReq = "NO"
                hasValue = 1
            end
            /*------------------------------------------------------------*/
            else if CommandLineParser.!Option.theOption.!ValueReq = "NO" then
            do  /*----------------------------------------------------------*/
                /* The option does not accept data    */
                /* First, add it to the instance list */
                /*----------------------------------------------------------*/
                instanceIndex = CommandLineParser.!Instance.0 + 1
                CommandLineParser.!Instance.0 = instanceIndex
                /*----------------------------------------------------------*/
                CommandLineParser.!Instance.instanceIndex.!Name =,
                    CommandLineParser.!Option.theOption.!Name
                CommandLineParser.!Instance.instanceIndex.!Value = ""
                /*----------------------------------------------------------*/
                /* Now, initialize currOption in case we get an OPTIONDATA */
                /*----------------------------------------------------------*/
                currOption = CommandLineParser.!Option.theOption.!Name
                valueReq = "NO"
            end
            /*------------------------------------------------------------*/
            else
            do  /*----------------------------------------------------------*/
                /* The option either allows or requires data, but no */
                /* option data was specified.  We should get a       */
                /* subsequent OPTIONDATA or DATA.                    */
                /*----------------------------------------------------------*/
                currOption = CommandLineParser.!Option.theOption.!Name
                valueReq = CommandLineParser.!Option.theOption.!ValueReq
            end
         end  /* end if option /= 0 */
         /*-----------------------------------------------------------------*/
         else if possibleOption.0 > 1 then
         do /*------------------------------------*/
            /* We found too many possible matches */
            /*------------------------------------*/
            firstMatch = possibleOption.1.!Index
            /*------------------------------------*/
            CommandLineParseErrorBuffer = "Option" word.i.!Data "is",
                "ambiguous.  It matches",
                CommandLineParser.!Option.firstMatch.!Name
            /*------------------------------------*/
            do j = 2 to possibleOption.0 - 1
                nextMatch = possibleOption.j.!Index
                CommandLineParseErrorBuffer = CommandLineParseErrorBuffer",",
                    CommandLineParser.!Option.nextMatch.!Name
            end
            /*------------------------------------*/
            lastMatch = VALUE("possibleOption."possibleOption.0".!Index")
            /*------------------------------------*/
            CommandLineParseErrorBuffer = CommandLineParseErrorBuffer", and",
                CommandLineParser.!Option.lastMatch.!Name
            /*------------------------------------*/
            RETURN 1
        end
        /*-------------------------------------------------------------------*/
        else
        do  /*------------------------------*/
            /* We found no suitable matches */
            /*------------------------------*/
            CommandLineParseErrorBuffer = word.i.!Data "is not a valid option"
            RETURN 1
        end
        /*------------------------------------------------------------------*/
    end /*---------------------------------- end do if word.i.type = OPTION */
    else if word.i.!Type = "OPTIONDATA" then
    do
      /*------------------------------------------------------------------*/
      if valueReq = "NO" & hasValue then
      do  /*-----------------------------------------------------------*/
          /* They specified something of the form                      */
          /* /FeProg.exe:Prog2.exe, where Prog.exe is the option data, */
          /* and the specified additional option data using a data     */
          /* separator.                                                */
          /*                                                           */
          /* Note: This is somewhat obscure, but could happen.         */
          /*-----------------------------------------------------------*/
          CommandLineParseErrorBuffer = "You may not specify a second",
                                        "value for option" currOption
          RETURN 1
      end
      /*------------------------------------------------------------------*/
      else if valueReq = "NO" then
      do  /*--------------------------------------------------------*/
          /* They specified option data using a data separator, but */
          /* the option does not allow data                         */
          /*--------------------------------------------------------*/
          CommandLineParseErrorBuffer = "Option" currOption "is not",
                                        "allowed to have a value"
          /*--------------------------------------------------------*/
          RETURN 1
      end
      /*------------------------------------------------------------------*/
      else
      do  /*----------------------------------------------------*/
          /* The option either allows or requires data and they */
          /* specified it using a data separator                */
          /*----------------------------------------------------*/
          instanceIndex = CommandLineParser.!Instance.0 + 1
          CommandLineParser.!Instance.0 = instanceIndex
          /*----------------------------------------------------*/
          CommandLineParser.!Instance.instanceIndex.!Name = currOption
          CommandLineParser.!Instance.instanceIndex.!Value =,
              word.i.!Data
          /*----------------------------------------------------*/
          currOption = ""
          valueReq = "NO"
          hasValue = 0
      end
    end  /*------------------------------ end do if word.i.type = OPTIONDATA */
    /*-----------------------------------------------------------------------*/
    else
    do
      if valueReq = "NO" then
      do  /*------------------------------------------------------------*/
          /* We aren't expecting any option data so this is an argument */
          /*------------------------------------------------------------*/
          argIndex = CommandLineParser.!Arg.0 + 1
          CommandLineParser.!Arg.0 = argIndex
          CommandLineParser.!Arg.argIndex = word.i.!Data
      end
      /*----------------------------------------------------------------*/
      else
      do  /*----------------------------------------------------*/
          /* The option either allows or requires data and they */
          /* specified separate from the option                 */
          /*----------------------------------------------------*/
          instanceIndex = CommandLineParser.!Instance.0 + 1
          CommandLineParser.!Instance.0 = instanceIndex
          /*----------------------------------------------------*/
          CommandLineParser.!Instance.instanceIndex.!Name = currOption
          CommandLineParser.!Instance.instanceIndex.!Value =, word.i.!Data
      end
      /*----------------------------------------------------------------*/
      currOption = ""
      valueReq = "NO"
      hasValue = 0
    end
    /*-----------------------------------------------------------------------*/
end /* end do for I = 1 to word.0 */
/****************************************************************************/

if valueReq = "YES" then
do  /*-------------------------------------------------*/
    /* Error, previously found option requires a value */
    /*-------------------------------------------------*/
    CommandLineParseErrorBuffer = "You must specify a value",
                                  "for option" currOption
    RETURN 1
end
/*---------------------------------------------------------------------------*/
else if valueReq = "ALLOWED" then
do
    /* The end of the command line was a lone option which allows data, */
    /* but no data was specified.                                       */

    instanceIndex = CommandLineParser.!Instance.0 + 1
    CommandLineParser.!Instance.0 = instanceIndex

    CommandLineParser.!Instance.instanceIndex.!Name = currOption
    CommandLineParser.!Instance.instanceIndex.!Value = ""
end
/*****************************************************************************/
if CommandLineParser.!Debug then
do
    do i = 1 to CommandLineParser.!Instance.0
        say "Instance" i":" CommandLineParser.!Instance.i.!Name"(" ||,
            CommandLineParser.!Instance.i.!Value")"
    end

    do i = 1 to CommandLineParser.!Arg.0
        say "Arg" i":" CommandLineParser.!Arg.i
    end
end
/*****************************************************************************/
/*               Check the restriction on number of arguments                */
/*****************************************************************************/
if CommandLineParser.!Arg.0 > CommandLineParser.!MaxArgs then
do
    invalidArgIndex = CommandLineParser.!MaxArgs + 1

    CommandLineParseErrorBuffer = "You may have no more than",
                                  CommandLineParser.!MaxArgs "argument(s).",
                                  'The first excess argument is "' ||,
                                  CommandLineParser.!Arg.invalidArgIndex ||,
                                  '".'
    RETURN 1
end
/*****************************************************************************/
/*                         Check group restrictions                          */
/*****************************************************************************/
do i = 1 to CommandLineParser.!Group.0
    groupCount = 0
    /*-----------------------------------------------------------------------*/
    do j = 1 to WORDS(CommandLineParser.!Group.i.!Names)
        if CommandLineOptionTimes(WORD(CommandLineParser.!Group.i.!Names, j)) > 0 then
            groupCount = groupCount + 1
    end
    /*-----------------------------------------------------------------------*/
    if (groupCount < CommandLineParser.!Group.i.!Min) |,
       (groupCount > CommandLineParser.!Group.i.!Max) then
    do
        CommandLineParseErrorBuffer = "You must have at least",
                                      CommandLineParser.!Group.i.!Min",",
                                      "but no more than",
                                      CommandLineParser.!Group.i.!Max,
                                      'of the options "' ||,
                                      CommandLineParser.!Group.i.!Names'"'
        RETURN 1
    end
    /*-----------------------------------------------------------------------*/
end
/*****************************************************************************/
/*                         Check needs restrictions                          */
/*****************************************************************************/
do i = 1 to CommandLineParser.!Need.0

    foundNeeder = 0
    foundNeedee = 0
    /*-----------------------------------------------------------------------*/
    do j = 1 to WORDS(CommandLineParser.!Need.i.!Needers),
    while \foundNeeder
        if CommandLineOptionTimes(WORD(CommandLineParser.!Need.i.!Needers, j)) > 0 then
            foundNeeder = 1
    end
    /*-----------------------------------------------------------------------*/
    do j = 1 to WORDS(CommandLineParser.!Need.i.!Needees),
    while \foundNeedee
        if CommandLineOptionTimes(WORD(CommandLineParser.!Need.i.!Needees, j)) > 0 then
            foundNeedee = 1
    end
    /*-----------------------------------------------------------------------*/
    if (foundNeeder & \foundNeedee) then
    do
        CommandLineParseErrorBuffer = "When specifying one of the",
                                      'options "' ||,
                                      CommandLineParser.!Need.i.!Needers'"',
                                      ", you must also specify one of the",
                                      'options "' ||,
                                      CommandLineParser.!Need.i.!Needees'"'
        RETURN 1
    end
    /*-----------------------------------------------------------------------*/
end

RETURN 0

/* End of ParseCommandLine */

/*********************************************************************/
/* CommandLineParserInternalAddWord - This is an internal utility    */
/*                                    routine used by the parser to  */
/*                                    add words to its interal list  */
/*                                                                   */
/* Accepts: The next mode the parser should be in                    */
/*                                                                   */
/* Returns: 0                                                        */
/*********************************************************************/
CommandLineParserInternalAddWord: PROCEDURE EXPOSE word. currData mode

  parse arg nextMode

  index = word.0 + 1
  word.0 = index

  word.index.!Data = currData
  word.index.!Type = mode

  currData = ""
  mode = nextMode

  RETURN 0

/* End of CommandLineParserInternalAddWord */

/***************************************************************/
validate :
parse arg rc test
  call LINEOUT rtncode, RC  /* this creates a file for the file rename test */
  call LINEOUT rtncode
  if rc <> 0 then
  do
      say "RC =" RC test " TEST failed"
      testResult = "Result =" RC test "TEST failed"
      call LINEOUT logfile, testResult
      call LINEOUT logfile
      call bad_exit 4 test
  end
  else
  do
      say "RC =" RC test " TEST passed"
      testResult = "Result =" RC test" TEST passed"
      call LINEOUT logfile, testResult
      call LINEOUT logfile
  end
RETURN 0

/************ error exit *******************************************/
BAD_EXIT:
parse arg cause info
call directory curdir      /*return to the current directory */
if cause = 1 then do
  res = lineout(logfile, '***** Check the command line parameters  ')
  res = lineout(logfile, commandlineparseerrorbuffer)
  res = lineout(logfile, 'ERROR 'time() date()' FLSPGM1 Failed with a CommandLineParseErrorBuffer  *****')
  res = lineout(logfile)
end

if cause = 2 then do
  res = lineout(logfile, '***** 'hds' is not a valid drive size  *****')
  res = lineout(logfile, 'ERROR 'time() date()' FLSPGM1 Failed   *****')
  res = lineout(logfile)
end

if cause = 3 then do
  res = lineout(logfile, '***** Can not create file of 'hdsize' on hard disk with size of 'hpercen)
  res = lineout(logfile, 'ERROR 'time() date()' FLSPGM1 Failed   *****')
  res = lineout(logfile)
end

if cause = 4 then do
  res = lineout(logfile, '***** validation of the 'info' OS/2 command failed')
  res = lineout(logfile, 'ERROR 'time() date()' FLSPGM1 Failed   *****')
  res = lineout(logfile)
end

res = lineout(logfile, '***** FLSPGM1 ended abnormally    *****')
res = lineout(logfile)
EXIT
/* ************************************************************************* */
/* ERROR EXIT POINT WHEN TESTCASE FAILS - CAUSE POSTED IN LOGFILE            */
/* ************************************************************************* */

/*-------------------------------------------------------------------------- */
INFO_PLEASE:
'cls'
  say ' '
  say '[1;26;45mͻ'
  say ' FLSPGM1.CMD is copied to \JFSTEST directory on testcase partition.'
  say '                                                                   '
  say ' Parameters:                                                       '
  say '                                                                   '
  say ' NOTE: The DRIVE Letter provided WILL BE FORMATTED DURING TEST.    '
  say '                                                                   '
  say ' Output log file: \jfstest\jfs_test.log                            '
  say '                                                                   '
  say ' OS/2 environment variables used to determine boot/testcase drives.'
  say 'ͼ[0;40;37m'
  exit
