/*-----------------------------------------------------------*/
/* FVT_SUMM.CMD - FVT Section 2 Testcase Results Analyzer    */
/*                                                           */
/*  PURPOSE: Examine contents of FVT TESTTCASE directories.  */
/*                                                           */
/*  Compress the various log files into a one-screen SUMMARY */
/*  counts for PASS, FAIL, PARTIAL, and MISSING test results.*/
/*-----------------------------------------------------------*/
'@echo off'
'cls'
say ''
parse arg arglist    /* leaves parms in mixed case as entered */
logtest = ''
release = 0          /* set defaults for optional parameters */
bay = ''
quiet = 0
fmtxx = 3
do while (arglist \= '')              /* CASE logic controlled by */
   parse var arglist parm remainder   /* first letter parameter   */
   arglist = remainder
   code = left(parm,1)
   if code = '?' then signal INFO_PLEASE
   if pos(code,'Qq') >0  then quiet = 1
   else
      if pos(code,'Rr') > 0 then release = parm
   else
      if pos(code,'35') > 0 then fmtxx = parm
   else
      if code \= '' then do
         say 'Parameter "'parm'" not used; enter "?" to see full parm list:'
         pull y
         if y = '?' then signal INFO_PLEASE
         end
end

if quiet then 'echo off'

if (release = 0) then do
   rellvl  = value('PCM_RELLVL',,'OS2ENVIRONMENT');    /* get release level  */
   release = 'R'||rellvl
   end

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');       /* get OS2 boot drive */
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');       /* get testcase drive */
if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '[1;09;41m ***************************************************************[0;40;37m'
say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
say '[1;09;41m ***************************************************************[0;40;37m'
exit
end

if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '[1;09;41m ***************************************************************[0;40;37m'
say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
say '[1;09;41m ***************************************************************[0;40;37m'
exit
end

tstdrv':'
if stream(tstdrv':\logf','c','query size') >= 0 then signal START_LOGRUN
 else 'mkdir 'tstdrvf':\logf'

START_LOGRUN:
  'cd \logf'
  summary=tstdrv':\LOGF\FVTSECT2.SUM'

  'del' summary' 2>nul'

  call LOG_FVT_GROUP
exit



/******************************************************/
/*  LOG RESULTS FOR - SNF002, SNF006, SNF007, SNFMVDM */
/******************************************************/
LOG_FVT_GROUP:
procedure expose release summary quiet tstdrv os2drv

missing = 0
passed = 0
failed = 0
partial = 0
time_start = '';
time_end = '';
date_start = '';
date_end = '';

summary.1 = ''
summary.2 = ''
summary.3 = ''
summary.4 = ''

missing = 0
passed = 0
failed = 0
partial = 0
'cd \kbd'
call examkbd 'KEYBOARD:  KBD.LOG   1000  5'
summary.6 = ''
summary.7 = ''
summary.8 = ''
missing2 = missing
passed2 = passed
failed2 = failed
partial2 = partial


missing = 0
passed = 0
failed = 0
partial = 0
'cd \logf'
if fmtxx = '5' then do
   call examfmt 'FORMAT:    DSKTRSLT.LOG 1000   9'
   call examfmt '\          FLOP525.LOG  1000  10'
   end
else
   do
   call examfmt 'FORMAT:    DSKTRSLT.LOG 1000   9'
   call examfmt '\          FLOP144.LOG  1000  10'
   end
summary.11 = ''
summary.12 = ''
missing3 = missing
passed3 = passed
failed3 = failed
partial3 = partial


missing = 0
passed = 0
failed = 0
partial = 0
'cd \logf'
call exmdisk 'FVTDISK:  DASDSTD1.LOG  1000  13'
call exmdisk '\         DASDSTD2.LOG  1000  14'
summary.15 = ''
summary.16 = ''
missing4 = missing
passed4 = passed
failed4 = failed
partial4 = partial


missing = 0
passed = 0
failed = 0
partial = 0
'cd \timerdd\dh\dh'
call exmtimr 'TIMERDD:   DH.LOG    1000  17'
summary.18 = ''
summary.19 = ''
summary.20 = ''
missing5 = missing
passed5 = passed
failed5 = failed
partial5 = partial



missing = 0
passed = 0
failed = 0
partial = 0
'cd \printdd'
call exmprnt 'PRINTDD:   PRT1OS.LOG   1000  21'
call exmprnt '\          PRT1DOS.LOG  1000  22'
summary.23 = ''
summary.24 = ''
missing6 = missing
passed6 = passed
failed6 = failed
partial6 = partial

call stream summary,'c','open write'
call lineout summary,'*********** SECTION 2 FVT TESTCASE RESULTS SUMMARY ***************'
call lineout summary,' '
do j0 = 1 to 24 by 4
   j1 = j0+1
   j2 = j1+1
   j3 = j2+1
   call lineout summary,summary.j0 summary.j1 summary.j2 summary.j3
end
call lineout summary,'OS2 Release 'left(release,7)
call lineout summary,' '
call lineout summary,'KEYBOARD:   PASS'right(passed2,8)'   FAIL'right(failed2,5)'     PARTIAL'right(partial2,6)'    MISSING'right(missing2,5)
call lineout summary,'FORMAT:     PASS'right(passed3,8)'   FAIL'right(failed3,5)'     PARTIAL'right(partial3,6)'    MISSING'right(missing3,5)
call lineout summary,'FVTDISK:    PASS'right(passed4,8)'   FAIL'right(failed4,5)'     PARTIAL'right(partial4,6)'    MISSING'right(missing4,5)
call lineout summary,'TIMERDD:    PASS'right(passed5,8)'   FAIL'right(failed5,5)'     PARTIAL'right(partial5,6)'    MISSING'right(missing5,5)
call lineout summary,'PRINTDD:    PASS'right(passed6,8)'   IF ALL CHARACTERS PRINTED.     MISSING'right(missing6,5)
call stream summary, 'c', 'close'
if quiet = 0 then
  'type' summary

'cd \logf'
return


/**************************/
/*   SHARED LOG SECTION   */
/**************************/
examine:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)

skip_tail = "NO";

if file_name = "SWITCH3F" then do
   skip_tail = "YES";
  end

if file_name = "SWITCH5F" then do
   skip_tail = "YES";
  end

file_text = left(file_name,8);

if description = '\' then description = ''
  else description = left(description,10)

no_answer = 1

if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  return
  end

/********************************************/
/* file was found and opened for processing */
/********************************************/
if skip_tail = "NO" then do
   if tail_len > stream(file_name,'c','query size') then
      call stream file_name,'c','open read'
   else
      call stream file_name,'c','seek <'tail_len
   end

do forever
   my_text = linein(file_name)
   if datatype(left(my_text,9),'N') then time_text = left(my_text,9)

   if file_name = "SWITCH3F" then do
      if pos('starting at',my_text) > 0 then do
         parse var my_text parm S1 S2 S3 S4 time_in S5 date_start remainder
         time_start = left(time_in, length(time_in - 3))
         say "**TIMESTART =  "time_start
         end
      if pos('stopping at',my_text) > 0 then do
         parse var my_text parm S1 S2 S3 S4 time_in S5 date_end remainder
         time_end = left(time_in, length(time_in - 3))
         say "**TIME END =  "time_end
         end
      if pos('SWITCHER process is ending thru normal exit. rc =0',my_text) > 0 then do
         summary.spot = description file_text 'PASS   '
         passed = passed + 1
         leave
         end
     end

   if file_name = "SWITCH5F" then do
      if pos('starting at',my_text) > 0 then do
         parse var my_text parm S1 S2 S3 S4 time_in S5 date_start remainder
         time_start = left(time_in, length(time_in - 3))
         say "**TIMESTART =  "time_start
         end
      if pos('stopping at',my_text) > 0 then do
         parse var my_text parm S1 S2 S3 S4 time_in S5 date_end remainder
         time_end = left(time_in, length(time_in - 3))
         say "**TIME END =  "time_end
         end
      if pos('SWITCHER process is ending thru normal exit. rc =0',my_text) > 0 then do
         summary.spot = description file_text 'PASS   '
         passed = passed + 1
         leave
         end
     end

   if pos('FAIL-ABORT', my_text) > 0 then do
      summary.spot = description file_text '<PASS>'
      passed = passed + 1
      leave
      end

   if pos('SUCCESS', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('OK', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('pass', my_text) > 0 | pos('PASS', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('fail', my_text) > 0 | pos('FAIL', my_text) > 0 then do
      summary.spot = description file_text '<PASS>'
      passed = passed + 1
      leave
      end

   if pos('Bad', my_text) > 0 | pos('BAD', my_text) > 0 then do
      summary.spot = description file_text '<FAIL>'
      failed = failed + 1
      leave
      end

   if lines(file_name) = 0 then do
      summary.spot = description file_text '<PART>'
      partial = partial + 1
      leave
      end
end

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return


/***********************************************/
/* EXAMKBD  - Analyze KBD and FORMAT log files */
/***********************************************/
examkbd:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)


file_text = left(file_name,8);

if description = '\' then description = ''
  else description = left(description,10)

no_answer = 1

if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 35
  return
  end

/****************************************/
/* file was found , open for processing */
/****************************************/
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   s. = '';
   if pos('AUTO BASE RUN', my_text) > 0 then do
      parse var my_text s.1 s.2 s.3 s.4 s.5 s.6 s.7 s.8 s.9 s.10 s.11 s.12;

      file_text = left(s.2,7)

      if s.10 = 0 then do
         summary.spot = description file_text ' PASS ';
         description = '';
         spot = spot + 1;
         passed = passed + s.8;
         failed = failed + s.10;
         end
      else do
           summary.spot = description file_text '<FAIL>'
           description = ''
           spot = spot + 1;
           passed = passed + s.8;
           failed = failed + s.10;
           end
      end
   if lines(file_name) = 0 then do
      leave
      end
end

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end

my_text = time_text

call stream file_name,'c','close'
return

/********************************************************/
/* examfmt - LOOP THROUGH COUNTING success in each file */
/********************************************************/
examfmt:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
cnt_1276 = 0
cnt_0530 = 0
cnt_0636 = 0
ok_cnt = 0
fmt_cnt = 0
spot=strip(spot)

if file_name = 'FLOP144.LOG' then do
     file_text = 'FLOP144 ';
   end
else do
     if file_name = 'FLOP525.LOG' then do
          file_text = 'FLOP525 ';
        end
     else do
          file_text = left(file_name,8);
          end
     end

if description = '\' then description = ''
  else description = left(description,10)

no_answer = 1

if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS '
  missing = missing + 1
  return
  end

/****************************************************/
/* file found, open and count Success entries found */
/****************************************************/
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   if pos('SYS1276', my_text) > 0 then do
      cnt_1276 = cnt_1276 + 1
      end
   if pos('SYS0530', my_text) > 0 then do
      cnt_0530 = cnt_0530 + 1
      end
   if pos('SYS0636', my_text) > 0 then do
      cnt_0636 = cnt_0636 + 1
      end
   if pos('Success', my_text) > 0 then do
      ok_cnt = ok_cnt + 1
      end
   if pos('bytes total disk space', my_text) > 0 then do
      fmt_cnt = fmt_cnt + 1
      end
   if lines(file_name) = 0 then do
      leave
      end
end

call stream file_name,'c','close'

if file_name = 'DSKTRSLT.LOG' then do
   if cnt_1276 = 15 then do
      if cnt_0530 = 1 then do
         if fmt_cnt = 8 then do
            summary.spot = description file_text 'PASS '
            passed = passed + 1
            end
         else
            do
            summary.spot = description file_text '<FAIL>'
            failed = failed + 1
            end
         end
      else
         do
         summary.spot = description file_text '<FAIL>'
         failed = failed + 1
         end
      end
   else
   if cnt_1276 = 14 then do
      if cnt_0636 = 1 then do
         if fmt_cnt = 8 then do
            summary.spot = description file_text ' PASS '
            passed = passed + 1
            end
         else
            do
            summary.spot = description file_text '<FAIL>'
            failed = failed + 1
            end
         end
      else
         do
         summary.spot = description file_text '<FAIL>'
         failed = failed + 1
         end
      end
   else
      do
      summary.spot = description file_text '<FAIL>'
      failed = failed + 1
      end
   end
else
   do
   file_text = left(file_name,7)
   if ok_cnt = 72 then do
      summary.spot = description file_text ' PASS '
      passed = passed + 1
      end
   else
      do
      summary.spot = description file_text ' <FAIL>'
      failed = failed + 1
      end
   end

return


/********************************************************/
/* exmdisk - LOOP THROUGH COUNTING success in each file */
/********************************************************/
exmdisk:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
ok_cnt = 0
spot=strip(spot)
file_text = left(file_name,8)
if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1
if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  return
  end
/*************************************************** */
/* file found, open and count Success entries found  */
/*************************************************** */
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   if pos('Success', my_text) > 0 then do
      ok_cnt = ok_cnt + 1
      end
   if lines(file_name) = 0 then do
      leave
      end
end

call stream file_name,'c','close'

if file_name = 'DASDSTD1.LOG' then do
   if ok_cnt = 54 then do
      summary.spot = description file_text 'PASS '
      passed = passed + 1
      end
   else do
        summary.spot = description file_text '<FAIL>'
        failed = failed + 1
        end
   end


if file_name = 'DASDSTD2.LOG' then do
   if ok_cnt = 52 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      end
   else do
        summary.spot = description file_text '<FAIL>'
        failed = failed + 1
        end
   end
/* ****************************************************** */
return


/************************************/
/* EXMTIMR - TIMERDD examine DH.LOG */
/************************************/
exmtimr:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)

file_text = 'DH      ';

if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1

if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  return
  end

/*******************************************/
/* file found, open for processing results */
/*******************************************/
othrfail = 0
timerset = 0;
timernot = 0;
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   if pos('SUCCESS', my_text) > 0 then do
      parse var my_text s.1 s.2 s.3 s.4 s.5 s.6
      if s.3 = 'Timer' then do
         timerset = timerset + 1;
         end
      end

   if pos('FAILED', my_text) > 0 then do
      parse var my_text s.1 s.2 s.3 s.4 s.5 s.6
      if s.3 = 'Timer' then do
         timernot = timernot + 1;
         end
      else do
           othrfail = othrfail + 1;
           end
      end

   if lines(file_name) = 0 then do
      leave
      end
end

if othrfail > 0 then do
   summary.spot = description file_text '<FAIL>'
   failed = failed + 1;
   end

if timerset > 10 then do
   summary.spot = description file_text 'PASS '
   passed = passed + 1;
   end
else do
     summary.spot = description file_text '<FAIL>'
     failed = failed + 1;
     end


if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return

/**********************/
/* EXMPRNT - PRINTDD  */
/**********************/
exmprnt:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)
if file_name = 'PRT1OS.LOG' then do
   file_text = 'PRT1OS  '
   end
else do
     file_text = 'PRT1DOS '
     end

if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1
if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  return
  end

/*******************************************/
/* file found, open for processing results */
/*******************************************/
readok = 0;
writok = 0;
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   if pos('PASSED IF ALL CHARACTERS', my_text) > 0 then do
      prntok = 1;
      end
   if lines(file_name) = 0 then do
      leave
      end
end

if prntok > 0 then do
   summary.spot = description file_text 'PASS '
   passed = passed + 1;
   end
else do
     summary.spot = description file_text '<FAIL>'
     failed = failed + 1;
     end

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return

INFO_PLEASE:
say '[1;45;37m ͻ '
say '    This command file examines the output logfiles from the         '
say '    SECTION 2 FVT Testcases.  The logfiles are categorized          '
say '    for display and PASS/FAIL etc totals are given at the bottom.   '
say '                                                                    '
say '    The output file is saved as \LOGF\FVTSECT2.SUM                  '
say '                                                                    '
say '  PARAMETERS:  3 or 5    REQUIRED - 1.44 or 1.2 test group          '
say '               Q         OPTIONAL  - echo off, no screen displays   '
say '               Rnnnnnnn  OPTIONAL  - Release designation            '
say '                                                                    '
say ' ͼ [0;40;37m'
exit
