/*--------------------------------------------------------------------*/
/* PCMJFS.CMD - Test the Journaled File System (JFS) support in OS/2. */
/*                                                                    */
/*    Parameters: JFS DRIVE LETTER (example  E:)                      */
/*                                                                    */
/*    Invocation: from OS/2 full screen prompt \batch\pcmjfs.cmd      */
/*                                                                    */
/*    Uses OS2 environment variables to determine testcase drive.     */
/*--------------------------------------------------------------------*/
/* Only JFSDrive Letter passed in as parameter, rest are hard coded.  */
/*                                                                    */
/* Run \JFSTEST\FLSPGM1.CMD to execute JFSTEST with different parms.  */
/*                                                                    */
/* 04-30-99 Removed the pipe to jfs_test.log so the window would show */
/*          the test as it was running.  The log file is written to   */
/*          the jfstest.log (Rich Bassemir)                           */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
'@echo off'
arg parm.1 comments

'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE
if left(parm.1,1) = ''  then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
/*-------------------------------------------------------------------------- */
jfsdrv = left(parm.1,1);          /* get jfs drive letter from parm 1st char */

tstdrv':'
'cd \jfstest'
/*-----------------------------------------------------------------------*/
/*  /H:MB        (File size to be created: MB or GB                      */
/*  /per:90      (Percentage of freespace to be filled: 0->100)          */
/*  /num:1       (number of drives:    Default is 1)                     */
/*  /dl:E        (Drive letter(s)      Default is E)                     */
/*  /FSDir:JDIR  (Dir  name to create: Default is DIR)                   */
/*  /FName:JFILE (File name to create: Default is FILE)                  */
/*  /iter:1      (no of iterations:    Default is 1)                     */
/*  /AUTO        (runs FLSPGM1.CMD with hard coded parms except jfsdrive */
/*-----------------------------------------------------------------------*/
'echo on'
'call  FLSPGM1 /H:10MB /PER:90 /NUM:1 /DL:'JFSDRV' /FSDIR:JDIR /FNAME:JFILE /ITER:1 /AUTO '

'cd \'

exit
/*-------------------------------------------------------------------------- */
INFO_PLEASE:
  say '[1;26;45mͻ'
  say ' PCMJFS.CMD is copied to \BATCH directory on testcase partition.   '
  say '                                                                   '
  say ' Parameters: JFS Drive Letter                                      '
  say '                                                                   '
  say ' NOTE: The DRIVE Letter provided WILL BE FORMATTED DURING TEST.    '
  say '                                                                   '
  say ' Output log file: testdrive:\jfstest\jfstest.log                   '
  say '                                                                   '
  say ' OS/2 environment variables used to determine boot/testcase drives.'
  say '͹'
  say ' Only JFSDrive Letter passed in as parameter, rest are hard coded. '
  say '                                                                   '
  say ' Run \JFSTEST\FLSPGM1.CMD to execute JFSTEST with different parms. '
  say 'ͼ[0;40;37m'
  exit
