/* ---------------------------------------------------------------*/
/* ACC_LOG.CMD - ACCEPTANCE Testcase Results Analyzer             */
/*                                                                */
/*  PURPOSE: Examine contents of ACCEPTANCE TESTCASE directories. */
/*                                                                */
/*  Compress the various log files into a one-screen SUMMARY with */
/*  counts for PASS, FAIL, PARTIAL, and MISSING test results.     */
/*                                                                */
/* ---------------------------------------------------------------*/
'@echo off'
'cls'
say ''

parse arg arglist  /* leaves parms in mixed case as entered */
logtest = ''
release = 0        /* set defaults for optional parameters */
bay = ''
quiet = 0
do while (arglist \= '')                  /* 'CASE' logic is controlled by  */
   parse var arglist parm remainder       /* first letter of each parameter */
   arglist = remainder
   code = left(parm,1)
   if code = '?' then signal INFO_PLEASE
   if pos(code,'Qq') >0  then quiet = 1
   else
      if pos(code,'Rr') > 0 then release = parm
   else
      if pos(code,'Bb') > 0 then bay = parm
   else
      if code \= '' then do
         say 'Parameter "'parm'" not used; enter "?" to see full parm list:'
         pull y
         if y = '?' then signal INFO_PLEASE
         end
end

if quiet then 'echo off'


if (release = 0) then do
   release = value('PCM_RELLVL',,'OS2ENVIRONMENT');
   end

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end
if pos(tstdrv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '[1;09;41m ***************************************************************[0;40;37m'
   say '[1;09;41m * OS2 environment variable PCM_TESTDRV not set.  Run PCMSETUP *[0;40;37m'
   say '[1;09;41m * to update config.sys, then shutdown & reboot to continue.   *[0;40;37m'
   say '[1;09;41m ***************************************************************[0;40;37m'
   exit
   end

/*--CALL ROUTINES TO ANALYZE THE DIFFERENT ACCEPTANCE TESTCASES--*/
tstdrv':'

summary=tstdrv':\BATCH\PCMACCPT.SUM'
'del' summary' 2>nul'

call LOG_ACC_GROUP
exit



/*********************************************************/
/*   LOG RESULTS FOR - SNF002, SNF006, SNF007, SNFMVDM   */
/*********************************************************/
LOG_ACC_GROUP:
procedure expose release summary quiet tstdrv os2drv

tstdrv':'

missing = 0
passed = 0
failed = 0
partial = 0
'cd \accept\core'
call examine 'SNF002:   SWITCH_2  1000   1'
'cd \accept\core\tests\s\result'
call examine '\         CLEARSEM  1000   2'
call examine '\         ERTSKB    1000   3'
call examine '\         FIO1      1000   4'
call examine '+         FIO2      1000   5'
call examine '\         FIO4      1000   6'
call examine '\         FIOTEST1  1000   7'
call examine '\         FIOTEST2  1000   8'
call examine '+         FIOTEST3  1000   9'
call examine '\         FIOTEST4  1000  10'
call examine '\         FIOTEST5  1000  11'
call examine '\         FIOTEST6  1000  12'
call examine '+         FIOTEST7  1000  13'
call examine '\         FIOTEST9  1000  14'
call examine '\         FIOTESTA  1000  15'
call examine '\         FIOTESTB  1000  16'
call examine '+         FIOTESTC  1000  17'
call examine '\         FIOTESTD  1000  18'
call examine '\         FIOTESTE  1000  19'
call examine '\         FIOTESTF  1000  20'
call examine '+         HIDE      1000  21'
call examine '\         IPCQR     1000  22'
call examine '\         IPCQW     1000  23'
call examine '\         NOHIDE    1000  24'
call examine '+         PEC1      1000  25'
call examine '\         PROCESS1  1000  26'
call examine '\         PROCESS2  1000  27'
call examine '\         PROCESS3  1000  28'
call examine '+         PTEST001  1000  29'
call examine '\         STEST001  1000  30'
call examine '\         TIM1      1000  31'
call examine '\         TIM4      1000  32'
call examine '+         TIMER1    1000  33'
call examine '\         TIMER2    1000  34'
call examine '\         TSK006    1000  35'
call examine '\         TTEST001  1000  36'
call examine '+         TTEST003  1000  37'
call examine '\         TTEST03A  1000  38'
call examine '\         TTEST03B  1000  39'
call examine '\         TTEST004  1000  40'
call examine '+         VID1      1000  41'
call examine '\         VID11     1000  42'
call examine '\         VID12     1000  43'
call examine '\         VID14     1000  44'
call examine '+         VID15     1000  45'
call examine '\         VID16     1000  46'
call examine '\         VID17     1000  47'
call examine '\         VID19     1000  48'
call examine '+         VID2      1000  49'
call examine '\         VID3      1000  50'
call examine '\         VID4      1000  51'
call examine '\         VID8      1000  52'
call examine '+         VID8A     1000  53'
call examine '\         VID9      1000  54'
call examine '\         VIDT015   1000  55'
call examine '\         VIDT017   1000  56'
call examine '+         VIDT019   1000  57'
call examine '\         WTS1      1000  58'
call examine '\         XTEST001  1000  59'
summary.60 = ''
missing1 = missing
passed1 = passed
failed1 = failed
partial1 = partial

missing = 0
passed = 0
failed = 0
partial = 0
'cd \nlscpa'
call examine 'SNF006:   SWITCH_6  1000  61'
call examine '\         CPALOG    1000  62'
call examine '\         FONTD     1000  63'
call examine '\         PRINTD    1000  64'
missing3 = missing
passed3 = passed
failed3 = failed
partial3 = partial

missing = 0
passed = 0
failed = 0
partial = 0
'cd \loga'
call exm007x 'SNF007:   SWITCH_7 10000  65'
/*                                      66 - setup in exm007x procedure */
/*                                      67 - setup in exm007x procedure */
/*                                      68 - setup in exm007x procedure */
/*                                      69 - setup in exm007x procedure */
summary.70 = ''
summary.71 = ''
summary.72 = ''
missing4 = missing
passed4 = passed
failed4 = failed
partial4 = partial

missing = 0
passed = 0
failed = 0
partial = 0
'cd \batch'
call examine 'SNFBPB:   SNFBPB_L  1000  73'
summary.74 = ''
summary.75 = ''
summary.76 = ''
missing5 = missing
passed5 = passed
failed5 = failed
partial5 = partial

missing = 0
passed = 0
failed = 0
partial = 0
'cd \rexx'
call exmrexx 'SNFREXX:  REXX_LOG  1000  77'
/*                                      78 - setup in exmrexx procedure */
/*                                      79 - setup in exmrexx procedure */
summary.80 = ''
missing6 = missing
passed6 = passed
failed6 = failed
partial6 = partial


missing = 0
passed = 0
failed = 0
partial = 0
'cd \vdm'
call examine 'SNFMVDM:  SWITCH_V  1000  81'
call examine '\         VDM1      1000  82'
call examine '\         CTTCLOCK  1000  83'
call examine '\         FLT018    1000  84'
call examine '+         MAT015    1000  85'
call examine '\         VVTATXM4  1000  86'
summary.87 = ''
summary.88 = ''
missing7 = missing
passed7 = passed
failed7 = failed
partial7 = partial
call stream summary,'c','open write'
call lineout summary,'************* ACCEPTANCE TESTCASE RESULTS SUMMARY *****************'
call lineout summary,' '
do j0 = 1 to 88 by 4
   j1 = j0+1
   j2 = j1+1
   j3 = j2+1
   call lineout summary,summary.j0 summary.j1 summary.j2 summary.j3
end
call lineout summary,' '
call lineout summary,'OS2 Release 'left(release,7)
call lineout summary,'SNF002:     PASS'right(passed1,8)'   FAIL'right(failed1,5)'     PARTIAL'right(partial1,6)'    MISSING'right(missing1,5)
call lineout summary,'SNF006:     PASS'right(passed3,8)'   FAIL'right(failed3,5)'     PARTIAL'right(partial3,6)'    MISSING'right(missing3,5)
call lineout summary,'SNF007:     PASS'right(passed4,8)'   FAIL'right(failed4,5)'     PARTIAL'right(partial4,6)'    MISSING'right(missing4,5)
call lineout summary,'SNFBPB:     PASS'right(passed5,8)'   FAIL'right(failed5,5)'     PARTIAL'right(partial5,6)'    MISSING'right(missing5,5)
call lineout summary,'SNFREXX:    PASS'right(passed6,8)'   FAIL'right(failed6,5)'     PARTIAL'right(partial6,6)'    MISSING'right(missing6,5)
call lineout summary,'SNFMVDM:    PASS'right(passed7,8)'   FAIL'right(failed7,5)'     PARTIAL'right(partial7,6)'    MISSING'right(missing7,5)
call stream summary, 'c', 'close'
if quiet = 0 then
  'type' summary

'cd \batch'
return


/****************************/
/*    SHARED LOG SECTION    */
/****************************/
examine:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)
file_text = left(file_name,8)
if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1

if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  return
  end

/****************************************/
/* file found and opened for processing */
/****************************************/
if tail_len > stream(file_name,'c','query size') then
   call stream file_name,'c','open read'
else
   call stream file_name,'c','seek <'tail_len

cpafontx = 0;
do forever
   my_text = linein(file_name)
   if datatype(left(my_text,9),'N') then time_text = left(my_text,9)

   if pos('SWITCHER process is ending thru normal exit. rc =0', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if file_name = 'vvtatxm4' then do
      if pos('Total errors',my_text) > 0 then do
         if pos('Total errors = 0',my_text) > 0 then do
            summary.spot = description file_text 'PASS  '
            passed = passed + 1
         end
         else do
              summary.spot = description file_text '<FAIL>'
              failed = failed + 1
              end
      end
   end


   if pos('Font_Demon found wrong codepage (0)', my_text) > 0 then do
      cpafontx = cpafontx + 1;
      end

   if pos('FAIL-ABORT', my_text) > 0 then do
      summary.spot = description file_text '<PASS>'
      passed = passed + 1
      leave
      end

   if pos('Window over', my_text) > 0 then do
      summary.spot = description file_text '<PASS>'
      passed = passed + 1
      leave
      end

   if pos('successful', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('OK', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('pass', my_text) > 0 | pos('PASS', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('shutdown', my_text) > 0 | pos('SHUTDOWN', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   if pos('ALL DONE', my_text) > 0 then do
      summary.spot = description file_text 'PASS  '
      passed = passed + 1
      leave
      end

   /********************************************************** */
   /* cpalog - and found FONT DAEMON codepage 0 - then <PASS>  */
   /********************************************************** */
   if pos('fail', my_text) > 0 | pos('FAIL', my_text) > 0 then do
      if cpafontx = 0 then do
         summary.spot = description file_text '<FAIL>'
         failed = failed + 1
         leave
         end
      else do
         summary.spot = description file_text '<PASS>'
         passed = passed + 1
         leave
         end
      end

   if pos('Bad', my_text) > 0 | pos('BAD', my_text) > 0 then do
      summary.spot = description file_text '<FAIL>'
      failed = failed + 1
      leave
      end

   if pos('NO HPFS PARTITIONS', my_text) > 0 then do
      summary.spot = description file_text '<N/A> '
      partial = partial + 1
      leave
      end

   if lines(file_name) = 0 then do
      summary.spot = description file_text '<PART>'
      partial = partial + 1
      leave
      end
end

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return


/***********************************************************/
/* SNF007 - Check PASS/FAIL of 4 sub-processes from M32SHR */
/***********************************************************/
exm007x:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)
file_text = left(file_name,8)
if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1
if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  spot = spot + 1;
  description = ''
  text007 = 'GiveShr '
  rlst007 = 'MISS  '
  missing = missing + 1
  summary.spot = description text007 rlst007
  spot = spot + 1;
  description = ''
  text007 = 'GetShr  '
  rlst007 = 'MISS  '
  missing = missing + 1
  summary.spot = description text007 rlst007
  spot = spot + 1;
  description = ''
  text007 = 'NameShr '
  rlst007 = 'MISS  '
  summary.spot = description text007 rlst007
  spot = spot + 1;
  description = '+'
  description = left(description,10)
  text007 = 'M32Shr  '
  rlst007 = 'MISS  '
  missing = missing + 1
  summary.spot = description text007 rlst007
  return
  end
swpassed = 0;
givepassed = 0;
getpassed = 0;
namepassed = 0;
m32passed = 0;
/***********************************/
/* file found, open for processing */
/***********************************/
call stream file_name,'c','open read'
do forever
   if pos('SWITCHER process is ending thru normal exit. rc =0', my_text) > 0 then do
      swpassed = swpassed + 1
   end

   if pos('GiveShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         givepassed = givepassed + 1
      end
   end

   if pos('GetShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         getpassed = getpassed + 1
      end
   end

   if pos('NameShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         namepassed = namepassed + 1
      end
   end

   if pos('M32SHR', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         m32passed = m32passed + 1
      end
   end

   my_text = linein(file_name)
   if lines(file_name) = 0 then do
      leave
      end
end

if swpassed = 1 then do
   summary.spot = description file_text 'PASS  '
   passed = passed + 1
   end
else do
   summary.spot = description file_text '<FAIL>'
   failed = failed + 1
   end

spot = spot + 1;
description = ''
text007 = 'GiveShr '
if givepassed = 1 then do
   rlst007 = 'PASS  '
   passed = passed + 1
   end
else do
     rlst007 = '<FAIL>'
     failed = failed + 1
     end
summary.spot = description text007 rlst007

spot = spot + 1;
description = ''
text007 = 'GetShr  '
if getpassed = 1 then do
   rlst007 = 'PASS  '
   passed = passed + 1
   end
else do
     rlst007 = '<FAIL>'
     failed = failed + 1
     end
summary.spot = description text007 rlst007

spot = spot + 1;
description = ''
text007 = 'NameShr '
if namepassed = 1 then do
   rlst007 = 'PASS  '
   passed = passed + 1
   end
else do
     rlst007 = '<FAIL>'
     failed = failed + 1
     end
summary.spot = description text007 rlst007


spot = spot + 1;
description = '+'
description = left(description,10)
text007 = 'M32Shr  '
if m32passed = 1 then do
   rlst007 = 'PASS  '
   passed = passed + 1
   end
else do
     rlst007 = '<FAIL>'
     failed = failed + 1
     end
summary.spot = description text007 rlst007

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return



/**********************************************/
/* SNFREXX - LOOP THROUGH COUNTING OK and BAD */
/**********************************************/
exmrexx:
procedure expose passed failed missing partial summary. my_text tstdrv os2drv
parse arg description file_name tail_len spot
time_text = 0
spot=strip(spot)
file_text = left(file_name,8)
if description = '\' then description = ''
  else description = left(description,10)
no_answer = 1
if stream(file_name,'c','open read') \= 'READY:' then do
  summary.spot = description file_text 'MISS  '
  missing = missing + 1
  spot = spot + 1;
  description = ''
  ok_text = '#OK=    '
  okout = 'MISS  '
  summary.spot = description ok_text okout
  spot = spot + 1;
  description = ''
  bad_text = '#BAD=   '
  badout = 'MISS  '
  summary.spot = description bad_text badout
  return
  end
/***********************************/
/* file found, open for processing */
/***********************************/
call stream file_name,'c','open read'
do forever
   my_text = linein(file_name)
   if pos('Ok', my_text) > 0 | pos('OK', my_text) > 0 then do
      passed = passed + 1
      end
   if pos('Bad', my_text) > 0 | pos('BAD', my_text) > 0 then do
      failed = failed + 1
      end
   if lines(file_name) = 0 then do
      leave
      end
end

if failed > 0 then do
   summary.spot = description file_text '<FAIL>'
   end
else do
   summary.spot = description file_text 'PASS  '
   end

spot = spot + 1;
description = ''
ok_text = '#OK=    '
okout = left(passed,6)
summary.spot = description ok_text okout

spot = spot + 1;
description = ''
bad_text = '#BAD=   '
badout = left(failed,6)
summary.spot = description bad_text badout

if time_text = 0 then do
   my_text = left(linein(file_name),9)
   if datatype(my_text,'N') then time_text = my_text
   end
my_text = time_text
call stream file_name,'c','close'
return



INFO_PLEASE:
say '[1;45;37m ͻ '
say '    This command file examines the output logfiles from the         '
say '    automated ACCEPTANCE Testcases.  Each logfile is assessed       '
say '    as either PASS, FAIL, PARTIAL, or MISSING.  The logfiles        '
say '    are categorized for display and the PASS/FAIL etc. totals       '
say '    are given at the bottom.                                        '
say '                                                                    '
say '    The output file is saved as \BATCH\PCMACCPT.SUM.                '
say '                                                                    '
say '    PARAMETERS are optional:                                        '
say '         Q          - echo off, no screen displays                  '
say '         Rnnnnnnn   - Release/Build level                           '
say '                                                                    '
say ' ͼ [0;40;37m'
exit
