/*-------------------------------------------------------*/
/* PSVRRSLT.CMD - Copies LAN Testing logfiles to Results */
/*                Diskette for analysis of pass-fail     */
/* Parameters: NONE                                      */
/* called by PCMRSLTS.EXE for results processing.        */
/*-------------------------------------------------------*/
'@echo off'

arg parm.1 comments

'cls'
say ''

if left(parm.1,1) = '?' then signal INFO_PLEASE

grepchk = '-y'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
   say '***************************************************************'
   say '* OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *'
   say '* to update config.sys, then shutdown & reboot to continue.   *'
   say '***************************************************************'
   exit
end

if stream('A:\D01LOGS'  ,'c','query size') = '' then 'md A:\D01LOGS'
if stream('A:\S01LOGS'  ,'c','query size') = '' then 'md A:\S01LOGS'

if stream(OS2DRV':\D01LOGS' ,'c','query size') \= '' then do
   'copy 'OS2DRV':\D01LOGS\ITLLS56.S01   A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLLS56.R01   A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLLS56.R02   A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLMSG.D01    A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLMSG.R01    A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLFTP02.R02  A:\D01LOGS >nul'
   'copy 'OS2DRV':\D01LOGS\ITLTCP01.D01  A:\D01LOGS >nul'

   'copy 'OS2DRV':\ITLUTIL\ITLDUMP.TXT   A:\D01LOGS >nul'
   'copy 'OS2DRV':\ITLUTIL\ITLPSNS.TXT   A:\D01LOGS >nul'
   /*-----------------------------------------------*/
   /* Warp Server V4 - SystemView/TME10 alert log.  */
   /*-----------------------------------------------*/
   'copy 'OS2DRV':\SYSVIEW2\BIN\ALERTS.LOG  A:\D01LOGS >nul'
   'grep "RAID" 'OS2DRV':\SYSVIEW2\BIN\ALERTS.LOG  >A:\D01LOGS\ITLRAID.D01'
   /*-----------------------------------------------*/
   /* Warp Server e-business - Netfinity alert log. */
   /*-----------------------------------------------*/
   'copy 'OS2DRV':\NETFIN\ALERTS.LOG  A:\D01LOGS >nul'
   'grep "RAID" 'OS2DRV':\NETFIN\ALERTS.LOG  >A:\D01LOGS\ITLRAID.D01'
end

if stream(OS2DRV':\S01LOGS' ,'c','query size') \= '' then do
   'copy 'OS2DRV':\S01LOGS\ITLLS57.D01   A:\S01LOGS >nul'
   'copy 'OS2DRV':\S01LOGS\ITLLS57.R01   A:\S01LOGS >nul'
   'copy 'OS2DRV':\S01LOGS\ITLLS57.R02   A:\S01LOGS >nul'
   'copy 'OS2DRV':\S01LOGS\ITLFTP01.R01  A:\S01LOGS >nul'
   'copy 'OS2DRV':\S01LOGS\ITLALERT.S01  A:\S01LOGS >nul'
   'copy 'OS2DRV':\S01LOGS\ITLLD.R02     A:\S01LOGS >nul'
   'copy 'OS2DRV':\ITLUTIL\ITLPSF00.TXT  A:\S01LOGS >nul'
   /*-------------------------------------------------*/
   /* Warp Server V4 - SystemView/TME10 output files. */
   /*-------------------------------------------------*/
   'copy 'OS2DRV':\SYSVIEW2\BIN\SYSINFO.RPT  A:\S01LOGS >nul'
   'copy 'OS2DRV':\SYSVIEW2\BIN\IT01*.HST    A:\S01LOGS >nul'
   'copy 'OS2DRV':\SYSVIEW2\BIN\IT01*.INV    A:\S01LOGS >nul'
   'copy 'OS2DRV':\IT01*.DBF                 A:\S01LOGS >nul'
   /*-------------------------------------------------*/
   /* Warp Server e-business - Netfinity output files.*/
   /*-------------------------------------------------*/
   'copy 'OS2DRV':\NETFIN\SYSINFO.RPT  A:\S01LOGS >nul'
   'copy 'OS2DRV':\NETFIN\IT01*.HST    A:\S01LOGS >nul'
   'copy 'OS2DRV':\NETFIN\IT01*.INV    A:\S01LOGS >nul'
   'copy 'OS2DRV':\NETFIN\IT01*.DBF    A:\S01LOGS >nul'
end

exit

INFO_PLEASE:
say 'ͻ'
say ' PSVRRSLT.CMD - Copies LAN testcase logfiles to Results '
say '                Diskette for analysis of pass-fail.     '
say '                                                        '
say ' Parameters: NONE                                       '
say '                                                        '
say ' REQUIRES DISKETTE IN DRIVE A: Write-Protect OFF        '
say '                                                        '
say ' Called by PCMRSLTS.EXE                                 '
say 'ͼ'
exit
