/* ----------------------------------------------------------------*/
/* PCMBLDOB.CMD - Build PCM Testkit folder and objects on desktop. */
/*                                                                 */
/* Carried on: "SETUP" Diskette                                    */
/*                                                                 */
/* OS/2 BOOT DRIVE DETERMINED USING COMSPEC= ENVIRONMENT VARIABLE  */
/*     Create PCM TESTKIT folder on desktop                        */
/*     Add PCMSETUP to folder if found in \OS2                     */
/*     Add PCMRSLTS to folder if found in \OS2                     */
/*     Add PCMDOC   to folder if found in \OS2                     */
/*     Add PCMHDW   to folder if found in \OS2                     */
/*     Add PCMTEST  to folder if found in \OS2                     */
/*     Add LANTEST  to folder if found in \OS2                     */
/* ----------------------------------------------------------------*/
'@echo off'
arg parm.1 comments

if left(parm.1,1) = '?' then signal INFO_PLEASE

/*------------------------------------------*/
/* USE  COMSPEC= TO FIND OS/2 BOOT DRIVE.   */
/*------------------------------------------*/
cmspec = value('COMSPEC',,'OS2ENVIRONMENT');
os2drv = left(cmspec,1)


os2drv':'
'cd \'

'attrib  -h -r -s OS2KRNL'                                     /**************/
if stream('os2krnl','c','query exists') = '' then do           /* NO OS2KRNL */
   say '[1;09;41m  *****************************************************[0;40;37m';
   say '[1;09;41m  *** Could NOT find \OS2KRNL                       ***[0;40;37m';
   say '[1;09;41m  *** Please change to OS/2 boot drive and re-enter.***[0;40;37m';
   say '[1;09;41m  *****************************************************[0;40;37m';
   signal INFO_PLEASE
   end
else do
   say '[1;37;45m  *****************************************************[0;40;37m';
   say '[1;37;45m  *** Building PCM Testkit folder and objects       ***[0;40;37m';
   say '[1;37;45m  *****************************************************[0;40;37m';
   end
'attrib  +h +r +s OS2KRNL'


call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ----------------------------------------------------------------------*/
/* ICONVIEWPOS  var1,var2,var3,var4                                      */
/*              var1 = how far from left   of screen folder is when open */
/*              var2 = how far from bottom of screen folder is when open */
/*              var3 = how wide folder is when open                      */
/*              var4 = how deep folder is when open                      */
/* ----------------------------------------------------------------------*/
classname='WPFolder'
title='PCM^Compatibility Testkit^Version 4.5'
location='<WP_DESKTOP>'
setup='OBJECTID=<PCM_KIT>;'||,
      'ICONFILE='os2drv':\OS2\PCMKIT_F.ICO;'||,
      'ALWAYSSORT=YES;'||,
      'ICONVIEWPOS=20,50,55,45;'
call BldObj


if stream(os2drv':\os2\pcmsetup.exe','c','query exists') \= '' then do
   classname='WPProgram';
   title='Base Testcases^Installation & Setup'
   location='<PCM_KIT>'
   setup='OBJECTID=<PCM_SETUP>;'||,
         'EXENAME='os2drv':\OS2\PCMSETUP.EXE;'||,
         'ICONFILE='os2drv':\OS2\PCMSETUP.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end


if stream(os2drv':\os2\pcmrslts.exe','c','query exists') \= '' then do
   classname='WPProgram';
   title='Results Diskette^Processing'
   location='<PCM_KIT>'
   setup='OBJECTID=<PCM_RSLTS>;'||,
         'EXENAME='os2drv':\OS2\PCMRSLTS.EXE;'||,
         'ICONFILE='os2drv':\OS2\PCMRSLTS.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end


if stream(os2drv':\os2\pcmdoc.inf','c','query exists') \= '' then do
   classname='WPProgram';
   title='PCM Testkit^Documentation'
   location='<PCM_KIT>'
   setup='OBJECTID=<PCM_DOCS>;'||,
         'EXENAME='os2drv':\OS2\VIEW.EXE;'||,
         'PARAMETERS='os2drv':\OS2\PCMDOC.INF;'||,
         'ICONFILE='os2drv':\OS2\PCMDOC.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end


if stream(os2drv':\os2\pcmhdw.exe','c','query exists') \= '' then do
   classname='WPProgram';
   title='System Hardware^Configuration'
   location='<PCM_KIT>'
   setup='OBJECTID=<PCM_HDW>;'||,
         'EXENAME='os2drv':\OS2\PCMHDW.EXE;'||,
         'ICONFILE='os2drv':\OS2\PCMHDW.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end


if stream(os2drv':\os2\pcmtest.exe','c','query exists') \= '' then do
   classname='WPProgram';
   title='Test Selection^& Control^BASE'
   location='<PCM_KIT>'
   setup='OBJECTID=<PCM_TEST>;'||,
         'EXENAME='os2drv':\OS2\PCMTEST.EXE;'||,
         'ICONFILE='os2drv':\OS2\PCMTEST.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end


if stream(os2drv':\os2\lantest.exe','c','query exists') \= '' then do
   classname='WPProgram';
   title='Test Selection^& Control^LAN'
   location='<PCM_KIT>'
   setup='OBJECTID=<LAN_TEST>;'||,
         'EXENAME='os2drv':\OS2\LANTEST.EXE;'||,
         'ICONFILE='os2drv':\OS2\LANTEST.ICO;'||,
         'PROGTYPE=PM;'||,
         'STARTUPDIR='os2drv':\OS2;'
   call BldObj
end



exit;

/*------------------*/
/* Common procedure */
/*------------------*/
BldObj:
   say '[1;37;45m  *** Building object for 'title'     [0;40;37m';
   result = SysCreateObject(classname, title, location, setup, 'R')
   if result = 0 then do
      say '[1;09;41m  *** OBJECT NOT CREATED - ERROR -                  ***[0;40;37m';
      end
   return;


INFO_PLEASE:
say ''
say '[1;37;45mͻ';
say '                                                                ';
say ' PCMBLDOB.CMD - Build PCM Testkit folder and program objects on ';
say '                on the desktop.                                 ';
say '                                                                ';
say ' Parameters:  NONE                                              ';
say '                                                                ';
say ' OS/2 BOOT DRIVE DETERMINED WITH COMSPEC= ENVIRONMENT VARIABLE. ';
say '                                                                ';
say ' Called by x:\PCM_INST\INSTALL.CMD  or  x:\LAN_INST\INSTALL.CMD ';
say '                                                                ';
say 'ͼ[0;40;37m';
exit
