/* --------------------------------------------------------------*/
/* CHEKRSLT.CMD - Analyze results diskette logfiles for          */
/*                pass-fail-missing and creation of PCMSCORE.TXT */
/* Parameters: NONE                                              */
/* Invoked from PCMRSLTS.EXE for results diskette processing.    */
/* --------------------------------------------------------------*/
'@echo off'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

arg parm.1 comments
'cls'
say ''
if left(parm.1,1) = '?' then signal INFO_PLEASE

os2drv = value('PCM_BOOTDRV',,'OS2ENVIRONMENT');
tstdrv = value('PCM_TESTDRV',,'OS2ENVIRONMENT');
rellvl = value('PCM_RELLVL' ,,'OS2ENVIRONMENT');

if pos(os2drv,'CDEFGHIJKLMNOPQRSTUVWXYZ') = 0 then do
say '***************************************************************'
say '* OS2 environment variable PCM_BOOTDRV not set.  Run PCMSETUP *'
say '* to update config.sys, then shutdown & reboot to continue.   *'
say '***************************************************************'
exit
end

if pos('3',rellvl) > 0 then do
   verchk = 3;
   end
if pos('4', rellvl) > 0 then do
   verchk = 4;
   end


grepchk = '-Ny -r'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

if stream(os2drv':\pcmlogs\temp'  ,'c','query size') = '' then 'md 'os2drv':\pcmlogs\temp'
'cd 'os2drv':\'

'xcopy a:\ 'os2drv':\pcmlogs\temp /s/e/v >nul'

'echo . > 'os2drv':\pcmlogs\temp\testbad'


/*--------*/
SNF001:
if stream(os2drv':\pcmlogs\temp\snf001\config.sys'  ,'c','query size') = '' then signal SNF001FAIL
if stream(os2drv':\pcmlogs\temp\snf001\autoexec.bat','c','query size') = '' then signal SNF001FAIL
if stream(os2drv':\pcmlogs\temp\snf001\machine.txt' ,'c','query size') = '' then signal MTXTFAIL

snf001stat = 0;

machfle = os2drv':\pcmlogs\temp\snf001\machine.txt'
x=stream(machfle,'c','open read');
do forever;
   line = LINEIN(machfle);
   len1 = length(line);
   line = LINEIN(machfle);
   len2 = length(line);
   line = LINEIN(machfle);
   len3 = length(line);
   leave;
end
x=stream(machfle,'c','close')

if len1 > 30 then do
   if len2 > 30 then do
      if len3 >30 then do
         snf001stat = 1;
      end
   end
end

if snf001stat = 0 then signal MTXTFAIL

'echo PCM Base Test________SNF001_____________PASS > 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNF002

MTXTFAIL:
'echo SNF001 test, MACHINE.TXT is Not complete >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required. Please Run the System Hardware Configuration program >> 'os2drv':\pcmlogs\temp\testbad'
'echo     in the PCM Kit folder and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'

SNF001FAIL:
'echo PCM Base Test________SNF001_____________FAIL > 'os2drv':\pcmlogs\temp\pcmscore.txt'


/*--------*/
SNF002:

'grep PASS 'os2drv':\pcmlogs\temp\snf002\snf002.log > nul'
if rc = 59 then signal SNF002PASS

'echo PCM Base Test________SNF002_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo SNF002 test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less that the correct number of files (59) indicated passing >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Examine the 'os2drv':\PCMLOGS\TEMP\SNF002\SNF002.LOG file for failures.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo   rerun Test SNF002 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
signal SNF006

SNF002PASS:
'echo PCM Base Test________SNF002_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
SNF006:

status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\PCMLOGS\TEMP\SNF006\cpalog'  ,'c','query size') \= '' then signal CHEK_CPALOG

'echo SNF006 test, no CPALOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FONTD

CHEK_CPALOG:
'grep " successful" 'os2drv':\pcmlogs\temp\snf006\cpalog > nul'
if rc = 1 then signal FIND_FONTD

'grep " failed" 'os2drv':\pcmlogs\temp\snf006\cpalog > nul'
if rc = 1 then signal TEST_FOR_SVGA
if rc = 78 then signal CPA_LOG_FIX

'echo SNF006 test, no PASS or FAIL for CPALOG >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FONTD

CPA_LOG_FIX:

'copy 'os2drv':\pcmlogs\temp\snf006\cpalog 'os2drv':\pcmlogs\temp\snf006\cpalog.test'
'call c:\itlutil\cube\cube.cmd {delstring "|" (all }'os2drv':\pcmlogs\temp\snf006\cpalog.test >nul'
'call c:\itlutil\cube\cube.cmd {delstring "." (all }'os2drv':\pcmlogs\temp\snf006\cpalog.test >nul'
'call c:\itlutil\cube\cube.cmd {delstring "-" (all }'os2drv':\pcmlogs\temp\snf006\cpalog.test >nul'
'call c:\itlutil\cube\cube.cmd {delstring "+" (all }'os2drv':\pcmlogs\temp\snf006\cpalog.test >nul'

call SysFileSearch 'should be', os2drv':\pcmlogs\temp\snf006\cpalog.test', 'shouldbe.'
call SysFileSearch 'was', os2drv':\pcmlogs\temp\snf006\cpalog.test', 'was.'

do i=1 to shouldbe.0

  parse var shouldbe.i junk ':' a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 a11 a12 a13 a14 a15 a16 a17 a18 a19 a20 a21 a22 a23 a24
  parse var was.i junk ':' b1 b2 b3 b4 b5 b6 b7 b8 b9 b10 b11 b12 b13 b14 b15 b16 b17 b18 b19 b20 b21 b22 b23 b24 b25 b26 b27 b28 b29 b30 b31 b32 b33
  shouldbeline = a1||a2||a3||a4||a5||a6||a7||a8||a9||a10||a11||a12||a13||a14||a15||a16||a17||a18||a19||a20||a21||a22||a23||a24
  wasline = b1||b2||b3||b4||b5||b6||b7||b8||b9||b10||b11||b12||b13||b14||b15||b16||b17||b18||b19||b20||b21||b22||b23||b24||b25||b26||b27||b28||b29||b30||b31||b32||b33
  if shouldbeline \= wasline then
    do
      'echo SNF006 test, FAILED for CPALOG >> 'os2drv':\pcmlogs\temp\testbad'
      'echo   ..There were errors with the codepages in the CPALOG.  Please >> 'os2drv':\pcmlogs\temp\testbad'
      'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
      'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
      status = 1;
    end
end
signal FIND_FONTD

TEST_FOR_SVGA:
'grep "Font_Demon found wrong codepage" 'os2drv':\PCMLOGS\TEMP\snf006\cpalog > nul'
if rc > 10 then signal FIND_FONTD

'echo SNF006 test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " failed" 'os2drv':\PCMLOGS\TEMP\snf006\cpalog >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FONTD:
if stream(os2drv':\pcmlogs\temp\snf006\fontd'  ,'c','query size') \= '' then signal CHEK_FONTD

'echo SNF006 test, no FONTD file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_PRINTD

CHEK_FONTD:
'grep " PASS " 'os2drv':\PCMLOGS\TEMP\snf006\fontd > nul'
if rc = 1 then signal FIND_PRINTD

'grep " FAIL " 'os2drv':\PCMLOGS\TEMP\snf006\fontd > nul'
if rc = 1 then signal FONTD_FAIL

'echo SNF006 test, no PASS or FAIL for FONTD >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_PRINTD

FONTD_FAIL:
'echo SNF006 test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " FAIL " 'os2drv':\PCMLOGS\TEMP\snf006\fontd >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;


FIND_PRINTD:
if stream(os2drv':\pcmlogs\temp\snf006\printd'  ,'c','query size') \= '' then signal CHEK_PRINTD

'echo SNF006 test, no PRINTD file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal SNF006_STATUS


CHEK_PRINTD:
'grep " PASS " 'os2drv':\PCMLOGS\TEMP\snf006\printd > nul'
if rc = 1 then signal SNF006_STATUS

'grep " FAIL " 'os2drv':\PCMLOGS\TEMP\snf006\printd > nul'
if rc = 1 then signal PRINTD_FAIL

'echo SNF006 test, no PASS or FAIL for PRINTD >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal SNF006_STATUS

PRINTD_FAIL:
'echo SNF006 test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " FAIL " 'os2drv':\PCMLOGS\TEMP\snf006\printd >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF006 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;


SNF006_STATUS:
if status > 0 then signal SNF006FAIL

'echo PCM Base Test________SNF006_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNF007

SNF006FAIL:
'echo PCM Base Test________SNF006_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
SNF007:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\snf007\switch_7'  ,'c','query size') \= '' then signal CHEK_SWITCH7

'echo SNF007 test, no SWITCH_7 file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF007, and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal SNF007_STATUS

CHEK_SWITCH7:
file_name = os2drv':\pcmlogs\temp\snf007\switch_7';
snf007passed = 0;
/* ****************************************************** */
call stream file_name,'c','open read'
do forever
   if pos('SWITCHER process is ending thru normal exit. rc =0', my_text) > 0 then do
      snf007passed = snf007passed + 1
   end

   if pos('GiveShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         snf007passed = snf007passed + 1
      end
   end

   if pos('GetShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         snf007passed = snf007passed + 1
      end
   end

   if pos('NameShr', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         snf007passed = snf007passed + 1
      end
   end

   if pos('M32SHR', my_text) > 0 then do
      if pos('PASS|',my_text) > 0 then do
         snf007passed = snf007passed + 1
      end
   end

   my_text = linein(file_name)
   if lines(file_name) = 0 then do
      leave
      end
end
call stream file_name,'c','close'
/**********************************/
if snf007passed < 5 then status = 1

SNF007_STATUS:
if status = 1 then signal SNF007FAIL

'echo PCM Base Test________SNF007_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFBPB

SNF007FAIL:
'echo PCM Base Test________SNF007_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
SNFBPB:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\snfbpb\snfbpb_l'  ,'c','query size') \= '' then signal CHEK_SNFBPB

'echo SNFBPB test, no SNFBPB_L file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required. Please rerun Test SNFBPB and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal SNFBPB_STATUS

CHEK_SNFBPB:
'grep PASS 'os2drv':\PCMLOGS\TEMP\snfbpb\SNFBPB_L > nul'
if rc = 1 then signal SNFBPB_STATUS

'grep FAIL 'os2drv':\PCMLOGS\TEMP\snfbpb\SNFBPB_L > nul'
if rc = 1 then signal SNFBPB_PROB

'grep "NO HPFS" 'os2drv':\PCMLOGS\TEMP\snfbpb\SNFBPB_L > nul'
if rc = 1 then signal SNFBPB_STATUS

'echo SNFBPB test, no PASS, FAIL, or No HPFS for SNFBPB_L >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete. Please rerun Test SNFBPB and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal SNFBPB_STATUS

SNFBPB_PROB:
'echo SNFBPB test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc "FAIL" 'os2drv':\PCMLOGS\TEMP\snfbpb\SNFBPB_L >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incorrect. Please rerun Test SNFBPB and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

SNFBPB_STATUS:
if status = 1 then signal SNFBPB_FAIL

'echo PCM Base Test________SNFBPB_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFREXX

SNFBPB_FAIL:
'echo PCM Base Test________SNFBPB_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---------*/
SNFREXX:
if stream(os2drv':\pcmlogs\temp\snfrexx\rexx_log'  ,'c','query size') \= '' then signal CHEK_REXX

'echo SNFREXX test, no REXX_LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNFREXX and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________SNFREXX____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFMVDM


CHEK_REXX:
'grep BAD 'os2drv':\PCMLOGS\TEMP\snfrexx\REXX_LOG > nul'
if rc = 1 then signal SNFREXX_FAIL

'grep OK 'os2drv':\PCMLOGS\TEMP\snfrexx\REXX_LOG > nul'
if rc = 71 then signal SNFREXX_PASS

'echo SNFREXX test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less than 71 expected OK's found but no BAD's. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Manually check the file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNFREXX and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________SNFREXX____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFMVDM

SNFREXX_FAIL:
'echo SNFREXX test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc BAD 'os2drv':\PCMLOGS\TEMP\snfrexx\REXX_LOG >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incorrect and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test SNF007 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________SNFREXX____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFMVDM

SNFREXX_PASS:
'echo PCM Base Test________SNFREXX____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---------*/
SNFMVDM:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\snfmvdm\switch_v'  ,'c','query size') \= '' then signal CHEK_SWITCHV

'echo SNFMVDM test, no SWITCH_V file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required. Please rerun Test SNFMVDM and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_VDM1

CHEK_SWITCHV:
'grep "Switch.........stopping at" 'os2drv':\pcmlogs\temp\snfmvdm\switch_v > nul'
if rc > 0 then signal FIND_VDM1

'echo SNFMVDM test, SWITCH_V file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Switcher process did not end correctly. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun test SNFMVDM and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_VDM1:
if stream(os2drv':\pcmlogs\temp\snfmvdm\vdm1'  ,'c','query size') \= '' then signal FIND_VVTATXM4

'echo SNFMVDM test, no VDM1 file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required. Please rerun Test SNFMVDM and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_VVTATXM4:
if stream(os2drv':\pcmlogs\temp\snfmvdm\vvtatxm4'  ,'c','query size') \= '' then signal CHEK_VVTATXM4

'echo SNFMVDM test, no VVTATXM4 file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and can be run by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing VVTATXM4 -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FLT018

CHEK_VVTATXM4:
'grep "Total errors = 0" 'os2drv':\pcmlogs\temp\snfmvdm\vvtatxm4 > nul'
if rc = 1 then signal FIND_FLT018

'echo SNFMVDM test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " FAIL " 'os2drv':\PCMLOGS\TEMP\snfmvdm\vvtatxm4 >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incorrect, but can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing VVTATXM4 -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FLT018:
if stream(os2drv':\pcmlogs\temp\snfmvdm\flt018'  ,'c','query size') \= '' then signal CHEK_FLT018

'echo SNFMVDM test, no FLT018 file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required. Please rerun Test SNFMVDM and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_MAT015

CHEK_FLT018:
'grep "PASS|" 'os2drv':\pcmlogs\temp\snfmvdm\flt018 > nul'
if rc = 1 then signal FIND_MAT015

'echo SNFMVDM test >> 'os2drv':\pcmlogs\temp\testbad'
'echo     FLT018 is not correct. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This test can be run separately, or rerun test SNFMVDM and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_MAT015:
if stream(os2drv':\pcmlogs\temp\snfmvdm\mat015'  ,'c','query size') \= '' then signal CHEK_MAT015

'echo SNFMVDM test, no MAT015 file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and can be run by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing MAT015 -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_CTTCLOCK

CHEK_MAT015:
'grep " PASS " 'os2drv':\PCMLOGS\TEMP\snfmvdm\mat015 > nul'
if rc = 1 then signal FIND_CTTCLOCK

'grep " FAIL " 'os2drv':\PCMLOGS\TEMP\snfmvdm\mat015 > nul'
if rc = 1 then signal MAT015_FAIL

'echo SNFMVDM test - No PASS or FAIL >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete, but can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing MAT015 -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_CTTCLOCK

MAT015_FAIL:
'echo SNFMVDM test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " FAIL " 'os2drv':\PCMLOGS\TEMP\snfmvdm\mat015 >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incorrect, but can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing MAT015 -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_CTTCLOCK:
if stream(os2drv':\pcmlogs\temp\snfmvdm\cttclock'  ,'c','query size') \= '' then signal CHEK_CTTCLOCK

'echo SNFMVDM test, no CTTCLOCK file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing CTTCLOCK -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal MVDM_STATUS

CHEK_CTTCLOCK:
'grep " PASS " 'os2drv':\PCMLOGS\TEMP\snfmvdm\cttclock > nul'
if rc = 1 then signal MVDM_STATUS

'grep " FAIL " 'os2drv':\PCMLOGS\TEMP\snfmvdm\cttclock > nul'
if rc = 1 then signal CTTCLOCK_FAIL

'echo SNFMVDM test, no PASS or FAIL for CTTCLOCK >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incomplete, but can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing CTTCLOCK -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal MVDM_STATUS

CTTCLOCK_FAIL:
'echo SNFMVDM test >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc " FAIL " 'os2drv':\PCMLOGS\TEMP\snfmvdm\cttclock >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is incorrect, but can be rerun by itself.  Please run this >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test from the VDM subdirectory by typing CTTCLOCK -l5 (lower case L) >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and pressing enter.  After the test has ended, please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

MVDM_STATUS:
if status = 1 then signal MVDM_FAIL

'echo PCM Base Test________SNFMVDM____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SNFWIN

MVDM_FAIL:
'echo PCM Base Test________SNFMVDM____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
SNFWIN:

if stream(os2drv':\pcmlogs\temp\snfwin\snfwin.txt'  ,'c','query size') = '' then signal SNFWIN.INCOMPLETE
'grep -y "x" 'os2drv':\pcmlogs\temp\snfwin\snfwin.txt > nul'
if rc < 2 then signal SNFWIN.INCOMPLETE

'grep -y "x       " 'os2drv':\pcmlogs\temp\snfwin\snfwin.txt > nul'
if rc > 0 then signal SNFWINPASS
'grep -y " x      " 'os2drv':\pcmlogs\temp\snfwin\snfwin.txt > nul'
if rc > 0 then signal SNFWINPASS
'grep -y "  x     " 'os2drv':\pcmlogs\temp\snfwin\snfwin.txt > nul'
if rc > 0 then signal SNFWINPASS
'grep -y "   x    " 'os2drv':\pcmlogs\temp\snfwin\snfwin.txt > nul'
if rc > 0 then signal SNFWINPASS

SNFWIN.INCOMPLETE:
'echo PCM Base Test________SNFWIN_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
'echo SNFWIN.TXT file has not been updated.  Complete the SNFWIN testcase >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and update \PCMLOGS\SNFWIN.TXT, then UPDATE the results diskette >> 'os2drv':\pcmlogs\temp\testbad'
'echo ********************************************************************* >> 'os2drv':\pcmlogs\temp\testbad'
signal STRESS

SNFWINPASS:
'echo PCM Base Test________SNFWIN_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'


/*--------*/
STRESS:
stress_part = 0;
cube_part = 0;
dswitch_part = 0;
if stream(os2drv':\pcmlogs\temp\stress\pcmmed01.sum'  ,'c','query size') \= '' then signal CHEK_STRESS

'echo STRESS test, no PCMMED01.SUM file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test STRESS and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________STRESS_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal KBD

CHEK_STRESS:
'grep "PASS      68" 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum > nul'
if rc = 1 then signal STRESS_PASS

'grep "CUBE     PARTIAL" 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum > nul'
if rc = 1 then do
               cube_part = cube_part + 1;
               stress_part = stress_part + 1;
               end

'grep "DSWITCHM PARTIAL" 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum > nul'
if rc = 1 then do
               dswitch_part = dswitch_part + 1;
               stress_part = stress_part + 1;
               end

'grep "PASS      66" 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum > nul'
if rc = 1 then do
               if stress_part = 2 then signal STRESS_PASS
               signal STRESS_FAIL
               end

'grep "PASS      67" 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum > nul'
if rc = 1 then do
               if cube_part = 1 then signal STRESS_PASS
               if dswitch_part = 1 then signal STRESS_PASS
               end

signal STRESS_FAIL


STRESS_PASS:
'echo PCM Base Test________STRESS_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal KBD

STRESS_FAIL:
'echo PCM Base Test________STRESS_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

'echo STRESS test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..One or more of the files in the PCMMED01.SUM file indicate   >> 'os2drv':\pcmlogs\temp\testbad'
'echo     FAIL, PARTIAL, or MISSING. Analyze the following printout to >> 'os2drv':\pcmlogs\temp\testbad'
'echo     determine which file(s). >> 'os2drv':\pcmlogs\temp\testbad'
'echo. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     DSWITCHM PARTIAL and CUBE PARTIAL are acceptable. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     If Video failed, set display to VGA mode using the command >> 'os2drv':\pcmlogs\temp\testbad'
'echo     'os2drv':\OS2\SETVGA.CMD, then rerun.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Many of the new testcases use a TIMER variable to specifiy how long >> 'os2drv':\pcmlogs\temp\testbad'
'echo     the .exe is to run.  The timer variable is usually "-u txxxx"  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     You can lower this time to 5-10 minutes when re-running an >> 'os2drv':\pcmlogs\temp\testbad'
'echo     individual .exe, check \SCRIPT\PCMMED01 top for additional information. >> 'os2drv':\pcmlogs\temp\testbad'
'echo. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     The other tests can be rerun alone from the \LOG directory.    >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please check WEB PAGE TIPS FILES for details. >> 'os2drv':\pcmlogs\temp\testbad'
'echo. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     After the individual test is corrected, run STRLOG from the \LOG >> 'os2drv':\pcmlogs\temp\testbad'
'echo     directory of your test drive to update the PCMMED01.SUM >> 'os2drv':\pcmlogs\temp\testbad'
'echo     file. Then update results diskette. >> 'os2drv':\pcmlogs\temp\testbad >> 'os2drv':\pcmlogs\temp\testbad'
'echo. >> 'os2drv':\pcmlogs\temp\testbad'
'type 'os2drv':\PCMLOGS\TEMP\stress\pcmmed01.sum >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'

/*---------*/
KBD:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\kbd\kbd.log'  ,'c','query size') \= '' then signal CHEK_KBD

'echo KBD test, no KBD.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and can be run by itself. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please run Test KBD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal KBD_STATUS

CHEK_KBD:
'grep "RUN 35 PASS 35 FAIL 0" 'os2drv':\PCMLOGS\TEMP\kbd\kbd.log > nul'
if rc \= 1 then signal KBD_FAIL

signal KBD_STATUS

KBD_FAIL:
'echo KBD test, Error(s) Detected in KBD.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Analyze this .LOG file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'grep -Nc "STATUS KBD" 'os2drv':\PCMLOGS\TEMP\kbd\kbd.log >> 'os2drv':\pcmlogs\temp\testbad'
'echo     This file is required and can be run by itself. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test KBD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

KBD_STATUS:
if status = 1 then signal KBDFAIL

'echo PCM Base Test________KBD________________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal FVTDISK

KBDFAIL:
'echo PCM Base Test________KBD________________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---------*/
FVTDISK:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\fvtdisk\dasdstd1.log'  ,'c','query size') \= '' then signal CHEK_STD1

'echo FVTDISK test no DASDSTD1.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required.  Please rerun Test FVTDISK and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_STD2

CHEK_STD1:
'grep "Success" 'os2drv':\pcmlogs\temp\fvtdisk\dasdstd1.log > nul'
if rc = 54 then signal FIND_STD2

'echo FVTDISK test DASDSTD1.LOG is not correct >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less than 54 "Success" entries found. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test FVTDISK and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_STD2:
if stream(os2drv':\pcmlogs\temp\fvtdisk\dasdstd2.log'  ,'c','query size') \= '' then signal CHEK_STD2

'echo FVTDISK test no DASDSTD2.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required.  Please rerun Test FVTDISK and >> 'os2drv':\pcmlogs\temp\testbad'
'echo     update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FVTDISK_STATUS

CHEK_STD2:
'grep "Success" 'os2drv':\pcmlogs\temp\fvtdisk\dasdstd2.log > nul'
if rc = 52 then signal FVTDISK_STATUS

'echo FVTDISK test DASDSTD2.LOG is not correct >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less than 52 "Success" entries found. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test FVTDISK and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FVTDISK_STATUS:
if status = 1 then signal FVTDISK_FAIL

'echo PCM Base Test________FVTDISK____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal FORMAT

FVTDISK_FAIL:
'echo PCM Base Test________FVTDISK____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
FORMAT:
status = 0;   /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\format\flop525.log'  ,'c','query size') \= '' then signal CHEK_525
if stream(os2drv':\pcmlogs\temp\format\flop144.log'  ,'c','query size') \= '' then signal CHEK_144

'echo FORMAT test, no DDTT LOG files >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..No log file found for the FVT Diskette DDTT testcase for  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     either 5.25" or 3.5" diskette drives.  This file is required. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun test \FORMAT\TST1_44.CMD, or TST1_2.CMD >> 'os2drv':\pcmlogs\temp\testbad'
'echo     then update results diskette.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_DSKTRSLT

CHEK_525:
'grep "Success" 'os2drv':\PCMLOGS\TEMP\format\flop525.log > nul'
if rc = 72 then signal FIND_DSKTRSLT

'echo FORMAT test FLOP525.LOG is incorrect >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less than 72 "Success" entries found >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun \FORMAT\TST1_2.CMD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_DSKTRSLT

CHEK_144:
'grep "Success" 'os2drv':\PCMLOGS\TEMP\format\flop144.log > nul'
if rc = 72 then signal FIND_DSKTRSLT

'echo FORMAT test FLOP144.LOG is incorrect >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Less than 72 "Success" entries found >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun \FORMAT\TST1_44.CMD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_DSKTRSLT:
if stream(os2drv':\pcmlogs\temp\format\dsktrslt.log'  ,'c','query size') \= '' then signal CHEK_DSKTRSLT
'echo FORMAT test DSKTRSLT.LOG not found. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun \FORMAT\TST1_44.CMD or TST1_2.CMD and then. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FORMAT_STATUS

CHEK_DSKTRSLT:
'grep "SYS1276" 'os2drv':\pcmlogs\temp\format\dsktrslt.log > nul'
if rc = 15 then signal FINISH_CHEK
if rc = 14 then signal CHEK_0530
signal DSKTRSLT_FAIL

CHEK_0530:
'grep "SYS0530" 'os2drv':\pcmlogs\temp\format\dsktrslt.log > nul'
if rc > 0 then signal FINISH_CHEK

CHEK_1512:
'grep "SYS1512" 'os2drv':\pcmlogs\temp\format\dsktrslt.log > nul'
if rc \= 1 then signal DSKTRSLT_FAIL

FINISH_CHEK:
'grep "bytes total disk space" 'os2drv':\pcmlogs\temp\format\dsktrslt.log > nul'
if rc = 8 then signal FORMAT_STATUS

DSKTRSLT_FAIL:
'echo FORMAT test DSKTRSLT.LOG is incorrect >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Should find SYS1276 15 times, SYS0530 or SYS1512 once, and 8 Successful formats. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun \FORMAT\TST1_44 or TST1_2, then update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FORMAT_STATUS:
if status = 1 then signal FORMAT_FAIL

'echo PCM Base Test________FORMAT_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal TIMERDD

FORMAT_FAIL:
'echo PCM Base Test________FORMAT_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---------*/
TIMERDD:
status = 0; /* 0=pass, 1=fail */

if stream(os2drv':\pcmlogs\temp\timerdd\dh.log'  ,'c','query size') \= '' then signal CHEK_DH

'echo TIMERDD test, no DH.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test TIMERDD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal TIMERDD_STATUS

CHEK_DH:
'grep "SUCCESS : Timer handler....set" 'os2drv':\pcmlogs\temp\timerdd\dh.log > nul'
if rc > 10 then signal TIMERDD_STATUS

'echo TIMERDD test, Possible Error in DH.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Analyze this .LOG file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     shutdown the system and reboot befor reruning test TIMERDD. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Then update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

TIMERDD_STATUS:
if status = 1 then signal TIMERDD_FAIL

'echo PCM Base Test________TIMERDD____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal PRINTDD

TIMERDD_FAIL:
'echo PCM Base Test________TIMERDD____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*---------*/
PRINTDD:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\printdd\prt1os.log'  ,'c','query size') \= '' then signal CHEK_PRT1OS

'echo PRINTDD test, no PRT1OS.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PRINTDD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_PRT1DOS

CHEK_PRT1OS:
'grep PASSED 'os2drv':\PCMLOGS\TEMP\printdd\prt1os.log > nul'
if rc = 1 then signal FIND_PRT1DOS

'echo PRINTDD test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Error(s) detected in the PRT1OS.LOG file. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PRINTDD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_PRT1DOS:
if stream(os2drv':\pcmlogs\temp\printdd\prt1dos.log'  ,'c','query size') \= '' then signal CHEK_PRT1DOS

'echo PRINTDD test, no PRT1DOS.LOG file >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PRINTDD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal PRINTDD_STATUS

CHEK_PRT1DOS:
'grep PASSED 'os2drv':\PCMLOGS\TEMP\printdd\prt1dos.log > nul'
if rc = 1 then signal PRINTDD_STATUS

'echo PRINTDD test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..An error(s) detected in the PRT1DOS.LOG file. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Analyze this .LOG file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..This file is required and cannot be run by itself.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PRINTDD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

PRINTDD_STATUS:
if status = 1 then signal PRINTDD_FAIL

'echo PCM Base Test________PRINTDD____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal MMPM2

PRINTDD_FAIL:
'echo PCM Base Test________PRINTDD____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*-------*/
MMPM2:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\snf001\mmpm2.ini'  ,'c','query size') \= '' then signal FIND_SOUND

'echo PCM Base Test________MMPM2______________N/A  >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal APM

FIND_SOUND:
'grep "Waveaudio" 'os2drv':\PCMLOGS\TEMP\SNF001\MMPM2.INI >nul'
if rc \= 1 then signal FIND_CDROM

if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_hpfs.ra_'  ,'c','query size') \= '' then signal MMPM2_HPFS
signal CHECK_FOR_SVGA_VGA

MMPM2_HPFS:
'grep "PASSED: 1" 'os2drv':\PCMLOGS\TEMP\mmpm2\pcm_hpfs.ra_ >nul'
if rc = 1 then signal CHECK_FOR_SVGA_VGA
'echo MMPM2 test, FILE PCM_HPFS.RA_ is not correct.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..If TESTCASE drive is HPFS, then re-run PCM_HPFS testcase.  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     If TESTCASE drive is NOT HPFS, then erase the file \RESULTS\MMEPCM\SVTRAW\PCM_HPFS.RA_  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     then RE-CREATE the testcase results diskette, NOT UPDATE. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

CHECK_FOR_SVGA_VGA:
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_svga.ra_'  ,'c','query size') \= '' then signal MMPM2_SVGA
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_vga.ra_'  ,'c','query size') \= '' then signal CHECK_FOR_VGA2

'echo MMPM2 test, A sound card was detected in your multimedia setup. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..For WARP 3.0 - you must pass PCM_VGA or PCM_SVGA, and PCM_REXX. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     FOR WARP 4.x - you must pass PCM_VGA or PCM_SVGA, PCM_REXX, and PCM_FLC. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     In addition if TESTCASE drive is HPFS, you can run PCM_HPFS (optional). >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test MMPM2 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_CDROM

MMPM2_SVGA:
'grep "PASSED: 12" 'os2drv':\PCMLOGS\TEMP\mmpm2\pcm_svga.ra_ >nul'
if rc = 1 then signal CHECK_FOR_VGA1

'echo MMPM2 test, FILE PCM_SVGA.RA_ is not correct.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PCM_SVGA and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

CHECK_FOR_VGA1:
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_vga.ra_'  ,'c','query size') \= '' then signal MMPM2_VGA
signal TEST_FOR_REXX

CHECK_FOR_VGA2:
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_vga.ra_'  ,'c','query size') \= '' then signal MMPM2_VGA
'echo MMPM2 test, A sound card was detected in your multimedia setup. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..For WARP 3.0 - you must pass PCM_VGA or PCM_SVGA, and PCM_REXX. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     FOR WARP 4.x - you must pass PCM_VGA or PCM_SVGA, PCM_REXX, and PCM_FLC. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     In addition if TESTCASE drive is HPFS, you can run PCM_HPFS (optional). >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test MMPM2 and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal TEST_FOR_REXX

MMPM2_VGA:
'grep "PASSED: 11" 'os2drv':\pcmlogs\temp\mmpm2\pcm_vga.ra_ >nul'
if rc = 1 then signal TEST_FOR_REXX

'echo MMPM2 test, FILE PCM_VGA.RA_ is not correct.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PCM_VGA and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

TEST_FOR_REXX:
if stream(os2drv':\pcmlogs\temp\mmpm2\rexxrsp.out'  ,'c','query size') \= '' then signal MMPM2_REXX
'echo MMPM2 test, REXXRSP.OUT file was not found. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_REXX for OS/2 Compatibility. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test PCM_REXX and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal CHEK_FOR_FLCFLI

MMPM2_REXX:
'grep "This string has passed" 'os2drv':\pcmlogs\temp\mmpm2\rexxrsp.out >nul'
if rc = 1 then signal MMPM2_REXX_2

'echo MMPM2 test, REXXRSP.OUT is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_REXX for OS/2 Compatibility. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test PCM_REXX and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal CHEK_FOR_FLCFLI

MMPM2_REXX_2:
'grep "STATUS DV1 MODE WAIT returned stopped" 'os2drv':\pcmlogs\temp\mmpm2\rexxrsp.out >nul'
if rc = 1 then signal CHEK_FOR_FLCFLI

'echo MMPM2 test, REXXRSP.OUT is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_REXX for OS/2 Compatibility. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test PCM_REXX and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

CHEK_FOR_FLCFLI:
if verchk = 3 then signal FIND_CDROM
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_flc.ra_'  ,'c','query size') \= '' then signal MMPM2_FLCFLI

'echo MMPM2 test, PCM_FLC.RA_ was not found. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_FLC for OS/2 V4.x Compatibility. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test PCM_FLC and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_CDROM

MMPM2_FLCFLI:
'grep "PASSED: 2" 'os2drv':\pcmlogs\temp\mmpm2\pcm_flc.ra_ >nul'
if rc = 1 then signal FIND_CDROM

'echo MMPM2 test, PCM_FLC.RA_ is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_FLC for OS/2 V4.x Compatibility. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test PCM_FLC and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;


FIND_CDROM:
'grep "CDaudio" 'os2drv':\pcmlogs\temp\snf001\mmpm2.ini >nul'
if rc \= 1 then signal MMPM2_STATUS

if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_cds.ra_'  ,'c','query size') \= '' then signal MMPM2_CDSTREAM
signal CHECK_FOR_MUSICCD

MMPM2_CDSTREAM:
'grep "PASSED: 6" 'os2drv':\PCMLOGS\TEMP\mmpm2\pcm_cds.ra_ >nul'
if rc = 1 signal CHECK_FOR_MUSICCD
'echo MMPM2 test, FILE PCM_CDS.RA_ is present. Testcase PCM_CDS is optional, >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..and provided for use with STREAMING CDROM drives. The test always >> 'os2drv':\pcmlogs\temp\testbad'
'echo     produces FAILS. Erase 'tstdrv':\RESULTS\MMEPCM\SVTRAW\PCM_CDS.RA_  >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and A:\MMPM2\PCM_CDS.RA_, and then UPDATE the results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

CHECK_FOR_MUSICCD:
if stream(os2drv':\pcmlogs\temp\mmpm2\pcm_cd.ra_'  ,'c','query size') \= '' then signal MMPM2_MUSICCD

'echo MMPM2 test, A CD ROM was detected in your multimedia setup. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass PCM_CD for OS/2 Compatibility. Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     run Test PCM_CD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal MMPM2_STATUS

MMPM2_MUSICCD:
'grep "PASSED: 7" 'os2drv':\PCMLOGS\TEMP\mmpm2\pcm_cd.ra_ >nul'
if rc = 1 then signal MMPM2_STATUS

'echo MMPM2 test, FILE PCM_CD.RA_ is not correct.  Please >> 'os2drv':\pcmlogs\temp\testbad'
'echo     rerun Test PCM_CD and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

MMPM2_STATUS:
if status = 1 then signal MMPM2_FAIL

'echo PCM Base Test________MMPM2______________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal APM

MMPM2_FAIL:
'echo PCM Base Test________MMPM2______________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*-----*/
APM:

grepchk = '-r'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

'grep x 'os2drv':\pcmlogs\temp\apm\apm.txt > nul'
if rc > 4 then signal CHK_APM

'echo PCM Base Test________APM________________NOT RUN >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SPEECH

CHK_APM:
'grep "     X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "      X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "       X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "        X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "         X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "          X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "     x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "      x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "       x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "        x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "         x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "          x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "     X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "      X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "       X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "        X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "         X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "          X" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "     x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "      x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "       x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "        x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "         x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL
'grep "          x" 'os2drv':\PCMLOGS\TEMP\APM\APM.TXT > nul'
if rc = 1 then signal APMFAIL

'echo PCM Base Test________APM________________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SPEECH

APMFAIL:
'echo APM test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..APM.TXT indicates a failure in the APM Test Section. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     The APM Test is not required for OS/2 Hardware Compatibilty >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please delete the APM.TXT file from the \APM directory on the >> 'os2drv':\pcmlogs\temp\testbad'
'echo     test system and recreate results diskette. NOT RUN is an >> 'os2drv':\pcmlogs\temp\testbad'
'echo     acceptable result for Test APM. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________APM________________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
SPEECH:

if verchk = 3 then signal PCMCIA

grepchk = '-r'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

'grep x 'os2drv':\pcmlogs\temp\speech\speech.txt > nul'
if rc > 2 then signal CHK_SPEECH

'echo PCM Base Test________SPEECH_____________NOT RUN >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal PCMCIA

CHK_SPEECH:
'grep "     X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "      X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "       X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "        X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "         X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "          X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "     x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "      x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "       x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "        x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "         x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "          x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "     X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "      X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "       X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "        X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "         X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "          X" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "     x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "      x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "       x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "        x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "         x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL
'grep "          x" 'os2drv':\PCMLOGS\TEMP\SPEECH\SPEECH.TXT > nul'
if rc = 1 then signal SPEECHFAIL

'echo PCM Base Test________SPEECH_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal PCMCIA

SPEECHFAIL:
'echo SPEECH test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..SPEECH.TXT indicates a failure in the Speech Test Section. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     The Speech Test is not required for OS/2 Hardware Compatibilty >> 'os2drv':\pcmlogs\temp\testbad'
'echo     if using a sound card that is not listed in the WARP 4.x readme. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Erase the file speech.txt from SPEECH directory on testcase drive >> 'os2drv':\pcmlogs\temp\testbad'
'echo     and re-create results diskette. NOT RUN is an >> 'os2drv':\pcmlogs\temp\testbad'
'echo     acceptable result for Test SPEECH. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________SPEECH_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*--------*/
PCMCIA:
grepchk = '-Ny -r'
rcx = value('grepopt',grepchk,'OS2ENVIRONMENT');

'grep "PCM2ATA.ADD" 'os2drv':\pcmlogs\temp\snf001\config.sys > nul'
if rc = 1 then signal PCMCIA_YES
'echo PCM Base Test________PCMCIA_____________NOT RUN  >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SMP

PCMCIA_YES:
status = 0;                       /* 0 = pass, 1 = fail */

if stream(os2drv':\pcmlogs\temp\pcmcia\ata-disk.log'  ,'c','query size') \= '' then signal CHEK_ATA_DISK
if stream(os2drv':\pcmlogs\temp\pcmcia\sramcrd.log'  ,'c','query size') \= '' then signal FIND_SRAM
if stream(os2drv':\pcmlogs\temp\pcmcia\flashcrd.log'  ,'c','query size') \= '' then signal FIND_FLASH

'echo PCMCIA test, The CONFIG.SYS indicates that PCMCIA support is installed. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..You must pass a PCMCIA SVT test to pass OS/2 Hardware Compatibility Testing. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please run PCMCIA SVT Tests and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal PCMCIA_STATUS

CHEK_ATA_DISK:
'grep "PASS" 'os2drv':\pcmlogs\temp\pcmcia\ata-disk.log > nul'
if rc = 11 then signal FIND_PCMCIA_A

'echo PCMCIA test, The ATA_DISK.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_SRAM

FIND_PCMCIA_A:
if stream(os2drv':\pcmlogs\temp\pcmcia\pcmcia_a.log'  ,'c','query size') \= '' then signal CHEK_PCMCIA_A

'echo PCMCIA test, The PCMCIA_A.LOG file is missing. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FSCPYATA

CHEK_PCMCIA_A:
'grep "SWITCHER process is ending thru normal exit. rc =0" 'os2drv':\pcmlogs\temp\pcmcia\pcmcia_a.log > nul'
if rc = 1 then signal FIND_FSCPYATA

'echo PCMCIA test, The PCMCIA_A.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FSCPYATA:
if stream(os2drv':\pcmlogs\temp\pcmcia\fscpyata.log'  ,'c','query size') \= '' then signal CHEK_FSCPYATA

'echo PCMCIA test, The FSCPYATA.LOG file is missing. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FSDELATA

CHEK_FSCPYATA:
'grep "PASS|" 'os2drv':\PCMLOGS\TEMP\PCMCIA\FSCPYATA.LOG > nul'
if rc = 1 then signal FIND_FSDELATA

'echo PCMCIA test, The FSCPYATA.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FSDELATA:
if stream(os2drv':\pcmlogs\temp\pcmcia\fsdelata.log'  ,'c','query size') \= '' then signal CHEK_FSDELATA

'echo PCMCIA test, The FSDELATA.LOG file is missing. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_FSDIRATA

CHEK_FSDELATA:
'grep "PASS|" 'os2drv':\PCMLOGS\TEMP\PCMCIA\FSDELATA.LOG > nul'
if rc = 1 then signal FIND_FSDIRATA

'echo PCMCIA test, The FSDELATA.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FSDIRATA:
if stream(os2drv':\pcmlogs\temp\pcmcia\fsdirata.log'  ,'c','query size') \= '' then signal CHEK_FSDIRATA

'echo PCMCIA test, The FSDIRATA.LOG file is missing. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;
signal FIND_SRAM

CHEK_FSDIRATA:
'grep "PASS|" 'os2drv':\PCMLOGS\TEMP\PCMCIA\FSDIRATA.LOG > nul'
if rc = 1 then signal FIND_SRAM

'echo PCMCIA test, The FSDIRATA.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA ATA Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_SRAM:
if stream(os2drv':\pcmlogs\temp\pcmcia\sramcrd.log'  ,'c','query size') = '' then signal FIND_FLASH

'grep "PASS" 'os2drv':\pcmlogs\temp\pcmcia\sramcrd.log > nul'
if rc = 4 then signal FIND_FLASH

'echo PCMCIA test, The SRAMCRD.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA SRAM Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

FIND_FLASH:
if stream(os2drv':\pcmlogs\temp\pcmcia\flashcrd.log'  ,'c','query size') = '' then signal PCMCIA_STATUS

'grep "PASS" 'os2drv':\PCMLOGS\TEMP\PCMCIA\FLASHCRD.LOG > nul'
if rc = 4 then signal PCMCIA_STATUS

'echo PCMCIA test, The FLASHCRD.LOG file is incorrect. >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Please rerun PCMCIA FLASH Card Test and update test results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
status = 1;

PCMCIA_STATUS:
if status = 1 then signal PCMCIA_FAIL

PCMCIA_PASS:
'echo PCM Base Test________PCMCIA_____________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal SMP

PCMCIA_FAIL:
'echo PCM Base Test________PCMCIA_____________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

/*-----*/
SMP:
if stream(os2drv':\pcmlogs\temp\smp\smptest.log'  ,'c','query size') \= '' then signal CHK_SMP

'echo PCM Base Test________SMP________________NOT RUN >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal JFSTEST

CHK_SMP:
'grep "Test passed" 'os2drv':\PCMLOGS\TEMP\SMP\SMPTEST.LOG > nul'
if rc = 6 then signal SMPPASS

'echo SMP test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Errors were detected in the SMPTEST.LOG. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Analyze this .LOG file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test SMP and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________SMP________________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal JFSTEST

SMPPASS:
'echo PCM Base Test________SMP________________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'

JFSTEST:
if stream(os2drv':\pcmlogs\temp\JFSTEST\JFSTEST.LOG'  ,'c','query size') \= '' then signal CHK_JFS

'echo PCM Base Test________JFS________________NOT RUN >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal CLEANUP

CHK_JFS:
'grep "completed successfully" 'os2drv':\PCMLOGS\TEMP\JFSTEST\JFSTEST.LOG > nul'
if rc = 1 then signal JFSPASS

'echo JSF test >> 'os2drv':\pcmlogs\temp\testbad'
'echo   ..Errors were detected in the JFSTEST.LOG. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Analyze this .LOG file for possible causes. >> 'os2drv':\pcmlogs\temp\testbad'
'echo     Please rerun Test JFS and update results diskette. >> 'os2drv':\pcmlogs\temp\testbad'
'echo *************************************************************************** >> 'os2drv':\pcmlogs\temp\testbad'
'echo PCM Base Test________JFS________________FAIL >> 'os2drv':\pcmlogs\temp\pcmscore.txt'
signal CLEANUP

JFSPASS:
'echo PCM Base Test________JFS________________PASS >> 'os2drv':\pcmlogs\temp\pcmscore.txt'



CLEANUP:

if stream(os2drv':\pcmlogs\temp\pcmscore.txt'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt A:\ > nul'
   'copy 'os2drv':\pcmlogs\temp\pcmscore.txt 'os2drv':\PCMLOGS > nul'
   end

if stream(os2drv':\pcmlogs\temp\testbad'  ,'c','query size') \= '' then do
   'copy 'os2drv':\pcmlogs\temp\testbad A:\ > nul'
   end

exit

INFO_PLEASE:
say 'ͻ'
say ' CHEKRSLT.CMD - Analyzes testkit results diskette logfiles '
say '                for PASS-FAIL and creates PCMSCORE.TXT     '
say '                                                           '
say ' Parameters: NONE                                          '
say '                                                           '
say ' Called by PCMRSLTS.EXE after running PREPRSLT.CMD         '
say 'ͼ'
exit
