/* Abstract syntax tree
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 * 
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.20
 * Terence Parr
 * Purdue University
 * With AHPCRC, University of Minnesota
 * 1989-1994
 */

#ifndef ASTX_H
#define ASTX_H

#include <stdio.h>

/*
 * Notes:
 *
 * To specify a copy constructor, subclass one of these classes and
 * give the copy constructor.  For dup(), you must override the inheritance
 * also as this is copying tree nodes.
 */

class ASTBase {
public:
	ASTBase *_right, *_down;	// yes, I know 'public' is bad; I don't care

public:
	ASTBase() { _right = _down = NULL; }
	virtual ~ASTBase() { ; }
	ASTBase *right() { return _right; }
	ASTBase *down() { return _down; }
	ASTBase *dup();
	void destroy();
	void preorder();
	static ASTBase *tmake(ASTBase *, ...);
	static void link(ASTBase **, ASTBase **, ASTBase **);
	void subchild(ASTBase **, ASTBase **, ASTBase **);
	void subroot(ASTBase **, ASTBase **, ASTBase **);
	virtual void preorder_action() { ; }
	virtual void preorder_before_action() { printf(" ("); }
	virtual void preorder_after_action() { printf(" )"); }
};

class ASTDoublyLinkedBase : public ASTBase {
protected:
	ASTDoublyLinkedBase *_left, *_up;
public:
	void double_link(ASTBase *left, ASTBase *up);
	ASTDoublyLinkedBase *dup();
	ASTBase *left() { return _left; }
	ASTBase *up() { return _up; }
};

class AST;	// announce that this class will be coming along shortly
#endif
