/* AToken.h
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 * 
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.20
 * Terence Parr
 * Purdue University
 * With AHPCRC, University of Minnesota
 * 1989-1994
 */

#ifndef ATOKEN_H
#define ATOKEN_H

#include <string.h>

#ifndef ANTLRCommonTokenTEXTSIZE
#define ANTLRCommonTokenTEXTSIZE	100
#endif

/* must define what a char looks like; can make this a class too */
typedef char ANTLRChar;

// What does an ANTLR Token look like?
// Must not have virtual functions so that min token size can be sizeof('int').
// This could an abstract class, but we don't want the vtable pointers
class ANTLRTokenBase {
protected:
	TokenType _type;
public:
	TokenType getType() { return _type; }
	void setType(TokenType t) { _type = t; }

	/* Define to satisfy ANTLR error mechanism */
	ANTLRChar *getText() { return ""; }
};

// if you are using DLG, your token def must derive from this class
// min Token size is sizeof(TokenType) + space for virtual function table.
class DLGBasedToken : public ANTLRTokenBase {
public:
	DLGBasedToken(TokenType t) { setType(t); }
	DLGBasedToken() {;}
	virtual void setText(ANTLRChar *s) = 0;
	virtual ANTLRChar *getText() = 0;
	/* must define makeToken() so that DLG knows how to fill in a token;
	 * you can redefine it to do whatever you want
	 */
	virtual void makeToken(TokenType t, ANTLRChar *s)
	{
		setType(t); setText(s);
	}
};

class ANTLRCommonToken : public DLGBasedToken {
protected:
	ANTLRChar _text[ANTLRCommonTokenTEXTSIZE+1];
public:
	ANTLRCommonToken(TokenType t, ANTLRChar *s) : DLGBasedToken(t)
			{ setText(s); }
	ANTLRCommonToken() {;}
	ANTLRChar *getText() { return _text; }
	void setText(ANTLRChar *s) { strncpy(_text, s, ANTLRCommonTokenTEXTSIZE); }
};

/* Example of creation of ANTLRToken:
   ANTLRToken must have constructor kinda like old zzcr_attr().  The args
   to the constructor must be exactly as shown below (number/type).
   The destructor (if any) can do what it wants.

   The type 'ANTLRToken' must be defined for ANTLR.  This class can
   be anything you want if you use "typedef mytokenclass ANTLRToken;".

class ANTLRToken : public DLGBasedToken {
	int muck;
public:
	ANTLRToken(TokenType t, ANTLRChar *s) : ANTLRBasedToken(t,s)
		{ muck = atoi(s); }
	ANTLRToken() { muck = 0; }
};

*/

#endif
