/*
 * generic.h -- generic include stuff for new PCCTS ANTLR.
 *
 * $Id: generic.h,v 1.5 1994/03/25 19:40:05 parrt Exp parrt $
 * $Revision: 1.5 $
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 * 
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.20
 * Terence Parr
 * Purdue University
 * With AHPCRC, University of Minnesota
 * 1989-1994
 */

#define StrSame			0

/* User may redefine how line information looks */
#define LineInfoFormatStr "# %d \"%s\"\n"

#define DefaultParserName	"zzparser"

#define ZZLEXBUFSIZE 4000

/* Tree/FIRST/FOLLOW defines -- valid only after all grammar has been read */
#define ALT			TokenNum+1
#define SET			TokenNum+2
#define TREE_REF	TokenNum+3

					/* E r r o r  M a c r o s */

#ifdef MPW		/* Macintosh Programmer's Workshop */
#define ErrHdr "File \"%s\"; Line %d #"
#else
#define ErrHdr "%s, line %d:"
#endif

#define fatal(err)	fatalFL(err, __FILE__, __LINE__)


#define eMsg1(s,a)	eMsg3(s,a,NULL,NULL)
#define eMsg2(s,a,b)	eMsg3(s,a,b,NULL)

				/* S a n i t y  C h e c k i n g */

#ifndef require
#define require(expr, err) {if ( !(expr) ) fatal_internal(err, __FILE__, __LINE__);}
#endif

					/* L i s t  N o d e s */

typedef struct _ListNode {
			void *elem;			/* pointer to any kind of element */
			struct _ListNode *next;
		} ListNode;

/* Define a Cycle node which is used to track lists of cycles for later
 * reconciliation by ResolveFoCycles().
 */
typedef struct _c {
			int croot;			/* cycle root */
			set cyclicDep;		/* cyclic dependents */
			unsigned deg;		/* degree of FOLLOW set of croot */
		} Cycle;

typedef struct _e {
			int tok;			/* error class name == TokenStr[tok] */
			ListNode *elist;	/* linked list of elements in error set */
			set eset;
			int setdeg;			/* how big is the set */
			int lexclass;		/* which lex class is it in? */
		} ECnode;

typedef struct _TCnode {
			int tok;			/* token class name */
			ListNode *tlist;	/* linked list of elements in token set */
			set tset;
			int lexclass;		/* which lex class is it in? */
		} TCnode;

typedef struct _ft {
			char *token;		/* id of token type to remap */
			int tnum;			/* move token type to which token position */
		} ForcedToken;

#define newListNode	(ListNode *) calloc(1, sizeof(ListNode));
#define newCycle	(Cycle *) calloc(1, sizeof(Cycle));
#define newECnode	(ECnode *) calloc(1, sizeof(ECnode));
#define newTCnode	(TCnode *) calloc(1, sizeof(TCnode));


				/* H a s h  T a b l e  E n t r i e s */

typedef struct _t {				/* Token name or expression */
			char *str;
			struct _t *next;
			int token;			/* token number */
			unsigned char classname;	/* is it a err/tok class name or token */
			TCnode *tclass;		/* ptr to token class */
			char *action;
		} TermEntry;

typedef struct _r {				/* Rule name and ptr to start of rule */
			char *str;
			struct _t *next;
/*			int passedSomething;/* is this rule passed something? */
/*			int returnsSomething;/* does this rule return something? */
			int rulenum;		/* RulePtr[rulenum]== ptr to RuleBlk junction */
			int noAST;			/* gen AST construction code? (def==gen code) */
			char *egroup;		/* which error group (err reporting stuff) */
		} RuleEntry;

typedef struct _f {				/* cache Fi/Fo set */
			char *str;			/* key == (rulename, computation, k) */
			struct _f *next;
			set fset;			/* First/Follow of rule */
			set rk;				/* set of k's remaining to be done after ruleref */
			int incomplete;		/* only w/FOLLOW sets.  Use only if complete */
		} CacheEntry;

#define newTermEntry(s)		(TermEntry *) newEntry(s, sizeof(TermEntry))
#define newRuleEntry(s)		(RuleEntry *) newEntry(s, sizeof(RuleEntry))
#define newCacheEntry(s)	(CacheEntry *) newEntry(s, sizeof(CacheEntry))

					/* L e x i c a l  C l a s s */

/* to switch lex classes, switch ExprStr and Texpr (hash table) */
typedef struct _lc {
			char *classnum, **exprs;
			Entry **htable;
		} LClass;

typedef struct _exprOrder {
			char *expr;
			int lclass;
		} Expr;


typedef Graph Attrib;

						/* M a x i m u m s */

#ifndef HashTableSize
#define HashTableSize	253
#endif
#ifndef StrTableSize
#define StrTableSize	15000	/* all tokens, nonterminals, rexprs stored here */
#endif
#define MaxLexClasses	50		/* how many automatons */
/* TokenStart and EofToken are ignored if #tokdefs meta-op is used */
#define TokenStart		2		/* MUST be in 1 + EofToken */
#define EofToken		1		/* Always predefined to be 1 */
#define MaxNumFiles		20
#define MaxFileName		300		/* largest file name size */
#define MaxRuleName		100		/* largest rule name size */
#define TSChunk			100		/* how much to expand TokenStr/ExprStr each time */
#define TIChunk			TSChunk	/* expand TokenInd by same as TokenStr to mirror them */
#define FoStackSize		100		/* deepest FOLLOW recursion possible */

/* AST token types */
#define ASTexclude		0
#define ASTchild		1
#define ASTroot			2
#define ASTinclude		3		/* include subtree made by rule ref */


#define PredictionVariable				"zzpr_expr"
#define PredictionLexClassSuffix		"_zzpred"

#define DirectorySymbol					"/"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef ANTLRm
#define ANTLRm(st, f, _m)	zzbufsize = ZZLEXBUFSIZE;\
						zzmode(_m);					\
						zzenterANTLR(f);			\
						st; ++zzasp;				\
						zzleaveANTLR(f);
#endif						

#include "proto.h"
