/*
 * dialog.c
 *
 * $Id: dialog.c,v 1.2 1993/12/14 20:17:08 parrt Exp parrt $
 * $Revision: 1.2 $
 *
 * dialog manager for -ai (antlr interactive) mode
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 * 
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.20
 * Terence Parr
 * Purdue University
 * With AHPCRC, University of Minnesota
 * 1989-1994
 */
#include <stdio.h>
#ifdef __cplusplus
#ifndef __STDC__
#define __STDC__
#endif
#endif
#include "set.h"
#include "syn.h"
#include "hash.h"
#include "generic.h"
#include "dlgdef.h"

#ifdef NOT_USED

void
#ifdef __STDC__
AmbiguityDialog( Junction *j, int jtype, Junction *alt1, Junction *alt2, int *CLL_k, int *LL_k)
#else
AmbiguityDialog( j, jtype, alt1, alt2, CLL_k, LL_k )
Junction *j;
int jtype;
Junction *alt1;
Junction *alt2;
int *CLL_k;
int *LL_k;
#endif
{
	int i;
	set *fset;

	fset = (set *) calloc( *CLL_k+1, sizeof(set));
	require(fset!=NULL, "cannot allocate fset");
	for (i=1; i<= *CLL_k; i++)
	{
		fset[i] = set_and(alt1->fset[i], alt2->fset[i]);
	}

	fprintf(stdout, "\n");
	pLevel = 0;
	pAlt1 = alt1->altnum;
	pAlt2 = alt2->altnum;

	if ( jtype==aLoopBlk )
	{
		pLevel = 1;
		if ( pAlt1==1 ) printf("=>");
		printf("\t");
	}

#ifdef DUM
	if ( jtype==aLoopBlk )
	{
		pLevel++;
		if ( pLevel==1 )
		{
			if ( pAlt1==1 ) printf("=>");
			printf("\t");
		}
		else printf(" ");
		printf("(");
		if ( pLevel==1 ) printf(" ");
		pJunc(j);
		if ( pLevel>1 ) printf(" ");
		else printf("\n\t");
		printf(")*");
		pLevel--;
		if ( j->end->p1 != NULL ) PRINT(j->end->p1);
	}
	else
#endif

	pJunc(j);
	fprintf(stdout, "\n");

	fprintf(stdout, ErrHdr, FileStr[alt1->file], alt1->line);
	if ( jtype == aLoopBegin )
		fprintf(stdout, " warning: optional path and alt(s) of (..)* ambiguous upon");
	else
		fprintf(stdout, " warning: alts %d and %d ambiguous upon",
					alt1->altnum, alt2->altnum);
/*	if ( elevel == 3 )
	{
		preorder(ambig);
		fprintf(stderr, "\n");
		Tfree(ambig);
		return;
	}*/

	dumpAmbigMsg(fset, stdout, 1);

	fprintf(stdout, "> ");
	getchar();
	for (i=1; i<= *CLL_k; i++) set_free( fset[i] );
	free(fset);
}

#endif
