/*
 * antlr.g	--	PCCTS Version 1.xx ANTLR
 *
 * $Id: antlr.g,v 1.7 1994/03/25 19:40:05 parrt Exp parrt $
 * $Revision: 1.7 $
 *
 * Parse an antlr input grammar and build a syntax-diagram.
 *
 * Written in itself (needs at least 1.06 to work)
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to the Purdue Compiler Construction Tool
 * Set (PCCTS) -- PCCTS is in the public domain.  An individual or
 * company may do whatever they wish with source code distributed with
 * PCCTS or the code generated by PCCTS, including the incorporation of
 * PCCTS, or its output, into commerical software.
 * 
 * We encourage users to develop software with PCCTS.  However, we do ask
 * that credit is given to us for developing PCCTS.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like PCCTS and have developed a nice tool with the
 * output, please mention that you developed it using PCCTS.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * ANTLR 1.20
 * Terence Parr
 * Purdue University
 * With AHPCRC, University of Minnesota
 * 1989-1994
 */
#header <<
	#ifdef __cplusplus
	#ifndef __STDC__
	#define __STDC__
	#endif
	#endif
	#include "set.h"
	#include <ctype.h>
	#include "syn.h"
	#include "hash.h"
	#include "generic.h"
	#define zzcr_attr(attr,tok,t)
	>>

<<
#ifdef __STDC__
static void chkToken(char *, char *, char *, int);
#else
static void chkToken();
#endif

static int class_nest_level = 0;
>>

#lexaction <<
/* maintained, but not used for now */
set AST_nodes_refd_in_actions = set_init;
>>

#lexclass STRINGS
#token QuotedTerm "\""		<< zzmode(START); >>
#token "\n"					<<
							zzline++;
							warn("eoln found in string");
							zzskip();
							>>
#token "\\~[]"				<< zzmore(); >>
#token "~[\n\"\\]+"			<< zzmore(); >>

#lexclass ACTION_STRINGS
#token "\""					<< zzmode(ACTIONS); zzmore(); >>
#token "\n"					<<
							zzline++;
							warn("eoln found in string (in user action)");
							zzskip();
							>>
#token "\\~[]"				<< zzmore(); >>
#token "~[\n\"\\]+"			<< zzmore(); >>

#lexclass ACTION_CHARS
#token "'"					<< zzmode(ACTIONS); zzmore(); >>
#token "\n"					<<
							zzline++;
							warn("eoln found in char literal (in user action)");
							zzskip();
							>>
#token "\\~[]"				<< zzmore(); >>
#token "~[\n'\\]+"			<< zzmore(); >>

#lexclass ACTION_COMMENTS
#token "\*/"				<< zzmode(ACTIONS); zzmore(); >>
#token "\*"					<< zzmore(); >>
#token "\n"					<< zzline++; zzmore(); >>
#token "~[\n\*]+"			<< zzmore(); >>

#lexclass TOK_DEF_COMMENTS
#token "\*/"				<< zzmode(PARSE_ENUM_FILE); zzmore(); >>
#token "\*"					<< zzmore(); >>
#token "\n"					<< zzline++; zzmore(); >>
#token "~[\n\*]+"			<< zzmore(); >>

#lexclass TOK_DEF_CPP_COMMENTS
#token "\n"					<< zzline++; zzmode(PARSE_ENUM_FILE); zzmore(); >>
#token "~[\n]+"				<< zzmore(); >>

#lexclass ACTION_CPP_COMMENTS
#token "\n"					<< zzline++; zzmode(ACTIONS); zzmore(); >>
#token "~[\n]+"				<< zzmore(); >>

#lexclass CPP_COMMENTS
#token "\n"					<< zzline++; zzmode(START); zzskip(); >>
#token "~[\n]+"				<< zzskip(); >>

#lexclass COMMENTS
#token "\*/"				<< zzmode(START); zzskip(); >>
#token "\*"					<< zzskip(); >>
#token "\n"					<< zzline++; zzskip(); >>
#token "~[\n\*]+"			<< zzskip(); >>

/*
 * This lexical class accepts actions of type [..] and <<..>>
 *
 * It translates the following special items for C:
 *
 * $j		--> "zzaArg(current zztasp, j)"
 * $i.j		--> "zzaArg(zztaspi, j)"
 * $i.nondigit> "zzaArg(current zztasp, i).nondigit"
 * $$		--> "zzaRet"
 * $alnum	--> "alnum"			(used to ref parameters)
 * $rule	--> "zzaRet"
 * $retval	--> "_retv.retval" if > 1 return values else "_retv"
 * $[token, text] --> "zzconstr_attr(token, text)"
 * $[]		--> "zzempty_attr()"
 *
 * It translates the following special items for C++:
 * (attributes are now stored with 'Token' and $i's are only 
 *  pointers to the Tokens.  Rules don't have attributes now.)
 *
 * $j		--> "_tbj" where b is the block level
 * $i.j		--> "_tij"
 * $j->nondigit> "_tbj->nondigit"
 * $$		--> "$$"
 * $alnum	--> "alnum"			(used to ref parameters)
 * $rule	--> "$rule"
 * $retval	--> "_retv.retval" if > 1 return values else "_retv"
 * $[token, text] --> invalid
 * $[]		--> invalid
 *
 * And, for trees:
 *
 * #0		-->	"(*_root)"
 * #i		--> "zzastArg(i)"
 * #[args]	--> "zzmk_ast(zzastnew(), args)"
 * #[]		--> "zzastnew()"
 * #( root, child1, ..., childn )
			--> "zztmake(root, child1, ...., childn, NULL)"
 * #()		--> "NULL"
 *
 * For C++, ...
 *
 * #0		-->	"(*_root)"
 * #i		--> "_astbi" where b is the block level
 * #[args]	--> "new AST(args)"
 * #[]		--> "new AST"
 * #( root, child1, ..., childn )
			--> "AST::tmake(root, child1, ...., childn, NULL)"
 * #()		--> "NULL"
 *
 * To escape,
 *
 * \]		--> ]
 * \)		--> )
 * \$		--> $
 * \#		--> #
 *
 * A stack is used to nest action terminators because they can be nested
 * like crazy:  << #[$[..],..] >>
 */
#lexclass ACTIONS
#token Action "\>\>"        << /* these do not nest */
                              zzmode(START);
                              NLATEXT[0] = ' ';
                              NLATEXT[1] = ' ';
                              zzbegexpr[0] = ' ';
                              zzbegexpr[1] = ' ';
							  if ( zzbufovf ) {
								err( eMsgd("action buffer overflow; size %d",ZZLEXBUFSIZE));
							  }
                            >>
#token Pred "\>\>?"			<< /* these do not nest */
                              zzmode(START);
                              NLATEXT[0] = ' ';
                              NLATEXT[1] = ' ';
                              zzbegexpr[0] = '\0';
							  if ( zzbufovf ) {
								err( eMsgd("predicate buffer overflow; size %d",ZZLEXBUFSIZE));
							  }
                            >>
#token PassAction "\]"		<< if ( topint() == ']' ) {
								  popint();
								  if ( istackempty() )	/* terminate action */
								  {
									  zzmode(START);
									  NLATEXT[0] = ' ';
									  zzbegexpr[0] = ' ';
									  if ( zzbufovf ) {
										err( eMsgd("parameter buffer overflow; size %d",ZZLEXBUFSIZE));
									  }
								  }
								  else {
									  /* terminate $[..] and #[..] */
									  if ( GenCC ) zzreplstr("))");
									  else zzreplstr(")");
									  zzmore();
								  }
							   }
							   else if ( topint() == '|' ) { /* end of simple [...] */
								  popint();
								  zzmore();
							   }
							   else zzmore();
							>>
#token "\n"					<< zzline++; zzmore(); >>
#token "\>"					<< zzmore(); >>
#token "$"					<< zzmore(); >>
#token "$$"					<< if ( !GenCC ) {zzreplstr("zzaRet"); zzmore();}
							   else err("$$ use invalid in C++ mode"); >>

#token "$\[\]"				<< if ( !GenCC ) {zzreplstr("zzempty_attr"); zzmore();}
							   else err("$[] use invalid in C++ mode"); >>
#token "$\["				<<
							pushint(']');
							if ( !GenCC ) zzreplstr("zzconstr_attr(");
							else err("$[..] use invalid in C++ mode");
							zzmore();
							>>
#token "$[0-9]+"			<<{
							static char buf[100];
							if ( strlen(zzbegexpr)>85 )
								fatal("$i attrib ref too big");
							if ( !GenCC ) sprintf(buf,"zzaArg(zztasp%d,%s)",
										BlkLevel-1,zzbegexpr+1);
							else sprintf(buf,"_t%d%s",
										BlkLevel-1,zzbegexpr+1);
							zzreplstr(buf);
							zzmore();
							}
							>>
#token "$[0-9]+."			<<{
							static char buf[100];
							if ( strlen(zzbegexpr)>85 )
								fatal("$i.field attrib ref too big");
							zzbegexpr[strlen(zzbegexpr)-1] = ' ';
							if ( !GenCC ) sprintf(buf,"zzaArg(zztasp%d,%s).",
										BlkLevel-1,zzbegexpr+1);
							else sprintf(buf,"_t%d%s.",
										BlkLevel-1,zzbegexpr+1);
							zzreplstr(buf);
							zzmore();
							}
							>>
#token "$[0-9]+.[0-9]+"		<<{
							static char buf[100];
							static char i[20], j[20];
							char *p,*q;
							if (strlen(zzbegexpr)>85) fatal("$i.j attrib ref too big");
							for (p=zzbegexpr+1,q= &i[0]; *p!='.'; p++) {
								if ( q == &i[20] ) fatalFL("i of $i.j attrib ref too big", FileStr[CurFile], zzline );
								*q++ = *p;
							}
							*q = '\0';
							for (p++, q= &j[0]; *p!='\0'; p++) {
								if ( q == &j[20] ) fatalFL("j of $i.j attrib ref too big", FileStr[CurFile], zzline );
								*q++ = *p;
							}
							*q = '\0';
							if ( !GenCC ) sprintf(buf,"zzaArg(zztasp%s,%s)",i,j);
							else sprintf(buf,"_t%s%s",i,j);
							zzreplstr(buf);
							zzmore();
							}
							>>
#token "$[_a-zA-Z][_a-zA-Z0-9]*"
							<<{ static char buf[300];
							zzbegexpr[0] = ' ';
							if ( CurRule != NULL &&
								 strcmp(CurRule, &zzbegexpr[1])==0 ) {
								if ( !GenCC ) zzreplstr("zzaRet");
							}
							else if ( CurRetDef != NULL ) {
								if ( strmember(CurRetDef, &zzbegexpr[1]) ) {
									if ( HasComma( CurRetDef ) ) {
										require (strlen(zzbegexpr)<=285,
												 "$retval attrib ref too big");
										sprintf(buf,"_retv.%s",&zzbegexpr[1]);
										zzreplstr(buf);
									}
									else zzreplstr("_retv");
								}
								else if ( CurParmDef != NULL ) {
									if ( !strmember(CurParmDef, &zzbegexpr[1]) )
										warn(eMsg1("$%s not parameter or return value",&zzbegexpr[1]));
								}
								else warn(eMsg1("$%s not parameter or return value",&zzbegexpr[1]));
							}
							}
							zzmore();
							>>
#token "#0"					<< zzreplstr("(*_root)"); zzmore(); >>
#token "#\[\]"				<< if ( GenCC ) zzreplstr("(new AST)");
							   zzreplstr("zzastnew()"); zzmore();>>
#token "#\(\)"				<< zzreplstr("NULL"); zzmore(); >>
#token "#[0-9]+"			<<{
							static char buf[100];
							if ( strlen(zzbegexpr)>85 )
								fatal("#i AST ref too big");
							if ( GenCC ) sprintf(buf,"_ast%d%s",BlkLevel-1,zzbegexpr+1);
							else sprintf(buf,"zzastArg(%s)",zzbegexpr+1);
							zzreplstr(buf);
							zzmore();
							set_orel(atoi(zzbegexpr+1), &AST_nodes_refd_in_actions);
							}
							>>
#token "#\["				<<
							pushint(']');
							if ( GenCC ) zzreplstr("(new AST(");
							else zzreplstr("zzmk_ast(zzastnew(),");
							zzmore();
							>>
#token "#\("				<<
							pushint('}');
							if ( GenCC ) zzreplstr("ASTBase::tmake(");
							else zzreplstr("zztmake(");
							zzmore();
							>>
#token "#"					<< zzmore(); >>
#token "\)"					<<
							if ( istackempty() )
								zzmore();
							else if ( topint()==')' ) {
								popint();
							}
							else if ( topint()=='}' ) {
								popint();
								/* terminate #(..) */
								zzreplstr(", NULL)");
							}
							zzmore();
							>>
#token "\["					<<
							pushint('|');	/* look for '|' to terminate simple [...] */
							zzmore();
							>>
#token "\("					<<
							pushint(')');
							zzmore();
							>>

#token "\\\]"				<< zzreplstr("]");  zzmore(); >>
#token "\\\)"				<< zzreplstr(")");  zzmore(); >>
#token "\\>"				<< zzreplstr(">");  zzmore(); >>


#token "'"					<< zzmode(ACTION_CHARS); zzmore();>>
#token "\""					<< zzmode(ACTION_STRINGS); zzmore();>>
#token "\\$"				<< zzreplstr("$");  zzmore(); >>
#token "\\#"				<< zzreplstr("#");  zzmore(); >>
/*#token "\\\\"				<< zzmore(); >> /* need this for some reason */
#token "\\~[\]\)>$#]"		<< zzmore(); >> /* escaped char, always ignore */
#token "/"					<< zzmore(); >>
#token "/\*"				<< zzmode(ACTION_COMMENTS); zzmore(); >>
#token "\*/"				<< warn("Missing /*; found dangling */ in action"); zzmore(); >>
#token "//"					<< zzmode(ACTION_CPP_COMMENTS); zzmore(); >>
#token "~[\n\)\(\\$#\>\]\[\"'/]+" << zzmore(); >>

#lexclass START
#token "[\t\ ]+"			<< zzskip(); >>				/* Ignore White */
#token "[\n\r]"				<< zzline++; zzskip(); >>	/* Track Line # */
#token "\["                 << zzmode(ACTIONS); zzmore();
                               istackreset();
                               pushint(']'); >>
#token "\<\<"               << action_file=CurFile; action_line=zzline;
                               zzmode(ACTIONS); zzmore();
                               istackreset();
                               pushint('>'); >>
#token "\""					<< zzmode(STRINGS); zzmore(); >>
#token "/\*"				<< zzmode(COMMENTS); zzskip(); >>
#token "\*/"				<< warn("Missing /*; found dangling */"); zzskip(); >>
#token "//"					<< zzmode(CPP_COMMENTS); zzskip(); >>
#token "\>\>"				<< warn("Missing <<; found dangling \\>\\>"); zzskip(); >>
#token WildCard "."
#token Eof					"@"
							<<	/* L o o k  F o r  A n o t h e r  F i l e */
							{
							FILE *new_input;
							new_input = NextFile();
							if ( new_input == NULL ) { NLA=Eof; return; }
							fclose( input );
							input = new_input;
							zzrdstream( input );
							/*zzadvance();	/* Get 1st char of this file */
							zzskip();	/* Skip the Eof (@) char i.e continue */
							}
							>>

#errclass "grammar-element" { element }
#errclass "meta-symbol"		{ "\}" "!" ";" "\|" "\~" "^" "\)" }

/*
 * Get a grammar -- Build a list of rules like:
 *
 *	o-->Rule1--o
 *	|
 *	o-->Rule2--o
 *	|
 *	...
 *	|
 *	o-->RuleN--o
 */
grammar :	<<Graph g;>>
			(	"#header" Action
				<<
				if ( HdrAction==NULL ) {
				HdrAction = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
				require(HdrAction!=NULL, "rule grammar: cannot allocate header action");
				strcpy(HdrAction, LATEXT(1));
				}
				else warn("additional #header statement ignored");
				>>
			|	"#parser" QuotedTerm
				<<
				if ( GenCC ) {
					warn("#parser meta-op incompatible with -CC; ignored");
				}
				else {
					if ( strcmp(ParserName,"zzparser")==0 ) {
						ParserName=StripQuotes(mystrdup(LATEXT(1)));
						if ( RulePrefix[0]!='\0' )
						{
							warn("#parser meta-op incompatible with '-gp prefix'; '-gp' ignored");
							RulePrefix[0]='\0';
						}
					}
					else warn("additional #parser statement ignored");
				}
				>>
			|	"#tokdefs" QuotedTerm
				<<{
				zzantlr_state st; FILE *f; struct zzdlg_state dst;
				UserTokenDefsFile = mystrdup(LATEXT(1));
				zzsave_antlr_state(&st);
				zzsave_dlg_state(&dst);
				f = fopen(StripQuotes(LATEXT(1)), "r");
				if ( f==NULL ) {warn(eMsg1("cannot open token defs file '%s'", LATEXT(1)+1));}
				else {
					ANTLRm(enum_file(), f, PARSE_ENUM_FILE);
					UserDefdTokens = 1;
				}
				zzrestore_antlr_state(&st);
				zzrestore_dlg_state(&dst);
				}>>
			)*
			(	<<char *a;>>
				Action
				<<
				a = (char *) calloc(strlen(LATEXT(1))+1,
sizeof(char));
				require(a!=NULL, "rule grammar: cannot allocate action");
				strcpy(a, LATEXT(1));
				if ( class_nest_level>0 ) list_add(&class_actions, a);
				else list_add(&BeforeActions, a);
				>>
			|	laction
			|	aLexclass
			|	token
			|	error
			|	tclass
			|	class_def
			|	"\}"
				<<
				if ( class_nest_level==0 )
					warn("missing class definition for trailing '}'");
				class_nest_level--;
				>>
			)*
			rule		<<g=$3; SynDiag = (Junction *) $3.left;>>
			(	rule	<<if ( $1.left!=NULL ) {g.right = NULL; g = Or(g, $1);}>>
			|	aLexclass
			|	token
			|	error
			|	tclass
			|	class_def
			|	"\}"
				<<
				if ( class_nest_level==0 )
					warn("missing class definition for trailing '}'");
				class_nest_level--;
				>>
			)*
			(	<<char *a;>>
				Action
				<<
				a = (char *) calloc(strlen(LATEXT(1))+1,
sizeof(char));
				require(a!=NULL, "rule grammar: cannot allocate action");
				strcpy(a, LATEXT(1));
				if ( class_nest_level>0 ) list_add(&class_actions, a);
				else list_add(&AfterActions, a);
				>>
			|	laction
			|	error
			|	tclass
			|	class_def
			|	"\}"
				<<
				if ( class_nest_level==0 )
					warn("missing class definition for trailing '}'");
				class_nest_level--;
				>>
			)*
			Eof
		;
		<<CannotContinue=TRUE;>>

class_def
	:	<<int go=1; char name[MaxRuleName+1];>>
		"class"
		(	NonTerminal		<<if(go) strncpy(name,LATEXT(1),MaxRuleName);>>
		|	TokenTerm		<<if(go) strncpy(name,LATEXT(1),MaxRuleName);>>
		)
		<<
		if ( CurrentClassName[0]!='\0' && strcmp(CurrentClassName,name)!=0
			 && GenCC ) {
			err("only one grammar class allowed in this release");
			go = 0;
		}
		else strcpy(CurrentClassName, name);
		>>
		<<if ( !GenCC ) { err("class meta-op used without C++ option"); }>>
		"\{"
		<<
		no_classes_found = 0;
		if ( class_nest_level>=1 ) {warn("cannot have nested classes");}
		else class_nest_level++;
		>>
	;
	<<CannotContinue=TRUE;>>

/*
 * Build -o-->o-R-o-->o-	where -o-R-o- is the block from rule 'block'.
 * Construct the RuleBlk front and EndRule node on the end of the
 * block.  This is used to add FOLLOW pointers to the rule end.  Add the
 * new rule name to the Rname hash table and sets its rulenum.
 * Store the parameter definitions if any are found.
 *
 * Note that locks are required on the RuleBlk and EndRule nodes to thwart
 * infinite recursion.
 *
 * Return the left graph pointer == NULL to indicate error/dupl rule def.
 */
rule	:	<<
			RuleEntry *q; Junction *p; Graph r; int f, l; ECnode *e;
			set toksrefd, rulesrefd;
			char *pdecl=NULL, *ret=NULL, *a; CurRetDef = CurParmDef = NULL;
			>>
			NonTerminal
			<<q=NULL;
			  if ( hash_get(Rname, LATEXT(1))!=NULL ) {
				  warn(eMsg1("duplicate rule definition: '%s'",LATEXT(1)));
				  CannotContinue=TRUE;
			  }
			  else
			  {
			  	  q = (RuleEntry *)hash_add(Rname,
										LATEXT(1),
										(Entry *)newRuleEntry(LATEXT(1)));
				  CurRule = q->str;
			  }
			  CurRuleNode = q;
			  f = CurFile; l = zzline;
			  NumRules++;
			>>
			{	"!"  <<if ( q!=NULL ) q->noAST = TRUE;>> }
			{	<<;>>
				{"\<"}
				PassAction
				<<	pdecl = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
					require(pdecl!=NULL, "rule rule: cannot allocate param decl");
					strcpy(pdecl, LATEXT(1));
					CurParmDef = pdecl;
				>>
			}
			{	"\>"
				PassAction
				<<	ret = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
				    require(ret!=NULL, "rule rule: cannot allocate ret type");
					strcpy(ret, LATEXT(1));
 					CurRetDef = ret;
				>>
			}
			{ QuotedTerm <<if ( q!=NULL ) q->egroup=mystrdup(LATEXT(1));>> }
			<<
			if ( GenEClasseForRules && q!=NULL ) {
				e = newECnode;
				require(e!=NULL, "cannot allocate error class node");
				if ( q->egroup == NULL ) {a = q->str; a[0] = (char)toupper(a[0]);}
				else a = q->egroup;
				if ( Tnum( a ) == 0 )
				{
					e->tok = addTname( a );
					list_add(&eclasses, (char *)e);
					if ( q->egroup == NULL ) a[0] = (char)tolower(a[0]);
					/* refers to itself */
					list_add(&(e->elist), mystrdup(q->str));
				}
				else {
					warn(eMsg1("default errclass for '%s' would conflict with token/errclass/tokclass",a));
					if ( q->egroup == NULL ) a[0] = (char)tolower(a[0]);
					free(e);
				}
			}
			>>
			<<BlkLevel++;>>
			":" block[&toksrefd, &rulesrefd]
							<<r = makeBlk($7,0);
							  ((Junction *)r.left)->jtype = RuleBlk;
							  if ( q!=NULL ) ((Junction *)r.left)->rname = q->str;
							  ((Junction *)r.left)->file = f;
							  ((Junction *)r.left)->line = l;
							  ((Junction *)r.left)->pdecl = pdecl;
							  ((Junction *)r.left)->ret = ret;
							  ((Junction *)r.left)->lock = makelocks();
							  ((Junction *)r.left)->pred_lock = makelocks();
							  ((Junction *)r.left)->tokrefs = toksrefd;
							  ((Junction *)r.left)->rulerefs = rulesrefd;
							  p = newJunction();	/* add EndRule Node */
							  ((Junction *)r.right)->p1 = (Node *)p;
							  r.right = (Node *) p;
							  p->jtype = EndRule;
							  p->lock = makelocks();
							  p->pred_lock = makelocks();
							  ((Junction *)r.left)->end = p;
							  if ( q!=NULL ) q->rulenum = NumRules;
							  $7 = r;
							>>
			<<--BlkLevel;>>
			";"
			{	Action
				<<	a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
					require(a!=NULL, "rule rule: cannot allocate error action");
					strcpy(a, LATEXT(1));
					((Junction *)r.left)->erraction = a;
				>>
			}
			<<if ( q==NULL ) $0.left = NULL; else $0 = $7;>>
			<<CurRuleNode = NULL;>>
		;
		<<CannotContinue=TRUE;>>

laction	:	<<char *a;>>
			"#lexaction"
			Action
			<<
			a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
			require(a!=NULL, "rule laction: cannot allocate action");
			strcpy(a, LATEXT(1));
			list_add(&LexActions, a);
			>>
		;
		<<CannotContinue=TRUE;>>

aLexclass:	"#lexclass" TokenTerm <<lexclass(mystrdup(LATEXT(1)));>>
		;
		<<CannotContinue=TRUE;>>

error	:	<<char *t=NULL; ECnode *e; int go=1; TermEntry *p;>>
			"#errclass"
			(<<;>>	TokenTerm  <<t=mystrdup(LATEXT(1));>>
			|		QuotedTerm <<t=mystrdup(LATEXT(1));>>
			)
			<<e = newECnode;
			  require(e!=NULL, "cannot allocate error class node");
			  e->lexclass = CurrentLexClass;
			  if ( Tnum( (t=StripQuotes(t)) ) == 0 )
			  {
				if ( hash_get(Texpr, t) != NULL )
					warn(eMsg1("errclass name conflicts with regular expression  '%s'",t));
			  	e->tok = addTname( t );
				set_orel(e->tok, &imag_tokens);
				require((p=(TermEntry *)hash_get(Tname, t)) != NULL,
						"hash table mechanism is broken");
				p->classname = 1;	/* entry is errclass name, not token */
				list_add(&eclasses, (char *)e);
			  }
			  else
			  {
			  	warn(eMsg1("redefinition of errclass or conflict w/token or tokclass '%s'; ignored",t));
				free( e );
				go=0;
			  }
			>>
			"\{"
				( NonTerminal <<if ( go ) t=mystrdup(LATEXT(1));>>
				| TokenTerm <<if ( go ) t=mystrdup(LATEXT(1));>>
				| QuotedTerm <<if ( go ) t=mystrdup(LATEXT(1));>>
				)
				<<if ( go ) list_add(&(e->elist), t);>>
				(
					( NonTerminal <<if ( go ) t=mystrdup(LATEXT(1));>>
					| TokenTerm <<if ( go ) t=mystrdup(LATEXT(1));>>
					| QuotedTerm <<if ( go ) t=mystrdup(LATEXT(1));>>
					)
					<<if ( go ) list_add(&(e->elist), t);>>
				)*
			"\}"
		;
		<<CannotContinue=TRUE;>>

tclass	:	<<char *t=NULL; TCnode *e; int go=1,tok; TermEntry *p, *term;>>
			"#tokclass" TokenTerm <<t=mystrdup(LATEXT(1));>>
			<<e = newTCnode;
			  require(e!=NULL, "cannot allocate token class node");
			  e->lexclass = CurrentLexClass;
			  if ( Tnum( t ) == 0 )
			  {
			  	e->tok = addTname( t );
				set_orel(e->tok, &imag_tokens);
				require((p=(TermEntry *)hash_get(Tname, t)) != NULL,
						"hash table mechanism is broken");
				p->classname = 1;	/* entry is class name, not token */
				p->tclass = e;		/* save ptr to this tclass def */
				list_add(&tclasses, (char *)e);
			  }
			  else
			  {
			  	warn(eMsg1("redefinition of tokclass or conflict w/token '%s'; ignored",t));
				free( e );
				go=0;
			  }
			>>
			"\{"
				(
				( TokenTerm
				  <<if ( go ) {
					term = (TermEntry *) hash_get(Tname, LATEXT(1));
					if ( term==NULL && UserDefdTokens ) {
						err("implicit token definition not allowed with #tokdefs");
						go = 0;
					}
					else {t=mystrdup(LATEXT(1)); tok=addTname(LATEXT(1));}
					}>>
				| QuotedTerm
				  <<if ( go ) {
					term = (TermEntry *) hash_get(Texpr, LATEXT(1));
					if ( term==NULL && UserDefdTokens ) {
						err("implicit token definition not allowed with #tokdefs");
						go = 0;
					}
					else {t=mystrdup(LATEXT(1)); tok=addTexpr(LATEXT(1));}
					}>>
				)
				<<if ( go ) list_add(&(e->tlist), t);>>
				)*
			"\}"
		;
		<<CannotContinue=TRUE;>>

token	:	<<char *t=NULL, *e=NULL, *a=NULL; int tnum=0;>>
			"#token"
			{	TokenTerm  <<t=mystrdup(LATEXT(1));>>
				{	"=" "[0-9]+"		/* define the token type number */
					<<tnum = atoi(LATEXT(1));>>
				}
			}
			{ QuotedTerm <<e=mystrdup(LATEXT(1));>> }
			{	Action
				<<
					a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
					require(a!=NULL, "rule token: cannot allocate action");
					strcpy(a, LATEXT(1));
				>>
			}
			<<chkToken(t, e, a, tnum);>>
		;
		<<CannotContinue=TRUE;>>

block[set *toksrefd, set *rulesrefd]
		:	<<
			Graph g, b;
			*$toksrefd = empty;
			*$rulesrefd = empty;
			set_clr(AST_nodes_refd_in_actions);
			>>
			alt[toksrefd,rulesrefd]		<<b = g = $1;>>
			<<
			if ( ((Junction *)g.left)->p1->ntype == nAction )
			{
				if ( !((ActionNode *)(((Junction *)g.left)->p1))->is_predicate )
				{
					((ActionNode *)(((Junction *)g.left)->p1))->init_action = TRUE;
				}
			}
			>>
			(	"\|"
				alt[toksrefd,rulesrefd]		<<g = Or(g, $2);>>
			)*
			<<$0 = b;>>
		;
		<<CannotContinue=TRUE;>>

alt[set *toksrefd, set *rulesrefd]
		:	<<int n=0,ne=0; Graph g; int e_num=0, not=0;
			int first_on_line = 1; g.left=g.right=NULL;
			>>
			(	<<int tok;>>
				<<tok = LA(1);>>
				{ <<not=0;>> "\~" <<not=1;>> }
				element[not, first_on_line]
				<<if ( tok!=Action && tok!=Pred ) first_on_line = 0;>>
				<<
				if ( $2.left!=NULL ) {
					g = Cat(g, $2);
					n++;
					if ( tok!=Action && tok!=Pred ) e_num++;
					/* record record number of all rule and token refs */
					if ( tok==TokenTerm||tok==QuotedTerm||tok==WildCard ) {
						((TokNode *)((Junction *)$2.left)->p1)->elnum = e_num;
						set_orel(e_num, $toksrefd);
					}
					else if ( tok==NonTerminal ) {
						((RuleRefNode *)((Junction *)$2.left)->p1)->elnum = e_num;
						set_orel(e_num, $rulesrefd);
					}
				}
				>>
			)*
			<<if ( n == 0 ) g = emptyAlt();
			  $0 = g;
			>>
		;
		<<CannotContinue=TRUE;>>

element[int not, int first_on_line]
		:	<<
			set toksrefd, rulesrefd;
			TermEntry *term;
			TokNode *p=NULL; RuleRefNode *q; int approx=0;
			>>
			TokenTerm
			<<
			term = (TermEntry *) hash_get(Tname, LATEXT(1));
			if ( term==NULL && UserDefdTokens ) {
				err("implicit token definition not allowed with #tokdefs");
				$0.left = $0.right = NULL;
			}
			else {
				$0 = buildToken(LATEXT(1)); p=((TokNode *)((Junction *)$0.left)->p1);
				term = (TermEntry *) hash_get(Tname, LATEXT(1));
				require( term!= NULL, "hash table mechanism is broken");
				p->tclass = term->tclass;
				p->complement = $not;
			}
			>>
			{	".."
				(	QuotedTerm
					<<if ( p!=NULL ) setUpperRange(p, LATEXT(1));>>
				|	TokenTerm
					<<if ( p!=NULL ) setUpperRange(p, LATEXT(1));>>
				)
			}
			<<
			if ( p!=NULL && (p->upper_range!=0 || p->tclass || $not) )
				list_add(&MetaTokenNodes, (void *)p);
			>>
			(	"^"	<<if ( p!=NULL ) p->astnode=ASTroot;>>
			|		<<if ( p!=NULL ) p->astnode=ASTchild;>>
			|	"!" <<if ( p!=NULL ) p->astnode=ASTexclude;>>
			)
		|	QuotedTerm
			<<
			term = (TermEntry *) hash_get(Texpr, LATEXT(1));
			if ( term==NULL && UserDefdTokens ) {
				err("implicit token definition not allowed with #tokdefs");
				$0.left = $0.right = NULL;
			}
			else {
				$0 = buildToken(LATEXT(1)); p=((TokNode *)((Junction *)$0.left)->p1);
				p->complement = $not;
			}
			>>
			{	".."
				(	QuotedTerm
					<<if ( p!=NULL ) setUpperRange(p, LATEXT(1));>>
				|	TokenTerm
					<<if ( p!=NULL ) setUpperRange(p, LATEXT(1));>>
				)
			}
			(	"^"	<<if ( p!=NULL ) p->astnode=ASTroot;>>
			|		<<if ( p!=NULL ) p->astnode=ASTchild;>>
			|	"!" <<if ( p!=NULL ) p->astnode=ASTexclude;>>
			)
			<<
			if ( p!=NULL && (p->upper_range!=0 || p->tclass || $not) )
				list_add(&MetaTokenNodes, (void *)p);
			>>
		|	<<if ( $not ) warn("~ WILDCARD is an undefined operation (implies 'nothing')");>>
			"."
			<<$0 = buildWildCard(LATEXT(1)); p=((TokNode *)((Junction *)$0.left)->p1);>>
			(	"^"	<<p->astnode=ASTroot;>>
			|		<<p->astnode=ASTchild;>>
			|	"!" <<p->astnode=ASTexclude;>>
			)
			<<list_add(&MetaTokenNodes, (void *)p);>>
		|	<<if ( $not ) warn("~ NONTERMINAL is an undefined operation");>>
			NonTerminal
			<<$0 = buildRuleRef(LATEXT(1));>>
			{ "!" <<q = (RuleRefNode *) ((Junction *)$$.left)->p1;
					q->astnode=ASTexclude;>>
			}
			{	{"\<"}
				PassAction <<addParm(((Junction *)$$.left)->p1, LATEXT(1));>>
			}
			{	<<char *a; RuleRefNode *rr=(RuleRefNode *) ((Junction *)$$.left)->p1;
				  >>
				"\>"
				PassAction
				<<
					a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
					require(a!=NULL, "rule element: cannot allocate assignment");
					strcpy(a, LATEXT(1));
					rr->assign = a;
				>>
			}
		|	<<if ( $not )	warn("~ ACTION is an undefined operation");>>
			Action <<$0 = buildAction(LATEXT(1),action_file,action_line, 0);>>
		|	<<if ( $not )	warn("~ SEMANTIC-PREDICATE is an undefined operation");>>
			Pred   <<$0 = buildAction(LATEXT(1),action_file,action_line, 1);>>
			{	<<char *a; ActionNode *act = (ActionNode *) ((Junction *)$$.left)->p1;>>
				PassAction
				<<
				a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
				require(a!=NULL, "rule element: cannot allocate predicate fail action");
				strcpy(a, LATEXT(1));
				act->pred_fail = a;
				>>
			}
			<<
			if ( DemandLookahead )
			{
				warn("-gk incompatible with <<..>>? predicate usage; -gk turned off");
				DemandLookahead = 0;
			}
			>>
		|	<<if ( $not )	warn("~ BLOCK is an undefined operation");>>
			<<BlkLevel++;>>
			{	"#pragma"
				(	"approx" <<approx=LL_k;>>
				|	"LL(1)"  <<approx = 1;>>
				|	"LL(2)"  <<approx = 2;>>
				)
			}
			(	"\(" block[&toksrefd,&rulesrefd]
								<<$$ = $2; --BlkLevel;>> "\)"
				(	"\*"		<<$$ = makeLoop($$,approx);>>
				|	"\+"		<<$$ = makePlus($$,approx);>>
				|	"?"			<<$$ = makeBlk($$,approx);
								  FoundGuessBlk = 1;
								  ((Junction *) ((Junction *)$$.left)->p1)->guess=1;
								  if ( !$first_on_line ) {
									err("(...)? predicate must be first element of production");
								  }
								>>
				|				<<$$ = makeBlk($$,approx);>>
				)
				<<
				((Junction *)((Junction *)$$.left)->p1)->tokrefs = toksrefd;
				((Junction *)((Junction *)$$.left)->p1)->rulerefs = rulesrefd;
				>>

				{	PassAction	<<addParm(((Junction *)$$.left)->p1, LATEXT(1));>>
				}
			|	"\{"	block[&toksrefd,&rulesrefd]
						<<$$ = makeOpt($2,approx); --BlkLevel;>>
				"\}"
				<<
				((Junction *)((Junction *)$$.left)->p1)->tokrefs = toksrefd;
				((Junction *)((Junction *)$$.left)->p1)->rulerefs = rulesrefd;
				>>
				{	PassAction	<<addParm(((Junction *)$$.left)->p1, LATEXT(1));>>
				}
			)

/* Error catching alternatives */
		|	":"		<<warn(eMsg1("missing ';' on rule %s", CurRule));
					  CannotContinue=TRUE;>>
		|	"\*"	<<warn("don't you want a ')' with that '*'?"); CannotContinue=TRUE;>>
		|	"\+"	<<warn("don't you want a ')' with that '+'?"); CannotContinue=TRUE;>>
		|	"\>"	<<warn("'>' can only appear after a nonterminal"); CannotContinue=TRUE;>>
		|	PassAction <<warn("[...] out of context 'rule > [...]'");
						 CannotContinue=TRUE;>>
		;
		<<CannotContinue=TRUE;>>

#token NonTerminal		"[a-z] [A-Za-z0-9_]*"
#token TokenTerm		"[A-Z] [A-Za-z0-9_]*"
#token "#[A-Za-z0-9_]*"	<<warn(eMsg1("unknown meta-op: %s",LATEXT(1))); zzskip(); >>

#lexclass PARSE_ENUM_FILE

#token "[\t\ ]+"			<< zzskip(); >>				/* Ignore White */
#token "[\n\r]"				<< zzline++; zzskip(); >>	/* Track Line # */
#token "//"					<< zzmode(TOK_DEF_CPP_COMMENTS); zzmore(); >>
#token "/\*"				<< zzmode(TOK_DEF_COMMENTS); zzmore(); >>
#token "@"					<< ; >>

enum_file
	:	( enum_def )*
	|	defines
	;

defines
	:	<<int v,maxt= -1; char *t;>>
		(
			"#define" ID
			<<t = mystrdup(LATEXT(1));>>
			INT
			<<
			v = atoi(LATEXT(1));
/*			fprintf(stderr, "#token %s=%d\n", t, v); */
			TokenNum = v;
			if ( v>maxt ) maxt=v;
			if ( Tnum( t ) == 0 ) addForcedTname( t, v );
			else {
				warn(eMsg1("redefinition of token %s; ignored",t));
			}
			>>
		)*
		<<TokenNum = maxt + 1;>>
	;

enum_def
	:	<<int v= -1; char *t;>>
		"enum" ID
		"\{"
			ID
			<<t = mystrdup(LATEXT(1));>>
			(	"=" INT	<<v=atoi(LATEXT(1));>>
			|			<<v++;>>
			)
			<<
/*			fprintf(stderr, "#token %s=%d\n", t, v);*/
			TokenNum = v;
			if ( Tnum( t ) == 0 ) addForcedTname( t, v );
			else {
				warn(eMsg1("redefinition of token %s; ignored",t));
			}
			>>
			(	","
				{	ID
					<<t = mystrdup(LATEXT(1));>>
					(	"=" INT	<<v=atoi(LATEXT(1));>>
					|			<<v++;>>
					)
					<<
/*					fprintf(stderr, "#token %s=%d\n", t, v);*/
					TokenNum = v;
					if ( Tnum( t ) == 0 ) addForcedTname( t, v );
					else {
						warn(eMsg1("redefinition of token %s; ignored",t));
					}
					>>
				}
			)*
		"\}"
		";"
		<<TokenNum++;>>
	;

#token INT	"[0-9]+"
#token ID	"[A-Z][_a-zA-Z0-9]*"

#lexclass START

<<
/* semantics of #token */
static void
#ifdef __STDC__
chkToken(char *t, char *e, char *a, int tnum)
#else
chkToken(t,e,a,tnum)
char *t, *e, *a;
int tnum;
#endif
{
	TermEntry *p;

	/* check to see that they don't try to redefine a token as a token class */
	if ( t!=NULL ) {
		p = (TermEntry *) hash_get(Tname, t);
		if ( p!=NULL && p->classname ) {
			err(eMsg1("redefinition of #tokclass '%s' to #token not allowed; ignored",t));
			if ( a!=NULL ) free(a);
			return;
		}
	}

	if ( t==NULL && e==NULL ) {			/* none found */
		err("#token requires at least token name or rexpr");
	}
	else if ( t!=NULL && e!=NULL ) {	/* both found */
		if ( UserDefdTokens ) {			/* if #tokdefs, must not define new */
			p = (TermEntry *) hash_get(Tname, t);
			if ( p==NULL ) {
				err(eMsg1("#token definition '%s' not allowed with #tokdefs; ignored",t));
				return;
			}
		}
		Tklink(t, e);
		if ( a!=NULL ) {
			if ( hasAction(e) ) {
				err(eMsg1("redefinition of action for %s; ignored",e));
			}
			else setHasAction(e, a);
		}
	}
	else if ( t!=NULL ) {				/* only one found */
		if ( UserDefdTokens ) {
			err(eMsg1("#token definition '%s' not allowed with #tokdefs; ignored",t));
			return;
		}
		if ( Tnum( t ) == 0 ) addTname( t );
		else {
			err(eMsg1("redefinition of token %s; ignored",t));
		}
		if ( a!=NULL ) {
			err(eMsg1("action cannot be attached to a token name (%s); ignored",t));
			free(a);
		}
	}
	else if ( e!=NULL ) {
		if ( Tnum( e ) == 0 ) addTexpr( e );
		else {
			if ( hasAction(e) ) {
				err(eMsg1("redefinition of action for expr %s; ignored",e));
			}
			else if ( a==NULL ) {
				err(eMsg1("redefinition of expr %s; ignored",e));
			}
		}
		if ( a!=NULL ) setHasAction(e, a);
	}

	/* if a token type number was specified, then add the token ID and 'tnum'
	 * pair to the ForcedTokens list.  (only applies if an id was given)
	 */
	if ( t!=NULL && tnum>0 )
	{
		if ( set_el(tnum, reserved_positions) )
		{
			err(eMsgd("a token has already been forced to token number %d; ignored", tnum));
		}
		else
		{
			list_add(&ForcedTokens, newForcedToken(t,tnum));
			set_orel(tnum, &reserved_positions);
		}
	}
}
>>

<<
/* ANTLR-specific syntax error message generator 
 * (define USER_ZZSYN when compiling so don't get 2 definitions)
 */
void
#ifdef __STDC__
zzsyn(char *text, int tok, char *egroup, SetWordType *eset, int etok, int k, char *bad_text)
#else
zzsyn(text, tok, egroup, eset, etok, k, bad_text)
char *text, *egroup, *bad_text;
int tok;
int etok;
int k;
SetWordType *eset;
#endif
{
	fprintf(stderr, ErrHdr, FileStr[CurFile]!=NULL?FileStr[CurFile]:"stdin", zzline);
	fprintf(stderr, " syntax error at \"%s\"", (tok==zzEOF_TOKEN)?"EOF":text);
	if ( !etok && !eset ) {fprintf(stderr, "\n"); return;}
	if ( k==1 ) fprintf(stderr, " missing");
	else
	{
		fprintf(stderr, "; \"%s\" not", bad_text);
		if ( zzset_deg(eset)>1 ) fprintf(stderr, " in");
	}
	if ( zzset_deg(eset)>0 ) zzedecode(eset);
	else fprintf(stderr, " %s", zztokens[etok]);
	if ( strlen(egroup) > 0 ) fprintf(stderr, " in %s", egroup);
	fprintf(stderr, "\n");
}
>>
