/*
 * A n t l r  T r a n s l a t i o n  H e a d e r
 *
 * Terence Parr, Will Cohen, and Hank Dietz: 1989-1994
 * Purdue University Electrical Engineering
 * With AHPCRC, University of Minnesota
 * ANTLR Version 1.20b9
 */
#include <stdio.h>
#define ANTLR_VERSION	120b9

#ifdef __cplusplus
#ifndef __STDC__
#define __STDC__
#endif
#endif
#include "set.h"
#include <ctype.h>
#include "syn.h"
#include "hash.h"
#include "generic.h"
#define zzcr_attr(attr,tok,t)
#define zzEOF_TOKEN 1
#define zzSET_SIZE 16
#include "antlr.h"
#include "tokens.h"
#include "dlgdef.h"
#include "mode.h"
ANTLR_INFO

#ifdef __STDC__
static void chkToken(char *, char *, char *, int);
#else
static void chkToken();
#endif

static int class_nest_level = 0;

void
#ifdef __STDC__
grammar(void)
#else
grammar()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	Graph g;  
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( 1 ) {
			if ( (LA(1)==80) ) {
				zzmatch(80); zzCONSUME;
				zzmatch(Action);
				
				if ( HdrAction==NULL ) {
					HdrAction = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
					require(HdrAction!=NULL, "rule grammar: cannot allocate header action");
					strcpy(HdrAction, LATEXT(1));
				}
				else warn("additional #header statement ignored");
 zzCONSUME;
			}
			else {
				if ( (LA(1)==81) ) {
					zzmatch(81); zzCONSUME;
					zzmatch(QuotedTerm);
					
					if ( GenCC ) {
						warn("#parser meta-op incompatible with -CC; ignored");
					}
					else {
						if ( strcmp(ParserName,"zzparser")==0 ) {
							ParserName=StripQuotes(mystrdup(LATEXT(1)));
							if ( RulePrefix[0]!='\0' )
							{
								warn("#parser meta-op incompatible with '-gp prefix'; '-gp' ignored");
								RulePrefix[0]='\0';
							}
						}
						else warn("additional #parser statement ignored");
					}
 zzCONSUME;
				}
				else {
					if ( (LA(1)==82) ) {
						zzmatch(82); zzCONSUME;
						zzmatch(QuotedTerm);
						{
							zzantlr_state st; FILE *f; struct zzdlg_state dst;
							UserTokenDefsFile = mystrdup(LATEXT(1));
							zzsave_antlr_state(&st);
							zzsave_dlg_state(&dst);
							f = fopen(StripQuotes(LATEXT(1)), "r");
							if ( f==NULL ) {warn(eMsg1("cannot open token defs file '%s'", LATEXT(1)+1));}
							else {
								ANTLRm(enum_file(), f, PARSE_ENUM_FILE);
								UserDefdTokens = 1;
							}
							zzrestore_antlr_state(&st);
							zzrestore_dlg_state(&dst);
						}  
 zzCONSUME;
					}
					else break;
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		char *a;  
		while ( 1 ) {
			if ( (LA(1)==Action) ) {
				zzmatch(Action);
				
				a = (char *) calloc(strlen(LATEXT(1))+1,
				sizeof(char));
				require(a!=NULL, "rule grammar: cannot allocate action");
				strcpy(a, LATEXT(1));
				if ( class_nest_level>0 ) list_add(&class_actions, a);
				else list_add(&BeforeActions, a);
 zzCONSUME;
			}
			else {
				if ( (LA(1)==93) ) {
					laction();
				}
				else {
					if ( (LA(1)==94) ) {
						aLexclass();
					}
					else {
						if ( (LA(1)==97) ) {
							token();
						}
						else {
							if ( (LA(1)==95) ) {
								error();
							}
							else {
								if ( (LA(1)==96) ) {
									tclass();
								}
								else {
									if ( (LA(1)==84) ) {
										class_def();
									}
									else {
										if ( (LA(1)==83) ) {
											zzmatch(83);
											
											if ( class_nest_level==0 )
											warn("missing class definition for trailing '}'");
											class_nest_level--;
 zzCONSUME;
										}
										else break;
									}
								}
							}
						}
					}
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	rule();
	g=zzaArg(zztasp1,3); SynDiag = (Junction *) zzaArg(zztasp1,3 ).left;  
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( 1 ) {
			if ( (LA(1)==NonTerminal) ) {
				rule();
				if ( zzaArg(zztasp2,1 ).left!=NULL ) {g.right = NULL; g = Or(g, zzaArg(zztasp2,1));}  
			}
			else {
				if ( (LA(1)==94) ) {
					aLexclass();
				}
				else {
					if ( (LA(1)==97) ) {
						token();
					}
					else {
						if ( (LA(1)==95) ) {
							error();
						}
						else {
							if ( (LA(1)==96) ) {
								tclass();
							}
							else {
								if ( (LA(1)==84) ) {
									class_def();
								}
								else {
									if ( (LA(1)==83) ) {
										zzmatch(83);
										
										if ( class_nest_level==0 )
										warn("missing class definition for trailing '}'");
										class_nest_level--;
 zzCONSUME;
									}
									else break;
								}
							}
						}
					}
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		char *a;  
		while ( 1 ) {
			if ( (LA(1)==Action) ) {
				zzmatch(Action);
				
				a = (char *) calloc(strlen(LATEXT(1))+1,
				sizeof(char));
				require(a!=NULL, "rule grammar: cannot allocate action");
				strcpy(a, LATEXT(1));
				if ( class_nest_level>0 ) list_add(&class_actions, a);
				else list_add(&AfterActions, a);
 zzCONSUME;
			}
			else {
				if ( (LA(1)==93) ) {
					laction();
				}
				else {
					if ( (LA(1)==95) ) {
						error();
					}
					else {
						if ( (LA(1)==96) ) {
							tclass();
						}
						else {
							if ( (LA(1)==84) ) {
								class_def();
							}
							else {
								if ( (LA(1)==83) ) {
									zzmatch(83);
									
									if ( class_nest_level==0 )
									warn("missing class definition for trailing '}'");
									class_nest_level--;
 zzCONSUME;
								}
								else break;
							}
						}
					}
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzmatch(Eof); zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x1);
	}
}

void
#ifdef __STDC__
class_def(void)
#else
class_def()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	int go=1; char name[MaxRuleName+1];  
	zzmatch(84); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==NonTerminal) ) {
			zzmatch(NonTerminal);
			if(go) strncpy(name,LATEXT(1),MaxRuleName);  
 zzCONSUME;
		}
		else {
			if ( (LA(1)==TokenTerm) ) {
				zzmatch(TokenTerm);
				if(go) strncpy(name,LATEXT(1),MaxRuleName);  
 zzCONSUME;
			}
			else {zzFAIL(1,zzerr1,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
		}
		zzEXIT(zztasp2);
		}
	}
	
	if ( CurrentClassName[0]!='\0' && strcmp(CurrentClassName,name)!=0
	&& GenCC ) {
		err("only one grammar class allowed in this release");
		go = 0;
	}
	else strcpy(CurrentClassName, name);
	if ( !GenCC ) { err("class meta-op used without C++ option"); }  
	zzmatch(87);
	
	no_classes_found = 0;
	if ( class_nest_level>=1 ) {warn("cannot have nested classes");}
	else class_nest_level++;
 zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x2);
	}
}

void
#ifdef __STDC__
rule(void)
#else
rule()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	
	RuleEntry *q; Junction *p; Graph r; int f, l; ECnode *e;
	set toksrefd, rulesrefd;
	char *pdecl=NULL, *ret=NULL, *a; CurRetDef = CurParmDef = NULL;
	zzmatch(NonTerminal);
	q=NULL;
	if ( hash_get(Rname, LATEXT(1))!=NULL ) {
		warn(eMsg1("duplicate rule definition: '%s'",LATEXT(1)));
		CannotContinue=TRUE;
	}
	else
	{
		q = (RuleEntry *)hash_add(Rname,
		LATEXT(1),
		(Entry *)newRuleEntry(LATEXT(1)));
		CurRule = q->str;
	}
	CurRuleNode = q;
	f = CurFile; l = zzline;
	NumRules++;
 zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==88) ) {
			zzmatch(88);
			if ( q!=NULL ) q->noAST = TRUE;  
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		;  
		if ( (setwd1[LA(1)]&0x4) ) {
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				if ( (LA(1)==89) ) {
					zzmatch(89); zzCONSUME;
				}
				zzEXIT(zztasp3);
				}
			}
			zzmatch(PassAction);
			pdecl = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
			require(pdecl!=NULL, "rule rule: cannot allocate param decl");
			strcpy(pdecl, LATEXT(1));
			CurParmDef = pdecl;
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==90) ) {
			zzmatch(90); zzCONSUME;
			zzmatch(PassAction);
			ret = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
			require(ret!=NULL, "rule rule: cannot allocate ret type");
			strcpy(ret, LATEXT(1));
			CurRetDef = ret;
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==QuotedTerm) ) {
			zzmatch(QuotedTerm);
			if ( q!=NULL ) q->egroup=mystrdup(LATEXT(1));  
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	
	if ( GenEClasseForRules && q!=NULL ) {
		e = newECnode;
		require(e!=NULL, "cannot allocate error class node");
		if ( q->egroup == NULL ) {a = q->str; a[0] = (char)toupper(a[0]);}
		else a = q->egroup;
		if ( Tnum( a ) == 0 )
		{
			e->tok = addTname( a );
			list_add(&eclasses, (char *)e);
			if ( q->egroup == NULL ) a[0] = (char)tolower(a[0]);
			/* refers to itself */
			list_add(&(e->elist), mystrdup(q->str));
		}
		else {
			warn(eMsg1("default errclass for '%s' would conflict with token/errclass/tokclass",a));
			if ( q->egroup == NULL ) a[0] = (char)tolower(a[0]);
			free(e);
		}
	}
	BlkLevel++;  
	zzmatch(91); zzCONSUME;
	block( &toksrefd, &rulesrefd );
	r = makeBlk(zzaArg(zztasp1,7),0);
	((Junction *)r.left)->jtype = RuleBlk;
	if ( q!=NULL ) ((Junction *)r.left)->rname = q->str;
	((Junction *)r.left)->file = f;
	((Junction *)r.left)->line = l;
	((Junction *)r.left)->pdecl = pdecl;
	((Junction *)r.left)->ret = ret;
	((Junction *)r.left)->lock = makelocks();
	((Junction *)r.left)->pred_lock = makelocks();
	((Junction *)r.left)->tokrefs = toksrefd;
	((Junction *)r.left)->rulerefs = rulesrefd;
	p = newJunction();	/* add EndRule Node */
	((Junction *)r.right)->p1 = (Node *)p;
	r.right = (Node *) p;
	p->jtype = EndRule;
	p->lock = makelocks();
	p->pred_lock = makelocks();
	((Junction *)r.left)->end = p;
	if ( q!=NULL ) q->rulenum = NumRules;
	zzaArg(zztasp1,7) = r;
	--BlkLevel;  
	zzmatch(92); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==Action) ) {
			zzmatch(Action);
			a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
			require(a!=NULL, "rule rule: cannot allocate error action");
			strcpy(a, LATEXT(1));
			((Junction *)r.left)->erraction = a;
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	if ( q==NULL ) zzaArg(zztasp1,0 ).left = NULL; else zzaArg(zztasp1,0) = zzaArg(zztasp1,7);  
	CurRuleNode = NULL;  
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x8);
	}
}

void
#ifdef __STDC__
laction(void)
#else
laction()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	char *a;  
	zzmatch(93); zzCONSUME;
	zzmatch(Action);
	
	a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
	require(a!=NULL, "rule laction: cannot allocate action");
	strcpy(a, LATEXT(1));
	list_add(&LexActions, a);
 zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x10);
	}
}

void
#ifdef __STDC__
aLexclass(void)
#else
aLexclass()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	zzmatch(94); zzCONSUME;
	zzmatch(TokenTerm);
	lexclass(mystrdup(LATEXT(1)));  
 zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x20);
	}
}

void
#ifdef __STDC__
error(void)
#else
error()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	char *t=NULL; ECnode *e; int go=1; TermEntry *p;  
	zzmatch(95); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		;  
		if ( (LA(1)==TokenTerm) ) {
			zzmatch(TokenTerm);
			t=mystrdup(LATEXT(1));  
 zzCONSUME;
		}
		else {
			if ( (LA(1)==QuotedTerm) ) {
				zzmatch(QuotedTerm);
				t=mystrdup(LATEXT(1));  
 zzCONSUME;
			}
			else {zzFAIL(1,zzerr2,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
		}
		zzEXIT(zztasp2);
		}
	}
	e = newECnode;
	require(e!=NULL, "cannot allocate error class node");
	e->lexclass = CurrentLexClass;
	if ( Tnum( (t=StripQuotes(t)) ) == 0 )
	{
		if ( hash_get(Texpr, t) != NULL )
		warn(eMsg1("errclass name conflicts with regular expression  '%s'",t));
		e->tok = addTname( t );
		set_orel(e->tok, &imag_tokens);
		require((p=(TermEntry *)hash_get(Tname, t)) != NULL,
		"hash table mechanism is broken");
		p->classname = 1;	/* entry is errclass name, not token */
		list_add(&eclasses, (char *)e);
	}
	else
	{
	warn(eMsg1("redefinition of errclass or conflict w/token or tokclass '%s'; ignored",t));
	free( e );
	go=0;
}
	zzmatch(87); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==NonTerminal) ) {
			zzmatch(NonTerminal);
			if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
		}
		else {
			if ( (LA(1)==TokenTerm) ) {
				zzmatch(TokenTerm);
				if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
			}
			else {
				if ( (LA(1)==QuotedTerm) ) {
					zzmatch(QuotedTerm);
					if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
				}
				else {zzFAIL(1,zzerr3,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
			}
		}
		zzEXIT(zztasp2);
		}
	}
	if ( go ) list_add(&(e->elist), t);  
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (setwd1[LA(1)]&0x40) ) {
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				if ( (LA(1)==NonTerminal) ) {
					zzmatch(NonTerminal);
					if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
				}
				else {
					if ( (LA(1)==TokenTerm) ) {
						zzmatch(TokenTerm);
						if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
					}
					else {
						if ( (LA(1)==QuotedTerm) ) {
							zzmatch(QuotedTerm);
							if ( go ) t=mystrdup(LATEXT(1));  
 zzCONSUME;
						}
						else {zzFAIL(1,zzerr4,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
					}
				}
				zzEXIT(zztasp3);
				}
			}
			if ( go ) list_add(&(e->elist), t);  
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzmatch(83); zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x80);
	}
}

void
#ifdef __STDC__
tclass(void)
#else
tclass()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	char *t=NULL; TCnode *e; int go=1,tok; TermEntry *p, *term;  
	zzmatch(96); zzCONSUME;
	zzmatch(TokenTerm);
	t=mystrdup(LATEXT(1));  
 zzCONSUME;
	e = newTCnode;
	require(e!=NULL, "cannot allocate token class node");
	e->lexclass = CurrentLexClass;
	if ( Tnum( t ) == 0 )
	{
		e->tok = addTname( t );
		set_orel(e->tok, &imag_tokens);
		require((p=(TermEntry *)hash_get(Tname, t)) != NULL,
		"hash table mechanism is broken");
		p->classname = 1;	/* entry is class name, not token */
		p->tclass = e;		/* save ptr to this tclass def */
		list_add(&tclasses, (char *)e);
	}
	else
	{
	warn(eMsg1("redefinition of tokclass or conflict w/token '%s'; ignored",t));
	free( e );
	go=0;
}
	zzmatch(87); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (setwd2[LA(1)]&0x1) ) {
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				if ( (LA(1)==TokenTerm) ) {
					zzmatch(TokenTerm);
					if ( go ) {
						term = (TermEntry *) hash_get(Tname, LATEXT(1));
						if ( term==NULL && UserDefdTokens ) {
							err("implicit token definition not allowed with #tokdefs");
							go = 0;
						}
						else {t=mystrdup(LATEXT(1)); tok=addTname(LATEXT(1));}
					}  
 zzCONSUME;
				}
				else {
					if ( (LA(1)==QuotedTerm) ) {
						zzmatch(QuotedTerm);
						if ( go ) {
							term = (TermEntry *) hash_get(Texpr, LATEXT(1));
							if ( term==NULL && UserDefdTokens ) {
								err("implicit token definition not allowed with #tokdefs");
								go = 0;
							}
							else {t=mystrdup(LATEXT(1)); tok=addTexpr(LATEXT(1));}
						}  
 zzCONSUME;
					}
					else {zzFAIL(1,zzerr5,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
				}
				zzEXIT(zztasp3);
				}
			}
			if ( go ) list_add(&(e->tlist), t);  
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzmatch(83); zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd2, 0x2);
	}
}

void
#ifdef __STDC__
token(void)
#else
token()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	char *t=NULL, *e=NULL, *a=NULL; int tnum=0;  
	zzmatch(97); zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==TokenTerm) ) {
			zzmatch(TokenTerm);
			t=mystrdup(LATEXT(1));  
 zzCONSUME;
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				if ( (LA(1)==98) ) {
					zzmatch(98); zzCONSUME;
					zzmatch(99);
					tnum = atoi(LATEXT(1));  
 zzCONSUME;
				}
				zzEXIT(zztasp3);
				}
			}
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==QuotedTerm) ) {
			zzmatch(QuotedTerm);
			e=mystrdup(LATEXT(1));  
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==Action) ) {
			zzmatch(Action);
			
			a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
			require(a!=NULL, "rule token: cannot allocate action");
			strcpy(a, LATEXT(1));
 zzCONSUME;
		}
		zzEXIT(zztasp2);
		}
	}
	chkToken(t, e, a, tnum);  
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd2, 0x4);
	}
}

void
#ifdef __STDC__
block( set *toksrefd, set *rulesrefd )
#else
block(toksrefd,rulesrefd)
 set *toksrefd;
set *rulesrefd ;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	
	Graph g, b;
	* toksrefd = empty;
	* rulesrefd = empty;
	set_clr(AST_nodes_refd_in_actions);
	alt( toksrefd,rulesrefd );
	b = g = zzaArg(zztasp1,1);  
	
	if ( ((Junction *)g.left)->p1->ntype == nAction )
	{
		if ( !((ActionNode *)(((Junction *)g.left)->p1))->is_predicate )
		{
			((ActionNode *)(((Junction *)g.left)->p1))->init_action = TRUE;
		}
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (LA(1)==100) ) {
			zzmatch(100); zzCONSUME;
			alt( toksrefd,rulesrefd );
			g = Or(g, zzaArg(zztasp2,2));  
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzaArg(zztasp1,0) = b;  
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd2, 0x8);
	}
}

void
#ifdef __STDC__
alt( set *toksrefd, set *rulesrefd )
#else
alt(toksrefd,rulesrefd)
 set *toksrefd;
set *rulesrefd ;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	int n=0,ne=0; Graph g; int e_num=0, not=0;
	int first_on_line = 1; g.left=g.right=NULL;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		int tok;  
		while ( (setwd2[LA(1)]&0x10) ) {
			tok = LA(1);  
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				not=0;  
				if ( (LA(1)==101) ) {
					zzmatch(101);
					not=1;  
 zzCONSUME;
				}
				zzEXIT(zztasp3);
				}
			}
			element( not, first_on_line );
			if ( tok!=Action && tok!=Pred ) first_on_line = 0;  
			
			if ( zzaArg(zztasp2,2 ).left!=NULL ) {
				g = Cat(g, zzaArg(zztasp2,2));
				n++;
				if ( tok!=Action && tok!=Pred ) e_num++;
				/* record record number of all rule and token refs */
				if ( tok==TokenTerm||tok==QuotedTerm||tok==WildCard ) {
					((TokNode *)((Junction *)zzaArg(zztasp2,2 ).left)->p1)->elnum = e_num;
					set_orel(e_num,  toksrefd);
				}
				else if ( tok==NonTerminal ) {
					((RuleRefNode *)((Junction *)zzaArg(zztasp2,2 ).left)->p1)->elnum = e_num;
					set_orel(e_num,  rulesrefd);
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	if ( n == 0 ) g = emptyAlt();
	zzaArg(zztasp1,0) = g;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd2, 0x20);
	}
}

void
#ifdef __STDC__
element( int not, int first_on_line )
#else
element(not,first_on_line)
 int not;
int first_on_line ;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	
	set toksrefd, rulesrefd;
	TermEntry *term;
	TokNode *p=NULL; RuleRefNode *q; int approx=0;
	if ( (LA(1)==TokenTerm) ) {
		zzmatch(TokenTerm);
		
		term = (TermEntry *) hash_get(Tname, LATEXT(1));
		if ( term==NULL && UserDefdTokens ) {
			err("implicit token definition not allowed with #tokdefs");
			zzaArg(zztasp1,0 ).left = zzaArg(zztasp1,0 ).right = NULL;
		}
		else {
			zzaArg(zztasp1,0) = buildToken(LATEXT(1)); p=((TokNode *)((Junction *)zzaArg(zztasp1,0 ).left)->p1);
			term = (TermEntry *) hash_get(Tname, LATEXT(1));
			require( term!= NULL, "hash table mechanism is broken");
			p->tclass = term->tclass;
			p->complement =  not;
		}
 zzCONSUME;
		{
			zzBLOCK(zztasp2);
			zzMake0;
			{
			if ( (LA(1)==102) ) {
				zzmatch(102); zzCONSUME;
				{
					zzBLOCK(zztasp3);
					zzMake0;
					{
					if ( (LA(1)==QuotedTerm) ) {
						zzmatch(QuotedTerm);
						if ( p!=NULL ) setUpperRange(p, LATEXT(1));  
 zzCONSUME;
					}
					else {
						if ( (LA(1)==TokenTerm) ) {
							zzmatch(TokenTerm);
							if ( p!=NULL ) setUpperRange(p, LATEXT(1));  
 zzCONSUME;
						}
						else {zzFAIL(1,zzerr6,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
					}
					zzEXIT(zztasp3);
					}
				}
			}
			zzEXIT(zztasp2);
			}
		}
		
		if ( p!=NULL && (p->upper_range!=0 || p->tclass ||  not) )
		list_add(&MetaTokenNodes, (void *)p);
		{
			zzBLOCK(zztasp2);
			zzMake0;
			{
			if ( (LA(1)==103) ) {
				zzmatch(103);
				if ( p!=NULL ) p->astnode=ASTroot;  
 zzCONSUME;
			}
			else {
				if ( (setwd2[LA(1)]&0x40) ) {
					if ( p!=NULL ) p->astnode=ASTchild;  
				}
				else {
					if ( (LA(1)==88) ) {
						zzmatch(88);
						if ( p!=NULL ) p->astnode=ASTexclude;  
 zzCONSUME;
					}
					else {zzFAIL(1,zzerr7,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
				}
			}
			zzEXIT(zztasp2);
			}
		}
	}
	else {
		if ( (LA(1)==QuotedTerm) ) {
			zzmatch(QuotedTerm);
			
			term = (TermEntry *) hash_get(Texpr, LATEXT(1));
			if ( term==NULL && UserDefdTokens ) {
				err("implicit token definition not allowed with #tokdefs");
				zzaArg(zztasp1,0 ).left = zzaArg(zztasp1,0 ).right = NULL;
			}
			else {
				zzaArg(zztasp1,0) = buildToken(LATEXT(1)); p=((TokNode *)((Junction *)zzaArg(zztasp1,0 ).left)->p1);
				p->complement =  not;
			}
 zzCONSUME;
			{
				zzBLOCK(zztasp2);
				zzMake0;
				{
				if ( (LA(1)==102) ) {
					zzmatch(102); zzCONSUME;
					{
						zzBLOCK(zztasp3);
						zzMake0;
						{
						if ( (LA(1)==QuotedTerm) ) {
							zzmatch(QuotedTerm);
							if ( p!=NULL ) setUpperRange(p, LATEXT(1));  
 zzCONSUME;
						}
						else {
							if ( (LA(1)==TokenTerm) ) {
								zzmatch(TokenTerm);
								if ( p!=NULL ) setUpperRange(p, LATEXT(1));  
 zzCONSUME;
							}
							else {zzFAIL(1,zzerr8,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
						}
						zzEXIT(zztasp3);
						}
					}
				}
				zzEXIT(zztasp2);
				}
			}
			{
				zzBLOCK(zztasp2);
				zzMake0;
				{
				if ( (LA(1)==103) ) {
					zzmatch(103);
					if ( p!=NULL ) p->astnode=ASTroot;  
 zzCONSUME;
				}
				else {
					if ( (setwd2[LA(1)]&0x80) ) {
						if ( p!=NULL ) p->astnode=ASTchild;  
					}
					else {
						if ( (LA(1)==88) ) {
							zzmatch(88);
							if ( p!=NULL ) p->astnode=ASTexclude;  
 zzCONSUME;
						}
						else {zzFAIL(1,zzerr9,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
					}
				}
				zzEXIT(zztasp2);
				}
			}
			
			if ( p!=NULL && (p->upper_range!=0 || p->tclass ||  not) )
			list_add(&MetaTokenNodes, (void *)p);
		}
		else {
			if ( (LA(1)==WildCard) ) {
				if (  not ) warn("~ WILDCARD is an undefined operation (implies 'nothing')");  
				zzmatch(WildCard);
				zzaArg(zztasp1,0) = buildWildCard(LATEXT(1)); p=((TokNode *)((Junction *)zzaArg(zztasp1,0 ).left)->p1);  
 zzCONSUME;
				{
					zzBLOCK(zztasp2);
					zzMake0;
					{
					if ( (LA(1)==103) ) {
						zzmatch(103);
						p->astnode=ASTroot;  
 zzCONSUME;
					}
					else {
						if ( (setwd3[LA(1)]&0x1) ) {
							p->astnode=ASTchild;  
						}
						else {
							if ( (LA(1)==88) ) {
								zzmatch(88);
								p->astnode=ASTexclude;  
 zzCONSUME;
							}
							else {zzFAIL(1,zzerr10,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
						}
					}
					zzEXIT(zztasp2);
					}
				}
				list_add(&MetaTokenNodes, (void *)p);  
			}
			else {
				if ( (LA(1)==NonTerminal) ) {
					if (  not ) warn("~ NONTERMINAL is an undefined operation");  
					zzmatch(NonTerminal);
					zzaArg(zztasp1,0) = buildRuleRef(LATEXT(1));  
 zzCONSUME;
					{
						zzBLOCK(zztasp2);
						zzMake0;
						{
						if ( (LA(1)==88) ) {
							zzmatch(88);
							q = (RuleRefNode *) ((Junction *)zzaRet.left)->p1;
							q->astnode=ASTexclude;  
 zzCONSUME;
						}
						zzEXIT(zztasp2);
						}
					}
					{
						zzBLOCK(zztasp2);
						zzMake0;
						{
						if ( (setwd3[LA(1)]&0x2) ) {
							{
								zzBLOCK(zztasp3);
								zzMake0;
								{
								if ( (LA(1)==89) ) {
									zzmatch(89); zzCONSUME;
								}
								zzEXIT(zztasp3);
								}
							}
							zzmatch(PassAction);
							addParm(((Junction *)zzaRet.left)->p1, LATEXT(1));  
 zzCONSUME;
						}
						zzEXIT(zztasp2);
						}
					}
					{
						zzBLOCK(zztasp2);
						zzMake0;
						{
						char *a; RuleRefNode *rr=(RuleRefNode *) ((Junction *)zzaRet.left)->p1;
						if ( (LA(1)==90) ) {
							zzmatch(90); zzCONSUME;
							zzmatch(PassAction);
							
							a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
							require(a!=NULL, "rule element: cannot allocate assignment");
							strcpy(a, LATEXT(1));
							rr->assign = a;
 zzCONSUME;
						}
						zzEXIT(zztasp2);
						}
					}
				}
				else {
					if ( (LA(1)==Action) ) {
						if (  not )	warn("~ ACTION is an undefined operation");  
						zzmatch(Action);
						zzaArg(zztasp1,0) = buildAction(LATEXT(1),action_file,action_line, 0);  
 zzCONSUME;
					}
					else {
						if ( (LA(1)==Pred) ) {
							if (  not )	warn("~ SEMANTIC-PREDICATE is an undefined operation");  
							zzmatch(Pred);
							zzaArg(zztasp1,0) = buildAction(LATEXT(1),action_file,action_line, 1);  
 zzCONSUME;
							{
								zzBLOCK(zztasp2);
								zzMake0;
								{
								char *a; ActionNode *act = (ActionNode *) ((Junction *)zzaRet.left)->p1;  
								if ( (LA(1)==PassAction) ) {
									zzmatch(PassAction);
									
									a = (char *) calloc(strlen(LATEXT(1))+1, sizeof(char));
									require(a!=NULL, "rule element: cannot allocate predicate fail action");
									strcpy(a, LATEXT(1));
									act->pred_fail = a;
 zzCONSUME;
								}
								zzEXIT(zztasp2);
								}
							}
							
							if ( DemandLookahead )
							{
								warn("-gk incompatible with <<..>>? predicate usage; -gk turned off");
								DemandLookahead = 0;
							}
						}
						else {
							if ( (setwd3[LA(1)]&0x4) ) {
								if (  not )	warn("~ BLOCK is an undefined operation");  
								BlkLevel++;  
								{
									zzBLOCK(zztasp2);
									zzMake0;
									{
									if ( (LA(1)==104) ) {
										zzmatch(104); zzCONSUME;
										{
											zzBLOCK(zztasp3);
											zzMake0;
											{
											if ( (LA(1)==105) ) {
												zzmatch(105);
												approx=LL_k;  
 zzCONSUME;
											}
											else {
												if ( (LA(1)==106) ) {
													zzmatch(106);
													approx = 1;  
 zzCONSUME;
												}
												else {
													if ( (LA(1)==107) ) {
														zzmatch(107);
														approx = 2;  
 zzCONSUME;
													}
													else {zzFAIL(1,zzerr11,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
												}
											}
											zzEXIT(zztasp3);
											}
										}
									}
									zzEXIT(zztasp2);
									}
								}
								{
									zzBLOCK(zztasp2);
									zzMake0;
									{
									if ( (LA(1)==108) ) {
										zzmatch(108); zzCONSUME;
										block( &toksrefd,&rulesrefd );
										zzaRet = zzaArg(zztasp2,2); --BlkLevel;  
										zzmatch(109); zzCONSUME;
										{
											zzBLOCK(zztasp3);
											zzMake0;
											{
											if ( (LA(1)==110) ) {
												zzmatch(110);
												zzaRet = makeLoop(zzaRet,approx);  
 zzCONSUME;
											}
											else {
												if ( (LA(1)==111) ) {
													zzmatch(111);
													zzaRet = makePlus(zzaRet,approx);  
 zzCONSUME;
												}
												else {
													if ( (LA(1)==112) ) {
														zzmatch(112);
														zzaRet = makeBlk(zzaRet,approx);
														FoundGuessBlk = 1;
														((Junction *) ((Junction *)zzaRet.left)->p1)->guess=1;
														if ( ! first_on_line ) {
															err("(...)? predicate must be first element of production");
														}
 zzCONSUME;
													}
													else {
														if ( (setwd3[LA(1)]&0x8) ) {
															zzaRet = makeBlk(zzaRet,approx);  
														}
														else {zzFAIL(1,zzerr12,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
													}
												}
											}
											zzEXIT(zztasp3);
											}
										}
										
										((Junction *)((Junction *)zzaRet.left)->p1)->tokrefs = toksrefd;
										((Junction *)((Junction *)zzaRet.left)->p1)->rulerefs = rulesrefd;
										{
											zzBLOCK(zztasp3);
											zzMake0;
											{
											if ( (LA(1)==PassAction) ) {
												zzmatch(PassAction);
												addParm(((Junction *)zzaRet.left)->p1, LATEXT(1));  
 zzCONSUME;
											}
											zzEXIT(zztasp3);
											}
										}
									}
									else {
										if ( (LA(1)==87) ) {
											zzmatch(87); zzCONSUME;
											block( &toksrefd,&rulesrefd );
											zzaRet = makeOpt(zzaArg(zztasp2,2),approx); --BlkLevel;  
											zzmatch(83);
											
											((Junction *)((Junction *)zzaRet.left)->p1)->tokrefs = toksrefd;
											((Junction *)((Junction *)zzaRet.left)->p1)->rulerefs = rulesrefd;
 zzCONSUME;
											{
												zzBLOCK(zztasp3);
												zzMake0;
												{
												if ( (LA(1)==PassAction) ) {
													zzmatch(PassAction);
													addParm(((Junction *)zzaRet.left)->p1, LATEXT(1));  
 zzCONSUME;
												}
												zzEXIT(zztasp3);
												}
											}
										}
										else {zzFAIL(1,zzerr13,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
									}
									zzEXIT(zztasp2);
									}
								}
							}
							else {
								if ( (LA(1)==91) ) {
									zzmatch(91);
									warn(eMsg1("missing ';' on rule %s", CurRule));
									CannotContinue=TRUE;  
 zzCONSUME;
								}
								else {
									if ( (LA(1)==110) ) {
										zzmatch(110);
										warn("don't you want a ')' with that '*'?"); CannotContinue=TRUE;  
 zzCONSUME;
									}
									else {
										if ( (LA(1)==111) ) {
											zzmatch(111);
											warn("don't you want a ')' with that '+'?"); CannotContinue=TRUE;  
 zzCONSUME;
										}
										else {
											if ( (LA(1)==90) ) {
												zzmatch(90);
												warn("'>' can only appear after a nonterminal"); CannotContinue=TRUE;  
 zzCONSUME;
											}
											else {
												if ( (LA(1)==PassAction) ) {
													zzmatch(PassAction);
													warn("[...] out of context 'rule > [...]'");
													CannotContinue=TRUE;  
 zzCONSUME;
												}
												else {zzFAIL(1,zzerr14,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	CannotContinue=TRUE;  
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd3, 0x10);
	}
}

void
#ifdef __STDC__
enum_file(void)
#else
enum_file()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	if ( (setwd3[LA(1)]&0x20) ) {
		{
			zzBLOCK(zztasp2);
			zzMake0;
			{
			while ( (LA(1)==121) ) {
				enum_def();
				zzLOOP(zztasp2);
			}
			zzEXIT(zztasp2);
			}
		}
	}
	else {
		if ( (setwd3[LA(1)]&0x40) ) {
			defines();
		}
		else {zzFAIL(1,zzerr15,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd3, 0x80);
	}
}

void
#ifdef __STDC__
defines(void)
#else
defines()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	int v,maxt= -1; char *t;  
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (LA(1)==118) ) {
			zzmatch(118); zzCONSUME;
			zzmatch(ID);
			t = mystrdup(LATEXT(1));  
 zzCONSUME;
			zzmatch(INT);
			
			v = atoi(LATEXT(1));
			/*			fprintf(stderr, "#token %s=%d\n", t, v); */
			TokenNum = v;
			if ( v>maxt ) maxt=v;
			if ( Tnum( t ) == 0 ) addForcedTname( t, v );
			else {
				warn(eMsg1("redefinition of token %s; ignored",t));
			}
 zzCONSUME;
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	TokenNum = maxt + 1;  
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd4, 0x1);
	}
}

void
#ifdef __STDC__
enum_def(void)
#else
enum_def()
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	int v= -1; char *t;  
	zzmatch(121); zzCONSUME;
	zzmatch(ID); zzCONSUME;
	zzmatch(122); zzCONSUME;
	zzmatch(ID);
	t = mystrdup(LATEXT(1));  
 zzCONSUME;
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		if ( (LA(1)==123) ) {
			zzmatch(123); zzCONSUME;
			zzmatch(INT);
			v=atoi(LATEXT(1));  
 zzCONSUME;
		}
		else {
			if ( (setwd4[LA(1)]&0x2) ) {
				v++;  
			}
			else {zzFAIL(1,zzerr16,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
		}
		zzEXIT(zztasp2);
		}
	}
	
	/*			fprintf(stderr, "#token %s=%d\n", t, v);*/
	TokenNum = v;
	if ( Tnum( t ) == 0 ) addForcedTname( t, v );
	else {
		warn(eMsg1("redefinition of token %s; ignored",t));
	}
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (LA(1)==124) ) {
			zzmatch(124); zzCONSUME;
			{
				zzBLOCK(zztasp3);
				zzMake0;
				{
				if ( (LA(1)==ID) ) {
					zzmatch(ID);
					t = mystrdup(LATEXT(1));  
 zzCONSUME;
					{
						zzBLOCK(zztasp4);
						zzMake0;
						{
						if ( (LA(1)==123) ) {
							zzmatch(123); zzCONSUME;
							zzmatch(INT);
							v=atoi(LATEXT(1));  
 zzCONSUME;
						}
						else {
							if ( (setwd4[LA(1)]&0x4) ) {
								v++;  
							}
							else {zzFAIL(1,zzerr17,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
						}
						zzEXIT(zztasp4);
						}
					}
					
					/*					fprintf(stderr, "#token %s=%d\n", t, v);*/
					TokenNum = v;
					if ( Tnum( t ) == 0 ) addForcedTname( t, v );
					else {
						warn(eMsg1("redefinition of token %s; ignored",t));
					}
				}
				zzEXIT(zztasp3);
				}
			}
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzmatch(125); zzCONSUME;
	zzmatch(126);
	TokenNum++;  
 zzCONSUME;
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd4, 0x8);
	}
}

/* semantics of #token */
static void
#ifdef __STDC__
chkToken(char *t, char *e, char *a, int tnum)
#else
chkToken(t,e,a,tnum)
char *t, *e, *a;
int tnum;
#endif
{
	TermEntry *p;
	
	/* check to see that they don't try to redefine a token as a token class */
	if ( t!=NULL ) {
	p = (TermEntry *) hash_get(Tname, t);
	if ( p!=NULL && p->classname ) {
	err(eMsg1("redefinition of #tokclass '%s' to #token not allowed; ignored",t));
	if ( a!=NULL ) free(a);
	return;
}
}

	if ( t==NULL && e==NULL ) {			/* none found */
err("#token requires at least token name or rexpr");
}
else if ( t!=NULL && e!=NULL ) {	/* both found */
if ( UserDefdTokens ) {			/* if #tokdefs, must not define new */
p = (TermEntry *) hash_get(Tname, t);
if ( p==NULL ) {
err(eMsg1("#token definition '%s' not allowed with #tokdefs; ignored",t));
return;
}
}
Tklink(t, e);
if ( a!=NULL ) {
if ( hasAction(e) ) {
err(eMsg1("redefinition of action for %s; ignored",e));
}
else setHasAction(e, a);
}
}
else if ( t!=NULL ) {				/* only one found */
if ( UserDefdTokens ) {
err(eMsg1("#token definition '%s' not allowed with #tokdefs; ignored",t));
return;
}
if ( Tnum( t ) == 0 ) addTname( t );
else {
err(eMsg1("redefinition of token %s; ignored",t));
}
if ( a!=NULL ) {
err(eMsg1("action cannot be attached to a token name (%s); ignored",t));
free(a);
}
}
else if ( e!=NULL ) {
if ( Tnum( e ) == 0 ) addTexpr( e );
else {
if ( hasAction(e) ) {
err(eMsg1("redefinition of action for expr %s; ignored",e));
}
else if ( a==NULL ) {
err(eMsg1("redefinition of expr %s; ignored",e));
}
}
if ( a!=NULL ) setHasAction(e, a);
}

	/* if a token type number was specified, then add the token ID and 'tnum'
* pair to the ForcedTokens list.  (only applies if an id was given)
*/
if ( t!=NULL && tnum>0 )
{
if ( set_el(tnum, reserved_positions) )
{
err(eMsgd("a token has already been forced to token number %d; ignored", tnum));
}
else
{
list_add(&ForcedTokens, newForcedToken(t,tnum));
set_orel(tnum, &reserved_positions);
}
}
}

/* ANTLR-specific syntax error message generator 
* (define USER_ZZSYN when compiling so don't get 2 definitions)
*/
void
#ifdef __STDC__
zzsyn(char *text, int tok, char *egroup, SetWordType *eset, int etok, int k, char *bad_text)
#else
zzsyn(text, tok, egroup, eset, etok, k, bad_text)
char *text, *egroup, *bad_text;
int tok;
int etok;
int k;
SetWordType *eset;
#endif
{
fprintf(stderr, ErrHdr, FileStr[CurFile]!=NULL?FileStr[CurFile]:"stdin", zzline);
fprintf(stderr, " syntax error at \"%s\"", (tok==zzEOF_TOKEN)?"EOF":text);
if ( !etok && !eset ) {fprintf(stderr, "\n"); return;}
if ( k==1 ) fprintf(stderr, " missing");
else
{
fprintf(stderr, "; \"%s\" not", bad_text);
if ( zzset_deg(eset)>1 ) fprintf(stderr, " in");
}
if ( zzset_deg(eset)>0 ) zzedecode(eset);
else fprintf(stderr, " %s", zztokens[etok]);
if ( strlen(egroup) > 0 ) fprintf(stderr, " in %s", egroup);
fprintf(stderr, "\n");
}
