         How to port PCCTS 1.10 (and 1.20 hopefully) to Visual C++

                                   By

                       John Hall <jhall@ivy.wpi.edu>

Here is how to compile an ANTLR grammar in Visual C++.  These steps
describe how to have your ANTLR grammar parse the input file the user
selects when they choose File Open in your Windows application.  (Even
if you aren't using Visual C++, the steps should be portable enough to
other compilers.)

 * Make sure that ANTLR and DLG generate ANSI code (use the -ga
   switch).

 * Set the following compiler flags in Visual C++ (these are in the
   Memory Model category of the compiler options in the Project
   Options menu):

   FLAG MEANING
   ==== ==============================================================
   /AL	Large memory model (multiple data segments; data items must be
	smaller than 64K).

   /Gtn	Allocates all items whose size is greater than or equal to n
	in a new data segment.  (I let n be 256: /Gt256.)

   /Gx-	All references to data items are done with far addressing in
	case they are placed in a far segment.

 * Add the following member variable to the attributes section of your
   derived CDocument class (you will need to make sure you also
   include stdio.h):

   FILE *fp;

 * Add the following method to your derived CDocument class:

   BOOL CAppDoc::OnOpenDocument(const char* pszPathName)
   {
       // Call CDocument's OnOpenDocument to do housekeeping for us
       // DON'T add anything to the loading section of Serialize
       if (!CDocument::OnOpenDocument(pszPathName))
           return FALSE;
   
       // Open input file
       if ((fp = fopen(pszPathName, "r")) == NULL)
           return FALSE;
   
       // Parse input file
       ANTLR(start(), fp);
   
       // Close input file
       fclose(fp);
       return TRUE;
   }

   (Note: additional code may be necessary, depending on your parser.
   For example, if your parser uses PCCTS's symbol table library, you
   will need to insert calls to zzs_init and zzs_done.)

 * Compile the generated C files as C++ files.  (I renamed the files
   to have a .CPP extension to fool Visual C++ into thinking they were
   C++ files.  One might also use the /Tp switch, but that switch
   requires you separately include the filename.)  [I used this step
   as an easy out for all the external linking errors I was getting
   that I couldn't fix by declaring things extern "C".]

 * Make sure the __STDC__ portion of the generated files gets
   compiled.  (Either define __STDC__ yourself or else change all
   occurrences of __STDC__ to __cplusplus in the generated files.  You
   can define __STDC__ in the Preprocessor category of the compiler
   options.)

That last step is important for Visual C++, but may not apply to other
compilers.  For C++ compilers, whether __STDC__ is defined is
implementation dependent (ARM, page 379).  Apparently, Visual C++ does
not to define it; it also does not support "old style" C function
definitions (which is okay, according to page 404 of the ARM).  Those
two things together caused problems when trying to port the code.
When it saw this:

#ifdef __STDC__
void
globals(AST **_root)
#else
globals(_root)
AST **_root;
#endif

it skipped the __STDC__ section and tried to process the "old style"
function definition, where it choked.

When you finally get your parser to compile and link without error,
you may get General Protection Fault errors at run time.  The problem
I had was that a NULL was passed to a variable argument function
without an explicit cast.  The function grabbed a pointer (32-bits)
off the stack using va_arg, but the NULL was passed silently as the
integer 0 (16 bits), making the resulting pointer was invalid.  (This
was in PCCTS's sample C parser.)

There is one other thing I might suggest to help you avoid a run-time
error.  Make sure you redefine the default error reporting function,
zzsyn.  To do this, put "#define USER_ZZSYN" in your #header section
and put your own zzsyn somewhere.  You can then pop up a MessageBox or
print the error to some output window.

