// PMGRAPH.CPP - contains support functions for PM graphics

#define  INCL_PM
#include <os2.h>
#include <string.h>

VOID Line(HPS hps,int xstart,int ystart,int xend,int yend,long color)
{
    POINTL currpos,oppos;

    currpos.x=xstart;
    currpos.y=ystart;
    GpiMove(hps,&currpos);
    oppos.x=xend;
    oppos.y=yend;
    GpiSetColor(hps,color);
    GpiLine(hps,&oppos);
}

VOID Box(HPS hps,int xstart,int ystart,int xend,int yend,long color)
{
    POINTL currpos,oppos;

    currpos.x=xstart;
    currpos.y=ystart;
    GpiMove(hps,&currpos);
    oppos.x=xend;
    oppos.y=yend;
    GpiSetColor(hps,color);
    GpiBox(hps,DRO_OUTLINEFILL,&oppos,0L,0L);
}

VOID Text(HPS hps,int xstart,int ystart,char *string,long backcolor,long forecolor)
{
    POINTL ptlText;

    ptlText.x   = xstart;
    ptlText.y   = ystart;
    GpiSetBackColor(hps,backcolor);
    GpiSetColor(hps,forecolor);
    GpiCharStringAt(hps,&ptlText,strlen(string),string);

}

VOID Point(HPS hps,int x,int y,long color)
{
    POINTL ptlPoint;

    ptlPoint.x   = x;
    ptlPoint.y   = y;
    GpiSetColor(hps,color);
    GpiSetPel(hps,&ptlPoint);
}

