//=======================================================================
//  PALETTE.CPP - Sample PM Sphere mapper
//=======================================================================

#define INCL_BASE
#define INCL_PM

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Include identifiers used in SPRITE.RC file (resources)
#include "palette.h"
#include "pmgraph.h"

// Turn off parameter not used warning in Borland C++
#pragma warn -par
#pragma warn -rch

// Flags
int FirstDraw=1;

// Color tables
LONG lColorsIdx[512];
int lColorsIdxCnt;

LONG lColorsRGB[256];
int lColorsRGBCnt;

// Window Dimensions (setup in WM_PAINT)
HPS     hps;
HDC     hdc;
SWP     swp;
RECTL   rcl;
RECTL   rclSize;
RECTL   rclsave;

POINTL  currpos,oppos;

//--------------------------------------------------------------
//  Global variables
//--------------------------------------------------------------

HWND hwndMain=0L,                    // Handle to the main frame window
     hwndClient;                     // Handle to the main client window
CHAR szAppName[MAXNAMEL] = "PALETTE"; // Buffer for application name string
HMQ  hmq;                            // Handle to the process' message queue
HAB  hab;                            // Handle to the anchor block
QMSG qmsg;                           // Queue message holder
HPAL hpal;

POINTL ptlMouse;                     // Mouse pointer location
POINTL ptlMouseClick;                // Location of mouse when button 1 pressed

//--------------------------------------------------------------
//  Entry point declarations
//--------------------------------------------------------------

MRESULT EXPENTRY _export MainWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY _export CameraDialogProc(HWND, ULONG, MPARAM, MPARAM);
HDC WinGetDC(HWND);
VOID SetupPalette(HWND,HPS);
VOID RestorePalette(HWND,HPS);
VOID DoMenuCommand(HWND,USHORT);
VOID PaintScreen(HWND,HPS);

// Start of program source

INT main(int argc, char *argv[])
{
    ULONG    flCtlData;                        /* Frame control data */
    LONG     sHold;
    int      i;

    // Set initial values for application

    // Set the main frame window creation flags

    flCtlData =
        FCF_TITLEBAR         |   // Title bar
        FCF_SIZEBORDER       |   // Size Border
        FCF_MINMAX           |   // Minimize Maximize Buttons
        FCF_SYSMENU          |   // System menu
        FCF_ICON             |   // Specify an ICON (POINTER) resource
                                 // is being provided
        FCF_MENU             |   // Specify a MENU is being provided
//        FCF_SHELLPOSITION    |   // System default size and position
        FCF_TASKLIST ;           // Add name to task list

    // Initialize the application for PM
        hab = WinInitialize(0L);

    // Create the application message queue
        hmq = WinCreateMsgQueue(hab, 0L);

    // register the class for the client window.  The main thing that
    // happens here is passing the pointer to the function which will
    // serve as the window procedure: MainWndProc

    WinRegisterClass(
        hab,                 // Anchor block handle
        (PSZ)szAppName,      // Name of class being registered
        (PFNWP)MainWndProc,  // Window Procedure function pointer
        CS_SIZEREDRAW |      // Class style
        CS_CLIPCHILDREN,     // Class style
        0L);                 // Extra bytes to reserve


    // Create a top-level frame window with a client window that
    // belongs to the window class - szAppName = 'palette'
    // The window is "top level" due to indicating its parent is
    // the PM desktop (HWND_DESKTOP).

    hwndMain = WinCreateStdWindow(
                   HWND_DESKTOP,        // Parent is desktop window
                   WS_VISIBLE,          // Make window frame visible
                   &flCtlData,          // Pointer to frame control style
                   szAppName,           // Name of client class
                   "Palette Play",       // Window Title
                   WS_VISIBLE,          // Make Client Window Visible
                   (HMODULE)0L,         // Resources are in executable
                                        // vs. dynamically loaded
                   ID_RESOURCE,         // Resource/Window identifier
                   (PHWND)&hwndClient); // Pointer to client window

    // Get size of desktop window
    WinQueryWindowPos(HWND_DESKTOP,(PSWP)&swp);

    // Size Window "squarish" within Desktop area

    rclSize.xLeft   = 10;
    rclSize.yBottom = 10;
    rclSize.yTop    = swp.cy - 100;
    rclSize.xRight  = rclSize.yTop;

    WinSetWindowPos(hwndMain,HWND_TOP,rclSize.xLeft,rclSize.yBottom,
                    rclSize.xRight,rclSize.yTop,
                    SWP_ACTIVATE| SWP_SIZE | SWP_MOVE);

     // Get/Dispatch Message loop
    while(WinGetMsg(hab,(PQMSG)&qmsg, 0L, 0L, 0L))
    {
        WinDispatchMsg(hab, (PQMSG)&qmsg);
    }


    return(0);

}

MRESULT EXPENTRY _export MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    CHAR    szMsg[80];      // Sprintf buffer
    MRESULT sRC;
    LONG    i;
    SIZEL   sizl = {0,0};    // Use same size as device

    switch(msg)
    {
        case WM_CREATE:

            hdc = WinGetDC(hwnd);
            hps = GpiCreatePS(hab,hdc,&sizl,PU_PELS|GPIT_MICRO|GPIA_ASSOC);
            break;

        case WM_PAINT:

            if (FirstDraw)
            {
                FirstDraw=0;
                SetupPalette(hwnd,hps);
            }

            // Begin painting
            WinBeginPaint(hwnd,hps,&rcl);

            // Get Dimensions of window to be used when window is redrawn.
            WinQueryWindowRect(hwnd,&rcl);

            // Fill client background with BLACK
            WinFillRect(hps,&rcl,CLR_BLACK);

            PaintScreen(hwnd,hps);

            // End paint
            WinEndPaint(hps);
            break;

        case WM_COMMAND:
            DoMenuCommand(hwnd,(USHORT)SHORT1FROMMP(mp1));
            break;

        case WM_CHAR:

            // Only process key presses - not key releasesups

            if (CHARMSG(&msg)->fs & KC_KEYUP)
                break;

            if (CHARMSG(&msg)->fs & KC_VIRTUALKEY)
            {
                if (CHARMSG(&msg)->fs & KC_SHIFT)
                {
                    switch (CHARMSG(&msg)->vkey)
                    {
                        case VK_UP:
                            break;
                        case VK_DOWN:
                            break;
                    }
                }
                else
                {
                    switch (CHARMSG(&msg)->vkey)
                    {
                        case VK_UP:
                            break;
                        case VK_DOWN:
                            break;
                        case VK_LEFT:
                            break;
                        case VK_RIGHT:
                            break;
                    }
                }
            }
            break;

        case WM_BUTTON1DOWN:

            ptlMouseClick.x = (LONG) SHORT1FROMMP(mp1);
            ptlMouseClick.y = (LONG) SHORT2FROMMP(mp1);

            // Pass Mouse Click for default window procedure
            sRC = WinDefWindowProc(hwnd, msg, mp1, mp2);
            return sRC;
            break;

        case WM_BUTTON2DOWN:

            ptlMouseClick.x = (LONG) SHORT1FROMMP(mp1);
            ptlMouseClick.y = (LONG) SHORT2FROMMP(mp1);

            // Pass Mouse Click for default window procedure
            sRC = WinDefWindowProc(hwnd, msg, mp1, mp2);
            return sRC;
            break;

        case WM_CLOSE:

            RestorePalette(hwnd,hps);

        default:
            // Pass unprocessed message types to default window procedure
            sRC = WinDefWindowProc(hwnd, msg, mp1, mp2);
            return sRC;
    }
    return (MRESULT)0L;
}

VOID DoMenuCommand(HWND hwnd, USHORT cm)
{
    switch (cm)
    {
        case IDM_DRAW:
            break;

        default:
            break;
    }
}

VOID PaintScreen(HWND hwnd,HPS hps)
{

    int i;
    int clr;
    POINTL ptl;

    // Draw using current color table
    for (i=0;i<256;i++)
    {
        Line(hps,0,0+i,100,0+i,i);
    }

    // Pick up pixel colors from the screen and use to draw another set
    // of lines - if they look like the original lines, the
    // palettes are correctly synchronized.

    for (i=0;i<256;i++)
    {
        ptl.x = 0;
        ptl.y = i;
        clr = GpiQueryPel(hps,&ptl);
        Line(hps,101,0+i,201,0+i,clr);
    }

}

VOID SetupPalette(HWND hwnd,HPS hps)
{
    int i;
    unsigned char red   = 0;
    unsigned char green = 0;
    unsigned char blue  = 0;
    ULONG cclr;

    // Create indexed and RGB form of color tables

    // Obtain the first 16 default colors
    GpiQueryLogColorTable(hps,LCOLOPT_INDEX,0,16*2,lColorsIdx);

    lColorsIdxCnt = 16;

    // Fill in remaining 240 entries with a continuous blue value.
    // At this point we can really fill the palette with any colors
    // we choose.  This is just an example.

    for (i=16;i<256;i++)
    {
        lColorsIdx[i*2] = i;
        lColorsIdx[(i*2)+1] = (0<<32)+(red<<16)+(green<<8)+(blue+i);
        lColorsIdxCnt++;
    }

    lColorsRGBCnt = lColorsIdxCnt;

    for (i=0;i<256;i++)
    {
        lColorsRGB[i] = lColorsIdx[(i*2)+1];
    }

    // Create palette (must use RGB type color table for this)
    hpal = GpiCreatePalette(hab,LCOL_OVERRIDE_DEFAULT_COLORS,LCOLF_CONSECRGB,
        lColorsRGBCnt,(PULONG)lColorsRGB);

    // Select new palette into presentation space
    GpiSelectPalette(hps,hpal);

    // Request current palette be applied to physical device palette
    WinRealizePalette(hwnd,hps,&cclr);

    // Create logical color table using indexed color table
    GpiCreateLogColorTable(hps,0L,LCOLF_INDRGB,0L,
        lColorsIdxCnt*2,lColorsIdx);
}

VOID RestorePalette(HWND hwnd,HPS hps)
{
    ULONG cclr;

    // Deselect Palette from PS
    GpiSelectPalette(hps,NULLHANDLE);

    // Restore physical palette
    WinRealizePalette(hwnd,hps,&cclr);
}

HDC WinGetDC(HWND hwnd)
{
    HDC hdc;
    if (!(hdc = WinQueryWindowDC(hwnd)))
        hdc = WinOpenWindowDC(hwnd);

    return hdc;
}







