/************************************************************************

	IBM Packed Decimal Conversion Demo Program
	copyright (c) 1994 Iambic Software, all rights reserved

*************************************************************************/
#include "pd.h"
#include <stdio.h>
#include <mem.h>
static void HexDump ( unsigned char * source, unsigned char * hex, short len );
void main(void)
{
	unsigned char p[6]= "\x00\x12\x34\x56\x78\x9d"; /* packed test numb */
	unsigned char p2[8];                            /* target packed numb */
	long lBin;                                      /* work number */
	short int iRc;                                  /* return code */
	unsigned char hex[17];                          /* hex version of numb */
	unsigned char *FirstSig;                                                                /* pointer to sig byte */
	unsigned char mask1[8] = " \x10\x10,\x10\x10\x10";       /* mask 1 */
	unsigned char pnum1[3] = "\x23\x00\x0c";                                                /* pack number 1 */
	unsigned char mask2[13] = "\x20\x10\x10\x10\x10,\x10\x10\x10.\x10\x10";
	unsigned char pnum2[5] = "\x01\x53\x23\x72\x5c";
	unsigned char mask3[16] = "$\x10,\x10\x10\x10,\x10\x10\x10.\x10\x10" "CR";
	unsigned char work16[16];                                                               /* work for edit */
	unsigned char pnum3[5] = "\x00\x00\x00\x23\x2d";
	printf(" Packed Decimal in C Demo \n\n");
	iRc=sPackedToBin( p, &lBin, sizeof(p));   /* convert to Binary */
	if ( iRc )                           /* always check return code */
	{
		printf("Conversion failed rc=%d\n",iRc);
		return;
	}
	HexDump( p, hex, sizeof(p));
	printf("packed number = 0x%s\nbinary= %ld\n", hex, lBin);
	sBinToPacked( p2, &lBin );                 /*  convert to Decimal */
	HexDump( p2, hex, sizeof(p2));
	printf("packed number from binary one = 0x%s\n", hex);
	printf("\n Example of overflow\n\n");
	lBin=3231231231l;             /* this constant is really negative */
	sBinToPacked( p2, &lBin );    /* convert to packed */
	HexDump( p2, hex, sizeof(p2));
	printf("overflow number= %s\n", hex);
	printf("\n\nDemo of bonus program:  edit and mark\n\n");
	iRc = sEdMk( mask1, sizeof( mask1), pnum1, &FirstSig);
	if ( iRc == 4 )
	{
		printf("Data execption, pnum1\n");
		return;
	}
	printf(" 23000 edited is: %s\n", mask1);
	iRc = sEdMk( mask2, sizeof( mask2), pnum2, &FirstSig);
	if ( iRc == 4 )
	{
		printf("Data execption, pnum2\n");
		return;
	}
	*FirstSig = '$';
	printf(" 153237.25 edited is: %s\n", mask2);
	memcpy(work16, mask3, sizeof(work16) );                         /* move mask to work */
	iRc = sEdMk( work16, sizeof( mask3), pnum3, &FirstSig); /* edit number */
	if ( iRc == 4 )
	{
		printf("Data execption, pnum3\n");
		return;
	}
	printf(" -2.32 edited is: %s\n", work16);
}

/* -----------------------------------------------------------------------

	 debugging routine
	 display number in hex

*/


static void HexDump ( unsigned char * source, unsigned char * hex, short len )
{
   short iI;
	/*  len is length of source, hex should be twice as long  plus 1*/
   for ( iI = 1; iI <= len; iI++ )
	{
		sprintf( hex, "%02X", *source );
		hex += 2;
		source++;
	}
	*hex = 0;                     /* end string */

}


