/* 
	oxcc.h -- header file for Oxbow C compiler

	Copyright (c) 1995
	Norman D. Culver dba
	Oxbow Software
	1323 S.E. 17th Street #662
	Ft. Lauderdale, FL 33316
	(305) 527-1663 Voice
	(305) 760-7584 Fax
	(305) 760-4679 Data
	ndc@fhd486.harvard.edu
	norman.culver@channel1.com
	All rights reserved.

 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by Norman D. Culver dba Oxbow Software''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*/
#ifdef __cplusplus
extern "C" {
#endif

/* debug bits */
#define dA	(0x00000001)	/* DEBUG_STRUCT_ELEMS */
#define dB	(0x00000002)	/* DEBUG_ASSIGNMENT */
#define dC	(0x00000004)	/* DEBUG_GETVAL */
#define dD	(0x00000008)	/* DEBUG_ABSOLUTE_ADDR */
#define dE	(0x00000010)	/* DEBUG_POINTER_BUMPS */
#define dF	(0x00000020)	/* DEBUG_INITTED */
#define dG	(0x00000040)	/* DEBUG_SHADOW */
#define dH	(0x00000080)	/* DEBUG_CAST */
#define dI	(0x00000100)	/* DEBUG_CMS */
#define dJ	(0x00000200)	/* DEBUG_DEREF */
#define dK	(0x00000400)	/* DEBUG_SETJMP */
#define dL	(0x00000800)	/* DEBUG_CALLBACKS */
#define dM	(0x00001000)	/* DEBUG_GROSS */
#define dN	(0x00002000)	/* DEBUG_BLOB */
#define dO	(0x00004000)	/* DEBUG_RINITS */
#define dP	(0x00008000)	/* DEBUG_RUNSTACK */
#define dQ	(0x00010000)	/* DEBUG_STMT_TRACE */
#define dR	(0x00020000)	/* DEBUG_RUNCALLS */
#define dS	(0x00040000)	/* DEBUG_PURGE */
#define dT	(0x00080000)
#define dU	(0x00100000)
#define dV	(0x00200000)
#define dW	(0x00400000)
#define dX	(0x00800000)
#define dY	(0x01000000)
#define dZ	(0x02000000)

/* NAME SPACES -- in the main symbol table */
#define DATASPACE 0
#define TAGSPACE 1
#define MEMBERSPACE 2
#define GOTOSPACE 3
#define USEDSPACE 4
#define LOCALSPACE 5
#define KEEPERSPACE 6
#define SUSPACE0 7
#define SUSPACE1 8
#define BSSPACE 9
#define INITSPACE 10
#define SEGSPACE 11

/* STRUCTURE FOR OPTIONS SETTING -- 16 bytes */
typedef struct _oxccopts {
	char code_format;
	char target_hardware;
	char target_debugger;
	char target_os;
	char memory_model;
	char obj_format;
	char target_assembler;
	char runcode;
	char fastmode;
	char quiet;
	char warn_addr;
	char ansi_mode;
	char shroud;
	char listing_wanted;
	char unused[2];
	char asciz;		/* should be zero to imitate a string */
} OXCCOPTS;

/* callable functions */
#ifndef __OXCCFUNCSH__
#define __OXCCFUNCSH__
extern void oxcc_proc_syms(void *iv, unsigned namespace, void (*func)());
/* func(AsTP node, int symb, void *container) */

extern void oxcc_proc_ptr_info(void *iv, void (*func)());
/* func(void *addr, void *mino, void *maxo) */

extern void oxcc_proc_mallocs(void *iv, void (*func)());
/* func(void *loc, int size, DATUM *ip) */

extern int oxcc(int argc, char **argv);
extern void *oxcc_get_pg(void *iv);
extern void oxcc_debug(void *iv, int flags);
extern void oxcc_enable_trace(void *iv);
extern void oxcc_disable_trace(void *iv);

extern void *oxcc_open_instance(void);
extern void oxcc_set_options(void *iv, char *opts);
extern int oxcc_preproc_file(void *iv, void *is, void *os, void *es,
								int argc, char **argv);
extern int oxcc_parse_file(void *iv, void *is, void *es, char *filename);
extern void oxcc_print_parse_errors(void *iv, void *es);
extern int oxcc_check_ast_tree(void *iv, void *es, char *filename);
extern int oxcc_init_outers(void *iv, void *es);
extern int oxcc_run_tree(void *iv, void *es, char *filename, 
								char *argstring, char *startfunc);
extern int oxcc_gen_code(void *iv, void *es, char *filename, void *os);
extern void oxcc_cleanup_parse(void *iv);
extern void oxcc_close_codefile(void *iv);
extern void oxcc_close_instance(void *iv);

extern void oxcc_print_ast(void *iv, void *os, int flag);
extern void *oxcc_get_ast_root(void *iv);
extern int oxcc_eval_expr(void *iv, void *buf, double *result, void *es);
extern void *__builtin_iv(void);
extern void *__builtin_pg(void);
#endif /* __OXCCFUNCSH__ */

#ifndef __OXCCCLASS__
#define __OXCCCLASS__
extern void gSetup(void *self, void *str);
extern int gPreProc(void *self, void *is, void *os, void *es, int argc, char **argv);
extern int gParse(void *self, void *is, void *es, char *filename);
extern void gPerror(void *self, void *es);
extern int gCheckTree(void *self, void *es, char *filename);
extern int gInitOuters(void *self, void *es);
extern int gRunCode(void *self, void *es, char *filename, char *args);
extern int gGenCode(void *self, void *es, void *os, char *filename);
extern void gCleanup(void *self);
extern void gCloseCode(void *self);
extern void gPrtAst(void *self, void *es, int flag);
extern void *gGetRoot(void *self);
extern int gEval(void *self, void *buf, double *result, void *es);
#endif /* __OXCCCLASS__

#ifdef __cplusplus
}
#endif

