extproc ksh .\/mkbuiltins.cmd 
shift 
#Generated by makefile.os2. Do not edit! 


if test $# -ne 2; then
  echo "usage: mkbuiltins f1 f2" 1>&2
  exit 1
fi

DEF_FILES=`cat $1`
VAR_FILES=`cat $2`

if test -z "$DEF_FILES"; then
  echo "mkbuiltins: DEF_FILES is empty!" 1>&2
  exit 1
fi

if test -z "$VAR_FILES"; then
  echo "mkbuiltins: VAR_FILES is empty!" 1>&2
  exit 1
fi

cat << \EOF
// DO NOT EDIT!  Generated automatically by mkbuiltins.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "defun.h"
#include "oct-obj.h"
#include "variables.h"

EOF

for file in $DEF_FILES; do
  fcn=`echo $file | sed 's,^\./,,; s/\.df//; s/-/_/g'`
  echo "static void"
  echo "install_${fcn##*/}_fcns (void)"
  echo "{"
  cat $file
  echo "}"
  echo ""
done

for file in $VAR_FILES; do
  f=`echo $file | sed 's,^\./,,; s/-/_/g'`
  echo "extern void symbols_of_${f##*/} (void);"
done

cat << \EOF

static void
install_builtin_variables (void)
{
EOF

for file in $VAR_FILES; do
  f=`echo $file | sed 's,^\./,,; s/-/_/g'`
  echo "  symbols_of_${f##*/} ();"
done

cat << \EOF
}

static void
install_builtin_functions (void)
{
EOF

for file in $DEF_FILES; do
  fcn=`echo $file | sed 's,^\./,,; s/\.df//; s/-/_/g'`
  echo "  install_${fcn##*/}_fcns ();"
done

cat << \EOF
}

extern void install_mapper_functions (void);

void
install_builtins (void)
{
  install_builtin_variables ();
  install_mapper_functions ();
  install_builtin_functions ();
}
EOF

exit 0
