#include <os2.h>
#include "nls.h"

PUCHAR nlsSearch(PUCHAR psz, UINT ui)
{  if (ui <= 0xff)
   {  while (*psz != 0)
      {  if (*psz == (UCHAR)ui) return psz;
	 else psz = nlsNext(psz);
      }
   }
   else
   {  while (*psz != 0)
      {  if (nlsIsDBCS(*psz))
	 {  if ((((UINT)psz[0] << 8) | (UINT)psz[1]) == ui) return psz;
	    else psz += 2;
	 }
	 else psz++;
      }
   }

   return NULL;
}

PUCHAR nlsSearchCollate(PUCHAR psz, UINT ui)
{  if (ui <= 0xff)
   {  UCHAR uc = nlsCollate(ui);

      while (*psz != 0)
      {  if (nlsCollate(*psz) == uc) return psz;
	 else psz = nlsNext(psz);
      }
   }
   else
   {  while (*psz != 0)
      {  if (nlsIsDBCS(*psz))
	 {  if ((((UINT)psz[0] << 8) | (UINT)psz[1]) == ui) return psz;
	    else psz += 2;
	 }
	 else psz++;
      }
   }

   return NULL;
}

PUCHAR nlsSearch(PUCHAR pb, UINT ui, UINT cbLength)
{  PUCHAR pbLimit = pb + cbLength;

   if (ui <= 0xff)
   {  while (pb < pbLimit)
      {  if (*pb == (UCHAR)ui) return pb;
	 else pb = nlsNext(pb);
      }
   }
   else
   {  while (pb < pbLimit)
      {  if (nlsIsDBCS(*pb))
	 {  if ((((UINT)pb[0] << 8) | (UINT)pb[1]) == ui) return pb;
	    else pb += 2;
	 }
	 else pb++;
      }
   }

   return NULL;
}

PUCHAR nlsSearchCollate(PUCHAR pb, UINT ui, UINT cbLength)
{  PUCHAR pbLimit = pb + cbLength;

   if (ui <= 0xff)
   {  UCHAR uc = nlsCollate(ui);

      while (pb < pbLimit)
      {  if (nlsCollate(*pb) == uc) return pb;
	 else pb = nlsNext(pb);
      }
   }
   else
   {  while (pb < pbLimit)
      {  if (nlsIsDBCS(*pb))
	 {  if ((((UINT)pb[0] << 8) | (UINT)pb[1]) == ui) return pb;
	    else pb += 2;
	 }
	 else pb++;
      }
   }

   return NULL;
}

PUCHAR nlsSearchLast(PUCHAR psz, UINT ui)
{  PUCHAR pszPosition = NULL;

   if (ui <= 0xff)
   {  while (*psz != 0)
      {  if (*psz == (UCHAR)ui) pszPosition = psz;
	 psz = nlsNext(psz);
      }
   }
   else
   {  while (*psz != 0)
      {  if (nlsIsDBCS(*psz))
	 {  if ((((UINT)psz[0] << 8) | (UINT)psz[1]) == ui) pszPosition = psz;
	    psz += 2;
	 }
	 else psz++;
      }
   }

   return pszPosition;
}

PUCHAR nlsSearchCollateLast(PUCHAR psz, UINT ui)
{  PUCHAR pszPosition = NULL;

   if (ui <= 0xff)
   {  UCHAR uc = nlsCollate(ui);

      while (*psz != 0)
      {  if (nlsCollate(*psz) == uc) pszPosition = psz;
	 psz = nlsNext(psz);
      }
   }
   else
   {  while (*psz != 0)
      {  if (nlsIsDBCS(*psz))
	 {  if ((((UINT)psz[0] << 8) | (UINT)psz[1]) == ui) pszPosition = psz;
	    psz += 2;
	 }
	 else psz++;
      }
   }

   return pszPosition;
}

PUCHAR nlsSearchLast(PUCHAR pb, UINT ui, UINT cbLength)
{  PUCHAR pbPosition = NULL, pbLimit = pb + cbLength;

   if (ui <= 0xff)
   {  while (pb < pbLimit)
      {  if (*pb == (UCHAR)ui) pbPosition = pb;
	 else pb = nlsNext(pb);
      }
   }
   else
   {  while (pb < pbLimit)
      {  if (nlsIsDBCS(*pb))
	 {  if ((((UINT)pb[0] << 8) | (UINT)pb[1]) == ui) pbPosition = pb;
	    pb += 2;
	 }
	 else pb++;
      }
   }

   return pbPosition;
}

PUCHAR nlsSearchCollateLast(PUCHAR pb, UINT ui, UINT cbLength)
{  PUCHAR pbPosition = NULL, pbLimit = pb + cbLength;

   if (ui <= 0xff)
   {  UCHAR uc = nlsCollate(ui);

      while (pb < pbLimit)
      {  if (nlsCollate(*pb) == uc) pbPosition = pb;
	 else pb = nlsNext(pb);
      }
   }
   else
   {  while (pb < pbLimit)
      {  if (nlsIsDBCS(*pb))
	 {  if ((((UINT)pb[0] << 8) | (UINT)pb[1]) == ui) pbPosition = pb;
	    pb += 2;
	 }
	 else pb++;
      }
   }

   return pbPosition;
}
