#define INCL_DOSNLS
#include <os2.h>
#include <memory.h>
#include "nls.h"

void nlsInitialize()
{  static COUNTRYCODE countrycode = { 0, 0 };
   UCHAR abVectorBuffer[12];

   memset(AfbDBCS, 0, sizeof(AfbDBCS));

   if (DosQueryDBCSEnv(sizeof(abVectorBuffer), &countrycode, abVectorBuffer) == 0)
   {  PUCHAR pb = abVectorBuffer;

      while (*(short *)pb != 0)
      {  memset(AfbDBCS + pb[0], 1, pb[1] - pb[0] + 1);
	 pb += 2;
      }
   }

   for (UINT ui = 0; ui < 256; ui++)
   {  AbUpperChars[ui] = AbLowerChars[ui] = ui;

      if (ui >= 0x20 && AfbDBCS[ui] == 0)
      {  DosMapCase(1, &countrycode, &AbUpperChars[ui]);
      }
   }

   for (ui = 0x20; ui < 256; ui++)
   {  UINT uiUpper;

      if (AfbDBCS[ui] == 0
	  && (uiUpper = AbUpperChars[ui]) != ui
	  && AbLowerChars[uiUpper] == uiUpper)
      {  AbLowerChars[uiUpper] = ui;
      }
   }

   ULONG ulTemp;
   DosQueryCollate(sizeof(AbCollate), &countrycode, AbCollate, &ulTemp);
}
