/* 2>nul
@echo. & echo Procedures Language 2/REXX is not installed. & echo Use Selective Install to install REXX, then try again. & goto :end 2>nul
*/
/****************************************************************************
 *                            COU Configuration                             *
 ****************************************************************************
 *                    Licensed Materials-Property of IBM                    *
 *               5604-472 (c) Copyright IBM Corporation, 1993               *
 *                           All rights reserved.                           *
 *                 US Government Users Restricted Rights -                  *
 *                Use, duplication or disclosure restricted                 *
 *               by GSA ADP Schedule Contract with IBM Corp.                *
 ****************************************************************************
 * Parameters:                                                              *
 *   /R:response file name (fully qualified)                                *
 *   /S:source directory (assumed to exist)                                 *
 *   /L1:log file name (fully qualified)                                    *
 ****************************************************************************
 * Internal Revision A.1 - 20 Apr 93                                        *
 * Revision 1.0 - 1 May 93                                                  *
 ****************************************************************************/
trace 'O'
TrVal = value('COUTRACE','','OS2ENVIRONMENT')
if TrVal = ''
  then TrVal = 'O'
trace value TrVal
'@ECHO OFF'
signal on syntax
signal on novalue
signal on halt
parse upper arg Args
Ctl.!DispEnv = 0
Ctl.!DispRsp = 0
Ctl.!Verbose = 'OFF'
Ctl.!Jump = ''

/*****************************************************************************
 *                                   MAIN                                    *
 *****************************************************************************/
Globals = 'Env Ctl. File. TrVal XCmd.'
XCmd.0 = 0
XC = Initialize()
if XC = 0
  then do
    XC = Configure()
    if XC = 0
      then do
        call LabelDrives
        XC = 'FE00'
      end
  end
call Xit XC
exit XC

Xit: procedure expose (Globals)
parse arg XC
if XC = 0
  then XC = '0000'
signal off novalue
/**** PTR 10027 start ****/
if symbol('Ctl.!AppName') = 'VAR' & value('CTL.!RXUTILS') = 1
  then call rxOs2Ini 'USER', Ctl.!AppName, 'RC', XC||d2c(0)
/**** PTR 10027 end ****/
signal on syntax name Cont1
call rxDropFuncs
Cont1:
call rxfuncdrop 'RXCOUENV'
signal off syntax
signal off novalue
do J = 1 to XCmd.0
  XCmd.J
end
exit XC

/*****************************************************************************
 * INITIALIZE                                                                *
 *****************************************************************************/
Initialize: procedure expose (Globals) Args
trace value TrVal
say 'Initializing...'
call setlocal
parse source . . File.!Me
File.!MyPath = left(File.!Me, lastpos('\', File.!Me))
/* e.g., "A:\SETUP\" or "Z:\COUINST\SETUP\" */
File.!RootPath = left(File.!MyPath, lastpos('\', left(File.!MyPath,,
    length(File.!MyPath)-1)))
/* e.g., "A:\" or "Z:\COUINST\" */

Ctl.!Args = Args  /* Save args */
Args  = translate(Args, ':', '=')
parse var Args '/R:' RspFile . '/' 1 '/S:' SrcDir . '/' 1 '/L1:' File.!Log .,
    '/' 1 '/ITL:' Ctl.!ItlList . '/'

parse upper value value('PATH',,'OS2ENVIRONMENT') with ':\OS2;' -1 Ctl.!BDr +2
if File.!Log = ''
  then File.!Log = Ctl.!BDr'\OS2\INSTALL\NETDOOR.LOG'
call lineout File.!Log, 'Args:' Ctl.!Args
call stream File.!Log, 'C', 'CLOSE'
if SrcDir <> ''
  then do
    File.!RootPath = strip(SrcDir, 'T', '\')'\'
    File.!MyPath = File.!RootPath'SETUP\'
  end
if length(File.!RootPath) > 3
  then File.!SourceDir = strip(File.!RootPath, 'T', '\')
  else File.!SourceDir = File.!RootPath
Ctl.!Test = (wordpos('/TEST', Args) > 0)
/**** PTR 10034 start ****/
Ctl.!NoInt = (wordpos('/NOINT', Args) > 0) | Ctl.!Test |,
    (value('CAS_STATE',,'OS2ENVIRONMENT') <> '')
/**** PTR 10034 end ****/
if Ctl.!Test
  then 'PKUNZIP2 -o' File.!RootPath'SETUP\INSTDLL.ZIP' Ctl.!BDr'\OS2\DLL >>',
      File.!Log '2>&1'

Ctl.!AppName = 'CREQINST'
RspFile = strip(RspFile)

RxUtils = Ctl.!BDr'\OS2\DLL\RXUTILS.DLL'
'COPY' File.!RootPath'DATA\DLL\RXUTILS.DLL' RxUtils '> NUL 2>&1'
CouEnv = Ctl.!BDr'\OS2\DLL\COUENV.DLL'
'COPY' File.!RootPath'DATA\DLL\COUENV.DLL' CouEnv '> NUL 2>&1'
call LoadExtFuncs

call rxOs2Ini 'USER', Ctl.!AppName, 'REXXERROR', '$RXDEL'
/**** PTR 10027 start ****/
call rxOs2Ini 'USER', Ctl.!AppName, 'RC', '1604'||d2c(0)
/**** PTR 10027 end ****/
call rxOs2Ini 'USER', Ctl.!Appname, 'Install XCode', 997

Ctl.!LanInst = (word(rxDriveInfo(left(File.!MyPath, 2),,
    'FSINFO', 'NOFORMAT'), 5) = 'LAN')
/**** PTR 70 start ****/
Ver = rxCouInfo('VER')
if verify(Ver, '10') > 0
  then call Error 'Error "'Ver'" from COUENV.', '0816', 403
if Ver
  then do
    Ctl.!InstClass = 'PRODUCT'
    Ctl.!IniApp = 'COU'
  end
  else do
    Ctl.!InstClass = 'IUO'
    Ctl.!IniApp = 'CORE'
  end
call rxOs2Ini 'USER', Ctl.!IniApp, 'IniFile', '$RXDEL'
/**** PTR 70 end ****/

/**** PTR 235 moved ****/
EtcDir = value('ETC',,'OS2ENVIRONMENT')
if EtcDir = ''
  then EtcDir = 'C:\ETC'
if rxDirExist(EtcDir)
  then Ctl.!Etc = strip(EtcDir, 'T', '\')'\'
  else Ctl.!Etc = ''
/**** PTR 235 end ****/

Ctl.!Prefix = 'COU'
Ctl.!BDr = rxBootDrive()
/**** PTR 235 moved following lines ****/
call value 'PATH', File.!RootPath'TOOLS;'value('PATH',,'OS2ENVIRONMENT'),,
    'OS2ENVIRONMENT'
call value 'DPATH', File.!RootPath'TOOLS;'value('DPATH',,'OS2ENVIRONMENT'),,
    'OS2ENVIRONMENT'
/**** PTR 235 end *****/
XC = ReadRspFile(RspFile)
if XC > 0
  then return XC

File.!SysLvl = File.!RootPath'DISK_1\SYSLEVEL.'Ctl.!Prefix
if rxFileExist(File.!SysLvl)
  then Ctl.!VerNum = rxSysLevel(File.!SysLvl, 'VER')
  else Ctl.!VerNum = '?'

call BuildDriveMaps
call GetIniInfo
call GetOthDomains
if Ctl.INSTTYPE = 'SERVER'
  then call FindMaster
  else Ctl.!MasterFile = ''
return 0

/****************************************************************************
 * LOADEXTFUNCS                                                             *
 * Load External Functions                                                  *
 ****************************************************************************/
LoadExtFuncs: procedure expose (Globals)
trace value TrVal
call rxfuncadd 'RXLOADFUNCS', 'RXUTILS', 'RXLOADFUNCS'
signal on syntax name LoadRxUtils2
Ver = rxLoadFuncs('QUIET')
signal on syntax name syntax
Ctl.!RxUtils = 1

if rxOs2Ver() >= 2.0
  then do
    if \rxfuncquery('SYSDROPFUNCS')
      then do
        signal on syntax name LoadRexxUtil
        call SysDropFuncs
      end
    call LoadRexxUtil
  end

call rxfuncadd 'RXCOUINFO', 'COUENV', 'RXCOUINFO'
signal on syntax name NoCouEnv
call rxCouInfo 'VER'
signal on syntax name syntax

call rxfuncadd 'RXCOUCOPY', 'COUCOPY', 'RXCOUCOPY'
call rxfuncadd 'RXCOUASSOCIATEAPPFILE', 'COUCOPY', 'RXCOUASSOCIATEAPPFILE'

return 0

LoadRxUtils2:
signal on syntax name syntax
call Error 'RXUTILS.DLL could not be initialized.', '0800', 100

LoadRexxUtil:
if rxOs2Ver() = 2.0
  then 'PKUNZIP2 -o' File.!RootPath'DISK_1\CLIENT.ZIP' Ctl.!BDr'\OS2\DLL',
        'REXXUTIL.DLL >>' File.!Log '2>&1'
signal on syntax name syntax
call rxfuncadd 'SYSLOADFUNCS', 'REXXUTIL', 'SYSLOADFUNCS'
call sysLoadFuncs
return 0

NoCouEnv:
signal on syntax name syntax
call Error 'COUENV.DLL could not be initialized.', '0800', 101

/*****************************************************************************
 * READRSPFILE                                                               *
 *****************************************************************************/
ReadRspFile: procedure expose (Globals)
trace value TrVal
parse arg RspFile ., Recurse
Recurse = (Recurse <> '')
if RspFile = ''
  then call Error 'Incorrect invocation.  (CONFIG should only be invoked',
      'from INSTALL.EXE.)', '1600', 501
/*** PTR 10091 start ***/
if stream(RspFile, 'C', 'QUERY EXISTS') = ''
  then do
    Temp = rxSearchPath('DPATH', RspFile)
    if Temp = ''
      then call Error 'The file' RspFile 'does not exist.', '0800', 102
      else RspFile = Temp
  end
/*** PTR 10091 end ***/
Size = stream(RspFile, 'C', 'QUERY SIZE')
Data = charin(RspFile, 1, Size)
call stream RspFile, 'C', 'CLOSE'
if \Recurse
  then do
    do queued(); pull .; end     /**** PTR 235 added ****/
    Found. = 0
    Ctl.!LogDoms = ''
    Ctl.!NfsSrv = ''
    /* Assume no CMPVM */
    call value Ctl.!Prefix'.CPMVM', 'N', 'OS2ENVIRONMENT'
    MaxDom = 4
    LogDomFound = 0
    NfsSrvFound = 0
/**** PTR 235 start ****/
    NumHosts = 0
    OldGlobals = Globals
    Globals = Globals 'OldGlobals Found. MaxDom LogDomFound NfsSrvFound',
        'NumHosts'
  end

Data = Data'0D0A'x
do while Data <> ''
  parse var Data Line '0D0A'x Data
  if Line = '' | abbrev(Line, '*') | pos('1A'x, Line) > 0
    then iterate
  parse var Line Key . '=' KVal
  Key = translate(Key)
  KVal = strip(KVal)
  call lineout File.!Log, Key'='KVal
  if Key = 'INCLUDE'
    then do
      Orig = KVal
      File = stream(KVal, 'C', 'QUERY EXISTS')
      if File = ''
        then KVal = rxSearchPath('DPATH', KVal)
        else KVal = File
      if KVal <> ''
        then call ReadRspFile KVal, 'RECURSE'
        else call Error 'Warning: INCLUDE file "'Orig'" does not exist.'
      iterate
    end

  parse var Key Type '.' Key
  if Type <> 'I'
    then iterate
  Found.Key = 1
  select
    when abbrev(Key, 'LOGDOMAIN') then do
      Ctl.!LogDoms = Ctl.!LogDoms KVal '|'
      LogDomFound = LogDomFound + 1
    end
    when abbrev(Key, 'NFSSRV') then do
      Ctl.!NfsSrv = Ctl.!NfsSrv KVal '|'
      NfsSrvFound = NfsSrvFound + 1
    end
    when Key = 'CDR' then do
      Key = 'REMOTE'
      if length(KVal) = 2
        then KVal = KVal'\'
        else if length(KVal) > 3
          then KVal = strip(KVal, 'T', '\')
      if right(KVal, 1) <> '\'
        then RemPath = KVal'\'
        else RemPath = KVal
      call value Ctl.!Prefix'.REMOTEPATH', RemPath, 'OS2ENVIRONMENT'
    end
    when Key = 'UDR' then do
      Key = 'LOCAL'
      if length(KVal) = 2
        then KVal = KVal'\'
        else if length(KVal) > 3
          then KVal = strip(KVal, 'T', '\')
      if right(KVal, 1) <> '\'
        then LocPath = KVal'\'
        else LocPath = KVal
      call value Ctl.!Prefix'.LOCALPATH', LocPath, 'OS2ENVIRONMENT'
    end
    when Key = 'HOSTSYS'
      then KVal = translate(KVal, ',', ' ')
    when Key = 'HOSTADDS' then do
      do NumHosts = NumHosts + 1 while KVal <> ''
        parse var KVal HName ',' HAddr KVal
        queue 'CMD' HAddr HName '# Added by NetDoor installation'
      end
      NumHosts = NumHosts - 1
      iterate
    end
    otherwise nop
  end /* select */
/**** PTR 235 end ****/
  Ctl.Key = KVal
  call value Ctl.!Prefix'.'Key, KVal, 'OS2ENVIRONMENT'
  if Ctl.!DispRsp
    then call Error Ctl.!Prefix'.'Key':' KVal
end /* do */
call stream File.!Log, 'C', 'CLOSE'

if \Recurse
  then do
/*** PTR 104 start ***/
    if symbol('Ctl.IMAGEDRIVE') = 'LIT'
      then do
        Ctl.IMAGEDRIVE = 'NONE'
        call value Ctl.!Prefix'.IMAGEDRIVE', 'NONE', 'OS2ENVIRONMENT'
      end
    if symbol('Ctl.DATADRIVE') = 'LIT'
      then do
        Ctl.DATADRIVE = 'NONE'
        call value Ctl.!Prefix'.DATADRIVE', 'NONE', 'OS2ENVIRONMENT'
      end
/*** PTR 104 end ***/
    call CheckRspFile
    if Ctl.INSTTYPE = 'SERVER'
      then do
        Ctl.STARTUP = 'CMD'
        call value Ctl.!Prefix'.STARTUP', 'CMD', 'OS2ENVIRONMENT'
      end
    do I = LogDomFound + 1 to MaxDom
      Ctl.!LogDoms = Ctl.!LogDoms '|'
    end I
    Ctl.!LogDoms = strip(strip(Ctl.!LogDoms), 'T', '|')
    call value Ctl.!Prefix'.LOGDOMS', Ctl.!LogDoms, 'OS2ENVIRONMENT'
    do I = NfsSrvFound + 1 to MaxDom
      Ctl.!NfsSrv = Ctl.!NfsSrv '|'
    end I
    Ctl.!NfsSrv = strip(strip(Ctl.!NfsSrv), 'T', '|')
    call value Ctl.!Prefix'.NFSSRV', Ctl.!NfsSrv, 'OS2ENVIRONMENT'

/**** PTR 235 start ****/
    if NumHosts > 0
      then do
        if Ctl.!Etc = ''
          then call Error 'Required TCP/IP ETC directory not found.',,
              '1604', 205
        Hosts = Ctl.!Etc'HOSTS'
        call Error 'Modifying' Hosts'...'
        push 'EVAL SetCurL("BOTTOM")'
        push 'RF' Hosts
        push 'MSGMODE OFF,' File.!Log
        queue 'WF J:\, N='Ctl.!Prefix
        queue 'WF' Ctl.!BDr'\OS2\INSTALL, N='Ctl.!Prefix
        XC = 'IMPIT'('/R:QUEUE COUINST 0')
        if XC <> 0
          then call Error 'Error' XC 'modifying' Hosts, '1604', 201
      end
/**** PTR 235 end ****/
    Globals = OldGlobals
  end
return 0

CheckRspFile: procedure expose (Globals)
/* Basic client */
call CheckRspFile2 'INSTTYPE ACCMETH UDR CDR STARTUP'
/* Conditional client */
select
  when Ctl.ACCMETH = 'NETBIOS'
    then call CheckRspFile2 'LOGDOMAIN1'
  when Ctl.ACCMETH = 'NFS'
    then call CheckRspFile2 'NFSSRV1'
/**** PTR 233 start ****/
  otherwise do
    call Error 'Unexpected access method "' Ctl.ACCMETH '".',,
        '0816', 404
  end
/**** PTR 233 end ****/
end
/* Server */
if Ctl.INSTTYPE = 'SERVER'
  then do
    call CheckRspFile2 'SRVPROTOCOL IMAGEDRIVE DATADRIVE MASTER'
    if wordpos('NETBIOS', Ctl.SRVPROTOCOL) > 0
      then do
        call CheckRspFile2 'SRVTYPE'
        if Ctl.IMAGEDRIVE <> 'NONE'
          then call CheckRspFile2 'ALIAS'
      end
    if Ctl.IMAGEDRIVE = 'NONE' & Ctl.DATADRIVE = 'NONE'
      then call Error 'Server role is not defined.', '1604', 202
  end
return 0

CheckRspFile2: procedure expose (Globals)
parse upper arg Reqd
do I = 1 to words(Reqd)
  parse var Reqd RKey Reqd
  if \Found.RKey
    then call Error 'Response file is incomplete:' RKey, '1604', 200
end
return 0

/*****************************************************************************
 * BUILDDRIVEMAPS                                                            *
 *****************************************************************************/
BuildDriveMaps: procedure expose (Globals)
Ctl.!Map = space(translate(rxDriveMap('C:', 'LOCAL'), '', ':'))
parse value '' with Ctl.!Unformat Ctl.!CDMap Ctl.!FatMap Ctl.!HpfsMap Ctl.!VDisks
do I = words(Ctl.!Map) to 1 by -1
  Dr = subword(Ctl.!Map, I, 1)
  parse upper value rxDriveInfo(Dr, 'FSINFO') with Info
  if Info = 'TYPE=' then Info = ''   /* RXUTILS 1.71 bug */
  if Info = ''
    then Ctl.!Unformat = Dr Ctl.!Unformat
    else do
      parse upper var Info 'LABEL=' Label . 'FREE=' Free . 'TYPE=' Type .
      select
        when wordpos(Label, 'OS2VDISK VFDISK') > 0
          then Ctl.!VDisks = Dr||Ctl.!VDisks
        when Type = 'CDFS'
          then Ctl.!CDMap = Dr||Ctl.!CDMap
        when Type = 'HPFS'
          then Ctl.!HpfsMap = Dr||Ctl.!HpfsMap
        when Type = 'FAT'
          then Ctl.!FatMap = Dr||Ctl.!FatMap
        otherwise
          nop
      end
    end
end

do queued(); pull .; end
if IniGet('USER', Ctl.!AppName, 'LSCSD') < 8000 then
   'CACHE386 /STATS 2>&1 | RXQUEUE'
Ctl.!Hpfs386 = 1
do queued()
  pull Error ':' Line
  if length(Error) = 7
    then if abbrev(Error, 'CAC') | abbrev(Error, 'SYS')
      then Ctl.!Hpfs386 = 0
end
return 0

/*****************************************************************************
 * GETINIINFO                                                                *
 *****************************************************************************/
GetIniInfo: procedure expose (Globals)
trace value TrVal
call SetInfo 'OS2', IniGet('USER', Ctl.!AppName, 'OS2CSD')
call SetInfo 'LR', IniGet('USER', Ctl.!AppName, 'LRCSD')
call SetInfo 'LS', IniGet('USER', Ctl.!AppName, 'LSCSD')
call SetInfo 'CM', IniGet('USER', Ctl.!AppName, 'CMCSD')
call SetInfo 'CM2', IniGet('USER', Ctl.!AppName, 'CM2CSD')
call SetInfo 'LAP', IniGet('USER', Ctl.!AppName, 'LAPSCSD')
call SetInfo 'TCP', IniGet('USER', Ctl.!AppName, 'TCPCSD')
return 0

IniGet: procedure expose (Globals)
trace value TrVal
parse arg File, App, Key
Res = rxOs2Ini(File, App, Key)
if wordpos(Res, '$RXERROR $INIERROR $INI_ERROR') >0 | abbrev(Res, 'ERROR:')
  then Res = ''
return Res

SetInfo: procedure expose (Globals)
trace value TrVal
parse arg Comp, Dr Csd Ver Name
Ctl.Comp = Dr Csd Ver Name
if Dr <> ''
  then do
    EVar = Ctl.!Prefix'.'Comp
    call value EVar'DRIVE', Dr, 'OS2ENVIRONMENT'
    call value EVar'CSD', substr(Csd, 4), 'OS2ENVIRONMENT'
    call value EVar'VER', Ver, 'OS2ENVIRONMENT'
    call value EVar'NAME', Name, 'OS2ENVIRONMENT'
  end
return 0

/*****************************************************************************
 * GETOTHDOMAINS                                                             *
 *****************************************************************************/
GetOthDomains: procedure expose (Globals)
trace value TrVal
Ctl.!IniOthDom = ''
if Ctl.AccMeth = 'NETBIOS'
  then do
    parse var Ctl.LR Dr Csd .
    call rxGrep 'OTHDOMAINS', Dr'\IBMLAN\IBMLAN.INI', 'HITS'
    do J = 1 to Hits.0 while Ctl.!IniOthDom = ''
      if \abbrev(Hits.J, ';')
        then parse var Hits.J '=' Ctl.!IniOthDom
    end
    Ctl.!IniOthDom = translate(strip(Ctl.!IniOthDom), ' ', ',')
    PriDomain = IniGet('USER', Ctl.!AppName, 'LRDOMAIN')
    Temp = translate(Ctl.!LogDoms, ' ', '|')
    do while words(Ctl.!IniOthDom) < 4 & Temp <> ''
      parse var Temp Dom Temp
      if wordpos(Dom, PriDomain Ctl.!IniOthDom) = 0
        then Ctl.!IniOthDom = strip(Ctl.!IniOthDom Dom)
    end
    if word(Ctl.LR, 2) >= 6000
      then Ctl.!IniOthDom = translate(Ctl.!IniOthDom, ',', ' ')
  end
return 0

/*****************************************************************************
 * FINDMASTER                                                                *
 *****************************************************************************/
FindMaster: procedure expose (Globals)
trace value TrVal
say 'Querying master server.'
say 'Please be patient.  This can take a while...'
File = 'SERVERS.COR'
ImageDir = 'COUIMAGE'

Netbios = wordpos('NETBIOS', Ctl.SRVPROTOCOL) > 0
Nfs = wordpos('NFS', Ctl.SRVPROTOCOL) > 0
parse value '?' with 1 NName 1 NDom 1 TName
if Netbios
  then do
    parse value rxUserInfo() with . NName NDom
  end
if Nfs
  then do
/**** PTR 139 start ****/
/*    PreQ = queued()*/
/*    'HOSTNAME 2>NUL | RXQUEUE /LIFO'*/
/*    if queued() > PreQ*/
/*      then pull TName '.'*/
/**** PTR 139 end ****/
      TName = value('HOSTNAME','','OS2ENVIRONMENT')
  end

/**** PTR 10052 start ****/
Mstr = ''
/**** PTR 10052 end ****/
if Ctl.MASTER <> '<HERE>'
  then do
    Ctl.MASTER = strip(Ctl.MASTER, 'L', '\')
    DataRes = rxCouInfo('GET', 'DATARES')
    select
      when Ctl.ACCMETH = 'NETBIOS'
        then Mstr = FindMaster.Netbios(Ctl.MASTER, DataRes, File)
      when Ctl.ACCMETH = 'NFS'
        then Mstr = FindMaster.Nfs(Ctl.MASTER, DataRes, File)
      otherwise Mstr = ''
    end
    if Mstr = ''
      then call Error 'Could not link to master server' Ctl.MASTER'.',,
          '0812', 300
    Ctl.!MasterFile = strip(Mstr, 'T', '\')'\'File
    call CheckData Ctl.!MasterFile, NName, TName
  end
  else do
    Ctl.!MasterFile = Ctl.!BDr'\OS2\INSTALL\'File
    Temp.0 = 0
/**** PTR 10018 start ****/
    if NFS
      then TDName = '_'TName
/**** PTR 10018 end ****/
    if Netbios & Nfs & NName = TName
      then do
/**** PTR 10018 start ****/
        call GenDomainEntry NDom, 1, 0, NName
/**** PTR 10036 start ****/
        call GenDomainEntry TDName, 0, 1, TName, TName
/**** PTR 10036 end ****/
/**** PTR 10018 end ****/
        call GenServerEntry NName, 1, 1, Ctl.ALIAS, Ctl.IMAGEDRIVE'\'||,
            ImageDir
      end
      else do
/**** PTR 10010 start ****/
        if Netbios
          then do
            call GenDomainEntry NDom, 1, 0, NName
            call GenServerEntry NName, 1, 0, Ctl.ALIAS
          end
        if Nfs
          then do
/**** PTR 10018 start ****/
/**** PTR 10036 start ****/
            call GenDomainEntry TDName, 0, 1, TName, TName
/**** PTR 10036 end ****/
/**** PTR 10018 end ****/
            call GenServerEntry TName, 0, 1, , Ctl.IMAGEDRIVE'\'ImageDir
          end
      end
/**** PTR 10010 end ****/

    call rxStemInsert 'TEMP.', Temp.0+1, ':nick.!CONTROL'
    call rxStemInsert 'TEMP.', Temp.0+1, ':savepw.YES'
    call rxWrite Ctl.!MasterFile, 'TEMP.'
    call rxStemInsert 'TEMP.', 1, center(' Master SERVERS.COR ', 30, '-')
    call rxWrite File.!Log, 'TEMP.', Temp.0, 1, 'A'
    call rxStemInsert 'TEMP.', Temp.0+1, copies('-', 30)
  end
return 0

CheckData: procedure expose (Globals)
parse arg NameFile, NEntry, TEntry
if Resolve('NAMEFIND') = ''
  then call Error 'NAMEFIND not found.', '1604', 204
Sep = '1A'x
if NEntry <> '' & NEntry <> '?'
  then do
    Data = translate('NAMEFIND'(NameFile ':NICK' NEntry))
    if Data = 'ERROR:3'
      then call Error 'Entry for' NEntry 'not found in' NameFile'.',,
          '0816', 400
    if abbrev(Data, 'ERROR:')
      then call Error 'Error' Data 'searching for' NEntry 'in' NameFile'.',,
          '0816', 402
/*** PTR 104 start ***/
    if Ctl.IMAGEDRIVE <> 'NONE'
/*** PTR 104 end ***/
      then do
        parse var Data ':ID.' Image (Sep)
        if Image = ''
          then call Error NEntry 'in' NameFile 'missing ID tag.',,
              '0816', 401
      end
  end
if TEntry <> '' & TEntry <> '?'
  then do
    Data = translate('NAMEFIND'(NameFile ':NICK' TEntry))
    if Data = 'ERROR:3'
      then call Error 'Entry for' TEntry 'not found in' NameFile'.',,
          '0816', 400
    if abbrev(Data, 'ERROR:')
      then call Error 'Error' Data 'searching for' TEntry 'in' NameFile'.',,
          '0816', 402
/*** PTR 104 start ***/
    if Ctl.IMAGEDRIVE <> 'NONE'
/*** PTR 104 end ***/
      then do
        parse var Data ':NFS.' Image (Sep)
        if Image = ''
          then call Error TEntry 'in' NameFile 'missing NFS tag.',,
              '0816', 401
      end
/*** PTR 149 start ***/
  end
/*** PTR 149 end ***/
return 0

GenDomainEntry: procedure expose (Globals) Temp.
parse arg DomName, NetBios, Nfs, DomSrvName, TName
call rxStemInsert 'TEMP.', Temp.0+1, ':nick.'DomName
call rxStemInsert 'TEMP.', Temp.0+1, ':type.DOMAIN'
/**** PTR 10036 start ****/
call rxStemInsert 'TEMP.', Temp.0+1, ':dserver.'DomSrvName
/**** PTR 10036 end ****/
if Netbios
  then call rxStemInsert 'TEMP.', Temp.0+1, ':servers.'DomSrvName
if Nfs
  then call rxStemInsert 'TEMP.', Temp.0+1, ':nservers.'TName
call rxStemInsert 'TEMP.', Temp.0+1, ''
return 0

GenServerEntry: procedure expose (Globals) Temp.
parse arg SrvName, NetBios, Nfs, Alias, Mount
call rxStemInsert 'TEMP.', Temp.0+1, ':nick.'SrvName
call rxStemInsert 'TEMP.', Temp.0+1, ':type.SERVER'
if NetBios
  then call rxStemInsert 'TEMP.', Temp.0+1, ':id.'Alias
if Nfs
  then call rxStemInsert 'TEMP.', Temp.0+1, ':nfs.'Mount
/* call rxStemInsert 'TEMP.', Temp.0+1, ':primary.1' */
call rxStemInsert 'TEMP.', Temp.0+1, ''
return 0

/***** NETBIOS ***************************************************************/
FindMaster.Netbios: procedure expose (Globals)
trace value TrVal
parse arg Master, DataRes, OFile
MasterUNC = '\\'Master'\'DataRes
File = MasterUNC'\'OFile
if \rxFileExist(File)
  then call Error 'Could not read from master server' MasterUNC'.',,
      '0812', 301

/*** PTR 10120 start ***/
Id = 'NAMEFIND'(File ':NICK' Master ':ID')
if Id <> '' & \abbrev(Id, 'ERROR:')
  then do
    parse var Id '.' Id '1A'x
    UNC2 = '\\'Master'\'Id'\LOCAL\COMPLEX'
    File2 = UNC2'\'OFile
    if rxFileExist(File2)
      then MasterUNC = UNC2
  end
/*** PTR 10120 end ***/
return MasterUNC

/***** NFS *******************************************************************/
/* d:\corestuf         everyone */
FindMaster.Nfs: procedure expose (Globals)
trace value TrVal
parse arg Master, DataRes, OFile

if Resolve('SHOWEXP') = '' | Resolve('RPCINFO') = '' | Resolve('MOUNT') = ''
  then call Error 'Could not read from master server' Master'.',,
      '1604', 203
if \RpcInfo(Master, 'NFS')
  then call Error 'Could not read from master server' Master'.',,
    '0812', 303   /* NFSD not running */

PreQ = queued()
'CALL SHOWEXP' Master '2>&1 | RXQUEUE'
Found = 0
Exports = ''
do while queued() > PreQ & \Found
  parse pull MtPoint
  if MtPoint = '' then iterate
  if words(MtPoint) = 1 & queued() > PreQ
    then parse pull Who
    else parse var MtPoint MtPoint Who
  if translate(Who) <> 'EVERYONE'
    then iterate
  Test = translate(translate(MtPoint, ' ', '\/'))
  if wordpos(DataRes, Test) > 0
    then Found = 1
end
do while queued() > PreQ; pull .; end

if \Found
  then call Error 'Could not read from master server' Master '('DataRes').',,
    '0812', 302

parse value rxDriveMap('C', 'FREE') with Dr Dr2 .
if Dr = ''
  then call Error 'No free drive to mount master server.', '0812', 304
'CALL MOUNT -u-2 -g-2' Dr Master':'MtPoint '>NUL'
call rxStemInsert 'XCMD.', XCmd.0+1, 'CALL UMOUNT' Dr '>CON 2>&1'
File = Dr'\'OFile
if \rxFileExist(File)
  then call Error File 'not found on master server' Master '.', '0812', 305

/*** PTR 10120 start ***/
Id = 'NAMEFIND'(File ':NICK' Master ':NFS')
if Id <> '' & \abbrev(Id, 'ERROR:') & Dr2 <> ''
  then do
    parse var Id '.' Id '1A'x
    'CALL MOUNT -u-2 -g-2' Dr2 Master':'Id '>NUL'
    call rxStemInsert 'XCMD.', XCmd.0+1, 'CALL UMOUNT' Dr2 '>CON 2>&1'
    Path2 = Dr2'\LOCAL\COMPLEX'
    File2 = Path2'\'OFile
    if rxFileExist(File2)
      then Dr = Path2
  end
/*** PTR 10120 end ***/
return Dr

RpcInfo: procedure expose (Globals)
parse upper arg Host, Service
Running = 0
if Ping(Host)
  then do
    PreQ = queued()
    'CALL RPCINFO -P' Host '2>NUL | RXQUEUE /LIFO'
    if Service = 'NFS'
      then Service = '2049'
    /**
     ** 100003    2   udp   2049can't open file E:\ETC\rpc
     ** 100003    2   udp   2049  nfs
     **/
    do while queued() > PreQ & \Running
      pull Prog Vers Proto Port "CAN'T OPEN FILE"
      if wordpos(Service, Port) > 0
        then Running = 1
    end
    do while queued() > PreQ; pull .; end
  end
return Running

Ping: procedure expose (Globals)
parse arg Host
PreQ = queued()
XC = 0
'CALL PING' Host '1 1 | RXQUEUE /LIFO'
do while queued() > PreQ
  pull Line
  if wordpos('0% PACKET LOSS', Line) > 0
    then XC = 1
end
return XC

/*****************************************************************************
 * RESOLVE                                                                   *
 *****************************************************************************/
Resolve: procedure expose (Globals)
parse arg Cmd
Exts = 'COM EXE CMD'
do I = 1 to words(Exts) until Res <> ''
  Res = rxSearchPath('PATH', Cmd'.'word(Exts, I))
end
return Res

/*****************************************************************************
 * CONFIGURE                                                                 *
 *****************************************************************************/
Configure: procedure expose (Globals)
trace value TrVal
say 'Loading configuration program...'

if value(Ctl.!Prefix'.VERBOSE',,'OS2ENVIRONMENT') = ''
  then call value Ctl.!Prefix'.VERBOSE', Ctl.!Verbose, 'OS2ENVIRONMENT'
if Ctl.!Jump <> ''
  then call value Ctl.!Prefix'.JUMP', Ctl.!Jump, 'OS2ENVIRONMENT'
call value 'TESTMODE', Ctl.!Test, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.LOG', File.!Log, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.VERNUM', Ctl.!VerNum, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.FATMAP', Ctl.!FatMap, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.HPFSMAP', Ctl.!HpfsMap, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.HPFS386', Ctl.!Hpfs386, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.SOURCEDR', left(File.!RootPath, 2), 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.ROOTPATH', File.!RootPath, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.INIOTHDOMAINS', Ctl.!IniOthDom, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.INSTCLASS', Ctl.!InstClass, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.DATARES', rxCouInfo('GET', 'DATARES'),,
    'OS2ENVIRONMENT'
call value Ctl.!Prefix'.LANINST', Ctl.!LanInst, 'OS2ENVIRONMENT'
call value Ctl.!Prefix'.MASTERFILE', Ctl.!MasterFile, 'OS2ENVIRONMENT'
/**** PTR 10034 start ****/
call value Ctl.!Prefix'.NOINT', Ctl.!NoInt, 'OS2ENVIRONMENT'
/**** PTR 10034 end ****/

/**** PTR 235 start ****/
if Ctl.!Etc <> ''
  then call value Ctl.!Prefix'.EXPORTS', Ctl.!Etc'EXPORTS', 'OS2ENVIRONMENT'
  else if value(Ctl.!Prefix'.PROTOCOL.NFS',,'OS2ENVIRONMENT') = 'YES'
    then call Error 'Required TCP/IP ETC directory not found.', '1604', 205
/**** PTR 235 end ****/

call value Ctl.!Prefix'.MACHNAME', IniGet('USER', Ctl.!AppName,,
    'LRCOMPUTERNAME'), 'OS2ENVIRONMENT'
/**** PTR 10218 start ****/
/*PreQ = queued()*/
/*'@HOSTNAME 2>NUL | RXQUEUE /FIFO'*/
/*if queued() > PreQ*/
/*  then do*/
/*    pull IPName '.'*/
/*    call value Ctl.!Prefix'.IPNAME', IPName, 'OS2ENVIRONMENT'*/
/*  end*/
/**** PTR 10218 end ****/
IPName = value('HOSTNAME','','OS2ENVIRONMENT')
call value Ctl.!Prefix'.IPNAME', IPName, 'OS2ENVIRONMENT'

if symbol('Ctl.SRVPROTOCOL') = 'VAR'
  then do I = 1 to words(Ctl.SRVPROTOCOL)
    call value Ctl.!Prefix'.PROTOCOL.'word(Ctl.SRVPROTOCOL, I), 'YES',,
        'OS2ENVIRONMENT'
  end I
DDCmd = 'SET DELDIR='
do I = 1 to words(Ctl.!Map)
  Dr = word(Ctl.!Map, I)
  if pos(Dr, Ctl.!VDisks) = 0 & pos(Dr, Ctl.!CDMap) = 0
    then DDCmd = DDCmd||Dr':\DELETE,512;'
end I
call value Ctl.!Prefix'.DELDIRCMD', DDCmd, 'OS2ENVIRONMENT'

/* log our environment */
call lineout File.!Log, '------ Install Env Vars ------'
do queued(); pull .; end
'SET 2>&1 | RXQUEUE'
do queued()
  parse pull Line
  if abbrev(Line, Ctl.!Prefix'.')
    then if Ctl.!DispEnv
      then call Error Line
      else call lineout File.!Log, Line
end
call lineout File.!Log, copies('-', 30)
call stream File.!Log, 'C', 'CLOSE'

RetC = 'IMPIT'('/R:'File.!MyPath'CONFIG.ITL')
if RetC <> 0
  then call Error 'Error' RetC 'from configuration.', '1604', 201
call value Ctl.!Prefix'.JUMP', '', 'OS2ENVIRONMENT'
do while Ctl.!ItlList <> ''
  parse var Ctl.!ItlList Itl ',' Ctl.!ItlList
  if Itl <> ''
    then RetC = 'IMPIT'('/R:'File.!MyPath||Itl)
end

/* Delete fix information from ini */
IniFile = rxCouInfo('GET', 'INIFILE')
if rxOs2Ini(IniFile, 'COREFIX', '$RXALL', 'KEYS.') = ''
  then do I = 1 to Keys.0
    if \abbrev(Keys.I, '@')
      then call rxOs2Ini IniFile, 'COREFIX', Keys.I, '$RXDEL'
  end

/* Build installation data file */
InstData = strip(rxCouInfo('GET', 'LOCAL'), 'T', '\')'\INSTDATA.'Ctl.!Prefix
call rxTree InstData, 'TEMP.', 'F',, '-----'
if Temp.0 > 0
  then call rxDelete InstData
call lineout InstData, rxBootDrive() rxOs2Ver()
call stream InstData, 'C', 'CLOSE'
call rxTree InstData, 'TEMP.', 'F',, '**+++'

/* Delete our null info from OS2.INI */
if rxOs2Ini('USER', 'CREQINST', '$RXALL', 'KEYS.') = ''
  then do I = 1 to Keys.0
    if length(rxOs2Ini('USER', 'CREQINST', Keys.I)) = 0
      then call rxOs2Ini 'USER', 'CREQINST', Keys.I, '$RXDEL'
  end

if rxOs2Ver() < 2.0
  then call MigrateGroup
return 0

/*****************************************************************************
 * MIGRATEGROUP                                                              *
 *****************************************************************************/
MigrateGroup: procedure expose (Globals)
trace value TrVal
New = 'NetDoor'
call MigrateGroup2 'CORE'
call MigrateGroup2 'Core'
return 0

MigrateGroup2: procedure expose (Globals) New
trace value TrVal
parse arg Old
rc = rxQueryGroup('USER', Old, 'PGMS.')
if rc = 0 then do
  do I = 1 to Pgms.0
    rc = rxQueryProgram('USER', Old, Pgms.I, 'DATA.')
    if rc = 0
      then do
        call rxAddProgram 'USER', New, 'DATA.'
        call rxDeleteProgram 'USER', Old, Pgms.I
      end
  end
  call rxDeleteGroup 'USER', Old
end
return 0

/*****************************************************************************
 * LABELDRIVES                                                               *
 *****************************************************************************/
LabelDrives: procedure expose (Globals)
return 0
call LabelDrives2 Ctl.!FatMap
call LabelDrives2 Ctl.!HpfsMap
return 0

LabelDrives2: procedure expose (Globals)
parse arg DrList
do while DrList <> ''
  parse var DrList Dr +1 DrList
  parse upper value rxDriveInfo(Dr) with 'LABEL=' Label 'FREE='
  if Label = ''
    /* NB This should be machname_drive, but it has to work in all cases */
    then '@ECHO DRIVE_'Dr '| LABEL' Dr': > NUL 2>&1'
end
return 0

/*****************************************************************************
 * ERROR                                                                     *
 *****************************************************************************/
Error: procedure expose (Globals)
parse arg EMsg, CIDcode, XCode
say EMsg
LogExists = 0
if symbol('FILE.!LOG') = 'VAR'
  then if File.!Log <> ''
    then LogExists = 1

if LogExists
  then call lineout File.!Log, EMsg
if CIDcode <> '' & LogExists
    then call lineout File.!Log, 'CID code:' CIDcode',  Extended error',
        'code:' XCode
if LogExists
  then call stream File.!Log, 'C', 'CLOSE'
if CIDcode <> ''
  then do
    if symbol('CTL.!APPNAME') = 'VAR' & value('CTL.!RXUTILS') = 1
      then call rxOs2Ini 'USER', Ctl.!Appname, 'Install XCode', XCode
    call Xit CIDCode
  end
return 0

/*****************************************************************************
 *                       DEBUGGING and ERROR RECOVERY                        *
 *****************************************************************************/
DebugInit:
if wordpos('/DEBUG', Args) > 0
  then do
    Parms.!Debug = 1
    Parms.!Wait = 1
    parse var Args ArgA '/DEBUG' DArg '/' ArgB
    Args = strip(ArgA '/'ArgB, 'T', '/')
    call Report '9999W', 'Debug mode activated.'
    call SetMsgClass 'X', 'X'
  end
  else do
    Parms.!Debug = 0
    call SetMsgClass 'I', 'X'
  end
return 0

BugInit:
if symbol('GLOBALS') = 'LIT'
  then do
    Globals = 'TrVal'
    TrVal = 'O'
  end
parse upper source . . Me   /* See if we're running from the macrospace */
say
call Error 'Error from' Me':'
MS = pos('\', Me) = 0       /* since we can't use sourceline if we are */
return MS

Syntax:
signal off error; signal off failure; signal off halt
signal off novalue; signal off notready; signal off syntax
Where = sigl
MacroSp = BugInit()
Msg = 'Syntax error' rc '('errortext(rc)') raised in line' Where'.'
signal DebugExit

Novalue:
signal off error; signal off failure; signal off halt
signal off novalue; signal off notready; signal off syntax
Where = sigl
MacroSp = BugInit()
Msg = 'Novalue error ('condition('D')') raised in line' Where'.'
signal DebugExit

DebugExit:
signal off syntax
if Parms.!Wait = 1
  then if translate(linein('STDIN:')) = '/D'
    then do
      say 'Trace mode started.  TRACE O to exit.'
      say
      trace ?i
      nop
    end
call Error Msg, '1604', 999

Halt:
call Error 'Execution halted by user request.'
call Xit 0

/*****************************************************************************
 * Required and optional response file tags.                                 *
 *****************************************************************************
 * I.INSTTYPE = CLIENT | SERVER (cs)                                         *
 * I.ACCMETH = NETBIOS | NFS (cs)                                            *
 * I.UDR = C:\CORE (cs)                                                      *
 * I.CDR = W: (cs)                                                           *
 * I.STARTUP = FOLDER | CMD (cs)                                             *
 * I.LOGDOMAIN1 = server (cs (accmeth=NETBIOS))                              *
 * I.LOGDOMAIN2 = server (cs (accmeth=NETBIOS), opt)                         *
 * I.LOGDOMAIN3 = server (cs (accmeth=NETBIOS), opt)                         *
 * I.LOGDOMAIN4 = server (cs (accmeth=NETBIOS), opt)                         *
 * I.NFSSRV1 = server (cs (accmeth=NFS))                                     *
 * I.NFSSRV2 = server (cs (accmeth=NFS), opt)                                *
 * I.NFSSRV3 = server (cs (accmeth=NFS), opt)                                *
 * I.NFSSRV4 = server (cs (accmeth=NFS), opt)                                *
 * I.CMPVM = Y | N (cs, iuo, opt)                                            *
 * I.HOSTSYS = vm,vm,vm,vm (cs, iou, only if CMPVM=Y)                        *
 * I.CMPVMGATE = gate (cs, iuo, only if CMPVM=Y)                             *
 * I.SITE = id (cs, iuo, opt)                                                *
 * I.HOSTID = vmid (cs, iuo)                                                 *
 * I.HOSTNODE = vmnode (cs, iuo)                                             *
 * I.NAME = Name A. Name (cs, iuo)                                           *
 * I.SRVPROTOCOL = NETBIOS | NFS (or both) (s)                               *
 * I.SRVTYPE = DOMAIN | SERVER (s (srvprotocol=NETBIOS))                     *
 * I.BKDC = Y (s (srvtype=DOMAIN), opt)                                      *
 * I.IMAGEDRIVE = C: | NONE (s)                                              *
 * I.ALIAS = CORE1 (s, only if IMAGEDRIVE specified)                         *
 * I.DATADRIVE = C: | NONE (s)                                               *
 * I.MASTER = <HERE> | server (s)                                            *
 * I.HOSTADDS = ipname,ipaddr [...] (cs (accmeth=NFS), opt)                  *
 *****************************************************************************/
