/******************************************************************

Description:    WordPerfect 5.0 Run Exec.

Details:        This exec is used to run the WordPerfect program.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used as command params to WP.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

Last Updated:   9/24/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'


/* Give header */
say
say ' WordPerfect 5.0'
say ' ---------------'
say

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'WordPerfect')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'WORDPERFECT', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
      call RxOS2Ini , 'WORDPERFECT', 'WORKDIR', '$RXDEL'
   end
end
if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local WordPerfect 5.0 directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause
   'exit 10'
end  /* Do */

/** Run WordPerfect 5.0 **/
say
say ' Starting WordPerfert 5.0...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while WP 5.0 is loaded.'
say '       ( This may take more than a minute )'
'WP /PS='Local.Directory' /D='Local.Directory
'exit'
