/******************************************************************

Description:    SPSS Installation Exec.

Details:        This exec asks the user what local directory
                should be used for the SPSS.  The directory
                spec is created and recorded in OS2.INI.

                The required DATA files are copied locally.

                The root directory of the remote drive is added
                to the user's LIBPATH if needed.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   None

Last Updated:   9/24/92
******************************************************************/
'@echo off'
trace 'o'

/* Load externals */
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'

/*  Get drive letter being used */
parse upper source . . drv
drv = left(drv,2)

say
say ' SPSS Installation:'
say ' ------------------'
say

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'SPSS')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'SPSS', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'SPSS', Local.Directory
      call RxOS2Ini , 'SPSS', 'WORKDIR', '$RXDEL'
   end
end

if rxDirExist(Local.Directory)=1 then do
   say ' Current SPSS local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory for your SPSS work files;'
say ' i.e. D:\SPSS'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'SPSS', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/********************************************/
/** Make directories and copy needed files **/
/********************************************/

call RxMkDir Local.Directory'\DATA'
call RxMkDir Local.Directory'\TEMP'
'COPY 'drv'\DATA\*.* 'Local.Directory'\DATA\*.*>nul 2>&1'

/****************************************************/
/** Add drive entry to LIBPATH statement if needed **/
/****************************************************/

call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your CONFIG.SYS file.  You must reboot before SPSS will'
  say ' run correctly.'
  say
end
else do
  say
  say ' SPSS is ready to run on your PC.'
  say
end
call RxPause
'exit'
