/******************************************************************

Description:    Smalltalk/V PM Installation Exec.

Details:        Query user for name of local directory for
                 Smalltalk files, create directory (if needed),
                 and record directory spec in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: None
   Window Type: FS/Win
   App Title:   None

Last Updated:   9/24/92
******************************************************************/
'@ECHO OFF'
trace 'o'

/* Load externals */
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Give header */
say
say ' Smalltalk/V PM Installation'
say ' ---------------------------'
say

/* Setup a few vars */
parse source . . Drv
Drv = left(Drv,2)

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'Smalltalk')

if rxDirExist(Local.Directory)=1 then do
   say ' Current Smalltalk local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory for your Smalltalk source files;'
say ' i.e. D:\SMALTALK'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'Smalltalk', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/****************************************************/
/** Add drive entry to LIBPATH statement if needed **/
/****************************************************/

call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your CONFIG.SYS file.  You must reboot before Smalltalk/V'
  say ' will run correctly.'
  say
end
else do
  say
  say ' Smalltalk/V PM is ready to run on your PC.'
  say
end
call RxPause
'exit'
