/******************************************************************

Description:    IBM Prolog/2 Run Exec

Details:        This exec sets up the appropriate Prolog/2
                environment then executes Prolog/2 in the
                appropriate user specified mode.

Dependencies:
   Externals:   None
   Drive(s):    None
   Directories: Assumes all package components in current
                 directory.
   Window Type: FS/Win
   App Title:   None

Last Updated 11/26/91
******************************************************************/
 '@echo off'
 trace 'o'

 parse source . . exec
 Pdr=left(exec, lastpos('\', exec))

 /* Give header */
 say
 say ' IBM PROLOG/2'
 say ' ------------'
 say
 say 'Setting up IBM PROLOG/2 environment for this session...'

 /* Get and set HELP Env Var */
 oldhelp = value('HELP',,'OS2ENVIRONMENT')
 newhelp = Pdr';'oldhelp
 call value 'HELP', newhelp,  'OS2ENVIRONMENT'

 /* Get and set PROLOGPATH local Source code directory Env Var */
 Local.Directory = RxOS2Ini(, 'Directories', 'PROLOG2')
 call value 'PROLOGPATH', Local.Directory, 'OS2ENVIRONMENT'

 /* Indicate editor info */
 proedit = value('PROLOGEDIT',,'OS2ENVIRONMENT')
 if proedit = '' then do
    say
    say 'Setting the default editor to be EPM.....'
    say
    say 'To change the default to use a different editor - '
    say '      Edit CONFIG.SYS and Add environment variable:'
    say
    say '         PROLOGEDIT=your.editor'
    say
    call value 'PROLOGEDIT','EPM.EXE','OS2ENVIRONMENT'
 end
 else do
   say
   say 'Default Prolog Editor = 'proedit
   say
 end

 say 'Set Up Done'   /* Tell user env setup is complete */


 say '*********',
     ' Loading PROLOG takes about 1 minute. Please be patient ',
     '*********'
 say
 say ' Do Not Terminate This Session.'
 say
 say '   Prolog is running in another session.  This session'
 say '   must be active while Prolog is running.'

'PROLOG /PM'

 'exit'
