/******************************************************************

Description:    PMWORD Install Exec.

Details:        This exec determines a local directory spec
                for the storing of the PMWORD.INI file.

                Once determined, it stores this info in the
                OS2.INI file.

                Other entries for font conversion and graphics
                are also added to OS2.INI

                The PMWord directory is then added to the LIBPATH.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/WIN
   App Title:   None

Last Updated:   4/17/92
******************************************************************/
trace 'O'
'@echo off'

/* Load external funcs */
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'


/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))


/* Give header */
say
say
say  'PMWORD SETUP'
say  '------------'; say

call RxOs2Ini , 'Microsoft Word', 'CONVERSION', 'Yes'd2c(0)


/* Check local dir already exists */
Local.Directory=RxOs2Ini('USER', 'Microsoft Word', 'INI-PATH')
if rxDirExist(Local.Directory)=1 then do
 say ' Current local directory = 'Local.Directory
 say
end

/* Let user change it */
do forever
   say ' Enter a local directory where PMWord files will be saved:'
   Local.Directory = translate(linein('STDIN'))
   if Local.Directory<>'' then do
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOs2Ini , 'Microsoft Word', 'INI-PATH',   Local.Directory||d2c(0)
        leave
     end
   end
   say d2c(7)
   say ' Invalid Directory.  Please enter a valid directory.'; say
end  /* Do Forever */


say ''
say ''
say 'Do you want to include the conversion utilities to convert'
say 'files from other formats to Microsoft Word? (Y/N)'
do until conv='Y' | conv='N'
   conv = translate(left(linein(STDIN),1))
end

if (conv='Y') then do
    call RxOs2Ini , 'Microsoft Word', 'CONVNUM', '18'd2c(0)

    /* Deleting entries in OS/2 ini before adding them */
    /* Fixes an unknown bug */
/*  call RxOs2Ini , 'Microsoft Word', '$RXDEL' */
    call RxOs2Ini , 'Microsoft Word', 'CONV1',  '"MS Word" 'path'PMW_WRD.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV2',  '"Macintosh Word" 'path'PMW_MCW.DLL ^.MAC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV3',  '"Windows Write" 'path'PMW_WRl.DLL ^.WRl'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV4',  '"MS Work" 'path'PMW_WWP.DLL ^.WPS'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV5',  '"DCA(RFT)" 'path'PMW_DCA.DLL ^.DCA'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV6',  '"WordPerfect 5.1" 'path'PMW_WP5.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV7',  '"WordPerfect 5.0" 'path'PMW_WP5.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV8',  '"WordPerfect 4.2" 'path'PMW_WP.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV9',  '"WordPerfect 4.1" 'path'PMW_WP.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV10', '"WordStar 5.5" 'path'PMW_WS.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV11', '"WordStar 5.0" 'path'PMW_WS.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV12', '"WordStar 4.0" 'path'PMW_WS.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV13', '"WordStar 3.45" 'path'PMW_WS.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV14', '"WordStar 3.3" 'path'PMW_WS.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV15', '"MultiMate 4.0" 'path'PMW_MM.DLL ^.DOX'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV16', '"MultiMate Adv II" 'path'PMW_MM.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV17', '"MultiMate Advantage" 'path'PMW_MM.DLL ^.DOC'd2c(0)
    call RxOs2Ini , 'Microsoft Word', 'CONV18', '"MultiMate 3.3" 'path'PMW_MM.DLL ^.DOC'd2c(0)
end

say ''
say ''
say 'Do you want to include the graphic importing utilities'
say 'for Microsoft Word? (Y/N)'
do until graph='Y' | graph='N'
   graph = translate(left(linein(STDIN),1))
end

if (graph='Y') then do
    call RxOs2Ini , 'MSGraphicsFilters', '$RXDEL'
    call RxOs2Ini , 'MSGraphicsFilters', 'Presentation Manager Metafile', 'MSPMFOS2.FLT,PMF'd2c(0)
    call RxOs2Ini , 'MSGraphicsFilters', 'CGM Graphics', 'CGMIMP.FLT,CGM'd2c(0)
    call RxOs2Ini , 'MSGraphicsFilters', 'PCX Graphics', 'MSPCXOS2.FLT,PCX'd2c(0)
end

    /* Include Help entries by default */

call RxOs2Ini , 'Microsoft Help', '$RXDEL'
call RxOs2Ini , 'Microsoft Help', 'Xl', '260'd2c(0)
call RxOs2Ini , 'Microsoft Help', 'Xr', '512'd2c(0)
call RxOs2Ini , 'Microsoft Help', 'Yd', '456'd2c(0)
call RxOs2Ini , 'Microsoft Help', 'Yu', '192'd2c(0)

say
say 'PMWord will not display a list of available fonts or font sizes'
say 'unless you have a printer driver installed in the OS/2 Print'
say 'Manager that supports the fonts.'
say

call LIBEDIT path 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC', , 'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say 'Important Note:'
  say '---------------'; say
  say 'The 'path' entry has just been added to the LIBPATH statement'
  say 'of your CONFIG.SYS file.  You must reboot before PMWord will'
  say 'run correctly.'; say
end
else do
  say; say
  say 'PMWord is ready to run on your PC.'; say
end
call RxPause
'exit'
