/******************************************************************

Description:    IBM Image Support Run Exec.

Details:        This exec sets up the appropriate IBM OS/2 Image
                Support defaults.
                The required device driver files are copied locally.

                The \DLL directory of the remote drive is added
                to the user's LIBPATH if needed.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   None

Last Updated:   9/9/91
******************************************************************/
'@echo off'
trace 'o'

/* Load externals */
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXWRITE',     'RXUTILS', 'RXWRITE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'


/*  Get drive letter being used */
parse upper source . . drv
Odr=left(drv , lastpos('\', drv))
OS2='OS2ENVIRONMENT'

/** Say what we are about to do **/
say
say ' OS/2 Image Support Installation'
say ' -------------------------------'
say

/* Give current setting */
Local.Directory = RxOS2Ini(, 'Directories', 'OIS')
if RxDirExist(Local.Directory)=1 then do
  say 'Current local directory = 'Local.Directory
end


/* Query user */
do forever
     say
     say ' Enter a local directory where local Image Support files may be stored:'
     Local.Directory = linein('STDIN')
     if Local.Directory<>'' then do
       call rxMkDir Local.Directory
       if rxDirExist(Local.Directory) then do
          call RxOS2Ini , 'Directories', 'OIS', Local.Directory
          leave
       end
     end
     say d2c(7)
     say ' Invalid Directory.  Please enter a valid directory.'
end  /* Do Forever */

isys=0
do until WhichEQ='3'
  say 'IBM OS/2 Image Support supports the following types of equipment:'
  say '     1. IBM scanners or video adapter cards'
  say '     2. Non-IBM scanners or video adapter cards'
  say '     3. No more Equipment'
  say;
  say 'Select an equipment type you wish to install'
  do until WhichEQ='1' | WhichEQ='2' | WhichEQ='3'
    WhichEQ = left(linein(STDIN),1)
  end
  if WhichEQ='1' then
    do until WhichIBM='5'
      say 'IBM OS/2 Image Support supports the following types of IBM equipment:'
      say '     1. IBM 3119 PageScanner'
      say '     2. IBM 3118 scanner'
      say '     3. IBM 3117 scanner'
      say '     4. IBM Video Capture Adapter/A'
      say '     5. No more Equipment'
      say;
      say 'Select an IBM equipment type you wish to install'
      do until WhichIBM='1' | WhichIBM='2' | WhichIBM='3' | WhichIBM='4' | WhichIBM='5'
        WhichIBM = left(linein(STDIN),1)
      end
      if WhichIBM='1' then do
         isys = isys+1
         Driver.isys='EQP3119.SYS '
         say 'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         end
      else if WhichIBM='2' | WhichIBM='3' then do
         isys = isys+1
         Driver.isys='AODB3118.SYS '
         say 'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         end
      else if WhichIBM='4' then do
         isys = isys+1
         Driver.isys='ICDD.SYS '
         say 'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         end
    end
  else if WhichEQ='2' then do
    do until WhichSCAN='8'
      say 'IBM OS/2 Image Support supports the following types of Non-IBM equipment:'
      say '     1. HP ScanJet scanner'
      say '     2. HP ScanJet Plus'
      say '     3. Howtek ScanMaster scanner'
      say '     4. Howtek ScanMaster II scanner'
      say '     5. Sharp JX-300 scanner'
      say '     6. Sharp JX-450 scanner'
      say '     7. SYLVIA/MC camera adapter card'
      say '     8. No more Equipment'
      say;
      say 'Select an IBM equipment type you wish to install'
      do until WhichSCAN='1' | WhichSCAN='2' | WhichSCAN='3' | WhichSCAN='4' |,
               WhichSCAN='5' | WhichSCAN='6' | WhichSCAN='7' | WhichSCAN='8'
        WhichSCAN = left(linein(STDIN),1)
      end
      if WhichSCAN='1' | WhichSCAN='2' then do
         isys = isys+1
         Driver.isys='SJDRIVER.SYS '
         say 'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         end
      else if WhichSCAN='7' then do
         isys = isys+1
         Driver.isys='EQPSYLVA.SYS'
         say 'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         'COPY 'Odr||Driver.isys||Local.Directory'\*.*>nul 2>&1'
         end
      else if WhichScan<>'8' then do
         say 'Be sure to install the manufacture supplied software for the'
         say 'Howtek or Sharp Scanners, if you have not already done so.'
         say;
         end
    end
  end  /* Do */
end
Driver.0=isys

/* Add new drivers to CONFIG.SYS */
if Driver.0<>0 then do
  isys=1
  do until isys > Driver.0
     Driver.isys='DEVICE='Local.Directory'\'Driver.isys
     isys=isys+1
  end /* do */
  call RxWrite 'C:\CONFIG.SYS', Driver,,,'A'
  if rc then do
    say rc
    say 'Error Writing C:\CONFIG.SYS!  Nothing updated'
    'exit'
  end
end

/** Add drive entry to LIBPATH statement if needed **/
call LIBEDIT Odr'DLL' 'A' 'E'  /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 | Driver.0<>0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  if LibEditRC=0 then do
    say ' The 'Odr'DLL entry has just been added to the LIBPATH statement'
    say ' of your C:\CONFIG.SYS file.'
  end
  if Driver.0<>0 then
    say ' A OIS Device driver was just added to your CONFIG.SYS.'
  say;
  say 'You must reboot before OS\2 Image Support will run correctly.'
  say
end
else do
  say
  say ' OS/2 Image Support is ready to run on your PC.'
  say
end
say 'Press Enter to finish updating local workstation.'
call RxPause
'OISINI'
'exit'
