/*******************************************************************/
/** MSWORD Package Run File                                       **/
/**                                                               **/
/** Ver 1.00 by Tom Rogers                                        **/
/*******************************************************************/
trace 'O'
'@echo off'

/** Setup needed variables **/
call RxFuncAdd 'RXGREP',  'RXUTILS', 'RXGREP'
call RxFuncAdd 'RXPAUSE', 'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR', 'RXUTILS', 'RXMKDIR'
Env='OS2ENVIRONMENT'              /* Set the REXX environment variable */
oldpath=value('PATH', , Env)      /* Get current path                  */
olddpath=value('DPATH', , Env)    /* Get current dpath                 */
parse upper source . . exec       /* Get packrun filespec              */
LanDrv=left(exec,3)               /* Get lan drive                     */

/** Give the header **/
say; say
say 'MSWORD'
say '------'; say

/** Make sure we can find the personal subdirectory **/
pdir=value('MSWNET',,Env)         /* Get personal lotus dir var if it exists */
if pdir='' then do                /* If not, scan CONFIG.SYS for it */
  if RxGrep('SET MSWNET=', 'C:\CONFIG.SYS', 'grep')=0 then
   if grep.0>0 then do
     pdir=space(substr(grep.1, pos('=', grep.1)+1))
     call value 'MSWNET', pdir, Env
   end
end

/** Run the program if the personal directory was found */
if pdir='' then do
  say D2C(7)
  say 'Could not determine your MSWORD personal directory.'; say
  say 'Please make sure you have run the installation program'
  say 'for MSWORD.'; say
  call RxPause
end
else do
 call value 'PATH', LanDrv';'oldpath, Env
 call value 'DPATH', LanDrv';'olddpath, Env
 call RxMkDir pdir
 call directory pdir
 say 'Personal directory is 'pdir'..'; say
 say 'Microsoft Word is loading, please wait...'
 LanDrv'WORD'
end
'EXIT'
