/******************************************************************

Description:    Molecular Presentation Graphics run exec.

Details:        This exec is used to run Molecular Presentation Graphics.

                This exec will determine whether or not the install
                exec has been run.  If not it will tell the user to
                run the install and exit.  If install has been run
                it will execute MPG2.EXE

Dependencies:
   Externals:   RXUTILS.DLL - Part of RXUTILS package on OS2TOOLS.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: none
   Window Type: FS/WIN
   App Title:   None

Last Updated:   3/4/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'

/* Give header */
say
say ' Molecular Presentation Graphics'
say ' -------------------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

Local.Directory = RxOS2Ini(, 'Directories', 'MPG')

/* Check if install has been run */
if rxDirExist(Local.Directory)=0 then do | rxFileExist(local.Directory'\scrfont.mft')=0 then do
   say ' Local Molecular Presentation Graphics directory not set.'
   say ' You must run the install program.'
   say
   call rxPause
   'exit'
end  /* Do */

/** Change to local directory **/
call directory Local.Directory

/** Prepend remote drive to current PATH and DPATH **/
Env = 'OS2ENVIRONMENT'
parse source . . drv
drv = left(drv,3)
call value 'PATH',  drv';'||value('PATH',,Env), Env
call value 'DPATH', drv';'||value('DPATH',,Env), Env


/** Run Molecular Presentation Graphics **/
say
say ' Starting Molecular Presentation Graphics...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while MPG is loaded.'
say
say ' Once MPG has started this window will be'
say ' hidden...'
'START HIDEWIN /D=20 Molecular Presentation Graph.'
'MPG2'
'exit'
