/***********************************************************/
/*                 SETUP - Version 1.00                    */
/*                                                         */
/* Author:   John Walicki                                  */
/* Purpose:  Sets up the proper IBM C/2 environment        */
/***********************************************************/
 trace 'O'
 '@echo off'

 call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

 File = 'USER'
 App = 'IBMC2'
 Toolkit = 'Toolkit'
 TCPIP = 'TCPIP'
 SQLLIB = 'SQLLIB'

CurTKver=RxOs2Ini(File, App, Toolkit)
LinkTCP=RxOs2Ini(File,  App, TCPIP)
LinkSQL=RxOs2Ini(File,  App, SQLLIB )

if CurTKver <> '$RXERROR' then do
  Ver=right(CurTKver,1)
  say 'Current OS/2 Programming Toolkit: 1.'Ver
  if left(LinkTCP,1) = 'Y' then
     say 'Link to TCPIP Libraries: Yes'
  else
     say 'Link to TCPIP Libraries: No'
  if left(LinkSQL,1) = 'Y' then
     say 'Link with SQL support: Yes'
  else
     say 'Link with SQL support: No'
  say;
  say 'You can choose to change the current settings or accept them.'
  say;
end

say 'IBM C/2 can link your applications with any of the following Programming Toolkits'
say '     1. IBM OS/2 Programming Tools and Information Ver 1.1'
say '     2. IBM OS/2 Programming Tools and Information Ver 1.2'
say '     3. IBM OS/2 Programming Tools and Information Ver 1.3'
say;
say 'Choose which toolkit you want to link your applications with:'
do until WhichTK='1' | WhichTK='2' | WhichTK='3'
  WhichTK = left(linein(STDIN),1)
end

say;
say 'If you are writing TCP/IP applications you will want to link with the TCPIP Libraries.'
say 'Do you want to include the TCPIP libraries in the LIBPATH? (Y/N)'
do until LinkTCP='Y' | LinkTCP='N'
  LinkTCP = translate(left(linein(STDIN),1))
end

say;
say 'If you are writing Database Manager applications you will want to link '
say 'with the SQL Libraries and header files.'
say 'Do you want to include the SQL libraries and headers? (Y/N)'
do until LinkSQL='Y' | LinkSQL='N'
  LinkSQL = translate(left(linein(STDIN),1))
end

CurTKver = 'TOOLKT1'WhichTK

call RxOs2Ini File, App, TCPIP,   LinkTCP
call RxOs2Ini File, App, SQLLIB,  LinkSQL
call RxOs2Ini File, App, Toolkit, CurTKver

say;
say 'IBMC2 Toolkit version, TCPIP and SQL link access saved.'
exit
