/******************************************************************

Description:    Freelance 4.0 Install Exec

                This exec determines which version of OS/2 is 
                running.  If OS/2 1.3 is running it calls the
Details:        the DOSEXE.EXE program to execute the Freelance
                version 4.0 Install program, FLINSTAL.COM, from
                within the DOS box.  If OS/2 2.0 is running the
                FLINSTAL.COM program is run directly.

                Parameters to the DOSEXE.EXE program are actually
                commands to be run in the DOS box.  This exec
                runs the FLINSTAL program which actually creates
                the local Freelance directory and copies required
                local files.

                The exec also asks the user what local directory
                was created by FLINSTAL, and stores said info in
                OS2.INI where the Freelance Run exec may get it.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
                HIDEWIN.EXE  - Part of VENDOR package.
                SWITCHTO.EXE - Part of VENDOR package.
                DOSEXE.EXE   - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   Freelance 4.0 (Dos)

Last Updated:   8/28/92
******************************************************************/
trace 'O'
'@echo off'

/*******************************************/
/** Give greetings messages               **/
/*******************************************/
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
'SWITCHTO /C>NUL 2>&1'
say;
say 'Freelance 4.0 (DOS) Installation'
say '--------------------------------'; say
say 'You are about to run the Freelance install program'
say 'provided with the Freelance package.  This program'
say 'will be run in the DOS box.'; say
say 'The Freelance installation program will ask you'
say 'what drive and directory you would like to use'
say 'for the storage of local Freelance components.'; say
say 'This directory should NOT already exist or the'
say 'installation may fail.'; say
say 'Please remember the drive and directory you'
say 'specify when running the Freelance installation'
say 'program.'; say
call RxPause


/***************************************/
/** Initialize vars that might change **/
/***************************************/
App     = 'FLINSTAL.COM'         /* Dos application to run          */
Params  = ''                     /* Parameters to DOS app (if any)  */
Session = 'Freelance 4.0 (Dos)'  /* Session title (used by HIDEWIN) */

/*******************************************/
/** Initialze vars that will never change **/
/*******************************************/
call RxFuncAdd 'RXCLS',       'RXUTILS', 'RXCLS'
call RxFuncAdd 'RXSAY',       'RXUTILS', 'RXSAY'
call RxFuncAdd 'RXGETKEY',    'RXUTILS', 'RXGETKEY'
call RxFuncAdd 'RXDELETE',    'RXUTILS', 'RXDELETE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'
parse upper source . . fspec                 /* Get full exec fspec   */
Dir     = left(fspec, lastpos('\', fspec)-1) /* Get full dir name     */
App     = Dir'\'App                          /* Get full app spec     */
Drive   = left(App,2)                        /* Get the drive letter  */
SemFile = RxBootDrive()'\$DOSSEM.$$$'        /* DOS semaphore file    */
Abort   = 'FALSE'

/******************************************************/
/** Check to see if Freelance can run on this        **/
/** system.                                          **/
/******************************************************/

if (rxOs2Ver() < 2.0) then do
  'QINETR /Q'
  if (rc = 3) then do
     say 'Error!  Ring 0 TCP/IP detected.  Freelance will not'
     say 'work.'
     call RxPause
     exit 10
  end
end

/******************************************************/
/** Stay in this loop until the user aborts or until **/
/** the DOS program is run successfully.             **/
/******************************************************/

if (rxOs2Ver() < 2.0) then do
do forever
  call RxDelete SemFile                      /* Delete Sem file (JIC) */
  'START HIDEWIN 'Session'>NUL 2>&1'
  'DOSEXE 'Drive' "CD 'Dir'" "'App Params'"'RxBootDrive()' "ECHO Do Not Delete>'SemFile'"'
   /***************************************************/
   /** If the RC is 0 then wait for the DOS exec to  **/
   /** finish.  The DOS exec will be finished when   **/
   /** the semaphore file exists.                    **/
   /***************************************************/
   if RC=0 then do
     say 'Waiting for DOS app to end...'
     do forever
       if RxFileExist(SemFile)=1 then do
         do while RxDelete(SemFile)<>0   /* Loop until file can be deleted */
            Nop
         end
         leave
       end
     end
     leave
   end
   /***************************************************/
   /** If the RC is not 0 then an error occurred.    **/
   /** Tell the user and give them a chance to abort **/
   /** the program.                                  **/
   /***************************************************/
   else do
    'START HIDEWIN /S 'Session'>NUL 2>&1'
     call RxCls
     say D2C(7)
     say 'ERROR - Could not start a program in the DOS box.'; say
     say 'Possible causes of failure:'
     say '  1)  There is no DOS box.'
     say '  2)  A program is already active in the DOS box.'
     say '  3)  DOS.SYS device driver not loaded via CONFIG.SYS.'; say
     resp = YesNoPrompt('Would you like to try again')
     if resp='N' then do
       say 'Aborted at your request.'
       Abort='TRUE'
       leave
     end
   end
end
end
else do
  'START HIDEWIN 'Session'>NUL 2>&1'
  App' 'Params
  Abort='FALSE'
end

/************************************************/
/** Ask the user what personal directory they  **/
/** created.                                   **/
/************************************************/
if Abort='FALSE' then do
  'START HIDEWIN /S 'Session'>NUL 2>&1'
  'SWITCHTO /C>NUL 2>&1'
  call RxCls
  say; say d2c(7)
  say 'You have just completed running the Freelance installation'
  say 'program.'; say
  say 'VENDOR has no way of knowing what drive and directory you specified'
  say 'for the storage of local Freelance components.'; say
  say 'Therefore, please enter the drive and directory you specified'
  say 'while running the installation program:'; say
  do until done='TRUE'
   call RxSay 'Enter local Freelance drive and directory (ie D:\FL) > '
   do until Dir<>''
     Dir = LINEIN('STDIN')
   end
   if RxDirExist(Dir) then do
     done='TRUE'
    end
   else do
     say d2c(7)
     say 'The drive and directory you specified does not seem to exist.'
     say 'Please try again...'; say
     done='FALSE'
    end
  end

  if (rxOs2Ver() < 2.0) then do
    call RxCls
    say; say 'VENDOR Plotter configuration'; say '----------------------------'
    say;
    say 'To use the COM ports you need  DEVICE='RxBootDrive()'\OS2\COM02.SYS in CONFIG.SYS.'
    say; say 'Do you have a Plotter attached to a serial port that you would'
    Plotter =  YesNoPrompt( 'like to use with Freelance.' )
    if Plotter = 'Y' then do
      say;
      done = FALSE
      do until done='TRUE'
        done = TRUE
        say 'Enter the COM port that the plotter is attached to:'
        say '  1. COM1'; say '  2. COM2'; say '  3. QUIT';
        call RxSay 'Which port >'
        COMport = LINEIN( STDIN )
        if COMport = 1 | COMport = 2 then
           call RxOS2Ini , 'FLCOMPORT', 'ACTIVE', 'COM'COMport
        else if COMport <> 3 then
           done = FALSE
      end
    end
  end

  call RxCls
  say
  say 'Storing local directory information for future reference...'; say
  call RxOS2Ini , 'Directories', 'FLV4', Dir
  say 'Installation complete!';
  say 'Freelance 4.0 is ready to run.'; say
  call RxPause
end
'EXIT'


/**************************************************/
/** YesNoPrompt(prompt)                          **/
/**                                              **/
/** Procedure which excepts a prompt and prompts **/
/** the user for a Y/N response.                 **/
/**************************************************/
YesNoPrompt: procedure
parse arg prompt
call RxSay prompt||' [Y/N] > '
do until resp='Y' | resp='N'
   resp = translate(RxGetKey('NOECHO'))
   if resp<>'Y' & resp<>'N' then call RxSay D2C(7)
end
say resp
return resp
