/**********************************************************************
Description:    Lotus Ami Pro for Windows Release 3.0 Install exec

Details:        This exec creates a local directory where work
                files can be saved.  It adds this information to
                OS2.INI.  It then runs NODE.EXE to set up the
                user's workstation.

                Ami Pro has a bug when running from the network that
                says the license directory cannot be found.  To get
                around this create a 0 or 1 byte file called AMIPRO.030
                in the \AMIPRO subdirectory.  This disables LICENSER,
                so Vendor is the only program keeping track of the
                licenses.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                NODE.EXE    - Part of Ami Pro
   Drive(s):    Must run from the M: drive
   Directories: Ami Pro .INI files will be copied to \OS2\MDOS\WINOS2
   Window Type: FS/Win
   App Title:   Ami Pro for Windows

Last Updated:   10/1/92
**********************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXCLS  ',     'RXUTILS', 'RXCLS'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXBOOTDRIVE', 'RXUTILS', 'RXBOOTDRIVE'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'

/* Give header */
say
say ' Ami Pro for Windows 3.0 Installation exec'
say ' -----------------------------------------'
say

parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
bdr=RxBootDrive()

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run Ami Pro for Windows.  Windows programs'
  say 'cannot be run on versions of OS/2 less than 2.0'
  say
  call RxPause 'Press any key to exit'
  'exit'
end /* do */

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'AMIPRO')
if RxDirExist(Local.Directory)=1 then do
   say ' Current Ami Pro for Windows local directory = 'Local.Directory
   say
end  /* if RxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/****************************************************************/
/** Prompt user for Local Directory.  Do until a valid local   **/
/** drive is used.  Create the directory and add it to OS2.INI **/
/****************************************************************/

say
say ' Enter a local directory for your Ami Pro files;'
say ' i.e. D:\AMIPRO'
say ' Valid local Drives:' DrvMap
say

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call RxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'AMIPRO', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/***********************************************************/
/** Give info about Node Setup program and start NODE.EXE **/
/** copying files locally is controlled by NETADMIN.INI   **/
/***********************************************************/

say
say ' You are about to start the Ami Pro Node Setup program.  This'
say ' will copy necessary files to your 'bdr'\OS2\MDOS\WINOS2'
say ' directory and to the local directory you just created.'
say ' The node setup program will copy approxiamately 3MB of files.'
say ' These include macros, style sheets, and documents.  You may'
say ' delete these at any time if you do not need them.'
say
call RxPause
call RxCls
say
say ' On the first popup which asks for the network path of Ami Pro'
say ' enter 'path
say
say ' When it asks where to copy the macros, docs, styles, user dictionary'
say ' enter - 'Local.Directory'\MACROS'
say '       - 'Local.Directory'\DOCS'
say '       - 'Local.Directory'\STYLES'
say '       - 'Local.Directory'\USERDICT'
say
say ' The Node Setup program will take a couple of minutes to copy'
say ' all of the files.'
say
say ' When the Setup program says that it cannot add the Ami Pro'
say ' icons to a program group, click on OK.'
say
say ' On the next popup, just click on OK.'
say ' Ignore the instructions for starting Ami Pro on the next'
say ' popup, they are not valid for starting Ami Pro from Vendor.'
say
say ' The Node Setup program will then take a few seconds to close.'
say
call RxPause
'NODE\NODE'
say
say ' Ami Pro is now ready to run.'
say ' A reboot is not necessary.'
say
call RxPause
'exit'
