/******************************************************************
Description:    Alchemy III Run Exec

Details:        This exec is used to run the Alchemy program.

                It checks to see if the Local.Directory exists.
                If it doesn't the user is told to run the install.
                It also checks to make sure that OS/2 2.0 is
                running.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    none
   Directories:
   Window Type: FS/WIN
   App Title:   Alchemy III

Last Updated:   8/25/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Give header */
say
say ' Alchemy III'
say ' -----------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
BootDrive = RxBootDrive()

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run Alchemy III.  Alchemy III is a Windows program'
  say 'and cannot be run on versions of OS/2 prior to 2.0'
  say
  'exit 10'
end /* do */

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'Alchemy')

if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local Alchemy directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause
   'exit 10'
end  /* Do */

/** Run Alchemy III **/
say
say ' Starting Alchemy III...'
say
say ' Please wait a moment while it is loaded.'
say '    ( This may take more than a minute )'
say
say ' Local directory = 'Local.Directory
say
say ' Once Alchemy III has started this window will be'
say ' hidden...'

'START HIDEWIN /D=20 Alchemy III'
Drive'\exe\alchemy'
'exit'
