/******************************************************************
Description:    Alchemy III Installation exec

Details:        This exec creates a local directory where work
                files can be saved.  It adds this information to
                OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   Alchemy III

Last Updated:   8/24/92
******************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run Alchemy III.  Alchemy III is a Windows program'
  say 'and cannot be run on versions of OS/2 less than 2.0'
  say
  exit 10
end /* do */

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'Alchemy')

if rxDirExist(Local.Directory)=1 then do
   say ' Current Alchemy local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory for your Alchemy work files;'
say ' i.e. D:\ALCHEMY'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'Alchemy', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

say
say ' Alchemy is now ready to run.'
say ' A reboot is not required.'
call RxPause
'exit 0'
