/******************************************************************
Description:    AutoDesk AutoCAD Install Exec.

Details:        This exec is used to install AutoCAD.  It checks
                that a math coprocessor is in the workstation.  
                It also prompts the user for a local directory
                which is then created and and added to OS2.INI.
                The user is also asked if they want to copy
                the sample drawing files locally.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package
                HIDEWIN.EXE - Part of VENDOR package
   Drive(s):    Sample files must be copied locally to use them.
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   AutoCAD for OS/2 Rel. 10

Last Updated:   9/23/92
******************************************************************/

trace 'O'
'@echo off'

call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDRIVEINFO' ,'RXUTILS', 'RXDRIVEINFO'
call RxFuncAdd 'RXDRIVEMAP' , 'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'
call RxFuncAdd 'RXDEVCONFIG', 'RXUTILS', 'RXDEVCONFIG'

 say
 say ' AutoCAD install exec'
 say '---------------------'

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/**************************************************/
/** Determine if a math coprocessor is installed **/
/**************************************************/

mathco = RxDevConfig('MATHCO')

if mathco = 0 then do
   say
   say d2c(7)
   say ' A Math Coprocessor is not present in this machine.'
   say ' AutoCAD requires a Math Coprocessor to run properly.'
   say
   call RxPause 'Press any key to exit'
   'exit 0'
end

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'AUTOCAD')
if rxDirExist(Local.Directory)=1 then do
   say ' Current AutoCAD local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' AutoCAD drawings will be saved on your workstation.'
say ' Valid local Drives:' DrvMap
say
say ' Enter a local directory where your AutoCAD files will'
say ' be saved, i.e. C:\ACAD'
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory)=1 then
            call RxOS2Ini , 'Directories', 'AUTOCAD', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/********************************************************/
/** Copy AutoCAD configuration file to Local.Directory **/
/********************************************************/

say 'Copying default ACAD.CFG file to 'Local.Directory
'COPY ACAD.CFG 'Local.Directory'\ACAD.CFG > NUL'

/*********************************************************/
/** Ask users if they want to copy sample drawing files **/
/*********************************************************/

say
say ' AutoCAD comes with several sample drawing files.  However,'
say ' in order to use them they must be copied locally to your'
say ' hard disk.  They take up approxiamately 583KB of disk space.'
say 
say ' Do you want to copy the sample drawings? (Y/N)'
say

do until conv='Y' | conv='N'
   conv = translate(left(linein(STDIN),1))
end  

if (conv='Y') then do
   'copy 'path'*.dwg' Local.Directory '> NUL'
end 

/* Give message */
say
say ' AutoCAD is now ready to run.'
say ' You do not have to reboot.'
say
call RxPause
'exit 0'
