/******************************************************************
Description:    Lotus FL/G Execution Exec.

Details:        This exec is used to run FL/G.

                This exec assigns the LOTUSLOT license alias
                then starts FL/G.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                GIME.EXE    - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   Lotus FLG

Last Updated:   7/27/92
******************************************************************/

'@echo off'
trace 'o'

/** Give header **/
say
say ' LOTUS Freelance Graphics'
say ' ------------------------'
say

/** Setup Miscellaneous Variables **/
call RxFuncAdd 'RXCLS',    'RXUTILS', 'RXCLS'
call RxFuncAdd 'RXGREP',   'RXUTILS', 'RXGREP'
call RxFuncAdd 'RXPAUSE',  'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI', 'RXUTILS', 'RXOS2INI'
parse source . . filespec        /* Get the drive, dir and name of  exec   */
LicAlias='LOTUSLOT'              /* Don't touch this one                   */
Env='OS2ENVIRONMENT'             /* Set the REXX environment variable      */
olddir=directory()               /* Get current directory                  */
pdir=GetPersonal()               /* Get personal Lotus dir var if  exists  */
Inst123G = RxOS2Ini( , '123G_FLG', 'INSTALL_123G')
InstFLG  = RxOS2Ini( , '123G_FLG', 'INSTALL_FLG')

/** If Personal directory not in CONFIG.SYS then exit error **/
if pdir='' then do
 say d2c(7)||d2c(7)
 say ' Cannot determine LOTUS Personal Directory.  Please run the'
 say ' installation program for this package then try again.'; say
 'pause'
 'exit'
end

/***********************************************************
** Assign License Drive:                                  **
** Replace this section of code with NET USE if your site **
** does not wish to use GIME.                             **
***********************************************************/
say ' Initializing LOTUS License Drive...'
do queued(); pull .; end
'gime 'LicAlias' | RXQUEUE'
parse upper pull 'THE NETNAME ' . ' ASSIGNED TO DRIVE ' drive
if drive='' then do
  say d2c(7)
  say ' Error assigning LOTUS License Drive.'
  say ' Please contact an OS/2 Consultant.'; say
  'pause'
  'exit'
end

/** Setup new path **/
call value 'DPATH', drive';'value('DPATH', ,Env), Env

/** Setup new directory to run from location of this exec **/
call directory left(filespec, lastpos('\', filespec)-1)

/** Start the program **/
if Package<>'QUIT' then do
  say
  say ' LOTUS FL/G is starting.  Please wait...'
  say
  say ' Please do not terminate this session.  It will be hidden'
  say ' automatically...'
  'START HIDEWIN /D=20 Lotus FL/G'
  'FLG presentation'
end

/** Drop the license drive (don't have a COW if this fails) **/
say ' Exiting...'
call directory olddir
'gime 'LicAlias' /d>nul'
'exit'

/************************************************************
** GetPersonal()                                           **
**                                                         **
** Returns the Lotus Personal Env Var as specified in      **
** the CONFIG.SYS.  This is needed as the user may change  **
** this and we would rather not force a reboot to activate **
** it.                                                     **
**                                                         **
** Also sets the current LOTUSPERSONAL to that set in the  **
** CONFIG.SYS (JIC).                                       **
************************************************************/
GetPersonal:
 if RxGrep('SET LOTUSPERSONAL=',RxBootDrive()'\CONFIG.SYS', 'grep')=0 then
   if grep.0>0 then
     pdir=space(substr(grep.1, pos('=', grep.1)+1))
   else
     pdir=''
 call value 'LOTUSPERSONAL', pdir, Env
return pdir
