/********************************************************************
** LIBPATH Editing Utility                                         **
*********************************************************************
:help.

  LIBEDIT Ver 1.00

  Copyright IBM Corp. 1990, 1992.  All rights reserved.

  Purpose: This exec is useful for general editting of the
           LIBPATH statement.

  Syntax:  LIBEDIT entry oper [pos]

  Where:   entry      - The directory spec to work with.

           oper       - Operation to be performed:
                         ADD    (A for short)
                         DELETE (D for short)
                         QUERY  (Q for short)

           pos        - The position of the new entry to be
                        added (used by ADD operation only):
                         BEGIN  (B for short)
                         END    (E for short)


  RC:      0          (ADD)    Added successfully
           2          (ADD)    Nothing added, entry already exists.
           0          (DELETE) Deleted successfully.
           2          (DELETE) Nothing deleted, entry did not exist.
           0          (QUERY)  The entry exists.
           2          (QUERY)  The entry does not exist.

  Return code also stored in LIBEDIT.RC environment variable.
:ehelp.
********************************************************************/
parse upper arg Entry Oper Pos .
'@echo off'
trace 'o'

/************************************/
/** Add external RXUTILS functions **/
/************************************/
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/******************************/
/** Check if user needs help **/
/******************************/
Oper=left(Oper,1)
Pos=left(Pos,1)
if Entry='?' | Entry='??' | Entry='' | pos(Oper, 'ADQ')=0 then
 call GiveHelp

/******************************/
/** Condition the parameters **/
/******************************/
Oper = left(Oper, 1)
if Pos<>'' then Pos=left(Pos, 1)

/****************************************************/
/** Read the file and figure out what line number  **/
/** the LIBPATH statement is in.                   **/
/****************************************************/
Dirty='N'
if right(Entry, 1)<>';' then Entry=Entry';'
bdr = RxBootDrive()
call RxRead bdr'\CONFIG.SYS', 'FILE'
call RxGrep 'LIBPATH=', bdr'\CONFIG.SYS', 'GREP', 'N'
string=''; i=GREP.0
do while left(string,7)<>'LIBPATH=' & i>0
   parse upper var GREP.i num string
   i=i-1
end

/****************************************/
/** Figure out just where the entry is **/
/** if it is in the LIBATH at all.     **/
/****************************************/
tpos = pos(Entry, FILE.num)
if tpos<>0 then do
   bChar=substr(FILE.num, tpos-1, 1)
   if pos(bChar, '=;')<>0 then RetC=0
   else RetC=2
 end
else RetC=2

/****************************************/
/** Perform the needed operation.      **/
/****************************************/
select
  when Oper='A' then do
    if RetC=2 then do
      oldpath = substr(FILE.num, pos('=', FILE.num)+1)
      if right(oldpath, 1)<>';' then oldpath=oldpath';'
      oldcmd = left(FILE.num, pos('=', FILE.num))
      if Pos='B' then
        FILE.num = oldcmd||Entry||oldpath
      else
        FILE.num = oldcmd||oldpath||Entry
      Dirty='Y'
      RetC=0
    end
    else RetC=2
  end
  when Oper='D' then
    if RetC=0 then do
      FILE.num=left(FILE.num, tpos-1)||substr(FILE.num, tpos+length(Entry))
      Dirty='Y'
    end
  otherwise     /* Do nothing, querying stuff already done */
end

/****************************************/
/** Save the file if needed then exit  **/
/** with the return code.              **/
/****************************************/
if Dirty='Y' then
 call RxWrite bdr'\CONFIG.SYS', 'FILE', file.0, 1

call value 'LIBEDIT.RC', RetC, 'OS2ENVIRONMENT'

exit RetC





/********************************************************************
** GiveHelp()                                                      **
**                                                                 **
** Purpose:  Provide syntax help for the user.                     **
********************************************************************/
GiveHelp: procedure

i=2
do until sourceline(i-1)=':help.'
  i=i+1
end
j=1
do until sourceline(i)=':ehelp.'
  say sourceline(i)
  if j=20 then do
    say; say '--MORE--'
    call RxGetKey
    j=0
  end
  i=i+1
  j=j+1
end
exit 0
