;***	VVD.INC
;
;
;	MVDM Virtual Video Exported Definitions
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;	For include file hierarchy, see MVDM.INC
;
;	Options:
;	    INCL_VIDEO	    include all video definitions
;	    INCL_VIDEOHW    include hardware-dependent definitions
;	    INCL_VIDEOVDD   include VDD-support definitions
;
;
;	MODIFICATION HISTORY
;	10/11/88    JTP	    Created.
;  XGA	04/22/91    TPL	    XGA enhancements to control whether VGA should
;			    save/restore the video state on a single XGA
;			    configuration system (i.e. P75 or PS/2 with
;			    monitor attached only to the XGA) where the
;			    XGA boots up in VGA mode.
;	05/07/91    RCW
;
;		    Changed all occurences of the single line comment
;		    notation to the standard notation to allow users to
;		    maintain ANSI compatibility.  This is in response to
;		    PTR B718526.  All future updates to this and all other
;		    header files should use the standard commenting format.
;  @025 03/14/92    TPL		      Add VDHRegisterInt2FProc for VVGA
;  @038 03/27/92    TPL	 PTRB735007 - avoid screen corruption on Starlight
;  @DDE 05/18/92    TPL	 D	    - Add event for DDE support
;  @049 09/02/92    TPL	 24749	    - Restrict 4K access to the MONO card
;  @054 03/09/93    YEE	 63354	    - Add more DEVREQ constants
;  @055 03/30/93    Senja 65283	    - Add more DEVREQ constants
;


ifndef INCL_NONE	       ;include everything by default
INCL_VIDEO	EQU 1
endif

ifdef  INCL_VIDEO
INCL_VIDEOHW	EQU 1
INCL_VIDEOPTR	EQU 1
INCL_VIDEOSYSREQ	EQU 1
INCL_VIDEODEVREQ	EQU 1
INCL_VIDEOINTERFACES	EQU 1		;@025
endif

ifdef INCL_VIDEOPTR
	include	vmd.inc
endif


ifdef  INCL_VIDEOHW

;***	Extended (non-BIOS) EGA _INT 10h functions
;

INT10_EGAREADONE	EQU	0F0h	    ;Read one EGA reg
INT10_EGAWRITEONE	EQU	0F1h	    ;Write one EGA reg
INT10_EGAREADRANGE	EQU	0F2h	    ;Read multiple EGA regs
INT10_EGAWRITERANGE	EQU	0F3h	    ;Write multiple EGA regs
INT10_EGAREADSET	EQU	0F4h	    ;Read set of EGA regs
INT10_EGAWRITESET	EQU	0F5h	    ;Write set of EGA regs
INT10_EGAREVERTDEF	EQU	0F6h	    ;Revert to default
INT10_EGADEFINEDEF	EQU	0F7h	    ;Define default
INT10_EGAQUERYDEF	EQU	0F8h	    ;Query default
INT10_EGACONTEXT	EQU	0F9h	    ;Get context information
INT10_EGAINQUIRE	EQU	0FAh	    ;Get EGA driver version

INT10_EGAFIRST	EQU	<INT10_EGAREADONE>
INT10_EGALAST	EQU	<INT10_EGAINQUIRE>


; Default physical memory locations
;

PLANE0	EQU	0
PLANE1	EQU	1
PLANE2	EQU	2
PLANE3	EQU	3

MONOMEM_START	EQU	0B0000h
MONOMEM_LEN	EQU	(4*1024)				    ;@049
ifdef  PAGESIZE
MONOMEM_PAGES	EQU	(MONOMEM_LEN/PAGESIZE)
endif

CGAMEM_START	EQU	0B8000h
CGAMEM_LEN	EQU	(16*1024)
ifdef  PAGESIZE
CGAMEM_PAGES	EQU	(CGAMEM_LEN/PAGESIZE)
endif

EGAVGAMEM_START		EQU	0A0000h
EGAVGAMEM_LEN	EQU	(128*1024)
ifdef  PAGESIZE
EGAVGAMEM_PAGES		EQU	(EGAVGAMEM_LEN/PAGESIZE)
endif


;  Hardware ports
;
;   All are single-register ports unless otherwise specified
;   All single-register ports are W/O unless VGA or otherwise specified
;

PORT_ATIVGA_INDX	EQU	01CEh	    ;used by ATI VGA Wonder
PORT_ATIVGA_DATA	EQU	01CFh	    ;used by ATI VGA Wonder
PORT_MONOCRTINDX	EQU	03B4h
PORT_MONOCRTDATA	EQU	03B5h	    ;multi-register port
PORT_MONOMODE	EQU	03B8h	    ;usually shadowed at uBiosVModeByte
PORT_MONOLPENSET	EQU	03B9h
PORT_MONOSTATUS1	EQU	03BAh	    ;(R/O)
PORT_MONOFEATURE	EQU	03BAh	    ;(W/O)
PORT_MONOLPENRESET	EQU	03BBh
PORT_ATC0	EQU	03C0h
PORT_ATC1	EQU	03C1h	    ;on VGA, distinct from ATC0 and R/O
PORT_STATUS0	EQU	03C2h	    ;(R/O)
PORT_MISCOUT	EQU	03C2h	    ;reset sequencer before writing
PORT_VGAENABLE	EQU	03C3h
PORT_SEQINDX	EQU	03C4h
PORT_SEQDATA	EQU	03C5h	    ;multi-register port
PORT_COMPAQ_CTRL	EQU	03C6h
PORT_VGADACMASK		EQU	03C6h	    ;initialized to 0FFh, leave alone
PORT_VGADACREAD		EQU	03C7h	    ;State , Index to read (W)
PORT_VGADACWRITE	EQU	03C8h	    ;Index to write (R/W)
PORT_VGADACDATA		EQU	03C9h	    ;multi-register port
PORT_GDCPOS2	EQU	03CAh	    ;on VGA, R/O (returns FEATURE)
PORT_ATIEGA_INDX	EQU	03CBh	    ;used by ATI EGA Wonder
PORT_GDCPOS1	EQU	03CCh	    ;on VGA, R/O (returns MISCOUT)
PORT_ATIEGA_DATA	EQU	03CDh	    ;used by ATI EGA Wonder
PORT_GDCINDX	EQU	03CEh
PORT_GDCDATA	EQU	03CFh	    ;multi-register port
PORT_COLRCRTINDX	EQU	03D4h
PORT_COLRCRTDATA	EQU	03D5h	    ;multi-register port
PORT_CGAMODE	EQU	03D8h	    ;usually shadowed at uBiosVModeByte
PORT_CGACOLOR	EQU	03D9h	    ;usually shadowed at uBiosVColorByte
PORT_COLRSTATUS1	EQU	03DAh	    ;(R/O)
PORT_COLRFEATURE	EQU	03DAh	    ;(W/O)
PORT_CGALPENRESET	EQU	03DBh
PORT_CGALPENSET		EQU	03DCh
PORT_COMPAQ_ENV		EQU	07C6h	    ;(R/O)
PORT_COMPAQ_DSP		EQU	0BC6h	    ;(R/O)
PORT_IBMP70_INDX	EQU	0D00h	    ;special port for plasma display?
PORT_IBMP70_DATA	EQU	0D01h	    ;special port for plasma display?
PORT_COMPAQ_MODE	EQU	0FC6h	    ;(R/O)

; 8514/A Display Controller registers (word registers unless noted otherwise)
;
A8514_DSPSTAT	EQU	002E8h	    ;(R/O)
DSPSTAT_PALSTAT		EQU	00001h
DSPSTAT_VERTRTRC	EQU	00002h
DSPSTAT_HORZRTRC	EQU	00004h
A8514_HORZTOTAL		EQU	002E8h	    ;(W/O)
A8514_DACMASK	EQU	002EAh	    ;pixel planes displayed   (R/W-byte)
A8514_DACREADINDEX	EQU	002EBh	    ;DAC data reg/mode select (R/W-byte)
A8514_DACWRITEINDEX	EQU	002ECh	    ;DAC data reg/mode select (R/W-byte)
A8514_DACDATA	EQU	002EDh	    ;DAC data register	      (R/W-byte)
A8514_HORZDSP	EQU	006E8h	    ;(W/O)
A8514_HORZSSTART	EQU	00AE8h	    ;(W/O)
A8514_HORZSWIDTH	EQU	00EE8h	    ;(W/O)
A8514_VERTTOTAL		EQU	012E8h	    ;(W/O)
A8514_VERTDSP	EQU	016E8h	    ;(W/O)
A8514_VERTSSTART	EQU	01AE8h	    ;(W/O)
A8514_VERTSWIDTH	EQU	01EE8h	    ;(W/O)
A8514_DSPCTRL	EQU	022E8h	    ;(W/O)
DSPCTRL_ODDEVEN		EQU	00001h
DSPCTRL_CAS2	EQU	00000h	;this implies 4-plane setting
DSPCTRL_CAS4	EQU	00002h	;this implies 8-plane setting
DSPCTRL_CAS6	EQU	00004h
DSPCTRL_CAS8	EQU	00006h
DSPCTRL_CASMASK		EQU	00006h
DSPCTRL_SCANDBL		EQU	00008h
DSPCTRL_INTERLACE	EQU	00010h
DSPCTRL_DSPENABLE	EQU	00020h
DSPCTRL_DSPDISABLE	EQU	00040h
DSPCTRL_DSPCTRLMASK	EQU	00060h

; 8514/A Configuration/Status registers (word registers unless noted otherwise)
;
A8514_SUBSYSCTRL	EQU	042E8h	    ;(W/O)
SUBCTRL_RESETVERTF	EQU	00001h
SUBCTRL_RESETDTR	EQU	00002h
SUBCTRL_RESETQFULL	EQU	00004h
SUBCTRL_RESETGPIDLE	EQU	00008h
SUBCTRL_INTONVERTF	EQU	00100h
SUBCTRL_INTONDTR	EQU	00200h
SUBCTRL_INTONQFULL	EQU	00400h
SUBCTRL_INTONGPIDLE	EQU	00800h
SUBCTRL_PIXENABLE	EQU	01000h
SUBCTRL_PIXDISABLE	EQU	02000h
SUBCTRL_PIXCTRLMASK	EQU	03000h
SUBCTRL_SEQENABLE	EQU	04000h
SUBCTRL_SEQDISABLE	EQU	08000h
SUBCTRL_SEQCTRLMASK	EQU	0C000h
A8514_SUBSYSSTATUS	EQU	042E8h	    ;(R/O)
SUBSTATUS_VERTF		EQU	00001h
SUBSTATUS_DTR	EQU	00002h
SUBSTATUS_QFULL		EQU	00004h
SUBSTATUS_GPIDLE	EQU	00008h
SUBSTATUS_MONITORID	EQU	00070h
SUBSTATUS_8503	EQU	00050h
SUBSTATUS_8512_3	EQU	00060h
SUBSTATUS_8514	EQU	00020h
SUBSTATUS_MONOCHROME	EQU	00010h
SUBSTATUS_NOT8514	EQU	00040h
SUBSTATUS_MEMORYOPT	EQU	00080h
A8514_ROMPAGESELECT	EQU	046E8h	    ;(W/O)
A8514_ADVCTRL	EQU	04AE8h	    ;(W/O)
ADVCTRL_VGADISABLE	EQU	00001h
ADVCTRL_OUTPUTPIN	EQU	00002h
ADVCTRL_DOTCLOCK	EQU	00004h	;0 implies 640x480 mode

; 8514/A Graphics Processor registers (word registers unless noted otherwise)
;
A8514_COMMAND	EQU	09AE8h	    ;(W/O)
COMMAND_WRITE	EQU	00001h	;0 implies read function
COMMAND_PLANAR	EQU	00002h	;0 implies pixel-access mode
COMMAND_LASTPIXNULL	EQU	00004h	;0 implies last pixel will be drawn
COMMAND_STROKEALG	EQU	00008h	;0 implies H/W line-drawing algorithm
COMMAND_DRAW	EQU	00010h	;0 implies move current position only
COMMAND_INCX	EQU	00020h	;0 implies decrement X
COMMAND_MAJORY	EQU	00040h	;0 implies X is major axis
COMMAND_INCY	EQU	00080h	;0 implies decrement Y
COMMAND_PCDATAXFER	EQU	00100h	;0 implies no PC intervention
COMMAND_PCDATA16BIT	EQU	00200h	;0 implies base pixel count per access
COMMAND_PIXEL16BIT	EQU	00400h	;0 implies 8-bit pixel transfers
COMMAND_SWAPBYTES	EQU	01000h	;0 implies even pixels from low bytes
COMMAND_FUN_NONE	EQU	00000h
COMMAND_FUN_LINE	EQU	02000h
COMMAND_FUN_FILLX	EQU	04000h
COMMAND_FUN_FILLY	EQU	06000h
COMMAND_FUN_FILL	EQU	08000h
COMMAND_FUN_AXIALLINE	EQU	0A000h
COMMAND_FUN_COPY	EQU	0C000h
COMMAND_FUNMASK		EQU	0F000h
A8514_STATUS	EQU	09AE8h	    ;(R/O)
STATUS_QUEUE1_INUSE	EQU	00001h
STATUS_QUEUE2_INUSE	EQU	00002h
STATUS_QUEUE3_INUSE	EQU	00004h
STATUS_QUEUE4_INUSE	EQU	00008h
STATUS_QUEUE5_INUSE	EQU	00010h
STATUS_QUEUE6_INUSE	EQU	00020h
STATUS_QUEUE7_INUSE	EQU	00040h
STATUS_QUEUE8_INUSE	EQU	00080h
STATUS_DATA_AVAILABLE	EQU	00100h
STATUS_COMMAND_ACTIVE	EQU	00200h

; 8514/A Coordinate registers (word registers unless noted otherwise)
;
A8514_CURRENTY	EQU	082E8h	    ;(R/W)
A8514_CURRENTX	EQU	086E8h	    ;(R/W)
A8514_DESTY_AXSTP	EQU	08AE8h	    ;(W/O)
A8514_DESTX_DIASTP	EQU	08EE8h	    ;(W/O)
A8514_ERRORTERM		EQU	092E8h	    ;suitable for presence test (R/W)
A8514_MAJORAXISCNT	EQU	096E8h	    ;(W/O)

; 8514/A Multi-function control registers (word registers unless noted otherwise)
;
A8514_MULTIFUNCTION	EQU	0BEE8h	    ;(W/O)
MFINDX_MINORAXISCNT	EQU	00000h
MFINDX_TOPSCISSORS	EQU	01000h
MFINDX_LEFTSCISSORS	EQU	02000h
MFINDX_BOTTOMSCISSORS	EQU	03000h
MFINDX_RIGHTSCISSORS	EQU	04000h
MFINDX_MEMORYCTRL	EQU	05000h
MEMCTRL_WRITE4	EQU	00000h
MEMCTRL_WRITE5	EQU	00001h
MEMCTRL_WRITE8	EQU	00002h
MEMCTRL_WRITE10		EQU	00003h
MEMCTRL_WRITEMASK	EQU	00003h
MEMCTRL_CAS2	EQU	00000h	;this implies 4-plane setting
MEMCTRL_CAS4	EQU	00004h	;this implies 8-plane setting
MEMCTRL_CAS6	EQU	00008h
MEMCTRL_CAS8	EQU	0000Ch
MEMCTRL_CASMASK		EQU	0000Ch
MEMCTRL_CASSWAP		EQU	00010h
MFINDX_PATTERNLOW	EQU	08000h
MFINDX_PATTERNHIGH	EQU	09000h
MFINDX_PIXELCTRL	EQU	0A000h
PIXELCTRL_5PIXELROTATE	EQU	00001h
PIXELCTRL_MASKSELECT	EQU	00002h
PIXELCTRL_PLANAR	EQU	00004h
PIXELCTRL_COLORFALSE	EQU	00000h
PIXELCTRL_COLORTRUE	EQU	00008h
PIXELCTRL_COLORGE	EQU	00010h
PIXELCTRL_COLORLT	EQU	00018h
PIXELCTRL_COLORNE	EQU	00020h
PIXELCTRL_COLOREQ	EQU	00028h
PIXELCTRL_COLORLE	EQU	00030h
PIXELCTRL_COLORGT	EQU	00038h
PIXELCTRL_MIXFGND	EQU	00000h
PIXELCTRL_FIXEDPATTERN	EQU	00040h
PIXELCTRL_PLANARWRITE	EQU	00080h
PIXELCTRL_SINGLEPLANE	EQU	000C0h
MFINDX_INDXMASK		EQU	0F000h
MFINDX_DATAMASK		EQU	00FFFh
MFINDX_INDXSHIFT	EQU	12
MFINDX_INDXTOTAL	EQU	16

; 8514/A Pixel processing registers (word registers unless noted otherwise)
;
A8514_SHORTSTROKE	EQU	09EE8h	    ;(W/O)
A8514_BGNDCOLOR		EQU	0A2E8h	    ;(W/O)
A8514_FGNDCOLOR		EQU	0A6E8h	    ;(W/O)
A8514_WRITEMASK		EQU	0AAE8h	    ;(W/O)
A8514_READMASK	EQU	0AEE8h	    ;(W/O)
A8514_COLORCOMPARE	EQU	0B2E8h	    ;(W/O)
A8514_BGNDMIX	EQU	0B6E8h	    ;(W/O)
A8514_FGNDMIX	EQU	0BAE8h	    ;(W/O)
FGNDMIX_SOURCE	EQU	00007h
FGNDMIX_BGNDCLR		EQU	00000h
FGNDMIX_FGNDCLR		EQU	00020h
FGNDMIX_PIXELDATA	EQU	00040h
FGNDMIX_PLANECOPY	EQU	00060h
A8514_PIXELTRANSFER	EQU	0E2E8h	    ;(R/W)

; XGA I/O Registers (all byte registers)

AXGA_OPERATING_MODE	EQU	0  ;private indexes into
AXGA_APERTURE_CONTROL	EQU	1  ;  awregXGAIOReg[].  See
AXGA_RESERVED1	EQU	2  ;  VVXGAREGS structure
AXGA_RESERVED2	EQU	3  ;  definition in VVXGAP.INC
AXGA_INTERRUPT_ENABLE	EQU	4  ;  for detail
AXGA_INTERRUPT_STATUS	EQU	5
AXGA_VIRTUAL_MEMORY_CONTROLLER	EQU	6
AXGA_VIRTUAL_MEMORY_INT_STATUS	EQU	7
AXGA_APERTURE_INDEX	EQU	8
AXGA_MEMORY_ACCESS_MODE		EQU	9
AXGA_INDEX_SELECT	EQU	10
AXGA_INDEX_DATA_B	EQU	11
AXGA_INDEX_DATA_C	EQU	12
AXGA_INDEX_DATA_D	EQU	13
AXGA_INDEX_DATA_E	EQU	14
AXGA_INDEX_DATA_F	EQU	15
AXGA_TOTAL	EQU	16

; XGA Index Registers (all byte register)
AINDX_RESERVED0		EQU	00000h	 ;(R/W)
AINDX_RESERVED1		EQU	00001h	 ;(R/O)
AINDX_RESERVED2		EQU	00002h	 ;(R/O)
AINDX_RESERVED3		EQU	00003h	 ;(R/O)
AINDX_AUTOCONFIG	EQU	00004h	 ;(R/O)
AINDX_RESERVED5		EQU	00005h	 ;(R/O)
AINDX_RESERVED6		EQU	00006h	 ;(R/O)
AINDX_RESERVED7		EQU	00007h	 ;(R/O)
AINDX_RESERVED8		EQU	00008h	 ;(R/O)
AINDX_RESERVED9		EQU	00009h	 ;(R/O)
AINDX_RESERVEDa		EQU	0000ah	 ;(R/O)
AINDX_RESERVEDb		EQU	0000bh	 ;(R/O)
AINDX_COPROCSAVERESTOREA	EQU	0000ch	 ;(R/O)
AINDX_COPROCSAVERESTOREB	EQU	0000dh	 ;(R/O)
AINDX_RESERVEDe		EQU	0000eh	 ;(R/O)
AINDX_RESERVEDf		EQU	0000fh	 ;(R/O)
AINDX_HORZTOTALLO	EQU	00010h	 ;(R/W)
AINDX_HORZTOTALHI	EQU	00011h	 ;(R/W)
AINDX_HORZDISPENDLO	EQU	00012h	 ;(R/W)
AINDX_HORZDISPENDHI	EQU	00013h	 ;(R/W)
AINDX_HORZBLANKINGSTARTLO	EQU	00014h	 ;(R/W)
AINDX_HORZBLANKINGSTARTHI	EQU	00015h	 ;(R/W)
AINDX_HORZBLANKINGENDLO		EQU	00016h	 ;(R/W)
AINDX_HORZBLANKINGENDHI		EQU	00017h	 ;(R/W)
AINDX_HORZSYNCPULSESTARTLO	EQU	00018h	 ;(R/W)
AINDX_HORZSYNCPULSESTARTHI	EQU	00019h	 ;(R/W)
AINDX_HORZSYNCPULSEENDLO	EQU	0001ah	 ;(R/W)	   132 Column Reg
AINDX_HORZSYNCPULSEENDHI	EQU	0001bh	 ;(R/W)	   132 Column Reg
AINDX_HORZSYNCPOSITION1		EQU	0001ch	 ;(W/O)
AINDX_RESERVED1d	EQU	0001dh	 ;(R/O)
AINDX_HORZSYNCPOSITION2		EQU	0001eh	 ;(W/O)
AINDX_RESERVED1f	EQU	0001fh	 ;(R/O)
AINDX_VERTTOTALLO	EQU	00020h	 ;(R/W)
AINDX_VERTTOTALHI	EQU	00021h	 ;(R/W)
AINDX_VERTDISPENDLO	EQU	00022h	 ;(R/W)
AINDX_VERTDISPENDHI	EQU	00023h	 ;(R/W)
AINDX_VERTBLANKINGSTARTLO	EQU	00024h	 ;(R/W)
AINDX_VERTBLANKINGSTARTHI	EQU	00025h	 ;(R/W)
AINDX_VERTBLANKINGENDLO		EQU	00026h	 ;(R/W)
AINDX_VERTBLANKINGENDHI		EQU	00027h	 ;(R/W)
AINDX_VERTSYNCPULSESTARTLO	EQU	00028h	 ;(R/W)
AINDX_VERTSYNCPULSESTARTHI	EQU	00029h	 ;(R/W)
AINDX_VERTSYNCPULSEEND	EQU	0002ah	 ;(R/W)	   132 Column Reg
AINDX_RESERVED2b	EQU	0002bh	 ;(R/O)
AINDX_VERTLINECOMPLO	EQU	0002ch	 ;(R/W)
AINDX_VERTLINECOMPHI	EQU	0002dh	 ;(R/W)
AINDX_RESERVED2e	EQU	0002eh	 ;(R/O)
AINDX_RESERVED2f	EQU	0002fh	 ;(R/O)
AINDX_SPRITEHORZSTARTLO		EQU	00030h	 ;(R/W)
AINDX_SPRITEHORZSTARTHI		EQU	00031h	 ;(R/W)
AINDX_SPRITEHORZPRESET	EQU	00032h	 ;(R/W)
AINDX_SPRITEVERTSTARTLO		EQU	00033h	 ;(R/W)
AINDX_SPRITEVERTSTARTHI		EQU	00034h	 ;(R/W)
AINDX_SPRITEVERTPRESET	EQU	00035h	 ;(R/W)
AINDX_SPRITECONTROL	EQU	00036h	 ;(R/W)
AINDX_RESERVED37	EQU	00037h	 ;(R/O)
AINDX_SPRITECOLOR0RED	EQU	00038h	 ;(R/W)
AINDX_SPRITECOLOR0GREEN		EQU	00039h	 ;(R/W)
AINDX_SPRITECOLOR0BLUE	EQU	0003ah	 ;(R/W)
AINDX_SPRITECOLOR1RED	EQU	0003bh	 ;(R/W)
AINDX_SPRITECOLOR1GREEN		EQU	0003ch	 ;(R/W)
AINDX_SPRITECOLOR1BLUE	EQU	0003dh	 ;(R/W)
AINDX_RESERVED3e	EQU	0003eh	 ;(R/O)
AINDX_RESERVED3f	EQU	0003fh	 ;(R/O)
AINDX_DISPPIXELMAPOFFSETLO	EQU	00040h	 ;(R/W)
AINDX_DISPPIXELMAPOFFSETMI	EQU	00041h	 ;(R/W)
AINDX_DISPPIXELMAPOFFSETHI	EQU	00042h	 ;(R/W)
AINDX_DISPPIXELMAPWIDTHLO	EQU	00043h	 ;(R/W)
AINDX_DISPPIXELMAPWIDTHHI	EQU	00044h	 ;(R/W)
AINDX_RESERVED45	EQU	00045h	 ;(R/O)
AINDX_RESERVED46	EQU	00046h	 ;(R/O)
AINDX_RESERVED47	EQU	00047h	 ;(R/O)
AINDX_RESERVED48	EQU	00048h	 ;(R/O)
AINDX_RESERVED49	EQU	00049h	 ;(R/O)
AINDX_RESERVED4a	EQU	0004ah	 ;(R/O)
AINDX_RESERVED4b	EQU	0004bh	 ;(R/O)
AINDX_RESERVED4c	EQU	0004ch	 ;(R/O)
AINDX_RESERVED4d	EQU	0004dh	 ;(R/O)
AINDX_RESERVED4e	EQU	0004eh	 ;(R/O)
AINDX_RESERVED4f	EQU	0004fh	 ;(R/O)
AINDX_DISPCONTROL1	EQU	00050h	 ;(R/W)	   132 Column Reg
AINDX_DISPCONTROL2	EQU	00051h	 ;(R/W)
AINDX_DISPIDCOMPARATOR	EQU	00052h	 ;(R/O)
AINDX_MYSTERYREG	EQU	00053h	 ;(R/O)	   Referenced by AFI
AINDX_CLOCKFREQSELECT	EQU	00054h	 ;(R/W)	   132 Column Reg
AINDX_BORDERCOLOR	EQU	00055h	 ;(R/W)
AINDX_RESERVED56	EQU	00056h	 ;(R/O)
AINDX_RESERVED57	EQU	00057h	 ;(R/O)
AINDX_RESERVED58	EQU	00058h	 ;(R/O)
AINDX_RESERVED59	EQU	00059h	 ;(R/O)
AINDX_RESERVED5a	EQU	0005ah	 ;(R/O)
AINDX_RESERVED5b	EQU	0005bh	 ;(R/O)
AINDX_RESERVED5c	EQU	0005ch	 ;(R/O)
AINDX_RESERVED5d	EQU	0005dh	 ;(R/O)
AINDX_RESERVED5e	EQU	0005eh	 ;(R/O)
AINDX_RESERVED5f	EQU	0005fh	 ;(R/O)
AINDX_SPRITEPALETTEIDXLO	EQU	00060h	 ;(R/W)
AINDX_SPRITEIDXHI	EQU	00061h	 ;(R/W)
AINDX_SPRITEPALETTEIDXLOPREF	EQU	00062h	 ;(R/W)
AINDX_SPRITEIDXHIPREFETCH	EQU	00063h	 ;(R/W)
AINDX_PALETTEMASK	EQU	00064h	 ;(R/W)
AINDX_PALETTEDATA	EQU	00065h	 ;(R/W)
AINDX_PALETTESEQUENCE	EQU	00066h	 ;(R/W)
AINDX_PALETTEREDPREFETCH	EQU	00067h	 ;(R/W)
AINDX_PALETTEGREENPREFETCH	EQU	00068h	 ;(R/W)
AINDX_PALETTEBLUEPREFETCH	EQU	00069h	 ;(R/W)
AINDX_SPRITEDATA	EQU	0006ah	 ;(R/W)
AINDX_SPRITEPREFETCH	EQU	0006bh	 ;(R/W)
AINDX_RESERVED6c	EQU	0006ch	 ;(R/O)
AINDX_RESERVED6d	EQU	0006dh	 ;(R/O)
AINDX_RESERVED6e	EQU	0006eh	 ;(R/O)
AINDX_RESERVED6f	EQU	0006fh	 ;(R/O)
AINDX_EXTCLOCKSELECT	EQU	00070h	 ;(R/W)	   132 Column Reg

IRINDX_INDXTOTAL	EQU	00071h
IRINDX_INDXMASK		EQU	000FFh
IRINDX_DATAMASK		EQU	0FF00h
IRINDX_DATASHIFT	EQU	8


;  Registers indexed via multi-register ports
;
;   All are W/O unless VGA or otherwise specified
;

REG_ATCPALETTE	EQU	000h	    ;00h-0Fh are palette registers
REG_ATCMODECTRL		EQU	010h	    ;Compaq VGA: wait for vert retrace
REG_ATCOVERSCAN		EQU	011h
REG_ATCPLANEENABLE	EQU	012h
REG_ATCPELPANNING	EQU	013h
REG_ATCVGAREG	EQU	014h
TOTAL_EGA_ATCREGS	EQU	014h
TOTAL_IBM_ATCREGS	EQU	015h
TOTAL_TSENG_ATCREGS	EQU	018h

REG_SEQRESET	EQU	000h
REG_SEQCLKMODE	EQU	001h	    ;reset sequencer before writing
REG_SEQMAPMASK	EQU	002h
REG_SEQCHARMAPSEL	EQU	003h
REG_SEQMEMMODE	EQU	004h	    ;reset sequencer before writing
REG_SEQUNKNOWN_IBM1	EQU	007h
TOTAL_IBM_SEQREGS	EQU	005h
TOTAL_TSENG_SEQREGS	EQU	008h

REG_GDCSR	EQU	000h
REG_GDCESR	EQU	001h
REG_GDCCLRCMP	EQU	002h
REG_GDCROTATE	EQU	003h
REG_GDCREADMAP	EQU	004h
REG_GDCMODE	EQU	005h
REG_GDCMISC	EQU	006h	    ;reset sequencer before writing
REG_GDCDONTCARE		EQU	007h
REG_GDCBITMASK	EQU	008h
TOTAL_IBM_GDCREGS	EQU	009h
TOTAL_TSENG_GDCREGS	EQU	00Fh

REG_CRTHORZTOTAL	EQU	000h
REG_CRTHORZDSPEND	EQU	001h
REG_CRTHORZSTBLNK	EQU	002h
REG_CRTHORZENDBLNK	EQU	003h
REG_CRTHORZSTRTRC	EQU	004h
REG_CRTHORZENDRTRC	EQU	005h
REG_CRTVERTTOTAL	EQU	006h
REG_CRTOVERFLOW		EQU	007h
REG_CRTPRESETROW	EQU	008h
REG_CRTMAXSCAN	EQU	009h
REG_CRTCURSTSCAN	EQU	00Ah
REG_CRTCURENDSCAN	EQU	00Bh
REG_CRTSTARTADDRHI	EQU	00Ch	    ;R/W (W/O on CGA???)
REG_CRTSTARTADDRLO	EQU	00Dh	    ;R/W (W/O on CGA???)
REG_CRTCURLOCHI		EQU	00Eh	    ;R/W
REG_CRTCURLOCLO		EQU	00Fh	    ;R/W
REG_CRTVERTSTRTRC	EQU	010h
REG_CRTLPENHI	EQU	010h	    ;R/O (dual-purpose register index)
REG_CRTVERTENDRTRC	EQU	011h
REG_CRTLPENLO	EQU	011h	    ;R/O (dual-purpose register index)
REG_CRTVERTDSPEND	EQU	012h
REG_TSENG_CRTLPEN2	EQU	012h	    ;R/O (dual-purpose register index)
REG_CRTOFFSET	EQU	013h
REG_CRTUNDLINELOC	EQU	014h
REG_CRTVERTSTBLNK	EQU	015h
REG_CRTVERTENDBLNK	EQU	016h
REG_CRTMODECTRL		EQU	017h
REG_CRTLINECMP	EQU	018h
REG_CRTUNKNOWN_IBM1	EQU	03Fh
TOTAL_CGA_CRTREGS	EQU	013h
TOTAL_IBM_CRTREGS	EQU	019h
TOTAL_TSENG_CRTREGS	EQU	026h

TOTAL_DACREGS	EQU	256	    ;on VGA, there are 256 color registers


; Individual bits for registers
;

ATCPAL_ADDRMASK		EQU	001Fh
ATCPAL_ENABLE	EQU	0020h

SEQRESET_ASYNC	EQU	0001h
SEQRESET_SYNC	EQU	0002h

SEQCLK_8DOTS	EQU	0001h	    ;reset sequencer before writing
SEQCLK_CYCLES	EQU	0002h
SEQCLK_SHIFTLOAD	EQU	0004h
SEQCLK_DOTCLOCK		EQU	0008h	    ;reset sequencer before writing
SEQCLK_VGASHIFT4	EQU	0010h
SEQCLK_VGASCREENOFF	EQU	0020h

SEQMAP_PLANE0	EQU	0001h
SEQMAP_PLANE1	EQU	0002h
SEQMAP_PLANE2	EQU	0004h
SEQMAP_PLANE3	EQU	0008h
SEQMAP_ALL	EQU	(SEQMAP_PLANE0 OR SEQMAP_PLANE1 OR  \
			     SEQMAP_PLANE2 OR SEQMAP_PLANE3)

SEQMEM_ALPHA	EQU	0001h
SEQMEM_EXTENDED		EQU	0002h
SEQMEM_ODDEVENSAME	EQU	0004h	    ;otherwise, even->0/2, odd->1/3
SEQMEM_CHAIN4	EQU	0008h	    ;low 2 bits select plane
SEQMEM_ALL	EQU	(SEQMEM_ALPHA OR SEQMEM_EXTENDED OR SEQMEM_ODDEVENSAME OR SEQMEM_CHAIN4)

GDCSR_PLANE0	EQU	0001h
GDCSR_PLANE1	EQU	0002h
GDCSR_PLANE2	EQU	0004h
GDCSR_PLANE3	EQU	0008h
GDCSR_ALL	EQU	(GDCSR_PLANE0 OR GDCSR_PLANE1 OR  \
			     GDCSR_PLANE2 OR GDCSR_PLANE3)
GDCESR_ALL	EQU	<GDCSR_ALL>

GDCCLRCMP_ALL	EQU	000Fh

GDCROTATE_COUNT		EQU	0007h
GDCROTATE_AND	EQU	0008h
GDCROTATE_OR	EQU	0010h
GDCROTATE_XOR	EQU	0018h
GDCROTATE_NOFUNC	EQU	0000h
GDCROTATE_ALL	EQU	(GDCROTATE_COUNT OR GDCROTATE_AND OR GDCROTATE_OR OR  \
			     GDCROTATE_XOR)

GDCREADMAP_ALL	EQU	(PLANE0 OR PLANE1 OR PLANE2 OR PLANE3)

GDCMODE_WRITE0	EQU	0000h
GDCMODE_WRITE1	EQU	0001h
GDCMODE_WRITE2	EQU	0002h
GDCMODE_WRITE3	EQU	0003h	    ;only on a VGA
GDCMODE_TEST	EQU	0004h
GDCMODE_READ0	EQU	0000h
GDCMODE_READ1	EQU	0008h
GDCMODE_ODDEVENDIFF	EQU	0010h
GDCMODE_ODDEVENBITS	EQU	0020h
GDCMODE_256COLOR	EQU	0040h	    ;only on a VGA
GDCMODE_ALL	EQU	(GDCMODE_WRITE3 OR GDCMODE_TEST OR GDCMODE_READ1 OR  \
			     GDCMODE_ODDEVENDIFF OR GDCMODE_ODDEVENBITS OR GDCMODE_256COLOR)

GDCMISC_NOCHARGEN	EQU	0001h
GDCMISC_ODDTOEVEN	EQU	0002h
GDCMISC_64K_A0000	EQU	0004h
GDCMISC_32K_B0000	EQU	0008h
GDCMISC_32K_B8000	EQU	000Ch
GDCMISC_128K_A0000	EQU	0000h
GDCMISC_ADDRMASK	EQU	000Ch
GDCMISC_ALL	EQU	(GDCMISC_NOCHARGEN OR GDCMISC_ODDTOEVEN OR GDCMISC_32K_B8000)

GDCDONTCARE_ALL		EQU	000Fh

GDCBITMASK_ALL	EQU	00FFh

CRTOVFL_VERTTOTAL	EQU	0001h
CRTOVFL_VERTDSPEND	EQU	0002h
CRTOVFL_VERTSTRTRC	EQU	0004h
CRTOVFL_VERTSTBLNK	EQU	0008h
CRTOVFL_LINECMP		EQU	0010h
CRTOVFL_CURLOC	EQU	0020h

CRTMAXSCAN_200CONV	EQU	0080h	    ;VGA bit for 200->400 conversion

CRTMCTRL_COMPAT		EQU	0001h	    ;CRT compatibility mode (8K disp.)


MISCOUT_COLRPORTS	EQU	0001h	    ;select 3Dx (or possibly 2Dx) ports
MISCOUT_ENABLERAM	EQU	0002h
MISCOUT_CLKSELECT	EQU	000Ch	    ;reset sequencer before writing
MISCOUT_DISABLEDRV	EQU	0010h
MISCOUT_HIGHPAGE	EQU	0020h
MISCOUT_NEGHORZRTRC	EQU	0040h
MISCOUT_NEGVERTRTRC	EQU	0080h

STATUS1_HORZRTRC	EQU	0001h	    ;very frequent, but very short
STATUS1_LPENSTROBE	EQU	0002h
STATUS1_LPENSWITCH	EQU	0004h
STATUS1_VERTRTRC	EQU	0008h	    ;less frequent, but much longer
STATUS1_ATCOUTPUT1	EQU	0010h
STATUS1_ATCOUTPUT2	EQU	0020h


MONOMODE_HIRES	EQU	0001h	    ;must always be set
MONOMODE_ENABLE		EQU	0008h
MONOMODE_BLINK	EQU	0020h

CGAMODE_80X25	EQU	0001h
CGAMODE_320X200		EQU	0002h
CGAMODE_BW	EQU	0004h
CGAMODE_ENABLE	EQU	0008h
CGAMODE_640X200		EQU	0010h
CGAMODE_BLINK	EQU	0020h

CGACOLOR_BORDER		EQU	000Fh	    ;border in modes 0/1/2/3, bgnd in 4/5
CGACOLOR_INTENSE	EQU	0010h
CGACOLOR_SET	EQU	0020h

endif  ;INCL_VIDEOHW


ifdef INCL_VIDEOPTR

; Define current pointer-draw limitations
;

PTRSAVWD	EQU	(MAX_PTRWIDTH+1)
PTRSAVHT	EQU	(MAX_PTRHEIGHT)
PTRSAVSIZE	EQU	(PTRSAVWD*PTRSAVHT)

BYTEPTRSAVWD	EQU	(PTRSAVWD*8)
BYTEPTRSAVHT	EQU	(PTRSAVHT*1)
BYTEPTRSAVSIZE	EQU	(BYTEPTRSAVWD*BYTEPTRSAVHT)

SCRSAVWD	EQU	(PTRSAVWD+2)
SCRSAVHT	EQU	(PTRSAVHT+4)
SCRSAVSIZE	EQU	(SCRSAVWD*SCRSAVHT)

BYTESCRSAVWD	EQU	(SCRSAVWD*8)
BYTESCRSAVHT	EQU	(SCRSAVHT*1)
BYTESCRSAVSIZE	EQU	(BYTESCRSAVWD*BYTESCRSAVHT)


; Define EGA/VGA off-screen memory usage
;

OFFSCREEN0D	EQU	((320/8)*200)
OFFSCREEN0E	EQU	((640/8)*200)
OFFSCREEN10	EQU	((640/8)*350)
OFFSCREEN12	EQU	((640/8)*480)
OFFSCREEN13	EQU	((320/1)*200)

SIZBASIC	EQU	00004h	    ;reserved for BASIC
SIZEGASYS	EQU	00001h	    ;reserved for EGA.SYS
SIZMOUSE	EQU	00001h	    ;reserved for MOUSE drivers
SIZMICROSOFT	EQU	00010h	    ;reserved for use by Microsoft
SIZRESERVED	EQU	(SIZBASIC+SIZEGASYS+SIZMOUSE+SIZMICROSOFT)

OFFBASIC	EQU	00000h
OFFEGASYS	EQU	(OFFBASIC  + SIZBASIC)
OFFMOUSE	EQU	(OFFEGASYS + SIZEGASYS)
OFFMICROSOFT	EQU	(OFFMOUSE  + SIZMOUSE)

OFFPTRSAV0D	EQU	(OFFSCREEN0D + SIZRESERVED)
OFFSCRSAV0D	EQU	(OFFPTRSAV0D + PTRSAVSIZE)

OFFPTRSAV0E	EQU	(OFFSCREEN0E + SIZRESERVED)
OFFSCRSAV0E	EQU	(OFFPTRSAV0E + PTRSAVSIZE)

OFFPTRSAV10	EQU	(OFFSCREEN10 + SIZRESERVED)
OFFSCRSAV10	EQU	(OFFPTRSAV10 + PTRSAVSIZE)

OFFPTRSAV12	EQU	(OFFSCREEN12 + SIZRESERVED)
OFFSCRSAV12	EQU	(OFFPTRSAV12 + PTRSAVSIZE)

OFFPTRSAV13	EQU	(OFFSCREEN13 + SIZRESERVED)
OFFSCRSAV13	EQU	(OFFPTRSAV13 + BYTEPTRSAVSIZE)


endif  ;INCL_VIDEOPTR


VVD_NAME1	EQU	"VVIDEO1$"  ;registered name of primary VVD
VVD_NAME2	EQU	"VVIDEO2$"  ;registered name of secondary VVD


ifdef  INCL_VIDEOSYSREQ

;***	VVD constants for system communication
;
ifndef CF_TEXT
CF_TEXT		EQU	1	    ;clipboard formats
CF_BITMAP	EQU	2	    ;(see PMWIN.INC)
endif

ADAPTER_MONO	EQU	0	;adapters supported
ADAPTER_CGA	EQU	1	;(same as VioGetConfig constants)
ADAPTER_EGA	EQU	2
ADAPTER_VGA	EQU	3
ADAPTER_8514A	EQU	7

ifndef MONITOR_8503	       ;BUGBUG: avoid conflicts with bsesub.inc
MONITOR_MONO	EQU	0	;monitors supported
MONITOR_RGB	EQU	1	;(typical for CGAs)
MONITOR_ECD	EQU	2	;(typical for EGAs)
MONITOR_8503	EQU	3	;(VGA or 8514/A monochrome)
MONITOR_8512_3	EQU	4	;(VGA or 8514/A color)
MONITOR_8514	EQU	9	;(VGA or 8514/A 1024x768 color, interlaced)
endif

FORMAT_CGA	EQU	2	;LVB formats supported
FORMAT_4BYTE	EQU	4
FORMAT_BITMAP	EQU	0

DDFORMAT_4PLANE		EQU	1	;display driver formats supported

MODE_MONO	EQU	00001h ;monochrome mode in effect
MODE_UNDERLINE	EQU	00002h ;underlining in effect
MODE_SUP_XSCALE2	EQU	01000h ;X scaling supported by factor of 2
MODE_SUP_YSCALE2	EQU	02000h ;Y scaling supported by factor of 2
MODE_SUP_PARTIALSCAN	EQU	04000h ;partial scanline copy requests supported

SUSPEND_NONE	EQU	0 ;VDM running normally
SUSPEND_OUT_OF_MEMORY	EQU	1 ;VDM suspended due to low memory
SUSPEND_UNSUPPORTED_MODE	EQU	2 ;VDM suspended due to unsupported mode

ACCESS_RELEASE	EQU	0 ;values for SETACCESS request
ACCESS_REQUEST	EQU	1
ACCESS_PMREQUEST	EQU	2

CONTROL_RELEASE		EQU	0 ;Release event thread
CONTROL_VDMMINIMIZED	EQU	1 ;Disable video events for VDM
CONTROL_VDMUNMINIMIZED	EQU	2 ;Enable video events for VDM


; VVD system functions
;
VVDSYSREQ_SETACCESS	EQU	1   ;Obtain exclusive event access
VVDSYSREQ_SETFOCUS	EQU	2   ;Notify VDM gaining/losing focus
VVDSYSREQ_SETLOCK	EQU	3   ;Lock/unlock VDM's video state 
VVDSYSREQ_QUERYMODE	EQU	4   ;Query VDM's current mode 
VVDSYSREQ_QUERYCURSOR	EQU	5   ;Query VDM's current mode 
VVDSYSREQ_QUERYPALETTE	EQU	6   ;Query VDM's palette settings 
VVDSYSREQ_COPYLVB	EQU	7   ;Copy LVB data
VVDSYSREQ_COPYBITMAP	EQU	8   ;Copy bitmap data
VVDSYSREQ_WAITEVENT	EQU	9   ;Wait for VDM video update event
VVDSYSREQ_CONTROLEVENT	EQU	10  ;Perform event control operations

VVDSYSREQ_SETDRQ	EQU	11  ;Set display requirements
VVDSYSREQ_REQMEM	EQU	12  ;Request off-screen video memory
VVDSYSREQ_FREEMEM	EQU	13  ;Free off-screen video memory
VVDSYSREQ_REQCTRL	EQU	14  ;Request video controller ownership
VVDSYSREQ_FREECTRL	EQU	15  ;Free video controller ownership

VVDSYSREQ_QUERYVRAMSTATUS	EQU	16;Return VRAM status since last call
VVDSYSREQ_SETOEMFLAG	EQU	17  ;Set OEM Status Flag

VVDSYSREQ_MAX	EQU	17


; VVD event IDs for VVDSYSREQ_WAITEVENT
;
VVDEVENT_NONE	EQU	0   ;No change
VVDEVENT_MODE	EQU	1   ;Change in VDM's mode 
VVDEVENT_PALETTE	EQU	2   ;Change in VDM's palette 
VVDEVENT_LVB	EQU	3   ;Change in VDM's LVB 
VVDEVENT_SCROLL		EQU	4   ;Scroll of VDM's LVB 
VVDEVENT_STRING		EQU	5   ;String output
VVDEVENT_CURSOR		EQU	6   ;Cursor position/type change
VVDEVENT_INPUT	EQU	7   ;VDM is checking for input data
VVDEVENT_ENDPASTE	EQU	8   ;VDM has cancelled pasting
VVDEVENT_PASTE	EQU	9   ;VDM is ready for additional pasting
VVDEVENT_SWITCHERROR	EQU	10  ;VDM cannot be switched foreground
VVDEVENT_TITLECHANGE	EQU	11  ;VDM title has changed
VVDEVENT_DDE	EQU	12  ;Set/Clear DDE flag		    ;@DDE*/

VVDEVENT_MAX	EQU	12					;@DDE



;***	VVD DosRequestVDD communication structures
;
DefStruc ,vvm_s			;vvm (output for MODE event)
    ULONG  vvm_ulAdapter       ;see the ADAPTER_* constants
    ULONG  vvm_ulFormat	       ;see the FORMAT_* constants
    ULONG  vvm_ulDDFormat      ;see the DDFORMAT_* constants
    ULONG  vvm_flMode	       ;mode descriptors (see MODE_* constants)
    ULONG  vvm_nRows	       ;height of screen in rows (or y pixels)
    ULONG  vvm_nCols	       ;width of screen in columns (or x pixels)
    ULONG  vvm_nPlanes	       ;# of planes (must be 1 for Cruiser)
    ULONG  vvm_nBitCount       ;if TEXT, zero;	if BITMAP, bits per pixel
    ULONG  vvm_ulCellWidth     ;width of cells (normally 8;  1 for BITMAPs)
    ULONG  vvm_ulCellHeight    ;height of cells (1 for BITMAPs)
    ULONG  vvm_fSuspended      ;see the SUSPEND_* constants
    ULONG  vvm_cpID	       ;current code-page ID
    ULONG  vvm_FormatID	       ;current format ID
EndStruc VVMODE
DefType NPVVMODE,dd
DefType PVVMODE,dd

DefStruc ,vvr_s			;vvr (input for COPYBITMAP request)
    ULONG  vvr_ulDDFormat      ;display driver format (0 if DIB used)
    ULONG  vvr_cx	       ;target bitmap width
    ULONG  vvr_cy	       ;target bitmap height
    RECTL  vvr_rcl	       ;rectangle being requested
    PBYTE  vvr_pbColorXlate    ;display driver color translation table
EndStruc VVRECT
DefType NPVVRECT,dd
DefType PVVRECT,dd

DefStruc ,vvl_s			;vvl (output for LVB event)
    RECTL  vvl_rcl	       ;rectangle being scrolled
    ULONG  vvl_fCertain	       ;TRUE if entire area changed, FALSE if unknown
EndStruc VVLVB
DefType NPVVLVB,dd
DefType PVVLVB,dd

DefStruc ,vvs_s			;vvs (output for SCROLL event)
    RECTL  vvs_rcl	       ;rectangle being scrolled
    LONG   vvs_fill	       ;fill value
    LONG   vvs_nRows	       ;# rows (negative means reverse scroll)
    LONG   vvs_nCols	       ;# columns (0,0 means rectangle blankfilled)
EndStruc VVSCROLL
DefType NPVVSCROLL,dd
DefType PVVSCROLL,dd

DefStruc ,vva_s			;vva (output for STRING event)
    ULONG  vva_row	       ;beginning row of string
    ULONG  vva_col	       ;beginning column of string
    ULONG  vva_nChars	       ;# characters in string
EndStruc VVSTRING
DefType NPVVSTRING,dd
DefType PVVSTRING,dd

DefStruc ,vvc_s			;vvc (output for CURSOR event)
    ULONG  vvc_row	       ;row (y position) of VDM's cursor 
    ULONG  vvc_col	       ;column (x position) of VDM's cursor 
    ULONG  vvc_ulScanStart     ;starting scan-line for VDM's cursor 
    ULONG  vvc_ulScanEnd       ;ending scan-line for VDM's cursor 
    ULONG  vvc_fVisible	       ;TRUE if VDM cursor visible, FALSE if not
EndStruc VVCURSOR
DefType NPVVCURSOR,dd
DefType PVVCURSOR,dd

DefStruc ,vve_s			;vve (output for VVDSYSREQ_GET/WAITEVENT)
    LONG   vve_iEvent	       ;one of the VVDEVENT_* constants
    ULONG  vve_sgID	       ;screen group ID of VDM
    ULONG  vve_nData	       ;# of entries of information returned
EndStruc VVEVENT
DefType NPVVEVENT,dd
DefType PVVEVENT,dd

DefStruc ,vvreg_s			;vvreg (shadow entry for VVDSYSREQ_SETDRQ)
    USHORT vvreg_port	       ;port #
    CHAR   vvreg_indx	       ;register index # (-1 if index reg)
    _BYTE   vvreg_value		;last value written to register by VDD
EndStruc VVREG
DefType NPVVREG,dd
DefType PVVREG,dd


;*** In the DRQ structure, all pointers are 16:16, and as such, cannot be
;    dereferenced directly from C.  The selector portions are GDT aliases to
;    the PM display driver's resident data, and are valid in any context, even
;    interrupt-time.
;
ALL_RESERVED	EQU	0ffffffffh

DRQ_DIRTYREGS	EQU	001h	;video controller registers have been modified

DefStruc ,vvdrq_s			;vvdrq (main structure for VVDSYSREQ_SETDRQ)
    PBYTE  vvd_pPhysVRAM       ;physical address of VRAM
    ULONG  vvd_nbReserved      ;# of reserved bytes
    ULONG  vvd_offLatchByte    ;offset of available latch storage
    PBYTE  vvd_pfbDRQFlags     ;pointer to flags (see DRQ_* constants)
    PBYTE  vvd_pfCtrlOwned     ;address of display.dll's fCtrlOwned flag 
    PBYTE  vvd_pfCtrlNotify    ;address of display.dll's fCtrlNotify flag 
    ULONG  vvd_nShadowRegs     ;# of registers to shadow
    PVVREG vvd_pShadowData     ;address of first entry in shadow list
EndStruc VVDRQ
DefType NPVVDRQ,dd
DefType PVVDRQ,dd


endif  ;INCL_VIDEOSYSREQ


ifdef  INCL_VIDEODEVREQ

;***	VVD constants for inter-VDD communication
;

VVDDEVREQ_POSTPEEK	EQU	1   ;VDM peeking for keyboard data
VVDDEVREQ_POSTREAD	EQU	2   ;VDM reading for keyboard data
VVDDEVREQ_POSTPASTE	EQU	3   ;VDM ready for more paste data
VVDDEVREQ_POSTMOUSE	EQU	4   ;VDM mouse activity notification
VVDDEVREQ_DEVACCEPT	EQU	5   ;request VVD to manage adapter
VVDDEVREQ_DEVRELEASE	EQU	6   ;request VVD to free adapter
VVDDEVREQ_DSPACCEPT	EQU	7   ;request VVD to manage display
VVDDEVREQ_DSPRELEASE	EQU	8   ;request VVD to free display
VVDDEVREQ_POSTEVENT	EQU	9   ;post a VDM event to the Shield
VVDDEVREQ_SAVERESTORE	EQU	10   ;enable/disable save/restore    ;XGA
VVDDEVREQ_REPAINT	EQU	11   ;keep VRAMISTOAST bit set	     ;XGA
VVDDEVREQ_REQCTRL	EQU	12   ;Request controller ownership    D1545
VVDDEVREQ_FREECTRL	EQU	13   ;Free video controller ownership D1545
VVDDEVREQ_PM_WINDOW	EQU	14   ;Set Windows on PM DeskTop state D1545
VVDDEVREQ_ENABLE_DDE	EQU	15   ;Set/Clear DDE flag	       @DDE
VVDDEVREQ_XGAPRESENT	EQU	16   ;VXGA installed		       @054
VVDDEVREQ_UNMAPVRAM	EQU	17   ;Unmap A0000 aperture	       @054
VVDDEVREQ_8514PRESENT	EQU	18   ;V8514 installed		       @055

VVDDEVREQ_MAX	EQU	18				     ;D1545


POSTEVENT_ADD	EQU	00001h	 ;add given event
POSTEVENT_FLUSH		EQU	00002h	 ;flush given (or existing) event
POSTEVENT_DELETE	EQU	00004h	 ;delete existing event


;***	VVD VDHRequestVDD communication structures
;
DefStruc ,vvp_s			;vvp (input for POSTEVENT request)
    LONG   vvp_iEvent	       ;see the VVDEVENT_* constants
    PVOID  vvp_pEvent	       ;event data (varies from one event to another)
    ULONG  vvp_flEvent	       ;event posting flags (see POSTEVENT_* constants)
EndStruc VVPOST
DefType NPVVPOST,dd
DefType PVVPOST,dd


endif  ;INCL_VIDEODEVREQ


;*** VVD exported function prototypes
;

ifdef INCL_VIDEOINTERFACES					    ;@025

DefType PFNINT2FP,dd			;@025

;*** ULONG value sent to the registered _INT 2F routine **	    ;@025*/
VDHVVD_INT2F_OFF	EQU	0				       ;@025
VDHVVD_INT2F_ON		EQU	1				       ;@025
VDHVVD_INT2F_FG_START	EQU	2				       ;@025
VDHVVD_INT2F_FG_END	EQU	3				       ;@025
VDHVVD_INT2F_BG_START	EQU	4				       ;@025
VDHVVD_INT2F_BG_END	EQU	5				       ;@025

ifndef VDHENTRY							    ;@025
DefEntry VDHENTRY PASCAL NEAR					      ;@025
endif								    ;@025

VDHENTRY VDHRegisterInt2FProc		<FLAGS, PFNINT2FP>		  ;@025

;*** BOOL value indicates the type of notifications required **	   ;@025*/
VDHVVD_NOTIFY_ON_OFF	EQU	1				       ;@025
VDHVVD_NOTIFY_START	EQU	2				       ;@025
VDHVVD_NOTIFY_END	EQU	4				       ;@025

endif	;INCL_VIDEOINTERFACES					;@025*/

; None
